/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.connection.ServerDescription;
import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.MongoServer;
import de.bwaldvogel.mongo.backend.ReadOnlyProxy;
import de.bwaldvogel.mongo.backend.TestUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.platform.commons.util.CollectionUtils;

public abstract class AbstractReadOnlyProxyTest {
    private MongoClient readOnlyClient;
    private MongoServer mongoServer;
    private MongoServer writeableServer;
    private MongoClient writeClient;

    protected abstract MongoBackend createBackend() throws Exception;

    @BeforeEach
    public void setUp() throws Exception {
        MongoBackend mongoBackend = this.createBackend();
        this.writeableServer = new MongoServer(mongoBackend);
        this.writeClient = MongoClients.create((String)this.writeableServer.bindAndGetConnectionString());
        this.mongoServer = new MongoServer((MongoBackend)new ReadOnlyProxy(mongoBackend));
        this.readOnlyClient = MongoClients.create((String)this.mongoServer.bindAndGetConnectionString());
    }

    @AfterEach
    public void tearDown() {
        this.writeClient.close();
        this.readOnlyClient.close();
        this.mongoServer.shutdownNow();
        this.writeableServer.shutdownNow();
    }

    @Test
    void testMaxDocumentSize() throws Exception {
        ServerDescription serverDescription = (ServerDescription)CollectionUtils.getOnlyElement((Collection)this.readOnlyClient.getClusterDescription().getServerDescriptions());
        Assertions.assertThat((int)serverDescription.getMaxDocumentSize()).isEqualTo(0x1000000);
    }

    @Test
    void testServerStatus() throws Exception {
        this.readOnlyClient.getDatabase("admin").runCommand((Bson)new Document("serverStatus", (Object)1));
    }

    @Test
    void testCurrentOperations() throws Exception {
        Document currentOperations = (Document)this.readOnlyClient.getDatabase("admin").getCollection("$cmd.sys.inprog").find().first();
        Assertions.assertThat((Map)currentOperations).isNotNull();
    }

    @Test
    void testStats() throws Exception {
        Document stats = this.readOnlyClient.getDatabase("testdb").runCommand((Bson)TestUtils.json("dbStats:1"));
        Assertions.assertThat((long)((Number)stats.get((Object)"objects")).longValue()).isZero();
    }

    @Test
    void testListDatabaseNames() throws Exception {
        Assertions.assertThat((Iterable)this.readOnlyClient.listDatabaseNames()).isEmpty();
        this.writeClient.getDatabase("testdb").getCollection("testcollection").insertOne((Object)new Document());
        Assertions.assertThat((Iterable)this.readOnlyClient.listDatabaseNames()).containsExactly((Object[])new String[]{"testdb"});
        this.writeClient.getDatabase("bar").getCollection("testcollection").insertOne((Object)new Document());
        Assertions.assertThat((Iterable)this.readOnlyClient.listDatabaseNames()).containsExactly((Object[])new String[]{"bar", "testdb"});
    }

    @Test
    void testIllegalCommand() throws Exception {
        Assertions.assertThatExceptionOfType(MongoException.class).isThrownBy(() -> this.readOnlyClient.getDatabase("testdb").runCommand((Bson)TestUtils.json("foo:1"))).withMessageContaining("Command failed with error 59 (CommandNotFound): 'no such command: 'foo'");
        Assertions.assertThatExceptionOfType(MongoException.class).isThrownBy(() -> this.readOnlyClient.getDatabase("bar").runCommand((Bson)TestUtils.json("foo:1"))).withMessageContaining("Command failed with error 59 (CommandNotFound): 'no such command: 'foo'");
    }

    @Test
    void testQuery() throws Exception {
        MongoCollection collection = this.readOnlyClient.getDatabase("testdb").getCollection("testcollection");
        Document obj = (Document)collection.find((Bson)TestUtils.json("_id: 1")).first();
        Assertions.assertThat((Map)obj).isNull();
        Assertions.assertThat((long)collection.countDocuments()).isEqualTo(0L);
    }

    @Test
    void testDistinctQuery() {
        MongoCollection collection = this.writeClient.getDatabase("testdb").getCollection("testcollection");
        collection.insertOne((Object)new Document("n", (Object)1));
        collection.insertOne((Object)new Document("n", (Object)2));
        collection.insertOne((Object)new Document("n", (Object)1));
        collection = this.readOnlyClient.getDatabase("testdb").getCollection("testcollection");
        Assertions.assertThat((Iterable)collection.distinct("n", Integer.class)).containsExactly((Object[])new Integer[]{1, 2});
    }

    @Test
    void testInsert() throws Exception {
        MongoCollection collection = this.readOnlyClient.getDatabase("testdb").getCollection("testcollection");
        Assertions.assertThat((long)collection.countDocuments()).isZero();
        Assertions.assertThatExceptionOfType(MongoException.class).isThrownBy(() -> collection.insertOne((Object)TestUtils.json("{}")));
    }

    @Test
    void testUpdate() throws Exception {
        MongoCollection collection = this.readOnlyClient.getDatabase("testdb").getCollection("testcollection");
        Document object = new Document("_id", (Object)1);
        Document newObject = new Document("_id", (Object)1);
        Assertions.assertThatExceptionOfType(MongoException.class).isThrownBy(() -> collection.replaceOne((Bson)object, (Object)newObject)).withMessageContaining("Command failed with error 59 (CommandNotFound): 'no such command: 'update'");
    }

    @Test
    void testUpsert() throws Exception {
        MongoCollection collection = this.readOnlyClient.getDatabase("testdb").getCollection("testcollection");
        Assertions.assertThatExceptionOfType(MongoException.class).isThrownBy(() -> collection.updateMany((Bson)TestUtils.json("{}"), Updates.set((String)"foo", (Object)"bar"), new UpdateOptions().upsert(true))).withMessageContaining("Command failed with error 59 (CommandNotFound): 'no such command: 'update'");
    }

    @Test
    void testDropDatabase() throws Exception {
        MongoDatabase database = this.readOnlyClient.getDatabase("testdb");
        Assertions.assertThatExceptionOfType(MongoException.class).isThrownBy(() -> ((MongoDatabase)database).drop());
    }

    @Test
    void testDropCollection() throws Exception {
        MongoCollection collection = this.readOnlyClient.getDatabase("testdb").getCollection("foo");
        Assertions.assertThatExceptionOfType(MongoException.class).isThrownBy(() -> ((MongoCollection)collection).drop()).withMessageContaining("Command failed with error 59 (CommandNotFound): 'no such command: 'drop'");
    }

    @Test
    void testHandleKillCursor() {
        MongoCollection collection = this.writeClient.getDatabase("testdb").getCollection("testcollection");
        collection.insertMany(Arrays.asList(new Document(), new Document()));
        MongoCursor cursor = this.readOnlyClient.getDatabase("testdb").getCollection("testcollection").find().batchSize(1).cursor();
        Assertions.assertThat((Object)cursor.getServerCursor()).isNotNull();
        while (cursor.hasNext()) {
            cursor.next();
        }
        Assertions.assertThat((Object)cursor.getServerCursor()).isNull();
    }

    @Test
    void testAggregateWithExpressionProjection() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$project: {_id: 0, idHex: {$toString: '$_id'}}");
        MongoCollection collection = this.readOnlyClient.getDatabase("testdb").getCollection("testcollection");
        Assertions.assertThat((Iterable)collection.aggregate(pipeline)).isEmpty();
    }

    @Test
    void testAggregateWithOut() {
        List<Document> pipeline = TestUtils.jsonList("$group: {_id: '$author', books: {$push: '$title'}}", "$out : 'authors'");
        MongoCollection collection = this.readOnlyClient.getDatabase("testdb").getCollection("testcollection");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.aggregate(pipeline).first()).withMessageContaining("Command failed with error -1: 'Aggregation contains a modifying stage and is therefore not allowed in read-only mode'");
    }
}

