/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import com.mongodb.util.JSON;
import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.MongoServer;
import java.net.InetSocketAddress;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractSimpleBackendTest {
    private MongoServer mongoServer;
    protected Mongo client;
    protected DB db;
    protected DBCollection collection;

    protected CommandResult command(String command) {
        return this.getAdminDb().command(command);
    }

    protected DBCollection getCollection(String collectionName) {
        return this.db.getCollection(collectionName);
    }

    protected BasicDBObject json(String string) {
        if (!(string = string.trim()).startsWith("{")) {
            string = "{" + string + "}";
        }
        return (BasicDBObject)JSON.parse((String)string);
    }

    protected DB getAdminDb() {
        return this.client.getDB("admin");
    }

    protected abstract MongoBackend createBackend() throws Exception;

    @Before
    public void setUp() throws Exception {
        this.spinUpServer();
    }

    @After
    public void tearDown() {
        this.shutdownServer();
    }

    protected void spinUpServer() throws Exception {
        MongoBackend backend = this.createBackend();
        this.mongoServer = new MongoServer(backend);
        InetSocketAddress serverAddress = this.mongoServer.bind();
        this.client = new MongoClient(new ServerAddress(serverAddress));
        this.db = this.client.getDB("testdb");
        this.collection = this.db.getCollection("testcoll");
    }

    protected void shutdownServer() {
        this.client.close();
        this.mongoServer.shutdownNow();
    }

    @Test
    public void testSimpleInsert() throws Exception {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
    }

    @Test
    public void testSimpleInsertDelete() throws Exception {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        this.collection.remove((DBObject)this.json("_id: 1"));
    }
}

