/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import com.mongodb.BasicDBObject;
import com.mongodb.BulkWriteOperation;
import com.mongodb.BulkWriteRequestBuilder;
import com.mongodb.BulkWriteResult;
import com.mongodb.CommandResult;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DuplicateKeyException;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import de.bwaldvogel.mongo.backend.AbstractSimpleBackendTest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BSONTimestamp;
import org.bson.types.ObjectId;
import org.fest.assertions.Assertions;
import org.fest.assertions.Fail;
import org.fest.assertions.ListAssert;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractBackendTest
extends AbstractSimpleBackendTest {
    @Test
    public void testCreateCollection() throws Exception {
        DBCollection someCollection = this.db.createCollection("some-collection", (DBObject)this.json(""));
        Assertions.assertThat((Object)someCollection).isNotNull();
        Assertions.assertThat((long)someCollection.count()).isEqualTo(0L);
    }

    @Test
    public void testCreateCollectionAlreadyExists() throws Exception {
        this.db.createCollection("some-collection", (DBObject)this.json(""));
        try {
            this.db.createCollection("some-collection", (DBObject)this.json(""));
            Fail.fail((String)"MongoCommandException expected");
        }
        catch (MongoCommandException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(48);
            Assertions.assertThat((String)e.getMessage()).contains("collection already exists");
        }
    }

    @Test
    public void testUnsupportedModifier() throws Exception {
        this.collection.insert(new DBObject[]{this.json("{}")});
        try {
            this.collection.update((DBObject)this.json("{}"), (DBObject)this.json("$foo: {}"));
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(10147);
            Assertions.assertThat((String)e.getMessage()).contains("Invalid modifier specified: $foo");
        }
    }

    @Test
    public void testUpsertWithInc() {
        BasicDBObject query = this.json("_id:{ f: 'ca', 1: { l: 2 }, t: { t: 11 } }");
        BasicDBObject update = this.json("'$inc': { 'n.!' : 1 , 'n.a.b:false' : 1}");
        this.collection.update((DBObject)query, (DBObject)update, true, false);
        query.putAll((BSONObject)this.json("n: {!: 1, a: {'b:false': 1}}"));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)query);
    }

    @Test
    public void testBasicUpdate() {
        this.collection.insert(new DBObject[]{this.json("_id:1")});
        this.collection.insert(new DBObject[]{this.json("_id:2, b:5")});
        this.collection.insert(new DBObject[]{this.json("_id:3")});
        this.collection.insert(new DBObject[]{this.json("_id:4")});
        this.collection.update((DBObject)this.json("_id:2"), (DBObject)this.json("_id:2, a:5"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("_id:2"))).isEqualTo((Object)this.json("_id:2, a:5"));
    }

    @Test
    public void testCollectionStats() throws Exception {
        try {
            this.collection.getStats();
            Fail.fail((String)"MongoCommandException expected");
        }
        catch (MongoCommandException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(26);
            Assertions.assertThat((String)e.getMessage()).contains("No such collection");
        }
        this.collection.insert(new DBObject[]{this.json("{}")});
        this.collection.insert(new DBObject[]{this.json("abc: 'foo'")});
        CommandResult stats = this.collection.getStats();
        stats.throwOnError();
        Assertions.assertThat((long)((Number)stats.get("count")).longValue()).isEqualTo(2L);
        Assertions.assertThat((long)((Number)stats.get("size")).longValue()).isEqualTo(57L);
        Assertions.assertThat((double)((Number)stats.get("avgObjSize")).doubleValue()).isEqualTo(28.5);
    }

    @Test
    public void testGetLogStartupWarnings() throws Exception {
        CommandResult startupWarnings = this.getAdminDb().command((DBObject)this.json("getLog: 'startupWarnings'"));
        startupWarnings.throwOnError();
        Assertions.assertThat((Object)startupWarnings.get("totalLinesWritten")).isEqualTo((Object)0);
        Assertions.assertThat((Object)startupWarnings.get("log")).isEqualTo(Collections.emptyList());
    }

    @Test
    public void testGetLogWhichDoesNotExist() throws Exception {
        CommandResult startupWarnings = this.getAdminDb().command((DBObject)this.json("getLog: 'illegal'"));
        try {
            startupWarnings.throwOnError();
            Fail.fail((String)"MongoCommandException expected");
        }
        catch (MongoCommandException e) {
            Assertions.assertThat((String)e.getMessage()).contains("no RamLog");
        }
    }

    @Test
    public void testCompoundDateIdUpserts() {
        BasicDBObject query = this.json("{ _id : { $lt : { n: 'a' , t: 10} , $gte: { n: 'a', t: 1}}}");
        List<BasicDBObject> toUpsert = Arrays.asList(this.json("_id: {n:'a', t: 1}"), this.json("_id: {n:'a', t: 2}"), this.json("_id: {n:'a', t: 3}"), this.json("_id: {n:'a', t: 11}"));
        for (BasicDBObject dbo : toUpsert) {
            this.collection.update((DBObject)dbo, (DBObject)((BasicDBObject)dbo.copy()).append("foo", (Object)"bar"), true, false);
        }
        List results = this.collection.find((DBObject)query).toArray();
        Assertions.assertThat((List)results).containsOnly(new Object[]{this.json("_id: {n:'a', t:1}, foo:'bar'"), this.json("_id: {n:'a', t:2}, foo:'bar'"), this.json("_id: {n:'a', t:3}, foo:'bar'")});
    }

    @Test
    public void testCompoundSort() {
        this.collection.insert(new DBObject[]{this.json("a:1, _id:1")});
        this.collection.insert(new DBObject[]{this.json("a:2, _id:5")});
        this.collection.insert(new DBObject[]{this.json("a:1, _id:2")});
        this.collection.insert(new DBObject[]{this.json("a:2, _id:4")});
        this.collection.insert(new DBObject[]{this.json("a:1, _id:3")});
        DBCursor cursor = this.collection.find().sort((DBObject)this.json("a:1, _id:-1"));
        Assertions.assertThat((List)cursor.toArray()).containsExactly(new Object[]{this.json("a:1, _id:3"), this.json("a:1, _id:2"), this.json("a:1, _id:1"), this.json("a:2, _id:5"), this.json("a:2, _id:4")});
        cursor.close();
    }

    @Test
    public void testCountCommand() {
        Assertions.assertThat((long)this.collection.count()).isZero();
    }

    @Test
    public void testCountWithQueryCommand() {
        this.collection.insert(new DBObject[]{this.json("n:1")});
        this.collection.insert(new DBObject[]{this.json("n:2")});
        this.collection.insert(new DBObject[]{this.json("n:2")});
        Assertions.assertThat((long)this.collection.count((DBObject)this.json("n:2"))).isEqualTo(2L);
    }

    @Test
    public void testCreateIndexes() {
        this.collection.createIndex((DBObject)new BasicDBObject("n", (Object)1));
        this.collection.createIndex((DBObject)new BasicDBObject("b", (Object)1));
        List indexes = this.getCollection("system.indexes").find().toArray();
        Assertions.assertThat((List)indexes).containsOnly(new Object[]{this.json("key:{_id:1}").append("ns", (Object)this.collection.getFullName()).append("name", (Object)"_id_"), this.json("key:{n:1}").append("ns", (Object)this.collection.getFullName()).append("name", (Object)"n_1"), this.json("key:{b:1}").append("ns", (Object)this.collection.getFullName()).append("name", (Object)"b_1")});
    }

    @Test
    public void testCurrentOperations() throws Exception {
        DBObject currentOperations = this.getAdminDb().getCollection("$cmd.sys.inprog").findOne();
        Assertions.assertThat((Object)currentOperations).isNotNull();
        Assertions.assertThat((Object)currentOperations.get("inprog")).isInstanceOf(List.class);
    }

    @Test
    public void testListCollectionsEmpty() throws Exception {
        CommandResult result = this.db.command((DBObject)this.json("listCollections: 1"));
        result.throwOnError();
        BSONObject cursor = (BSONObject)result.get("cursor");
        Assertions.assertThat((Collection)cursor.keySet()).containsOnly(new Object[]{"id", "ns", "firstBatch"});
        Assertions.assertThat((Object)cursor.get("id")).isEqualTo((Object)0L);
        Assertions.assertThat((Object)cursor.get("ns")).isEqualTo((Object)(this.db.getName() + ".$cmd.listCollections"));
        List firstBatch = (List)cursor.get("firstBatch");
        Assertions.assertThat((List)firstBatch).isEmpty();
    }

    @Test
    public void testListCollections() throws Exception {
        List<String> collections = Arrays.asList("coll1", "coll2", "coll3");
        for (String collection : collections) {
            this.getCollection(collection).insert(new DBObject[]{this.json("_id: 1")});
        }
        CommandResult result = this.db.command((DBObject)this.json("listCollections: 1"));
        result.throwOnError();
        BSONObject cursor = (BSONObject)result.get("cursor");
        Assertions.assertThat((Collection)cursor.keySet()).containsOnly(new Object[]{"id", "ns", "firstBatch"});
        Assertions.assertThat((Object)cursor.get("id")).isEqualTo((Object)0L);
        Assertions.assertThat((Object)cursor.get("ns")).isEqualTo((Object)(this.db.getName() + ".$cmd.listCollections"));
        Assertions.assertThat((Object)cursor.get("firstBatch")).isInstanceOf(List.class);
        List firstBatch = (List)cursor.get("firstBatch");
        HashSet<String> expectedCollections = new HashSet<String>();
        expectedCollections.addAll(collections);
        expectedCollections.add("system.indexes");
        Assertions.assertThat((List)firstBatch).hasSize(expectedCollections.size());
        HashSet<String> collectionNames = new HashSet<String>();
        for (BSONObject collection : firstBatch) {
            Assertions.assertThat((Collection)collection.keySet()).containsOnly(new Object[]{"name", "options"});
            Assertions.assertThat((Object)collection.get("options")).isEqualTo((Object)this.json("{}"));
            Assertions.assertThat((Object)collection.get("name")).isInstanceOf(String.class);
            collectionNames.add((String)collection.get("name"));
        }
        Assertions.assertThat(collectionNames).isEqualTo(expectedCollections);
    }

    @Test
    public void testGetCollectionNames() throws Exception {
        this.getCollection("foo").insert(new DBObject[]{this.json("{}")});
        this.getCollection("bar").insert(new DBObject[]{this.json("{}")});
        Set collectionNames = this.db.getCollectionNames();
        Assertions.assertThat((Collection)collectionNames).containsOnly(new Object[]{"system.indexes", "foo", "bar"});
    }

    @Test
    public void testSystemIndexes() throws Exception {
        this.getCollection("foo").insert(new DBObject[]{this.json("{}")});
        this.getCollection("bar").insert(new DBObject[]{this.json("{}")});
        DBCollection systemIndexes = this.db.getCollection("system.indexes");
        Assertions.assertThat((List)systemIndexes.find().toArray()).containsOnly(new Object[]{this.json("name: '_id_', ns: 'testdb.foo', key: {_id: 1}"), this.json("name: '_id_', ns: 'testdb.bar', key: {_id: 1}")});
    }

    @Test
    public void testSystemNamespaces() throws Exception {
        this.getCollection("foo").insert(new DBObject[]{this.json("{}")});
        this.getCollection("bar").insert(new DBObject[]{this.json("{}")});
        DBCollection namespaces = this.db.getCollection("system.namespaces");
        Assertions.assertThat((List)namespaces.find().toArray()).containsOnly(new Object[]{this.json("name: 'testdb.system.indexes'"), this.json("name: 'testdb.foo'"), this.json("name: 'testdb.bar'")});
    }

    @Test
    public void testDatabaseStats() throws Exception {
        CommandResult stats = this.db.getStats();
        stats.throwOnError();
        Assertions.assertThat((long)((Number)stats.get("objects")).longValue()).isZero();
        Assertions.assertThat((long)((Number)stats.get("collections")).longValue()).isZero();
        Assertions.assertThat((long)((Number)stats.get("indexes")).longValue()).isZero();
        Assertions.assertThat((long)((Number)stats.get("dataSize")).longValue()).isZero();
        this.getCollection("foo").insert(new DBObject[]{this.json("{}")});
        this.getCollection("foo").insert(new DBObject[]{this.json("{}")});
        this.getCollection("bar").insert(new DBObject[]{this.json("{}")});
        stats = this.db.getStats();
        stats.throwOnError();
        Assertions.assertThat((long)((Number)stats.get("objects")).longValue()).isEqualTo(8L);
        Assertions.assertThat((long)((Number)stats.get("collections")).longValue()).isEqualTo(3L);
        Assertions.assertThat((long)((Number)stats.get("indexes")).longValue()).isEqualTo(2L);
        Assertions.assertThat((long)((Number)stats.get("dataSize")).longValue()).isEqualTo(271L);
    }

    @Test
    public void testDeleteDecrementsCount() {
        this.collection.insert(new DBObject[]{this.json("key: 'value'")});
        Assertions.assertThat((long)this.collection.count()).isEqualTo(1L);
        this.collection.remove((DBObject)this.json("{}"));
        Assertions.assertThat((long)this.collection.count()).isZero();
    }

    @Test
    public void testDeleteInSystemNamespace() throws Exception {
        try {
            this.getCollection("system.foobar").remove((DBObject)this.json("{}"));
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(12050);
            Assertions.assertThat((String)e.getMessage()).contains("cannot delete from system namespace");
        }
        try {
            this.getCollection("system.namespaces").remove((DBObject)this.json("{}"));
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(12050);
            Assertions.assertThat((String)e.getMessage()).contains("cannot delete from system namespace");
        }
    }

    @Test
    public void testUpdateInSystemNamespace() throws Exception {
        try {
            this.getCollection("system.foobar").update((DBObject)this.json("{}"), (DBObject)this.json("{}"));
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(10156);
            Assertions.assertThat((String)e.getMessage()).contains("cannot update system collection");
        }
        try {
            this.getCollection("system.namespaces").update((DBObject)this.json("{}"), (DBObject)this.json("{}"));
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(10156);
            Assertions.assertThat((String)e.getMessage()).contains("cannot update system collection");
        }
    }

    @Test
    public void testDistinctQuery() {
        this.collection.insert(new DBObject[]{new BasicDBObject("n", (Object)3)});
        this.collection.insert(new DBObject[]{new BasicDBObject("n", (Object)1)});
        this.collection.insert(new DBObject[]{new BasicDBObject("n", (Object)2)});
        this.collection.insert(new DBObject[]{new BasicDBObject("n", (Object)1)});
        this.collection.insert(new DBObject[]{new BasicDBObject("n", (Object)1)});
        Assertions.assertThat((List)this.collection.distinct("n")).containsExactly(new Object[]{1, 2, 3});
        Assertions.assertThat((List)this.collection.distinct("foobar")).isEmpty();
        Assertions.assertThat((List)this.collection.distinct("_id")).hasSize((int)this.collection.count());
    }

    @Test
    public void testDropCollection() throws Exception {
        this.collection.insert(new DBObject[]{this.json("{}")});
        Assertions.assertThat((Collection)this.db.getCollectionNames()).contains(new Object[]{this.collection.getName()});
        this.collection.drop();
        Assertions.assertThat((Collection)this.db.getCollectionNames()).excludes(new Object[]{this.collection.getName()});
    }

    @Test
    public void testDropCollectionAlsoDropsFromDB() throws Exception {
        this.collection.insert(new DBObject[]{this.json("{}")});
        this.collection.drop();
        Assertions.assertThat((long)this.collection.count()).isZero();
        Assertions.assertThat((Collection)this.db.getCollectionNames()).excludes(new Object[]{this.collection.getName()});
    }

    @Test
    public void testDropDatabaseAlsoDropsCollectionData() throws Exception {
        this.collection.insert(new DBObject[]{this.json("{}")});
        this.db.dropDatabase();
        Assertions.assertThat((long)this.collection.count()).isZero();
    }

    @Test
    public void testDropDatabaseDropsAllData() throws Exception {
        this.collection.insert(new DBObject[]{this.json("{}")});
        DBCollection collection2 = this.getCollection("testcoll2");
        collection2.insert(new DBObject[]{this.json("{}")});
        this.client.dropDatabase(this.db.getName());
        Assertions.assertThat((List)this.client.getDatabaseNames()).excludes(new Object[]{this.db.getName()});
        Assertions.assertThat((long)this.collection.count()).isZero();
        Assertions.assertThat((Collection)this.db.getCollectionNames()).excludes(new Object[]{this.collection.getName(), collection2.getName()});
    }

    @Test
    public void testEmbeddedSort() {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        this.collection.insert(new DBObject[]{this.json("_id: 2")});
        this.collection.insert(new DBObject[]{this.json("_id: 3")});
        this.collection.insert(new DBObject[]{this.json("_id: 4, counts:{done:1}")});
        this.collection.insert(new DBObject[]{this.json("_id: 5, counts:{done:2}")});
        DBCursor cursor = this.collection.find((DBObject)this.json("c: {$ne:true}")).sort((DBObject)this.json("counts.done: -1, _id: 1"));
        Assertions.assertThat((List)cursor.toArray()).containsExactly(new Object[]{this.json("_id: 5, counts:{done:2}"), this.json("_id: 4, counts:{done:1}"), this.json("_id: 1"), this.json("_id: 2"), this.json("_id: 3")});
        cursor.close();
    }

    @Test
    public void testFindAndModifyCommandEmpty() throws Exception {
        BasicDBObject cmd = new BasicDBObject("findandmodify", (Object)this.collection.getName());
        CommandResult result = this.db.command((DBObject)cmd);
        Assertions.assertThat((String)result.getErrorMessage()).isEqualTo((Object)"need remove or update");
        Assertions.assertThat((boolean)result.ok()).isFalse();
    }

    @Test
    public void testFindAndModifyCommandIllegalOp() throws Exception {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        BasicDBObject cmd = new BasicDBObject("findAndModify", (Object)this.collection.getName());
        cmd.put("query", (Object)this.json("_id: 1"));
        cmd.put("update", (Object)new BasicDBObject("$inc", (Object)this.json("_id: 1")));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1"));
        CommandResult result = this.db.command((DBObject)cmd);
        try {
            result.throwOnError();
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(10148);
            Assertions.assertThat((String)e.getMessage()).contains("Mod on _id not allowed");
        }
    }

    @Test
    public void testFindAndModifyCommandUpdate() throws Exception {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        BasicDBObject cmd = new BasicDBObject("findAndModify", (Object)this.collection.getName());
        cmd.put("query", (Object)this.json("_id: 1"));
        cmd.put("update", (Object)this.json("$inc: {a: 1}"));
        CommandResult result = this.db.command((DBObject)cmd);
        Assertions.assertThat((Object)result.get("lastErrorObject")).isEqualTo((Object)this.json("updatedExisting: true, n: 1"));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, a: 1"));
        Assertions.assertThat((boolean)result.ok()).isTrue();
    }

    @Test
    public void testFindAndModifyError() throws Exception {
        this.collection.insert(new DBObject[]{this.json("_id: 1, a: 1")});
        try {
            this.collection.findAndModify((DBObject)this.json("_id: 1"), null, null, false, (DBObject)this.json("$inc: {_id: 1}"), false, false);
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(10148);
            Assertions.assertThat((String)e.getMessage()).contains("Mod on _id not allowed");
        }
    }

    @Test
    public void testFindAndModifyFields() throws Exception {
        this.collection.insert(new DBObject[]{this.json("_id: 1, a: 1")});
        DBObject result = this.collection.findAndModify((DBObject)this.json("_id: 1"), (DBObject)this.json("_id: 1"), null, false, (DBObject)this.json("$inc: {a:1}"), true, false);
        Assertions.assertThat((Object)result).isEqualTo((Object)this.json("_id: 1"));
    }

    @Test
    public void testFindAndModifyNotFound() throws Exception {
        this.collection.insert(new DBObject[]{this.json("_id: 1, a: 1")});
        DBObject result = this.collection.findAndModify((DBObject)this.json("_id: 2"), null, null, false, (DBObject)new BasicDBObject("$inc", (Object)this.json("a: 1")), false, false);
        Assertions.assertThat((Object)result).isNull();
        Assertions.assertThat((long)this.collection.count()).isEqualTo(1L);
    }

    @Test
    public void testFindAndModifyRemove() {
        this.collection.insert(new DBObject[]{this.json("_id: 1, a: 1")});
        DBObject result = this.collection.findAndModify((DBObject)this.json("_id: 1"), null, null, true, null, false, false);
        Assertions.assertThat((Object)result).isEqualTo((Object)this.json("_id: 1, a: 1"));
        Assertions.assertThat((long)this.collection.count()).isZero();
    }

    @Test
    public void testFindAndModifyReturnNew() {
        this.collection.insert(new DBObject[]{this.json("_id: 1, a: 1, b: {c: 1}")});
        BasicDBObject query = this.json("_id: 1");
        BasicDBObject update = this.json("$inc: {a: 1, 'b.c': 1}");
        DBObject result = this.collection.findAndModify((DBObject)query, null, null, false, (DBObject)update, true, false);
        Assertions.assertThat((Object)result).isEqualTo((Object)this.json("_id: 1, a: 2, b: {c: 2}"));
    }

    @Test
    public void testFindAndModifyMax() {
        this.collection.insert(new DBObject[]{this.json("_id: 1, a: 1, b: {c: 1}")});
        BasicDBObject query = this.json("_id: 1");
        BasicDBObject update = this.json("$max: {a: 2, 'b.c': 2, d : 'd'}");
        DBObject result = this.collection.findAndModify((DBObject)query, null, null, false, (DBObject)update, true, false);
        Assertions.assertThat((Object)result).isEqualTo((Object)this.json("_id: 1, a: 2, b: {c: 2}, d : 'd'"));
    }

    @Test
    public void testFindAndModifyMin() {
        this.collection.insert(new DBObject[]{this.json("_id: 1, a: 2, b: {c: 1}")});
        BasicDBObject query = this.json("_id: 1");
        BasicDBObject update = this.json("$min: {a: 1, 'b.c': 2, d : 'd'}");
        DBObject result = this.collection.findAndModify((DBObject)query, null, null, false, (DBObject)update, true, false);
        Assertions.assertThat((Object)result).isEqualTo((Object)this.json("_id: 1, a: 1, b: {c: 1}, d : 'd'"));
    }

    @Test
    public void testFindAndModifyReturnOld() {
        this.collection.insert(new DBObject[]{this.json("_id: 1, a: 1, b: {c: 1}")});
        BasicDBObject query = this.json("_id: 1");
        BasicDBObject update = this.json("$inc: {a: 1, 'b.c': 1}");
        DBObject result = this.collection.findAndModify((DBObject)query, null, null, false, (DBObject)update, false, false);
        Assertions.assertThat((Object)result).isEqualTo((Object)this.json("_id: 1, a: 1, b: {c: 1}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)query)).isEqualTo((Object)this.json("_id: 1, a: 2, b: {c: 2}"));
    }

    @Test
    public void testFindAndModifySorted() throws Exception {
        this.collection.insert(new DBObject[]{this.json("_id: 1, a:15")});
        this.collection.insert(new DBObject[]{this.json("_id: 2, a:10")});
        this.collection.insert(new DBObject[]{this.json("_id: 3, a:20")});
        BasicDBObject order = this.json("a:1");
        DBObject result = this.collection.findAndModify((DBObject)this.json("{}"), null, (DBObject)order, false, (DBObject)this.json("$inc: {a: 1}"), true, false);
        Assertions.assertThat((Object)result).isEqualTo((Object)this.json("_id: 2, a: 11"));
        order = this.json("a: -1");
        result = this.collection.findAndModify((DBObject)this.json("{}"), null, (DBObject)order, false, (DBObject)this.json("$inc: {a: 1}"), true, false);
        Assertions.assertThat((Object)result).isEqualTo((Object)this.json("_id: 3, a: 21"));
    }

    @Test
    public void testFindAndModifyUpsert() {
        DBObject result = this.collection.findAndModify((DBObject)this.json("_id: 1"), null, null, false, (DBObject)this.json("$inc: {a:1}"), true, true);
        Assertions.assertThat((Object)result).isEqualTo((Object)this.json("_id: 1, a: 1"));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, a: 1"));
    }

    @Test
    public void testFindAndModifyUpsertReturnNewFalse() {
        DBObject result = this.collection.findAndModify((DBObject)this.json("_id: 1"), null, null, false, (DBObject)this.json("$inc: {a:1}"), false, true);
        Assertions.assertThat((Object)result).isEqualTo((Object)this.json("{}"));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, a: 1"));
    }

    @Test
    public void testFindAndRemoveFromEmbeddedList() {
        BasicDBObject obj = this.json("_id: 1, a: [1]");
        this.collection.insert(new DBObject[]{obj});
        DBObject result = this.collection.findAndRemove((DBObject)this.json("_id: 1"));
        Assertions.assertThat((Object)result).isEqualTo((Object)obj);
        Assertions.assertThat((long)this.collection.count()).isZero();
    }

    @Test
    public void testFindOne() {
        this.collection.insert(new DBObject[]{this.json("key: 'value'")});
        this.collection.insert(new DBObject[]{this.json("key: 'value'")});
        DBObject result = this.collection.findOne();
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((Object)result.get("_id")).isNotNull();
    }

    @Test
    public void testFindOneById() {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        DBObject result = this.collection.findOne((DBObject)this.json("_id: 1"));
        Assertions.assertThat((Object)result).isEqualTo((Object)this.json("_id: 1"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("_id: 2"))).isNull();
    }

    @Test
    public void testFindOneIn() {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        DBObject result = this.collection.findOne((DBObject)this.json("_id: {$in: [1,2]}"));
        Assertions.assertThat((Object)result).isEqualTo((Object)this.json("_id: 1"));
    }

    @Test
    public void testFindWithLimit() {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        this.collection.insert(new DBObject[]{this.json("_id: 2")});
        this.collection.insert(new DBObject[]{this.json("_id: 3")});
        this.collection.insert(new DBObject[]{this.json("_id: 4")});
        List actual = this.collection.find().sort((DBObject)this.json("_id: 1")).limit(2).toArray();
        Assertions.assertThat((List)actual).containsExactly(new Object[]{this.json("_id: 1"), this.json("_id: 2")});
        List actualNegativeLimit = this.collection.find().sort((DBObject)this.json("_id: 1")).limit(-2).toArray();
        Assertions.assertThat((List)actualNegativeLimit).isEqualTo((Object)actual);
    }

    @Test
    public void testFindInReverseNaturalOrder() {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        this.collection.insert(new DBObject[]{this.json("_id: 2")});
        List actual = this.collection.find().sort((DBObject)this.json("$natural: -1")).toArray();
        Assertions.assertThat((List)actual).containsOnly(new Object[]{this.json("_id: 1"), this.json("_id: 2")});
    }

    @Test
    public void testFindWithPattern() {
        this.collection.insert(new DBObject[]{this.json("_id: 'marta'")});
        this.collection.insert(new DBObject[]{this.json("_id: 'john', foo: 'bar'")});
        this.collection.insert(new DBObject[]{this.json("_id: 'jon', foo: 'ba'")});
        this.collection.insert(new DBObject[]{this.json("_id: 'jo'")});
        Assertions.assertThat((List)this.collection.find((DBObject)new BasicDBObject("_id", (Object)Pattern.compile("mart"))).toArray()).containsOnly(new Object[]{this.json("_id: 'marta'")});
        Assertions.assertThat((List)this.collection.find((DBObject)new BasicDBObject("foo", (Object)Pattern.compile("ba"))).toArray()).containsOnly(new Object[]{this.json("_id: 'john', foo: 'bar'"), this.json("_id: 'jon', foo: 'ba'")});
        Assertions.assertThat((List)this.collection.find((DBObject)new BasicDBObject("foo", (Object)Pattern.compile("ba$"))).toArray()).containsOnly(new Object[]{this.json("_id: 'jon', foo: 'ba'")});
    }

    @Test
    public void testFindWithQuery() {
        this.collection.insert(new DBObject[]{this.json("name: 'jon'")});
        this.collection.insert(new DBObject[]{this.json("name: 'leo'")});
        this.collection.insert(new DBObject[]{this.json("name: 'neil'")});
        this.collection.insert(new DBObject[]{this.json("name: 'neil'")});
        DBCursor cursor = this.collection.find((DBObject)this.json("name: 'neil'"));
        Assertions.assertThat((List)cursor.toArray()).hasSize(2);
        cursor.close();
    }

    @Test
    public void testFindWithSkipLimit() {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        this.collection.insert(new DBObject[]{this.json("_id: 2")});
        this.collection.insert(new DBObject[]{this.json("_id: 3")});
        this.collection.insert(new DBObject[]{this.json("_id: 4")});
        DBCursor cursor = this.collection.find().sort((DBObject)this.json("_id: 1")).limit(2).skip(2);
        Assertions.assertThat((List)cursor.toArray()).containsExactly(new Object[]{this.json("_id: 3"), this.json("_id: 4")});
        cursor.close();
    }

    @Test
    public void testFindWithSkipLimitInReverseOrder() {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        this.collection.insert(new DBObject[]{this.json("_id: 2")});
        this.collection.insert(new DBObject[]{this.json("_id: 3")});
        this.collection.insert(new DBObject[]{this.json("_id: 4")});
        DBCursor cursor = this.collection.find().sort((DBObject)this.json("_id: -1")).limit(2).skip(2);
        Assertions.assertThat((List)cursor.toArray()).containsExactly(new Object[]{this.json("_id: 2"), this.json("_id: 1")});
        cursor.close();
    }

    @Test
    public void testFindWithSkipLimitAfterDelete() {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        this.collection.insert(new DBObject[]{this.json("_id: 2")});
        this.collection.insert(new DBObject[]{this.json("_id: 3")});
        this.collection.insert(new DBObject[]{this.json("_id: 4")});
        this.collection.insert(new DBObject[]{this.json("_id: 5")});
        this.collection.remove((DBObject)this.json("_id: 1"));
        this.collection.remove((DBObject)this.json("_id: 3"));
        DBCursor cursor = this.collection.find().sort((DBObject)this.json("_id: 1")).limit(2).skip(2);
        Assertions.assertThat((List)cursor.toArray()).containsExactly(new Object[]{this.json("_id: 5")});
        cursor.close();
    }

    @Test
    public void testFullUpdateWithSameId() throws Exception {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        this.collection.insert(new DBObject[]{this.json("_id: 2, b: 5")});
        this.collection.insert(new DBObject[]{this.json("_id: 3")});
        this.collection.insert(new DBObject[]{this.json("_id: 4")});
        this.collection.update((DBObject)this.json("_id: 2, b:5"), (DBObject)this.json("_id: 2, a:5"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("_id: 2"))).isEqualTo((Object)this.json("_id: 2, a:5"));
    }

    @Test
    public void testGetCollection() {
        DBCollection collection = this.getCollection("coll");
        this.getCollection("coll").insert(new DBObject[]{this.json("{}")});
        Assertions.assertThat((Object)collection).isNotNull();
        Assertions.assertThat((Object)this.getCollection("coll")).isSameAs((Object)collection);
        Assertions.assertThat((Object)this.db.getCollectionFromString("coll")).isSameAs((Object)collection);
        Assertions.assertThat((Collection)this.db.getCollectionNames()).contains(new Object[]{"coll"});
    }

    @Test
    public void testIdGenerated() throws Exception {
        BasicDBObject toSave = this.json("{_id: null, name: 'test'}");
        this.collection.save((DBObject)toSave);
        DBObject result = this.collection.findOne((DBObject)this.json("name: 'test'"));
        Assertions.assertThat((Object)result.get("_id")).isInstanceOf(ObjectId.class);
    }

    @Test
    public void testIdInQueryResultsInIndexOrder() {
        this.collection.insert(new DBObject[]{this.json("_id: 4")});
        this.collection.insert(new DBObject[]{this.json("_id: 3")});
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        this.collection.insert(new DBObject[]{this.json("_id: 2")});
        DBCursor cursor = this.collection.find((DBObject)this.json("_id: {$in: [3,2,1]}"));
        Assertions.assertThat((List)cursor.toArray()).containsExactly(new Object[]{this.json("_id: 1"), this.json("_id: 2"), this.json("_id: 3")});
        cursor.close();
    }

    @Test
    public void testIdNotAllowedToBeUpdated() {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        try {
            this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("_id:2, a:4"));
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((String)e.getMessage()).contains("cannot change _id of a document old:{ \\\"_id\\\" : 1} new:{ \\\"_id\\\" : 2}");
        }
        try {
            this.collection.update((DBObject)this.json("_id: 1"), (DBObject)new BasicDBObject("$set", (Object)this.json("_id: 2")));
            Fail.fail((String)"should throw exception");
        }
        catch (MongoException e) {
            Assertions.assertThat((String)e.getMessage()).contains("Mod on _id not allowed");
        }
    }

    @Test
    public void testIllegalCommand() throws Exception {
        try {
            this.command("foo").throwOnError();
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((String)e.getMessage()).contains("no such cmd: foo");
        }
        try {
            this.client.getDB("bar").command("foo").throwOnError();
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((String)e.getMessage()).contains("no such cmd: foo");
        }
    }

    @Test
    public void testInsert() throws Exception {
        Assertions.assertThat((long)this.collection.count()).isEqualTo(0L);
        for (int i = 0; i < 3; ++i) {
            this.collection.insert(new DBObject[]{new BasicDBObject("_id", (Object)i)});
        }
        Assertions.assertThat((long)this.collection.count()).isEqualTo(3L);
        WriteResult result = this.collection.insert(new DBObject[]{this.json("foo: [1,2,3]")});
        Assertions.assertThat((int)result.getN()).isZero();
        Assertions.assertThat((boolean)result.isUpdateOfExisting()).isFalse();
        this.collection.insert(new DBObject[]{new BasicDBObject("foo", (Object)new byte[10])});
        BasicDBObject insertedObject = new BasicDBObject("foo", (Object)UUID.randomUUID());
        this.collection.insert(new DBObject[]{insertedObject});
        Assertions.assertThat((Object)this.collection.findOne((DBObject)insertedObject)).isEqualTo((Object)insertedObject);
    }

    @Test
    public void testInsertDuplicate() throws Exception {
        Assertions.assertThat((long)this.collection.count()).isEqualTo(0L);
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        Assertions.assertThat((long)this.collection.count()).isEqualTo(1L);
        try {
            this.collection.insert(new DBObject[]{this.json("_id: 1")});
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((String)e.getMessage()).contains("duplicate key error");
        }
        try {
            this.collection.insert(new DBObject[]{new BasicDBObject("_id", (Object)1.0)});
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((String)e.getMessage()).contains("duplicate key error");
        }
        Assertions.assertThat((long)this.collection.count()).isEqualTo(1L);
    }

    @Test(expected=MongoException.class)
    public void testInsertDuplicateThrows() {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
    }

    @Test(expected=MongoException.class)
    public void testInsertDuplicateWithConcernThrows() {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        this.collection.insert((DBObject)this.json("_id: 1"), WriteConcern.SAFE);
    }

    @Test
    public void testInsertIncrementsCount() {
        Assertions.assertThat((long)this.collection.count()).isZero();
        this.collection.insert(new DBObject[]{this.json("key: 'value'")});
        Assertions.assertThat((long)this.collection.count()).isEqualTo(1L);
    }

    @Test
    public void testInsertQuery() throws Exception {
        Assertions.assertThat((long)this.collection.count()).isEqualTo(0L);
        BasicDBObject insertedObject = this.json("_id: 1");
        insertedObject.put((Object)"foo", (Object)"bar");
        this.collection.insert(new DBObject[]{insertedObject});
        Assertions.assertThat((Object)this.collection.findOne((DBObject)insertedObject)).isEqualTo((Object)insertedObject);
        Assertions.assertThat((Object)this.collection.findOne((DBObject)new BasicDBObject("_id", (Object)1L))).isEqualTo((Object)insertedObject);
        Assertions.assertThat((Object)this.collection.findOne((DBObject)new BasicDBObject("_id", (Object)1.0))).isEqualTo((Object)insertedObject);
        Assertions.assertThat((Object)this.collection.findOne((DBObject)new BasicDBObject("_id", (Object)Float.valueOf(1.0001f)))).isNull();
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("foo: 'bar'"))).isEqualTo((Object)insertedObject);
    }

    @Test
    public void testInsertRemove() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.collection.insert(new DBObject[]{this.json("_id: 1")});
            Assertions.assertThat((long)this.collection.count()).isEqualTo(1L);
            this.collection.remove((DBObject)this.json("_id: 1"));
            Assertions.assertThat((long)this.collection.count()).isZero();
            this.collection.insert(new DBObject[]{new BasicDBObject("_id", (Object)i)});
            this.collection.remove((DBObject)new BasicDBObject("_id", (Object)i));
        }
        Assertions.assertThat((long)this.collection.count()).isZero();
        this.collection.remove((DBObject)this.json("'doesnt exist': 1"));
        Assertions.assertThat((long)this.collection.count()).isZero();
    }

    @Test
    public void testInsertInSystemNamespace() throws Exception {
        try {
            this.getCollection("system.foobar").insert(new DBObject[]{this.json("{}")});
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(16459);
            Assertions.assertThat((String)e.getMessage()).contains("attempt to insert in system namespace");
        }
        try {
            this.getCollection("system.namespaces").insert(new DBObject[]{this.json("{}")});
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(16459);
            Assertions.assertThat((String)e.getMessage()).contains("attempt to insert in system namespace");
        }
    }

    @Test
    public void testListDatabaseNames() throws Exception {
        Assertions.assertThat((List)this.client.getDatabaseNames()).isEmpty();
        this.getCollection(this.collection.getName()).insert(new DBObject[]{this.json("{}")});
        Assertions.assertThat((List)this.client.getDatabaseNames()).containsExactly(new Object[]{this.db.getName()});
        this.client.getDB("bar").getCollection(this.collection.getName()).insert(new DBObject[]{this.json("{}")});
        Assertions.assertThat((List)this.client.getDatabaseNames()).containsExactly(new Object[]{"bar", this.db.getName()});
    }

    @Test
    public void testMaxBsonSize() throws Exception {
        int maxBsonObjectSize = this.client.getMaxBsonObjectSize();
        Assertions.assertThat((int)maxBsonObjectSize).isEqualTo(0x1000000);
    }

    @Test
    public void testQuery() throws Exception {
        DBObject obj = this.collection.findOne((DBObject)this.json("_id: 1"));
        Assertions.assertThat((Object)obj).isNull();
        Assertions.assertThat((long)this.collection.count()).isEqualTo(0L);
    }

    @Test
    public void testQueryAll() throws Exception {
        ArrayList<BasicDBObject> inserted = new ArrayList<BasicDBObject>();
        for (int i = 0; i < 10; ++i) {
            BasicDBObject obj = new BasicDBObject("_id", (Object)i);
            this.collection.insert(new DBObject[]{obj});
            inserted.add(obj);
        }
        Assertions.assertThat((long)this.collection.count()).isEqualTo(10L);
        Assertions.assertThat((List)this.collection.find().sort((DBObject)this.json("_id: 1")).toArray()).isEqualTo(inserted);
    }

    @Test
    public void testQueryCount() throws Exception {
        for (int i = 0; i < 100; ++i) {
            this.collection.insert(new DBObject[]{this.json("{}")});
        }
        Assertions.assertThat((long)this.collection.count()).isEqualTo(100L);
        BasicDBObject obj = this.json("_id: 1");
        Assertions.assertThat((int)this.collection.find((DBObject)obj).count()).isEqualTo(0);
        this.collection.insert(new DBObject[]{obj});
        Assertions.assertThat((int)this.collection.find((DBObject)obj).count()).isEqualTo(1);
    }

    @Test
    public void testQueryLimit() throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.collection.insert(new DBObject[]{this.json("{}")});
        }
        List objects = this.collection.find().limit(1).toArray();
        Assertions.assertThat((int)objects.size()).isEqualTo(1);
        Assertions.assertThat((List)this.collection.find().limit(-1).toArray()).isEqualTo((Object)objects);
    }

    @Test
    public void testQueryNull() throws Exception {
        BasicDBObject object = this.json("_id: 1");
        this.collection.insert(new DBObject[]{object});
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("foo: null"))).isEqualTo((Object)object);
    }

    @Test
    public void testQuerySkipLimit() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.collection.insert(new DBObject[]{this.json("{}")});
        }
        DBCursor cursor = this.collection.find().skip(3);
        Assertions.assertThat((int)cursor.itcount()).isEqualTo(7);
        cursor.close();
        cursor = this.collection.find().skip(3).limit(5);
        Assertions.assertThat((int)cursor.itcount()).isEqualTo(5);
        cursor.close();
    }

    @Test
    public void testQuerySort() throws Exception {
        double value;
        Random random = new Random(4711L);
        for (int i = 0; i < 10; ++i) {
            this.collection.insert(new DBObject[]{new BasicDBObject("_id", (Object)random.nextDouble())});
        }
        List objects = this.collection.find().sort((DBObject)this.json("_id: 1")).toArray();
        double before = Double.MIN_VALUE;
        for (DBObject dbObject : objects) {
            value = ((Number)dbObject.get("_id")).doubleValue();
            Assertions.assertThat((double)value).isGreaterThanOrEqualTo(before);
            before = value;
        }
        objects = this.collection.find().sort((DBObject)this.json("_id: -1")).toArray();
        before = Double.MAX_VALUE;
        for (DBObject dbObject : objects) {
            value = ((Number)dbObject.get("_id")).doubleValue();
            Assertions.assertThat((double)value).isLessThanOrEqualTo(before);
            before = value;
        }
    }

    @Test
    public void testQueryWithFieldSelector() throws Exception {
        this.collection.insert(new DBObject[]{this.json("foo: 'bar'")});
        DBObject obj = this.collection.findOne((DBObject)this.json("{}"), (DBObject)this.json("foo: 1"));
        Assertions.assertThat((Collection)obj.keySet()).containsOnly(new Object[]{"_id", "foo"});
        obj = this.collection.findOne((DBObject)this.json("foo:'bar'"), (DBObject)this.json("_id: 1"));
        Assertions.assertThat((Collection)obj.keySet()).containsOnly(new Object[]{"_id"});
        obj = this.collection.findOne((DBObject)this.json("foo: 'bar'"), (DBObject)this.json("_id: 0, foo:1"));
        Assertions.assertThat((Collection)obj.keySet()).containsOnly(new Object[]{"foo"});
    }

    @Test
    public void testQueryWithDotNotationFieldSelector() throws Exception {
        this.collection.insert(new DBObject[]{this.json("_id: 123, index: false, foo: { a: 'a1', b: 0}")});
        DBObject obj = this.collection.findOne((DBObject)this.json("{}"), (DBObject)this.json("foo.a: 1, foo.b: 1"));
        Assertions.assertThat((Object)obj).isEqualTo((Object)this.json("_id: 123, foo: {a: 'a1', b: 0}"));
        obj = this.collection.findOne((DBObject)this.json("{}"), (DBObject)this.json("foo.a: 1"));
        Assertions.assertThat((Object)obj).isEqualTo((Object)this.json("_id: 123, foo: {a: 'a1'}"));
        obj = this.collection.findOne((DBObject)this.json("{}"), (DBObject)this.json("foo.a: 1, index: 1, _id: 0"));
        Assertions.assertThat((Object)obj).isEqualTo((Object)this.json("foo: {a: 'a1'}, index: false"));
        obj = this.collection.findOne((DBObject)this.json("{}"), (DBObject)this.json("foo: 1, _id: 0"));
        Assertions.assertThat((Object)obj).isEqualTo((Object)this.json("foo: {a: 'a1', b: 0}"));
        obj = this.collection.findOne((DBObject)this.json("{}"), (DBObject)this.json("foo.a.b.c.d: 1"));
        Assertions.assertThat((Object)obj).isEqualTo((Object)this.json("_id: 123, foo: {}"));
    }

    @Test
    public void testQuerySystemNamespace() throws Exception {
        Assertions.assertThat((Object)this.getCollection("system.foobar").findOne()).isNull();
        Assertions.assertThat((Collection)this.db.getCollectionNames()).isEmpty();
        this.collection.insert(new DBObject[]{this.json("{}")});
        BasicDBObject expectedObj = new BasicDBObject("name", (Object)this.collection.getFullName());
        DBObject coll = this.getCollection("system.namespaces").findOne((DBObject)expectedObj);
        Assertions.assertThat((Object)coll).isEqualTo((Object)expectedObj);
    }

    @Test
    public void testQueryAllExpression() throws Exception {
        this.collection.insert(new DBObject[]{this.json(" _id : [ { x : 1 } , { x : 2  } ]")});
        this.collection.insert(new DBObject[]{this.json(" _id : [ { x : 2 } , { x : 3  } ]")});
        Assertions.assertThat((List)this.collection.find((DBObject)this.json("'_id.x':{$all:[1,2]}")).toArray()).hasSize(1);
        Assertions.assertThat((List)this.collection.find((DBObject)this.json("'_id.x':{$all:[2,3]}")).toArray()).hasSize(1);
    }

    @Test
    public void testQueryWithSubdocumentIndex() throws Exception {
        this.collection.createIndex((DBObject)new BasicDBObject("action.actionId", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
        this.collection.insert(new DBObject[]{this.json("action: { actionId: 1 }, value: 'a'")});
        this.collection.insert(new DBObject[]{this.json("action: { actionId: 2 }, value: 'b'")});
        this.collection.insert(new DBObject[]{this.json("action: { actionId: 3 }, value: 'c'")});
        DBObject foundWithNestedDocument = this.collection.findOne((DBObject)this.json("action: { actionId: 2 }"));
        Assertions.assertThat((Object)foundWithNestedDocument.get("value")).isEqualTo((Object)"b");
        DBObject foundWithDotNotation = this.collection.findOne((DBObject)this.json("action.actionId: 2"));
        Assertions.assertThat((Object)foundWithDotNotation.get("value")).isEqualTo((Object)"b");
    }

    @Test
    public void testQueryBinaryData() throws Exception {
        byte[] firstBytes = new byte[]{1, 2, 3};
        byte[] secondBytes = new byte[]{3, 2, 1};
        this.collection.insert(new DBObject[]{new BasicDBObject("_id", (Object)1).append("test", (Object)firstBytes)});
        this.collection.insert(new DBObject[]{new BasicDBObject("_id", (Object)2).append("test", (Object)secondBytes)});
        DBObject first = this.collection.findOne((DBObject)new BasicDBObject("test", (Object)firstBytes));
        Assertions.assertThat((Object)first).isNotNull();
        Assertions.assertThat((Object)first.get("_id")).isEqualTo((Object)1);
        DBObject second = this.collection.findOne((DBObject)new BasicDBObject("test", (Object)secondBytes));
        Assertions.assertThat((Object)second).isNotNull();
        Assertions.assertThat((Object)second.get("_id")).isEqualTo((Object)2);
    }

    @Test
    public void testRemove() {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        this.collection.insert(new DBObject[]{this.json("_id: 2")});
        this.collection.insert(new DBObject[]{this.json("_id: 3")});
        this.collection.insert(new DBObject[]{this.json("_id: 4")});
        this.collection.remove((DBObject)this.json("_id: 2"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("_id: 2"))).isNull();
        Assertions.assertThat((long)this.collection.count()).isEqualTo(3L);
        this.collection.remove((DBObject)this.json("_id: {$gte: 3}"));
        Assertions.assertThat((long)this.collection.count()).isEqualTo(1L);
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1"));
    }

    @Test
    public void testRemoveSingle() throws Exception {
        BasicDBObject obj = new BasicDBObject("_id", (Object)ObjectId.get());
        this.collection.insert(new DBObject[]{obj});
        this.collection.remove((DBObject)obj);
    }

    @Test
    public void testRemoveReturnsModifiedDocumentCount() {
        this.collection.insert(new DBObject[]{this.json("{}")});
        this.collection.insert(new DBObject[]{this.json("{}")});
        WriteResult result = this.collection.remove((DBObject)this.json("{}"));
        Assertions.assertThat((int)result.getN()).isEqualTo(2);
        result = this.collection.remove((DBObject)this.json("{}"));
        Assertions.assertThat((int)result.getN()).isEqualTo(0);
    }

    @Test
    public void testReservedCollectionNames() throws Exception {
        try {
            this.getCollection("foo$bar").insert(new DBObject[]{this.json("{}")});
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((String)e.getMessage()).contains("cannot insert into reserved $ collection");
        }
        try {
            this.getCollection("").insert(new DBObject[]{this.json("{}")});
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((String)e.getMessage().toLowerCase()).contains("invalid ns");
        }
        try {
            this.getCollection("verylongstringverylongstringverylongstringverylongstringverylongstringverylongstringverylongstringverylongstringverylongstringverylongstringverylongstringverylongstringverylongstringverylongstringverylongstringverylongstring").insert(new DBObject[]{this.json("{}")});
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((String)e.getMessage()).contains("name too long");
        }
    }

    @Test
    public void testSave() {
        BasicDBObject inserted = this.json("_id: 1");
        this.collection.insert(new DBObject[]{inserted});
        this.collection.save((DBObject)inserted);
    }

    @Test
    public void testServerStatus() throws Exception {
        Date before = new Date();
        CommandResult serverStatus = this.command("serverStatus");
        serverStatus.throwOnError();
        Assertions.assertThat((Object)serverStatus.get("uptime")).isInstanceOf(Number.class);
        Assertions.assertThat((Object)serverStatus.get("uptimeMillis")).isInstanceOf(Long.class);
        Date serverTime = (Date)serverStatus.get("localTime");
        Assertions.assertThat((Object)serverTime).isNotNull();
        Assertions.assertThat((boolean)serverTime.after(new Date())).isFalse();
        Assertions.assertThat((boolean)before.after(serverTime)).isFalse();
        BSONObject connections = (BSONObject)serverStatus.get("connections");
        Assertions.assertThat((Object)connections.get("current")).isNotNull();
    }

    @Test
    public void testReplSetGetStatus() throws Exception {
        CommandResult result = this.command("replSetGetStatus");
        Assertions.assertThat((boolean)result.ok()).isFalse();
        Assertions.assertThat((String)result.getErrorMessage()).isEqualTo((Object)"not running with --replSet");
    }

    @Test
    public void testWhatsMyUri() throws Exception {
        for (String dbname : new String[]{"admin", "local", "test"}) {
            CommandResult result = this.client.getDB(dbname).command("whatsmyuri");
            result.throwOnError();
            Assertions.assertThat((boolean)result.ok()).isTrue();
            Assertions.assertThat((Object)result.get("you")).isNotNull();
            Assertions.assertThat((String)result.get("you").toString()).startsWith("127.0.0.1:");
        }
    }

    @Test
    public void testSort() {
        this.collection.insert(new DBObject[]{this.json("a:1, _id:1")});
        this.collection.insert(new DBObject[]{this.json("a:2, _id:2")});
        this.collection.insert(new DBObject[]{this.json("_id: 5")});
        this.collection.insert(new DBObject[]{this.json("a:3, _id:3")});
        this.collection.insert(new DBObject[]{this.json("a:4, _id:4")});
        DBCursor cursor = this.collection.find().sort((DBObject)this.json("a: -1"));
        Assertions.assertThat((List)cursor.toArray()).containsExactly(new Object[]{this.json("a:4, _id:4"), this.json("a:3, _id:3"), this.json("a:2, _id:2"), this.json("a:1, _id:1"), this.json("_id: 5")});
        cursor.close();
    }

    @Test
    public void testSortByEmbeddedKey() {
        this.collection.insert(new DBObject[]{this.json("_id: 1, a: { b:1 }")});
        this.collection.insert(new DBObject[]{this.json("_id: 2, a: { b:2 }")});
        this.collection.insert(new DBObject[]{this.json("_id: 3, a: { b:3 }")});
        List results = this.collection.find().sort((DBObject)this.json("'a.b': -1")).toArray();
        Assertions.assertThat((List)results).containsExactly(new Object[]{this.json("_id: 3, a: { b:3 }"), this.json("_id: 2, a: { b:2 }"), this.json("_id: 1, a: { b:1 }")});
    }

    @Test
    public void testUpdate() throws Exception {
        BasicDBObject object = this.json("_id: 1");
        BasicDBObject newObject = this.json("_id: 1");
        newObject.put((Object)"foo", (Object)"bar");
        this.collection.insert(new DBObject[]{object});
        WriteResult result = this.collection.update((DBObject)object, (DBObject)newObject);
        Assertions.assertThat((int)result.getN()).isEqualTo(1);
        Assertions.assertThat((boolean)result.isUpdateOfExisting()).isTrue();
        Assertions.assertThat((Object)result.getUpsertedId()).isNull();
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)newObject);
    }

    @Test
    public void testUpdateNothing() throws Exception {
        BasicDBObject object = this.json("_id: 1");
        WriteResult result = this.collection.update((DBObject)object, (DBObject)object);
        Assertions.assertThat((int)result.getN()).isEqualTo(0);
        Assertions.assertThat((Object)result.getUpsertedId()).isNull();
    }

    @Test
    public void testUpdateBlank() throws Exception {
        BasicDBObject document = this.json("'': 1, _id: 2, a: 3, b: 4");
        this.collection.insert(new DBObject[]{document});
        this.collection.update((DBObject)this.json("{}"), (DBObject)this.json("$set: {c:5}"));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("'': 1, _id: 2, a: 3, b: 4, c:5"));
    }

    @Test
    public void testUpdateEmptyPositional() throws Exception {
        try {
            this.collection.update((DBObject)this.json("{}"), (DBObject)this.json("$set:{'a.$.b': 1}"), true, false);
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(16650);
            Assertions.assertThat((String)e.getMessage()).contains("Cannot apply the positional operator without a corresponding query field containing an array.");
        }
    }

    @Test
    public void testUpdateMultiplePositional() throws Exception {
        this.collection.insert(new DBObject[]{this.json("{a: {b: {c: 1}}}")});
        try {
            this.collection.update((DBObject)this.json("{'a.b.c':1}"), (DBObject)this.json("$set:{'a.$.b.$.c': 1}"));
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(16650);
            Assertions.assertThat((String)e.getMessage()).contains("Cannot apply the positional operator without a corresponding query field containing an array.");
        }
    }

    @Test
    public void testUpdateIllegalFieldName() throws Exception {
        this.collection.insert(new DBObject[]{this.json("{x:1}")});
        this.collection.update((DBObject)this.json("{x:1}"), (DBObject)this.json("$set: {y:1}"));
        try {
            this.collection.update((DBObject)this.json("{x:1}"), (DBObject)this.json("$set: {$z:1}"));
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(15896);
            Assertions.assertThat((String)e.getMessage()).contains("Modified field name may not start with $");
        }
        this.collection.update((DBObject)this.json("{x:1}"), (DBObject)this.json("$unset: {$z:1}"));
        try {
            this.collection.update((DBObject)this.json("{x:1}"), (DBObject)this.json("$inc: {$z:1}"));
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(15896);
            Assertions.assertThat((String)e.getMessage()).contains("Modified field name may not start with $");
        }
        try {
            this.collection.update((DBObject)this.json("{x:1}"), (DBObject)this.json("$pushAll: {$z:[1,2,3]}"));
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(15896);
            Assertions.assertThat((String)e.getMessage()).contains("Modified field name may not start with $");
        }
    }

    @Test
    public void testUpdateSubdocument() throws Exception {
        try {
            this.collection.update((DBObject)this.json("{}"), (DBObject)this.json("'a.b.c': 123"));
            Fail.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((String)e.getMessage()).contains("Invalid BSON field name a.b.c");
        }
    }

    @Test
    public void testUpdateIdNoChange() {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("_id: 1, a: 5"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("_id: 1"))).isEqualTo((Object)this.json("_id: 1, a: 5"));
        this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("$set: {_id: 1, b: 3}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("_id: 1"))).isEqualTo((Object)this.json("_id: 1, a: 5, b: 3"));
        this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("$set: {_id: 1, a: 7}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("_id: 1"))).isEqualTo((Object)this.json("_id: 1, a: 7, b: 3"));
    }

    @Test
    public void testUpdatePush() throws Exception {
        BasicDBObject idObj = this.json("_id: 1");
        this.collection.insert(new DBObject[]{idObj});
        this.collection.update((DBObject)idObj, (DBObject)this.json("$push: {'field.subfield.subsubfield': 'value'}"));
        BasicDBObject expected = this.json("_id: 1, field:{subfield:{subsubfield: ['value']}}");
        Assertions.assertThat((Object)this.collection.findOne((DBObject)idObj)).isEqualTo((Object)expected);
        this.collection.update((DBObject)idObj, (DBObject)this.json("$set: {field: 'value'}"));
        try {
            this.collection.update((DBObject)idObj, (DBObject)this.json("$push: {field: 'value'}"));
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(10141);
            Assertions.assertThat((String)e.getMessage()).contains("Cannot apply $push modifier to non-array");
        }
        BasicDBObject pushObj = this.json("$push: {field1: 'value', field2: 'value2'}");
        this.collection.update((DBObject)idObj, (DBObject)pushObj);
        expected = this.json("_id: 1, field: 'value', field1: ['value'], field2: ['value2']");
        Assertions.assertThat((Object)this.collection.findOne((DBObject)idObj)).isEqualTo((Object)expected);
        pushObj = this.json("$push: {field1: 'value'}");
        this.collection.update((DBObject)idObj, (DBObject)pushObj);
        expected.put("field1", Arrays.asList("value", "value"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)idObj)).isEqualTo((Object)expected);
    }

    @Test
    public void testUpdatePushAll() throws Exception {
        BasicDBObject idObj = this.json("_id: 1");
        this.collection.insert(new DBObject[]{idObj});
        try {
            this.collection.update((DBObject)idObj, (DBObject)this.json("$pushAll: {field: 'value'}"));
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(10153);
            Assertions.assertThat((String)e.getMessage()).contains("Modifier $pushAll allowed for arrays only");
        }
        this.collection.update((DBObject)idObj, (DBObject)this.json("$pushAll: {field: ['value', 'value2']}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)idObj)).isEqualTo((Object)this.json("_id: 1, field: ['value', 'value2']"));
    }

    @Test
    public void testUpdateAddToSet() throws Exception {
        BasicDBObject idObj = this.json("_id: 1");
        this.collection.insert(new DBObject[]{idObj});
        this.collection.update((DBObject)idObj, (DBObject)this.json("$addToSet: {'field.subfield.subsubfield': 'value'}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)idObj)).isEqualTo((Object)this.json("_id: 1, field:{subfield:{subsubfield:['value']}}"));
        this.collection.update((DBObject)idObj, (DBObject)this.json("$set: {field: 'value'}"));
        try {
            this.collection.update((DBObject)idObj, (DBObject)this.json("$addToSet: {field: 'value'}"));
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(10141);
            Assertions.assertThat((String)e.getMessage()).contains("Cannot apply $addToSet modifier to non-array");
        }
        this.collection.update((DBObject)idObj, (DBObject)this.json("$addToSet: {field1: 'value', field2: 'value2'}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)idObj)).isEqualTo((Object)this.json("_id: 1, field: 'value', field1: ['value'], field2: ['value2']"));
        this.collection.update((DBObject)idObj, (DBObject)this.json("$addToSet: {field1: 'value'}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)idObj)).isEqualTo((Object)this.json("_id: 1, field: 'value', field1: ['value'], field2: ['value2']"));
    }

    @Test
    public void testUpdateAddToSetEach() throws Exception {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("$addToSet: {a: {$each: [6,5,4]}}"));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, a: [6,5,4]"));
        this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("$addToSet: {a: {$each: [3,2,1]}}"));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, a: [6,5,4,3,2,1]"));
        this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("$addToSet: {a: {$each: [4,7,9,2]}}"));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, a: [6,5,4,3,2,1,7,9]"));
        this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("$addToSet: {a: {$each: [12,13,12]}}"));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, a: [6,5,4,3,2,1,7,9,12,13]"));
    }

    @Test
    public void testUpdateDatasize() throws Exception {
        BasicDBObject obj = this.json("{_id:1, a:{x:[1, 2, 3]}}");
        this.collection.insert(new DBObject[]{obj});
        int oldSize = this.collection.getStats().getInt("size");
        this.collection.update((DBObject)this.json("_id:1"), (DBObject)this.json("$set:{'a.x.0': 3}"));
        Assertions.assertThat((Object)this.collection.findOne().get("a")).isEqualTo((Object)this.json("x:[3,2,3]"));
        Assertions.assertThat((int)this.collection.getStats().getInt("size")).isEqualTo(oldSize);
        this.collection.update((DBObject)this.json("_id:1"), (DBObject)this.json("$set:{'a.x.0': 'abc'}"));
        Assertions.assertThat((int)(this.collection.getStats().getInt("size") - oldSize)).isEqualTo(4);
    }

    @Test
    public void testUpdatePull() throws Exception {
        BasicDBObject obj = this.json("_id: 1");
        this.collection.insert(new DBObject[]{obj});
        Assertions.assertThat((Object)this.collection.findOne((DBObject)obj)).isEqualTo((Object)obj);
        this.collection.update((DBObject)obj, (DBObject)this.json("$set: {field: 'value'}"));
        try {
            this.collection.update((DBObject)obj, (DBObject)this.json("$pull: {field: 'value'}"));
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(10142);
            Assertions.assertThat((String)e.getMessage()).contains("Cannot apply $pull modifier to non-array");
        }
        this.collection.update((DBObject)obj, (DBObject)this.json("$set: {field: ['value1', 'value2', 'value1']}"));
        this.collection.update((DBObject)obj, (DBObject)this.json("$pull: {field: 'value1'}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)obj).get("field")).isEqualTo(Arrays.asList("value2"));
        this.collection.update((DBObject)obj, (DBObject)this.json("$set: {field1: ['value1', 'value2', 'value1']}"));
        this.collection.update((DBObject)obj, (DBObject)this.json("$set: {field2: ['value3', 'value3', 'value1']}"));
        this.collection.update((DBObject)obj, (DBObject)this.json("$pull: {field1: 'value2', field2: 'value3'}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)obj).get("field1")).isEqualTo(Arrays.asList("value1", "value1"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)obj).get("field2")).isEqualTo(Arrays.asList("value1"));
    }

    @Test
    public void testUpdatePullValueWithCondition() {
        this.collection.insert(new DBObject[]{this.json("_id: 1, votes: [ 3, 5, 6, 7, 7, 8 ]")});
        this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("$pull: { votes: { $gte: 6 } }"));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, votes: [ 3, 5 ]"));
    }

    @Test
    public void testUpdatePullDocuments() {
        this.collection.insert(new DBObject[]{this.json("_id: 1, results: [{item: 'A', score: 5}, {item: 'B', score: 8, comment: 'foobar'}]")});
        this.collection.insert(new DBObject[]{this.json("_id: 2, results: [{item: 'C', score: 8, comment: 'foobar'}, {item: 'B', score: 4}]")});
        this.collection.update((DBObject)this.json("{}"), (DBObject)this.json("$pull: { results: { score: 8 , item: 'B' } }"), false, true);
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("_id: 1"))).isEqualTo((Object)this.json("_id: 1, results: [{item: 'A', score: 5}]"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("_id: 2"))).isEqualTo((Object)this.json("_id: 2, results: [{item: 'C', score: 8, comment: 'foobar'}, {item: 'B', score: 4}]"));
    }

    @Test
    public void testUpdatePullLeavesEmptyArray() {
        BasicDBObject obj = this.json("_id: 1");
        this.collection.insert(new DBObject[]{obj});
        this.collection.update((DBObject)obj, (DBObject)this.json("$set: {field: [{'key1': 'value1', 'key2': 'value2'}]}"));
        this.collection.update((DBObject)obj, (DBObject)this.json("$pull: {field: {'key1': 'value1'}}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)obj)).isEqualTo((Object)this.json("_id: 1, field: []"));
    }

    @Test
    public void testUpdatePullAll() throws Exception {
        BasicDBObject obj = this.json("_id: 1");
        this.collection.insert(new DBObject[]{obj});
        this.collection.update((DBObject)obj, (DBObject)this.json("$set: {field: 'value'}"));
        try {
            this.collection.update((DBObject)obj, (DBObject)this.json("$pullAll: {field: 'value'}"));
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(10142);
            Assertions.assertThat((String)e.getMessage()).contains("Cannot apply $pullAll modifier to non-array");
        }
        this.collection.update((DBObject)obj, (DBObject)this.json("$set: {field1: ['value1', 'value2', 'value1', 'value3', 'value4', 'value3']}"));
        this.collection.update((DBObject)obj, (DBObject)this.json("$pullAll: {field1: ['value1', 'value3']}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)obj).get("field1")).isEqualTo(Arrays.asList("value2", "value4"));
        try {
            this.collection.update((DBObject)obj, (DBObject)this.json("$pullAll: {field1: 'bar'}"));
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(10153);
            Assertions.assertThat((String)e.getMessage()).contains("Modifier $pullAll allowed for arrays only");
        }
    }

    @Test
    public void testUpdateSet() throws Exception {
        BasicDBObject object = this.json("_id: 1");
        this.collection.insert(new DBObject[]{object});
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)object);
        this.collection.update((DBObject)object, (DBObject)this.json("$set: {foo: 'bar'}"));
        BasicDBObject expected = this.json("{}");
        expected.putAll((BSONObject)object);
        expected.put((Object)"foo", (Object)"bar");
        this.collection.update((DBObject)object, (DBObject)this.json("$set: {bar: 'bla'}"));
        expected.put((Object)"bar", (Object)"bla");
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)expected);
        this.collection.update((DBObject)object, (DBObject)this.json("$set: {'foo.bar': 'bla'}"));
        expected.put((Object)"foo", (Object)this.json("bar: 'bla'"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)expected);
        this.collection.update((DBObject)object, (DBObject)this.json("$set: {'foo.foo': '123'}"));
        ((BasicBSONObject)expected.get("foo")).put((Object)"foo", (Object)"123");
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)expected);
    }

    @Test
    public void testUpdateSetOnInsert() throws Exception {
        BasicDBObject object = this.json("_id: 1");
        this.collection.update((DBObject)object, (DBObject)this.json("$set: {b: 3}, $setOnInsert: {a: 3}"), true, true);
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, b: 3, a: 3"));
        this.collection.update((DBObject)object, (DBObject)this.json("$set: {b: 4}, $setOnInsert: {a: 5}"), true, true);
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, b: 4, a: 3"));
    }

    @Test
    public void testUpdateSetWithArrayIndices() throws Exception {
        this.collection.insert(new DBObject[]{this.json("_id: 1, a: [{x:0}]")});
        this.collection.update((DBObject)this.json("{}"), (DBObject)this.json("$set: {'a.0.x': 3}"));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, a: [{x:3}]"));
        this.collection.update((DBObject)this.json("{}"), (DBObject)this.json("$set: {'a.1.z': 17}"));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, a: [{x:3}, {z:17}]"));
        this.collection.update((DBObject)this.json("{}"), (DBObject)this.json("$set: {'a.0.y': 7}"));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, a: [{x:3, y:7}, {z:17}]"));
        this.collection.update((DBObject)this.json("{}"), (DBObject)this.json("$set: {'a.1': 'test'}"));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, a: [{x:3, y:7}, 'test']"));
    }

    @Test
    public void testUpdateUnsetWithArrayIndices() throws Exception {
        this.collection.insert(new DBObject[]{this.json("_id: 1, a:[{x:0}]")});
        this.collection.update((DBObject)this.json("{}"), (DBObject)this.json("$unset: {'a.0.x': 1}"));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, a:[{}]"));
        this.collection.update((DBObject)this.json("{}"), (DBObject)this.json("$unset: {'a.0': 1}"));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, a:[null]"));
        this.collection.update((DBObject)this.json("{}"), (DBObject)this.json("$unset: {'a.10': 1}"));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, a:[null]"));
    }

    @Test
    public void testUpdateMax() throws Exception {
        BasicDBObject object = this.json("_id: 1");
        this.collection.insert(new DBObject[]{object});
        this.collection.update((DBObject)object, (DBObject)this.json("$max: {'foo.bar': 1}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)this.json("_id: 1, foo : {bar : 1}"));
        this.collection.update((DBObject)object, (DBObject)this.json("$max: {'foo.bar': 1}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)this.json("_id: 1, foo : {bar : 1}"));
        this.collection.update((DBObject)object, (DBObject)this.json("$max: {'foo.bar': 10}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)this.json("_id: 1, foo : {bar : 10}"));
        this.collection.update((DBObject)object, (DBObject)this.json("$max: {'foo.bar': -100}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)this.json("_id: 1, foo : {bar : 10}"));
        this.collection.update((DBObject)object, (DBObject)this.json("$max: {'foo.bar': '1'}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)this.json("_id: 1, foo : {bar : '1'}"));
        this.collection.update((DBObject)object, (DBObject)this.json("$max: {'foo.bar': null}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)this.json("_id: 1, foo : {bar : '1'}"));
        this.collection.update((DBObject)object, (DBObject)this.json("$max: {'foo.bar': '2', 'buz' : 1}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)this.json("_id: 1, foo : {bar : '2'}, buz : 1"));
    }

    @Test
    public void testUpdateMin() throws Exception {
        BasicDBObject object = this.json("_id: 1");
        this.collection.insert(new DBObject[]{object});
        this.collection.update((DBObject)object, (DBObject)this.json("$min: {'foo.bar': 'b'}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)this.json("_id: 1, foo : {bar : 'b'}"));
        this.collection.update((DBObject)object, (DBObject)this.json("$min: {'foo.bar': 'a'}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)this.json("_id: 1, foo : {bar : 'a'}"));
        this.collection.update((DBObject)object, (DBObject)this.json("$min: {'foo.bar': 10}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)this.json("_id: 1, foo : {bar : 10}"));
        this.collection.update((DBObject)object, (DBObject)this.json("$min: {'foo.bar': 10}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)this.json("_id: 1, foo : {bar : 10}"));
        this.collection.update((DBObject)object, (DBObject)this.json("$min: {'foo.bar': 1}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)this.json("_id: 1, foo : {bar : 1}"));
        this.collection.update((DBObject)object, (DBObject)this.json("$min: {'foo.bar': 100}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)this.json("_id: 1, foo : {bar : 1}"));
        this.collection.update((DBObject)object, (DBObject)this.json("$min: {'foo.bar': null}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)this.json("_id: 1, foo : {bar : null}"));
        this.collection.update((DBObject)object, (DBObject)this.json("$min: {'foo.bar': 'a'}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)this.json("_id: 1, foo : {bar : null}"));
    }

    @Test
    public void testUpdateMaxCompareNumbers() throws Exception {
        BasicDBObject object = this.json("_id: 1, highScore: 800, lowScore: 200");
        this.collection.insert(new DBObject[]{object});
        this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("$max: { highScore: 950 }"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("_id: 1"))).isEqualTo((Object)this.json("_id: 1, highScore: 950, lowScore: 200"));
        this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("$max: { highScore: 870 }"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("_id: 1"))).isEqualTo((Object)this.json("_id: 1, highScore: 950, lowScore: 200"));
    }

    @Test
    public void testUpdateMaxCompareDates() throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
        BasicDBObject object = new BasicDBObject("_id", (Object)1).append("desc", (Object)"crafts").append("dateEntered", (Object)df.parse("2013-10-01T05:00:00")).append("dateExpired", (Object)df.parse("2013-10-01T16:38:16"));
        this.collection.insert(new DBObject[]{object});
        this.collection.update((DBObject)this.json("_id: 1"), (DBObject)new BasicDBObject("$max", (Object)new BasicDBObject("dateExpired", (Object)df.parse("2013-09-30T00:00:00"))));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("_id: 1"))).isEqualTo((Object)this.json("_id: 1, desc: 'crafts'").append("dateEntered", (Object)df.parse("2013-10-01T05:00:00")).append("dateExpired", (Object)df.parse("2013-10-01T16:38:16")));
        this.collection.update((DBObject)this.json("_id: 1"), (DBObject)new BasicDBObject("$max", (Object)new BasicDBObject("dateExpired", (Object)df.parse("2014-01-07T00:00:00"))));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("_id: 1"))).isEqualTo((Object)this.json("_id: 1, desc: 'crafts'").append("dateEntered", (Object)df.parse("2013-10-01T05:00:00")).append("dateExpired", (Object)df.parse("2014-01-07T00:00:00")));
    }

    @Test
    public void testUpdateMinCompareNumbers() throws Exception {
        BasicDBObject object = this.json("_id: 1, highScore: 800, lowScore: 200");
        this.collection.insert(new DBObject[]{object});
        this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("$min: { lowScore: 150 }"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("_id: 1"))).isEqualTo((Object)this.json("_id: 1, highScore: 800, lowScore: 150"));
        this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("$min: { lowScore: 250 }"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("_id: 1"))).isEqualTo((Object)this.json("_id: 1, highScore: 800, lowScore: 150"));
    }

    @Test
    public void testUpdateMinCompareDates() throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
        BasicDBObject object = new BasicDBObject("_id", (Object)1).append("desc", (Object)"crafts").append("dateEntered", (Object)df.parse("2013-10-01T05:00:00")).append("dateExpired", (Object)df.parse("2013-10-01T16:38:16"));
        this.collection.insert(new DBObject[]{object});
        this.collection.update((DBObject)this.json("_id: 1"), (DBObject)new BasicDBObject("$min", (Object)new BasicDBObject("dateEntered", (Object)df.parse("2013-09-25T00:00:00"))));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("_id: 1"))).isEqualTo((Object)this.json("_id: 1, desc: 'crafts'").append("dateEntered", (Object)df.parse("2013-09-25T00:00:00")).append("dateExpired", (Object)df.parse("2013-10-01T16:38:16")));
        this.collection.update((DBObject)this.json("_id: 1"), (DBObject)new BasicDBObject("$min", (Object)new BasicDBObject("dateEntered", (Object)df.parse("2014-01-07T00:00:00"))));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("_id: 1"))).isEqualTo((Object)this.json("_id: 1, desc: 'crafts'").append("dateEntered", (Object)df.parse("2013-09-25T00:00:00")).append("dateExpired", (Object)df.parse("2013-10-01T16:38:16")));
    }

    @Test
    public void testUpdatePop() throws Exception {
        BasicDBObject object = this.json("_id: 1");
        this.collection.insert(new DBObject[]{object});
        this.collection.update((DBObject)object, (DBObject)this.json("$pop: {'foo.bar': 1}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)object);
        this.collection.update((DBObject)object, (DBObject)this.json("$set: {'foo.bar': [1,2,3]}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)this.json("_id:1, foo:{bar:[1,2,3]}"));
        this.collection.update((DBObject)object, (DBObject)this.json("$pop: {'foo.bar': 1}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)this.json("_id:1, foo:{bar:[1,2]}"));
        this.collection.update((DBObject)object, (DBObject)this.json("$pop: {'foo.bar': -1}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)this.json("_id:1, foo:{bar:[2]}"));
        this.collection.update((DBObject)object, (DBObject)this.json("$pop: {'foo.bar': null}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)this.json("_id:1, foo:{bar:[]}"));
    }

    @Test
    public void testUpdateUnset() throws Exception {
        BasicDBObject obj = this.json("_id: 1, a: 1, b: null, c: 'value'");
        this.collection.insert(new DBObject[]{obj});
        try {
            this.collection.update((DBObject)obj, (DBObject)this.json("$unset: {_id: ''}"));
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(10148);
            Assertions.assertThat((String)e.getMessage()).contains("Mod on _id not allowed");
        }
        this.collection.update((DBObject)obj, (DBObject)this.json("$unset: {a:'', b:''}"));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, c: 'value'"));
        this.collection.update((DBObject)obj, (DBObject)this.json("$unset: {'c.y': 1}"));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, c: 'value'"));
        this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("a: {b: 'foo', c: 'bar'}"));
        this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("$unset: {'a.b':1}"));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, a: {c: 'bar'}"));
    }

    @Test
    public void testUpdateWithIdIn() {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        BasicDBObject update = this.json("$push: {n: {_id: 2, u:3}}, $inc: {c:4}");
        BasicDBObject expected = this.json("_id: 1, n: [{_id: 2, u:3}], c:4");
        this.collection.update((DBObject)this.json("_id: {$in: [1]}"), (DBObject)update, false, true);
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)expected);
    }

    @Test
    public void testUpdateMulti() throws Exception {
        this.collection.insert(new DBObject[]{this.json("a: 1")});
        this.collection.insert(new DBObject[]{this.json("a: 1")});
        WriteResult result = this.collection.update((DBObject)this.json("a: 1"), (DBObject)this.json("$set: {b: 2}"));
        Assertions.assertThat((int)result.getN()).isEqualTo(1);
        Assertions.assertThat((boolean)result.isUpdateOfExisting()).isTrue();
        Assertions.assertThat((int)this.collection.find((DBObject)new BasicDBObject("b", (Object)2)).count()).isEqualTo(1);
        result = this.collection.update((DBObject)this.json("a: 1"), (DBObject)this.json("$set: {b: 3}"), false, true);
        Assertions.assertThat((int)result.getN()).isEqualTo(2);
        Assertions.assertThat((boolean)result.isUpdateOfExisting()).isTrue();
        Assertions.assertThat((int)this.collection.find((DBObject)new BasicDBObject("b", (Object)2)).count()).isEqualTo(0);
        Assertions.assertThat((int)this.collection.find((DBObject)new BasicDBObject("b", (Object)3)).count()).isEqualTo(2);
    }

    @Test
    public void testUpdateIllegalInt() throws Exception {
        this.collection.insert(new DBObject[]{this.json("_id: 1, a: {x:1}")});
        try {
            this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("$inc: {a: 1}"));
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((String)e.getMessage()).contains("cannot increment value");
        }
        try {
            this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("$inc: {'a.x': 'b'}"));
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((String)e.getMessage()).contains("cannot increment with non-numeric value");
        }
    }

    @Test
    public void testUpdateWithIdInMulti() {
        this.collection.insert(new DBObject[]{this.json("_id: 1"), this.json("_id: 2")});
        this.collection.update((DBObject)this.json("_id: {$in:[1,2]}"), (DBObject)this.json("$set: {n:1}"), false, true);
        List results = this.collection.find().toArray();
        Assertions.assertThat((List)results).containsOnly(new Object[]{this.json("_id: 1, n:1"), this.json("_id: 2, n: 1")});
    }

    @Test
    public void testUpdateWithIdInMultiReturnModifiedDocumentCount() {
        this.collection.insert(new DBObject[]{this.json("_id: 1"), this.json("_id: 2")});
        WriteResult result = this.collection.update((DBObject)this.json("_id: {$in:[1,2]}"), (DBObject)this.json("$set:{n:1}"), false, true);
        Assertions.assertThat((int)result.getN()).isEqualTo(2);
    }

    @Test
    public void testUpdateWithIdQuery() {
        this.collection.insert(new DBObject[]{this.json("_id: 1"), this.json("_id: 2")});
        this.collection.update((DBObject)this.json("_id: {$gt:1}"), (DBObject)this.json("$set: {n:1}"), false, true);
        List results = this.collection.find().toArray();
        Assertions.assertThat((List)results).containsOnly(new Object[]{this.json("_id: 1"), this.json("_id: 2, n:1")});
    }

    @Test
    public void testUpdateWithObjectId() {
        this.collection.insert(new DBObject[]{this.json("_id: {n:1}")});
        WriteResult result = this.collection.update((DBObject)this.json("_id: {n:1}"), (DBObject)this.json("$set: {a:1}"), false, false);
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: {n:1}, a:1"));
        Assertions.assertThat((int)result.getN()).isEqualTo(1);
    }

    @Test
    public void testUpdateArrayMatch() throws Exception {
        this.collection.insert(new DBObject[]{this.json("_id:1, a:[{x:1,y:1}, {x:2,y:2}, {x:3,y:3}]")});
        this.collection.update((DBObject)this.json("'a.x': 2"), (DBObject)this.json("$inc: {'a.$.y': 1}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("'a.x': 2"))).isEqualTo((Object)this.json("_id:1, a:[{x:1,y:1}, {x:2,y:3}, {x:3,y:3}]"));
        this.collection.insert(new DBObject[]{this.json("{'array': [{'123a':{'name': 'old'}}]}")});
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("{'array.123a.name': 'old'}"))).isNotNull();
        this.collection.update((DBObject)this.json("{'array.123a.name': 'old'}"), (DBObject)this.json("{$set: {'array.$.123a.name': 'new'}}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("{'array.123a.name': 'new'}"))).isNotNull();
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("{'array.123a.name': 'old'}"))).isNull();
    }

    @Test
    public void testMultiUpdateArrayMatch() throws Exception {
        this.collection.insert(new DBObject[]{this.json("{}")});
        this.collection.insert(new DBObject[]{this.json("x:[1,2,3]")});
        this.collection.insert(new DBObject[]{this.json("x:99")});
        this.collection.update((DBObject)this.json("x:2"), (DBObject)this.json("$inc:{'x.$': 1}"), false, true);
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("x:1")).get("x")).isEqualTo(Arrays.asList(1, 3, 3));
    }

    @Test
    public void testUpsert() {
        WriteResult result = this.collection.update((DBObject)this.json("n:'jon'"), (DBObject)this.json("$inc:{a:1}"), true, false);
        Assertions.assertThat((int)result.getN()).isEqualTo(1);
        DBObject object = this.collection.findOne();
        Assertions.assertThat((Object)result.getUpsertedId()).isEqualTo(object.get("_id"));
        object.removeField("_id");
        Assertions.assertThat((Object)object).isEqualTo((Object)this.json("n:'jon', a:1"));
        result = this.collection.update((DBObject)this.json("_id: 17, n:'jon'"), (DBObject)this.json("$inc:{a:1}"), true, false);
        Assertions.assertThat((Object)result.getUpsertedId()).isNull();
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("_id:17"))).isEqualTo((Object)this.json("_id: 17, n:'jon', a:1"));
    }

    @Test
    public void testUpsertFieldOrder() throws Exception {
        this.collection.update((DBObject)this.json("'x.y': 2"), (DBObject)this.json("$inc: {a:7}"), true, false);
        DBObject obj = this.collection.findOne();
        obj.removeField("_id");
        Assertions.assertThat((Object)obj).isEqualTo((Object)this.json("x:{y:2}, a:7"));
    }

    @Test
    public void testUpsertWithoutId() {
        WriteResult result = this.collection.update((DBObject)this.json("a:1"), (DBObject)this.json("a:2"), true, false);
        Assertions.assertThat((int)result.getN()).isEqualTo(1);
        Assertions.assertThat((boolean)result.isUpdateOfExisting()).isFalse();
        Assertions.assertThat((Object)this.collection.findOne().get("_id")).isInstanceOf(ObjectId.class);
        Assertions.assertThat((Object)this.collection.findOne().get("a")).isEqualTo((Object)2);
    }

    @Test
    public void testUpsertOnIdWithPush() {
        BasicDBObject update1 = this.json("$push: {c: {a:1, b:2} }");
        BasicDBObject update2 = this.json("$push: {c: {a:3, b:4} }");
        this.collection.update((DBObject)this.json("_id: 1"), (DBObject)update1, true, false);
        this.collection.update((DBObject)this.json("_id: 1"), (DBObject)update2, true, false);
        BasicDBObject expected = this.json("_id: 1, c: [{a:1, b:2}, {a:3, b:4}]");
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("'c.a':3, 'c.b':4"))).isEqualTo((Object)expected);
    }

    @Test
    public void testUpsertWithConditional() {
        BasicDBObject query = this.json("_id: 1, b: {$gt: 5}");
        BasicDBObject update = this.json("$inc: {a: 1}");
        this.collection.update((DBObject)query, (DBObject)update, true, false);
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, a: 1"));
    }

    @Test
    public void testUpsertWithEmbeddedQuery() {
        this.collection.update((DBObject)this.json("_id: 1, e.i: 1"), (DBObject)this.json("$set: {a:1}"), true, false);
        Assertions.assertThat((Object)this.collection.findOne((DBObject)this.json("_id: 1"))).isEqualTo((Object)this.json("_id:1, e: {i:1}, a:1"));
    }

    @Test
    public void testUpsertWithIdIn() throws Exception {
        BasicDBObject query = this.json("_id: {$in: [1]}");
        BasicDBObject update = this.json("$push: {n: {_id: 2 ,u : 3}}, $inc: {c: 4}");
        BasicDBObject expected = this.json("_id: 1, n: [{_id: 2 ,u : 3}], c: 4");
        this.collection.update((DBObject)query, (DBObject)update, true, false);
        DBObject actual = this.collection.findOne();
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void testUpdateWithMultiplyOperator() throws Exception {
        BasicDBObject object = this.json("_id: 1");
        this.collection.insert(new DBObject[]{object});
        this.collection.update((DBObject)object, (DBObject)this.json("$mul: {a: 2}, $set: {b: 2}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)this.json("_id: 1, a: 0, b: 2"));
        this.collection.update((DBObject)object, (DBObject)this.json("$mul: {b: 2.5}, $inc: {a: 0.5}"));
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)this.json("_id: 1, a: 0.5, b: 5.0"));
    }

    @Test
    public void testUpdateWithIllegalMultiplyFails() throws Exception {
        BasicDBObject object = this.json("_id: 1, foo: 'x', bar: 1");
        this.collection.insert(new DBObject[]{object});
        try {
            this.collection.update((DBObject)object, (DBObject)this.json("$mul: {_id: 2}"));
            Fail.fail((String)"MongoCommandException expected");
        }
        catch (MongoCommandException e) {
            Assertions.assertThat((String)e.getMessage()).contains("_id");
        }
        try {
            this.collection.update((DBObject)object, (DBObject)this.json("$mul: {foo: 2}"));
            Fail.fail((String)"MongoCommandException expected");
        }
        catch (MongoCommandException e) {
            Assertions.assertThat((String)e.getMessage()).contains("cannot multiply value 'x'");
        }
        try {
            this.collection.update((DBObject)object, (DBObject)this.json("$mul: {bar: 'x'}"));
            Fail.fail((String)"MongoCommandException expected");
        }
        catch (MongoCommandException e) {
            Assertions.assertThat((String)e.getMessage()).contains("cannot multiply with non-numeric value");
        }
    }

    @Test
    public void testIsMaster() throws Exception {
        CommandResult isMaster = this.db.command("isMaster");
        Assertions.assertThat((boolean)isMaster.ok()).isTrue();
        Assertions.assertThat((boolean)isMaster.getBoolean("ismaster")).isTrue();
        Assertions.assertThat((Object)isMaster.getDate("localTime")).isInstanceOf(Date.class);
        Assertions.assertThat((int)isMaster.getInt("maxBsonObjectSize")).isGreaterThan(1000);
        Assertions.assertThat((int)isMaster.getInt("maxMessageSizeBytes")).isGreaterThan(isMaster.getInt("maxBsonObjectSize"));
    }

    @Test
    public void testFindWithNullOrNoFieldFilter() {
        this.collection.insert(new DBObject[]{this.json("name: 'jon', group: 'group1'")});
        this.collection.insert(new DBObject[]{this.json("name: 'leo', group: 'group1'")});
        this.collection.insert(new DBObject[]{this.json("name: 'neil1', group: 'group2'")});
        this.collection.insert(new DBObject[]{this.json("name: 'neil2', group: null")});
        this.collection.insert(new DBObject[]{this.json("name: 'neil3'")});
        List objs = this.collection.find((DBObject)this.json("group: null")).toArray();
        ((ListAssert)Assertions.assertThat((List)objs).as("should have two neils (neil2, neil3)")).hasSize(2);
        objs = this.collection.find((DBObject)this.json("group: {$exists: false}")).toArray();
        ((ListAssert)Assertions.assertThat((List)objs).as("should have one neils (neil3)")).hasSize(1);
        objs = this.collection.find((DBObject)this.json("other: null")).toArray();
        ((ListAssert)Assertions.assertThat((List)objs).as("should return all documents")).hasSize(5);
        objs = this.collection.find((DBObject)this.json("other: {$exists: false}")).toArray();
        ((ListAssert)Assertions.assertThat((List)objs).as("should return all documents")).hasSize(5);
    }

    @Test
    public void testInsertsWithUniqueIndex() {
        this.collection.createIndex((DBObject)new BasicDBObject("uniqueKeyField", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
        this.collection.insert(new DBObject[]{this.json("uniqueKeyField: 'abc1', afield: 'avalue'")});
        this.collection.insert(new DBObject[]{this.json("uniqueKeyField: 'abc2', afield: 'avalue'")});
        this.collection.insert(new DBObject[]{this.json("uniqueKeyField: 'abc3', afield: 'avalue'")});
        try {
            this.collection.insert(new DBObject[]{this.json("uniqueKeyField: 'abc2', afield: 'avalue'")});
            Fail.fail((String)"DuplicateKeyException expected");
        }
        catch (DuplicateKeyException duplicateKeyException) {
            // empty catch block
        }
    }

    @Test
    public void testInsertBinaryData() throws Exception {
        this.collection.insert(new DBObject[]{new BasicDBObject("test", (Object)new byte[]{1, 2, 3})});
    }

    @Test
    public void testUniqueIndexWithSubdocument() {
        this.collection.createIndex((DBObject)new BasicDBObject("action.actionId", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
        this.collection.insert(new DBObject[]{this.json("action: 'abc1'")});
        this.collection.insert(new DBObject[]{this.json("action: { actionId: 1 }")});
        this.collection.insert(new DBObject[]{this.json("action: { actionId: 2 }")});
        this.collection.insert(new DBObject[]{this.json("action: { actionId: 3 }")});
        try {
            this.collection.insert(new DBObject[]{this.json("action: { actionId: 1 }")});
            Fail.fail((String)"DuplicateKeyException expected");
        }
        catch (DuplicateKeyException duplicateKeyException) {
            // empty catch block
        }
    }

    @Test
    public void testAddNonUniqueIndexOnNonIdField() {
        this.collection.createIndex((DBObject)new BasicDBObject("someField", (Object)1), (DBObject)new BasicDBObject("unique", (Object)false));
        this.collection.insert(new DBObject[]{this.json("someField: 'abc'")});
        this.collection.insert(new DBObject[]{this.json("someField: 'abc'")});
    }

    @Test
    public void testCompoundUniqueIndicesNotSupportedAndThrowsException() {
        try {
            this.collection.createIndex((DBObject)new BasicDBObject("a", (Object)1).append("b", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException mongoException) {
            // empty catch block
        }
    }

    @Test
    public void testCursorOptionNoTimeout() throws Exception {
        DBCursor cursor = this.collection.find().addOption(16);
        try {
            Assert.assertFalse((boolean)cursor.iterator().hasNext());
        }
        finally {
            cursor.close();
        }
    }

    @Test
    public void testBulkInsert() throws Exception {
        BulkWriteOperation bulk = this.collection.initializeOrderedBulkOperation();
        bulk.insert((DBObject)this.json("_id: 1"));
        bulk.insert((DBObject)this.json("_id: 2"));
        bulk.insert((DBObject)this.json("_id: 3"));
        BulkWriteResult result = bulk.execute();
        Assertions.assertThat((int)result.getInsertedCount()).isEqualTo(3);
    }

    @Test
    public void testBulkUpdateOrdered() throws Exception {
        this.insertUpdateInBulk(this.collection.initializeOrderedBulkOperation());
        this.removeInBulk(this.collection.initializeOrderedBulkOperation());
    }

    @Test
    public void testBulkUpdateUnordered() throws Exception {
        this.insertUpdateInBulk(this.collection.initializeUnorderedBulkOperation());
        this.removeInBulk(this.collection.initializeUnorderedBulkOperation());
    }

    @Test
    public void testUpdateCurrentDateIllegalTypeSpecification() throws Exception {
        BasicDBObject object = this.json("_id: 1");
        this.collection.insert(new DBObject[]{object});
        try {
            this.collection.update((DBObject)object, (DBObject)this.json("$currentDate: {lastModified: null}"));
            Fail.fail((String)"MongoCommandException expected");
        }
        catch (MongoCommandException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(2);
            Assertions.assertThat((String)e.getErrorMessage()).startsWith("NULL").contains("is not a valid type");
        }
        try {
            this.collection.update((DBObject)object, (DBObject)this.json("$currentDate: {lastModified: 123.456}"));
            Fail.fail((String)"MongoCommandException expected");
        }
        catch (MongoCommandException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(2);
            Assertions.assertThat((String)e.getErrorMessage()).startsWith("Double").contains("is not a valid type");
        }
        try {
            this.collection.update((DBObject)object, (DBObject)this.json("$currentDate: {lastModified: 'foo'}"));
            Fail.fail((String)"MongoCommandException expected");
        }
        catch (MongoCommandException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(2);
            Assertions.assertThat((String)e.getErrorMessage()).startsWith("String").contains("is not a valid type");
        }
        try {
            this.collection.update((DBObject)object, (DBObject)this.json("$currentDate: {lastModified: {$type: 'foo'}}"));
            Fail.fail((String)"MongoCommandException expected");
        }
        catch (MongoCommandException e) {
            Assertions.assertThat((int)e.getCode()).isEqualTo(2);
            Assertions.assertThat((String)e.getErrorMessage()).startsWith("The '$type' string field is required to be 'date' or 'timestamp'");
        }
        Assertions.assertThat((Object)this.collection.findOne((DBObject)object)).isEqualTo((Object)object);
    }

    @Test
    public void testUpdateCurrentDate() throws Exception {
        BasicDBObject object = this.json("_id: 1");
        this.collection.insert(new DBObject[]{object});
        this.collection.update((DBObject)object, (DBObject)this.json("$currentDate: {'x.lastModified': true}"));
        Assertions.assertThat((Object)((DBObject)this.collection.findOne((DBObject)object).get("x")).get("lastModified")).isInstanceOf(Date.class);
        this.collection.update((DBObject)object, (DBObject)this.json("$currentDate: {'x.lastModified': {$type: 'date'}}"));
        Assertions.assertThat((Object)((DBObject)this.collection.findOne((DBObject)object).get("x")).get("lastModified")).isInstanceOf(Date.class);
        this.collection.update((DBObject)object, (DBObject)this.json("$currentDate: {'x.lastModified': {$type: 'timestamp'}}"));
        Assertions.assertThat((Object)((DBObject)this.collection.findOne((DBObject)object).get("x")).get("lastModified")).isInstanceOf(BSONTimestamp.class);
    }

    @Test
    public void testRenameField() throws Exception {
        BasicDBObject object = this.json("_id: 1, foo: 'x', bar: 'y'");
        this.collection.insert(new DBObject[]{object});
        this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("$rename: {foo: 'foo2', bar: 'bar2'}"));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, foo2: 'x', bar2: 'y'"));
        this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("$rename: {'bar2': 'foo', foo2: 'bar'}"));
        Assertions.assertThat((Object)this.collection.findOne()).isEqualTo((Object)this.json("_id: 1, bar: 'x', foo: 'y'"));
    }

    @Test
    public void testRenameFieldIllegalValue() throws Exception {
        BasicDBObject object = this.json("_id: 1, foo: 'x', bar: 'y'");
        this.collection.insert(new DBObject[]{object});
        try {
            this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("$rename: {foo: 12345}"));
            Fail.fail((String)"MongoCommandException expected");
        }
        catch (MongoCommandException e) {
            Assertions.assertThat((String)e.getMessage()).contains("The 'to' field for $rename must be a string");
        }
        try {
            this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("$rename: {'_id': 'id'}"));
            Fail.fail((String)"MongoCommandException expected");
        }
        catch (MongoCommandException e) {
            Assertions.assertThat((String)e.getMessage()).contains("Mod on _id not allowed");
        }
        try {
            this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("$rename: {foo: '_id'}"));
            Fail.fail((String)"MongoCommandException expected");
        }
        catch (MongoCommandException e) {
            Assertions.assertThat((String)e.getMessage()).contains("Mod on _id not allowed");
        }
        try {
            this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("$rename: {foo: 'bar', 'bar': 'bar2'}"));
            Fail.fail((String)"MongoCommandException expected");
        }
        catch (MongoCommandException e) {
            Assertions.assertThat((String)e.getMessage()).contains("Cannot update 'bar' and 'bar' at the same time");
        }
        try {
            this.collection.update((DBObject)this.json("_id: 1"), (DBObject)this.json("$rename: {bar: 'foo', bar2: 'foo'}"));
            Fail.fail((String)"MongoCommandException expected");
        }
        catch (MongoCommandException e) {
            Assertions.assertThat((String)e.getMessage()).contains("Cannot update 'foo' and 'foo' at the same time");
        }
    }

    @Test
    public void testRenameCollection() throws Exception {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        this.collection.insert(new DBObject[]{this.json("_id: 2")});
        this.collection.insert(new DBObject[]{this.json("_id: 3")});
        DBCollection renamedCollection = this.collection.rename("other-collection-name");
        Assertions.assertThat((String)renamedCollection.getName()).isEqualTo((Object)"other-collection-name");
        Set collectionNames = this.db.getCollectionNames();
        Assertions.assertThat((Collection)collectionNames).containsOnly(new Object[]{"system.indexes", "other-collection-name"});
        Assertions.assertThat((long)this.getCollection("other-collection-name").count()).isEqualTo(3L);
    }

    @Test
    public void testRenameCollection_targetAlreadyExists() throws Exception {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        this.collection.insert(new DBObject[]{this.json("_id: 2")});
        this.collection.insert(new DBObject[]{this.json("_id: 3")});
        DBCollection otherCollection = this.db.getCollection("other-collection-name");
        otherCollection.insert(new DBObject[]{this.json("_id: 1")});
        try {
            this.collection.rename("other-collection-name");
            Fail.fail((String)"MongoCommandException expected");
        }
        catch (MongoCommandException e) {
            Assertions.assertThat((String)e.getErrorMessage()).isEqualTo((Object)"target namespace already exists");
        }
        Set collectionNames = this.db.getCollectionNames();
        Assertions.assertThat((Collection)collectionNames).containsOnly(new Object[]{"system.indexes", this.collection.getName(), "other-collection-name"});
        Assertions.assertThat((long)this.collection.count()).isEqualTo(3L);
        Assertions.assertThat((long)this.getCollection("other-collection-name").count()).isEqualTo(1L);
    }

    @Test
    public void testRenameCollection_dropTarget() throws Exception {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        this.collection.insert(new DBObject[]{this.json("_id: 2")});
        this.collection.insert(new DBObject[]{this.json("_id: 3")});
        DBCollection otherCollection = this.db.getCollection("other-collection-name");
        otherCollection.insert(new DBObject[]{this.json("_id: 1")});
        DBCollection renamedCollection = this.collection.rename("other-collection-name", true);
        Assertions.assertThat((String)renamedCollection.getName()).isEqualTo((Object)"other-collection-name");
        Set collectionNames = this.db.getCollectionNames();
        Assertions.assertThat((Collection)collectionNames).containsOnly(new Object[]{"system.indexes", "other-collection-name"});
        Assertions.assertThat((long)this.getCollection("other-collection-name").count()).isEqualTo(3L);
    }

    @Test
    public void testGetIndexes_empty() throws Exception {
        List indexInfo = this.collection.getIndexInfo();
        Assertions.assertThat((List)indexInfo).isEmpty();
    }

    @Test
    public void testGetIndexes() throws Exception {
        this.collection.insert(new DBObject[]{this.json("_id: 1")});
        this.db.getCollection("other").insert(new DBObject[]{this.json("_id: 1")});
        this.collection.createIndex("bla");
        List indexInfo = this.collection.getIndexInfo();
        Assertions.assertThat((List)indexInfo).containsOnly(new Object[]{this.json("name:'_id_', ns:'testdb.testcoll', key:{_id:1}"), this.json("name:'_id_', ns:'testdb.other', key:{_id:1}"), this.json("name:'bla_1', ns:'testdb.testcoll', key:{bla:1}")});
    }

    @Test
    public void testFieldSelection_deselectId() {
        BasicDBObject obj = this.json("_id: 1, order:1, visits: 2");
        this.collection.insert(new DBObject[]{obj});
        BasicDBObject fieldsMap = new BasicDBObject();
        fieldsMap.put((Object)"_id", (Object)0);
        DBCursor cur = this.collection.find((DBObject)new BasicDBObject(), (DBObject)new BasicDBObject((Map)fieldsMap));
        Assertions.assertThat((List)cur.toArray()).containsExactly(new Object[]{this.json("order:1, visits:2")});
        cur.close();
    }

    @Test
    public void testFieldSelection_deselectOneField() {
        BasicDBObject obj = this.json("_id: 1, order:1, visits: 2, eid: 12345");
        this.collection.insert(new DBObject[]{obj});
        BasicDBObject fieldsMap = new BasicDBObject();
        fieldsMap.put((Object)"visits", (Object)0);
        DBCursor cur = this.collection.find((DBObject)new BasicDBObject(), (DBObject)new BasicDBObject((Map)fieldsMap));
        Assertions.assertThat((List)cur.toArray()).containsExactly(new Object[]{this.json("_id:1, order:1, eid: 12345")});
        cur.close();
    }

    @Test
    public void testFieldSelection_deselectTwoFields() {
        BasicDBObject obj = this.json("_id: 1, order:1, visits: 2, eid: 12345");
        this.collection.insert(new DBObject[]{obj});
        BasicDBObject fieldsMap = new BasicDBObject();
        fieldsMap.put((Object)"visits", (Object)0);
        fieldsMap.put((Object)"eid", (Object)0);
        DBCursor cur = this.collection.find((DBObject)new BasicDBObject(), (DBObject)new BasicDBObject((Map)fieldsMap));
        Assertions.assertThat((List)cur.toArray()).containsExactly(new Object[]{this.json("_id:1, order:1")});
        cur.close();
    }

    @Test
    public void testFieldSelection_selectAndDeselectFields() {
        BasicDBObject obj = this.json("_id: 1, order:1, visits: 2, eid: 12345");
        this.collection.insert(new DBObject[]{obj});
        BasicDBObject fieldsMap = new BasicDBObject();
        fieldsMap.put((Object)"visits", (Object)0);
        fieldsMap.put((Object)"eid", (Object)1);
        DBCursor cur = this.collection.find((DBObject)new BasicDBObject(), (DBObject)new BasicDBObject((Map)fieldsMap));
        Assertions.assertThat((List)cur.toArray()).containsExactly(new Object[]{this.json("_id:1, eid: 12345")});
        cur.close();
    }

    private void insertUpdateInBulk(BulkWriteOperation bulk) {
        bulk.insert((DBObject)this.json("_id: 1, field: 'x'"));
        bulk.insert((DBObject)this.json("_id: 2, field: 'x'"));
        bulk.insert((DBObject)this.json("_id: 3, field: 'x'"));
        BulkWriteRequestBuilder bulkRequest = bulk.find((DBObject)this.json("field: 'x'"));
        bulkRequest.update((DBObject)this.json("$set: {field: 'y'}"));
        BulkWriteResult result = bulk.execute();
        Assertions.assertThat((int)result.getInsertedCount()).isEqualTo(3);
        long totalDocuments = this.collection.getCount();
        Assertions.assertThat((long)totalDocuments).isEqualTo(3L);
        int documentsWithY = this.collection.find((DBObject)this.json("field: 'y'")).count();
        Assertions.assertThat((int)documentsWithY).isEqualTo(3);
    }

    private void removeInBulk(BulkWriteOperation bulk) {
        BulkWriteRequestBuilder bulkRequest = bulk.find((DBObject)this.json("field: 'y'"));
        bulkRequest.remove();
        BulkWriteResult result = bulk.execute();
        Assertions.assertThat((int)result.getRemovedCount()).isEqualTo(3);
        Assertions.assertThat((long)this.collection.getCount()).isZero();
    }
}

