/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.MongoServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import org.fest.assertions.Assertions;
import org.junit.Assert;
import org.junit.Test;

public abstract class MongoServerTest {
    protected abstract MongoBackend createBackend() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test(timeout=10000L)
    public void testStopListenting() throws Exception {
        MongoServer server = new MongoServer(this.createBackend());
        MongoClient client = null;
        try {
            InetSocketAddress serverAddress = server.bind();
            client = new MongoClient(new ServerAddress(serverAddress));
            client.getDB("admin").command("serverStatus").throwOnError();
            server.stopListenting();
            client.getDB("admin").command("serverStatus").throwOnError();
            client.close();
            Socket socket = new Socket();
            try {
                socket.connect(serverAddress);
                Assert.fail((String)"IOException expected");
                return;
            }
            catch (IOException iOException) {
                return;
            }
            finally {
                socket.close();
            }
        }
        finally {
            if (client != null) {
                client.close();
            }
            server.shutdownNow();
        }
    }

    @Test(timeout=10000L)
    public void testShutdownNow() throws Exception {
        MongoServer server = new MongoServer(this.createBackend());
        MongoClient client = null;
        InetSocketAddress serverAddress = server.bind();
        client = new MongoClient(new ServerAddress(serverAddress));
        client.getDB("admin").command("serverStatus").throwOnError();
        server.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testGetLocalAddress() throws Exception {
        MongoServer server = new MongoServer(this.createBackend());
        Assertions.assertThat((Object)server.getLocalAddress()).isNull();
        try {
            InetSocketAddress serverAddress = server.bind();
            InetSocketAddress localAddress = server.getLocalAddress();
            Assertions.assertThat((Object)localAddress).isEqualTo((Object)serverAddress);
        }
        finally {
            server.shutdownNow();
        }
        Assertions.assertThat((Object)server.getLocalAddress()).isNull();
    }

    @Test(timeout=10000L)
    public void testShutdownAndRestart() throws Exception {
        MongoServer server = new MongoServer(this.createBackend());
        InetSocketAddress serverAddress = server.bind();
        MongoClient client = new MongoClient(new ServerAddress(serverAddress));
        client.getDB("admin").command("serverStatus").throwOnError();
        server.shutdownNow();
        try {
            client.getDB("admin").command("serverStatus");
            Assert.fail((String)"MongoException expected");
        }
        catch (MongoException mongoException) {
            // empty catch block
        }
        server.bind((SocketAddress)serverAddress);
        client.close();
        client = new MongoClient(new ServerAddress(serverAddress));
        client.getDB("admin").command("serverStatus").throwOnError();
        client.close();
        server.shutdownNow();
    }
}

