/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.MongoServer;
import de.bwaldvogel.mongo.backend.ReadOnlyProxy;
import java.util.List;
import org.fest.assertions.Assertions;
import org.fest.assertions.Fail;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractReadOnlyProxyTest {
    private Mongo readOnlyClient;
    private MongoServer mongoServer;
    private MongoServer writeableServer;
    private Mongo writeClient;

    protected abstract MongoBackend createBackend() throws Exception;

    @Before
    public void setUp() throws Exception {
        MongoBackend mongoBackend = this.createBackend();
        this.writeableServer = new MongoServer(mongoBackend);
        this.writeClient = new MongoClient(new ServerAddress(this.writeableServer.bind()));
        this.mongoServer = new MongoServer((MongoBackend)new ReadOnlyProxy(mongoBackend));
        this.readOnlyClient = new MongoClient(new ServerAddress(this.mongoServer.bind()));
    }

    @After
    public void tearDown() {
        this.writeClient.close();
        this.readOnlyClient.close();
        this.mongoServer.shutdownNow();
        this.writeableServer.shutdownNow();
    }

    @Test
    public void testMaxBsonSize() throws Exception {
        int maxBsonObjectSize = this.readOnlyClient.getMaxBsonObjectSize();
        Assertions.assertThat((int)maxBsonObjectSize).isEqualTo(0x1000000);
    }

    @Test
    public void testServerStatus() throws Exception {
        CommandResult serverStatus = this.readOnlyClient.getDB("admin").command("serverStatus");
        serverStatus.throwOnError();
    }

    @Test
    public void testCurrentOperations() throws Exception {
        DBObject currentOperations = this.readOnlyClient.getDB("admin").getCollection("$cmd.sys.inprog").findOne();
        Assertions.assertThat((Object)currentOperations).isNotNull();
    }

    @Test
    public void testStats() throws Exception {
        CommandResult stats = this.readOnlyClient.getDB("testdb").getStats();
        stats.throwOnError();
        Assertions.assertThat((long)((Number)stats.get("objects")).longValue()).isZero();
    }

    @Test
    public void testListDatabaseNames() throws Exception {
        Assertions.assertThat((List)this.readOnlyClient.getDatabaseNames()).isEmpty();
        this.writeClient.getDB("testdb").getCollection("testcollection").insert(new DBObject[]{new BasicDBObject()});
        Assertions.assertThat((List)this.readOnlyClient.getDatabaseNames()).containsExactly(new Object[]{"testdb"});
        this.writeClient.getDB("bar").getCollection("testcollection").insert(new DBObject[]{new BasicDBObject()});
        Assertions.assertThat((List)this.readOnlyClient.getDatabaseNames()).containsExactly(new Object[]{"bar", "testdb"});
    }

    @Test
    public void testIllegalCommand() throws Exception {
        try {
            this.readOnlyClient.getDB("testdb").command("foo").throwOnError();
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((String)e.getMessage()).contains("no such cmd");
        }
        try {
            this.readOnlyClient.getDB("bar").command("foo").throwOnError();
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException e) {
            Assertions.assertThat((String)e.getMessage()).contains("no such cmd");
        }
    }

    @Test
    public void testQuery() throws Exception {
        DBCollection collection = this.readOnlyClient.getDB("testdb").getCollection("testcollection");
        DBObject obj = collection.findOne((DBObject)new BasicDBObject("_id", (Object)1));
        Assertions.assertThat((Object)obj).isNull();
        Assertions.assertThat((long)collection.count()).isEqualTo(0L);
    }

    @Test
    public void testDistinctQuery() {
        DBCollection collection = this.writeClient.getDB("testdb").getCollection("testcollection");
        collection.insert(new DBObject[]{new BasicDBObject("n", (Object)1)});
        collection.insert(new DBObject[]{new BasicDBObject("n", (Object)2)});
        collection.insert(new DBObject[]{new BasicDBObject("n", (Object)1)});
        collection = this.readOnlyClient.getDB("testdb").getCollection("testcollection");
        Assertions.assertThat((List)collection.distinct("n")).containsExactly(new Object[]{1, 2});
    }

    @Test
    public void testInsert() throws Exception {
        DBCollection collection = this.readOnlyClient.getDB("testdb").getCollection("testcollection");
        Assertions.assertThat((long)collection.count()).isEqualTo(0L);
        try {
            collection.insert(new DBObject[]{new BasicDBObject()});
            Fail.fail((String)"exception expected");
        }
        catch (MongoException mongoException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdate() throws Exception {
        DBCollection collection = this.readOnlyClient.getDB("testdb").getCollection("testcollection");
        BasicDBObject object = new BasicDBObject("_id", (Object)1);
        BasicDBObject newObject = new BasicDBObject("_id", (Object)1);
        try {
            collection.update((DBObject)object, (DBObject)newObject);
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException mongoException) {
            // empty catch block
        }
    }

    @Test
    public void testUpsert() throws Exception {
        DBCollection collection = this.readOnlyClient.getDB("testdb").getCollection("testcollection");
        BasicDBObject object = new BasicDBObject("_id", (Object)1);
        BasicDBObject newObject = new BasicDBObject("_id", (Object)1);
        try {
            collection.update((DBObject)object, (DBObject)newObject, true, false);
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException mongoException) {
            // empty catch block
        }
    }

    @Test
    public void testDropDatabase() throws Exception {
        try {
            this.readOnlyClient.dropDatabase("testdb");
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException mongoException) {
            // empty catch block
        }
    }

    @Test
    public void testDropCollection() throws Exception {
        DBCollection collection = this.readOnlyClient.getDB("testdb").getCollection("foo");
        try {
            collection.drop();
            Fail.fail((String)"MongoException expected");
        }
        catch (MongoException mongoException) {
            // empty catch block
        }
    }
}

