/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.entity;

import de.bwaldvogel.mongo.entity.Account;
import java.util.ArrayList;
import java.util.List;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.TypeAlias;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

@Document
@TypeAlias(value="person")
public class Person {
    @Id
    private ObjectId id;
    private String name;
    @Indexed(unique=true)
    @Field(value="ssn")
    private int socialSecurityNumber;
    @DBRef
    private List<Account> accounts;

    protected Person() {
    }

    public Person(String name, int socialSecurityNumber) {
        this.name = name;
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public ObjectId getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    public List<Account> getAccounts() {
        return this.accounts;
    }

    public void addAccount(Account account) {
        if (this.accounts == null) {
            this.accounts = new ArrayList<Account>();
        }
        this.accounts.add(account);
    }
}

