/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import de.bwaldvogel.mongo.backend.AbstractTest;
import de.bwaldvogel.mongo.backend.CollectionUtils;
import de.bwaldvogel.mongo.backend.TestUtils;
import de.bwaldvogel.mongo.oplog.OperationType;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public abstract class AbstractOplogTest
extends AbstractTest {
    protected static final String LOCAL_DATABASE = "local";
    protected static final String OPLOG_COLLECTION_NAME = "oplog.rs";

    @Override
    protected void setUpBackend() throws Exception {
        super.setUpBackend();
        backend.enableOplog();
    }

    @Override
    protected void dropAllDatabases() {
        super.dropAllDatabases();
        this.clearOplog();
    }

    protected void clearOplog() {
        this.getOplogCollection().deleteMany((Bson)TestUtils.json(""));
    }

    protected MongoCollection<Document> getOplogCollection() {
        MongoDatabase localDb = syncClient.getDatabase(LOCAL_DATABASE);
        return localDb.getCollection(OPLOG_COLLECTION_NAME);
    }

    @Test
    public void testListDatabaseNames() throws Exception {
        AbstractOplogTest.assertThat(this.listDatabaseNames()).contains((Object[])new String[]{LOCAL_DATABASE});
        collection.insertOne((Object)TestUtils.json(""));
        AbstractOplogTest.assertThat(this.listDatabaseNames()).containsExactlyInAnyOrder((Object[])new String[]{db.getName(), LOCAL_DATABASE});
        syncClient.getDatabase("bar").getCollection("some-collection").insertOne((Object)TestUtils.json(""));
        AbstractOplogTest.assertThat(this.listDatabaseNames()).containsExactlyInAnyOrder((Object[])new String[]{"bar", db.getName(), LOCAL_DATABASE});
    }

    @Test
    public void testOplogInsertUpdateAndDelete() {
        Document document = TestUtils.json("_id: 1, name: 'testUser1'");
        collection.insertOne((Object)document);
        clock.windForward(Duration.ofSeconds(1L));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {name: 'user 2'}"));
        clock.windForward(Duration.ofSeconds(1L));
        collection.deleteOne((Bson)TestUtils.json("_id: 1"));
        List oplogDocuments = TestUtils.toArray(this.getOplogCollection().find().sort((Bson)TestUtils.json("ts: 1")));
        AbstractOplogTest.assertThat(oplogDocuments).hasSize(3);
        Document insertOplogDocument = (Document)oplogDocuments.get(0);
        AbstractOplogTest.assertThat(insertOplogDocument).containsKeys((Object[])new String[]{"ts", "t", "h", "v", "op", "ns", "ui", "wall", "o"});
        AbstractOplogTest.assertThat(insertOplogDocument.get((Object)"ts")).isInstanceOf(BsonTimestamp.class);
        AbstractOplogTest.assertThat(insertOplogDocument.get((Object)"t")).isEqualTo((Object)1L);
        AbstractOplogTest.assertThat(insertOplogDocument.get((Object)"h")).isEqualTo((Object)0L);
        AbstractOplogTest.assertThat(insertOplogDocument.get((Object)"v")).isEqualTo((Object)2L);
        AbstractOplogTest.assertThat(insertOplogDocument.get((Object)"op")).isEqualTo((Object)OperationType.INSERT.getCode());
        AbstractOplogTest.assertThat(insertOplogDocument.get((Object)"ns")).isEqualTo((Object)collection.getNamespace().getFullName());
        AbstractOplogTest.assertThat(insertOplogDocument.get((Object)"ui")).isInstanceOf(UUID.class);
        AbstractOplogTest.assertThat(insertOplogDocument.get((Object)"wall")).isEqualTo((Object)Date.from(Instant.parse("2019-05-23T12:00:00.123Z")));
        AbstractOplogTest.assertThat(insertOplogDocument.get((Object)"o")).isEqualTo((Object)document);
        Document updateOplogDocument = (Document)oplogDocuments.get(1);
        AbstractOplogTest.assertThat(updateOplogDocument).containsKeys((Object[])new String[]{"ts", "t", "h", "v", "op", "ns", "ui", "wall", "o", "o2"});
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"ts")).isInstanceOf(BsonTimestamp.class);
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"t")).isEqualTo((Object)1L);
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"h")).isEqualTo((Object)0L);
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"v")).isEqualTo((Object)2L);
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"op")).isEqualTo((Object)OperationType.UPDATE.getCode());
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"ns")).isEqualTo((Object)collection.getNamespace().getFullName());
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"ui")).isInstanceOf(UUID.class);
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"wall")).isEqualTo((Object)Date.from(Instant.parse("2019-05-23T12:00:01.123Z")));
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"o2")).isEqualTo((Object)TestUtils.json("_id: 1"));
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"o")).isEqualTo((Object)TestUtils.json("$set: {name: 'user 2'}"));
        Document deleteOplogDocument = (Document)oplogDocuments.get(2);
        AbstractOplogTest.assertThat(deleteOplogDocument).containsKeys((Object[])new String[]{"ts", "t", "h", "v", "op", "ns", "ui", "wall", "o"});
        AbstractOplogTest.assertThat(deleteOplogDocument.get((Object)"ts")).isInstanceOf(BsonTimestamp.class);
        AbstractOplogTest.assertThat(deleteOplogDocument.get((Object)"t")).isEqualTo((Object)1L);
        AbstractOplogTest.assertThat(deleteOplogDocument.get((Object)"h")).isEqualTo((Object)0L);
        AbstractOplogTest.assertThat(deleteOplogDocument.get((Object)"v")).isEqualTo((Object)2L);
        AbstractOplogTest.assertThat(deleteOplogDocument.get((Object)"op")).isEqualTo((Object)OperationType.DELETE.getCode());
        AbstractOplogTest.assertThat(deleteOplogDocument.get((Object)"ns")).isEqualTo((Object)collection.getNamespace().getFullName());
        AbstractOplogTest.assertThat(deleteOplogDocument.get((Object)"ui")).isInstanceOf(UUID.class);
        AbstractOplogTest.assertThat(deleteOplogDocument.get((Object)"wall")).isEqualTo((Object)Date.from(Instant.parse("2019-05-23T12:00:02.123Z")));
        AbstractOplogTest.assertThat(deleteOplogDocument.get((Object)"o")).isEqualTo((Object)TestUtils.json("_id: 1"));
    }

    @Test
    public void testQueryOplogWhenOplogIsDisabled() throws Exception {
        backend.disableOplog();
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        AbstractOplogTest.assertThat(this.getOplogCollection().find()).isEmpty();
    }

    @Test
    @Disabled(value="This test represents a missing feature")
    public void testSetOplogReplaceOneById() {
        collection.insertOne((Object)TestUtils.json("_id: 1, b: 6"));
        collection.replaceOne((Bson)TestUtils.json("_id: 1"), (Object)TestUtils.json("a: 5, b: 7"));
        List oplogDocuments = TestUtils.toArray(this.getOplogCollection().find().sort((Bson)TestUtils.json("ts: 1")));
        Document updateOplogEntry = (Document)oplogDocuments.get(1);
        AbstractOplogTest.assertThat(updateOplogEntry.get((Object)"op")).isEqualTo((Object)OperationType.UPDATE.getCode());
        AbstractOplogTest.assertThat(updateOplogEntry.get((Object)"ns")).isEqualTo((Object)collection.getNamespace().toString());
        AbstractOplogTest.assertThat(updateOplogEntry.get((Object)"o")).isEqualTo((Object)TestUtils.json("_id: 1, a: 5, b: 7"));
        AbstractOplogTest.assertThat(updateOplogEntry.get((Object)"o2")).isEqualTo((Object)TestUtils.json("_id: 1"));
    }

    @Test
    public void testSetOplogUpdateOneById() {
        collection.insertOne((Object)TestUtils.json("_id: 34, b: 6"));
        collection.updateOne(Filters.eq((String)"_id", (Object)34), Updates.set((String)"a", (Object)6));
        List oplogDocuments = TestUtils.toArray(this.getOplogCollection().find((Bson)TestUtils.json("op: 'u'")).sort((Bson)TestUtils.json("ts: 1")));
        Document updateOplogDocument = (Document)CollectionUtils.getSingleElement(oplogDocuments);
        AbstractOplogTest.assertThat(updateOplogDocument).containsKeys((Object[])new String[]{"ts", "t", "h", "v", "op", "ns", "ui", "wall", "o", "o2"});
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"ts")).isInstanceOf(BsonTimestamp.class);
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"t")).isEqualTo((Object)1L);
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"h")).isEqualTo((Object)0L);
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"v")).isEqualTo((Object)2L);
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"op")).isEqualTo((Object)OperationType.UPDATE.getCode());
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"ns")).isEqualTo((Object)collection.getNamespace().getFullName());
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"ui")).isInstanceOf(UUID.class);
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"o2")).isEqualTo((Object)TestUtils.json("_id: 34"));
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"o")).isEqualTo((Object)TestUtils.json("$set: {a: 6}"));
    }

    @Test
    @Disabled(value="This test represents a missing feature")
    public void testSetOplogUpdateOneByIdMultipleFields() {
        collection.insertOne((Object)TestUtils.json("_id: 1, b: 6"));
        collection.updateOne(Filters.eq((String)"_id", (Object)1), Arrays.asList(Updates.set((String)"a", (Object)7), Updates.set((String)"b", (Object)7)));
        List oplogDocuments = TestUtils.toArray(this.getOplogCollection().find().sort((Bson)TestUtils.json("ts: 1")));
        Document updateOplogDocument = (Document)oplogDocuments.get(1);
        AbstractOplogTest.assertThat(updateOplogDocument).containsKeys((Object[])new String[]{"ts", "t", "h", "v", "op", "ns", "ui", "wall", "o", "o2"});
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"ts")).isInstanceOf(BsonTimestamp.class);
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"t")).isEqualTo((Object)1L);
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"h")).isEqualTo((Object)0L);
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"v")).isEqualTo((Object)2L);
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"op")).isEqualTo((Object)OperationType.UPDATE.getCode());
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"ns")).isEqualTo((Object)collection.getNamespace().getFullName());
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"ui")).isInstanceOf(UUID.class);
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"o2")).isEqualTo((Object)TestUtils.json("_id: 1"));
        AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"o")).isEqualTo((Object)TestUtils.json("$set: {a: 7, b: 7}"));
    }

    @Test
    public void testSetOplogUpdateMany() {
        collection.insertMany(Arrays.asList(TestUtils.json("_id: 1, b: 6"), TestUtils.json("_id: 2, b: 6")));
        collection.updateMany(Filters.eq((String)"b", (Object)6), Updates.set((String)"a", (Object)7));
        List oplogDocuments = TestUtils.toArray(this.getOplogCollection().find((Bson)TestUtils.json("op: 'u'")).sort((Bson)TestUtils.json("ts: 1, 'o2._id': 1")));
        AbstractOplogTest.assertThat(oplogDocuments).hasSize(2);
        for (int i = 0; i < 2; ++i) {
            Document updateOplogDocument = (Document)oplogDocuments.get(i);
            AbstractOplogTest.assertThat(updateOplogDocument).containsKeys((Object[])new String[]{"ts", "t", "h", "v", "op", "ns", "ui", "wall", "o", "o2"});
            AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"ts")).isInstanceOf(BsonTimestamp.class);
            AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"t")).isEqualTo((Object)1L);
            AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"h")).isEqualTo((Object)0L);
            AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"v")).isEqualTo((Object)2L);
            AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"op")).isEqualTo((Object)OperationType.UPDATE.getCode());
            AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"ns")).isEqualTo((Object)collection.getNamespace().getFullName());
            AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"ui")).isInstanceOf(UUID.class);
            AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"o2")).isEqualTo((Object)TestUtils.json(String.format("_id: %d", i + 1)));
            AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"o")).isEqualTo((Object)TestUtils.json("$set: {a: 7}"));
        }
    }

    @Test
    public void testSetOplogDeleteMany() {
        collection.insertMany(Arrays.asList(TestUtils.json("_id: 1, b: 6"), TestUtils.json("_id: 2, b: 6")));
        collection.deleteMany(Filters.eq((String)"b", (Object)6));
        List oplogDocuments = TestUtils.toArray(this.getOplogCollection().find((Bson)TestUtils.json("op: 'd'")).sort((Bson)TestUtils.json("ts: 1, 'o._id': 1")));
        AbstractOplogTest.assertThat(oplogDocuments).hasSize(2);
        for (int i = 0; i < 2; ++i) {
            Document updateOplogDocument = (Document)oplogDocuments.get(i);
            AbstractOplogTest.assertThat(updateOplogDocument).containsKeys((Object[])new String[]{"ts", "t", "h", "v", "op", "ns", "ui", "wall", "o"});
            AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"ts")).isInstanceOf(BsonTimestamp.class);
            AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"t")).isEqualTo((Object)1L);
            AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"h")).isEqualTo((Object)0L);
            AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"v")).isEqualTo((Object)2L);
            AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"op")).isEqualTo((Object)OperationType.DELETE.getCode());
            AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"ns")).isEqualTo((Object)collection.getNamespace().getFullName());
            AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"ui")).isInstanceOf(UUID.class);
            AbstractOplogTest.assertThat(updateOplogDocument.get((Object)"o")).isEqualTo((Object)TestUtils.json(String.format("_id: %d", i + 1)));
        }
    }
}

