/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.MongoServer;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public abstract class MongoServerTest {
    private static final int TEST_TIMEOUT_SECONDS = 10;
    private MongoServer server;

    protected abstract MongoBackend createBackend() throws Exception;

    @BeforeEach
    void setUp() throws Exception {
        this.server = new MongoServer(this.createBackend());
    }

    @AfterEach
    void tearDown() {
        this.server.shutdown();
    }

    @Test
    void testToString() throws Exception {
        Assertions.assertThat((Object)this.server).hasToString("MongoServer()");
        InetSocketAddress inetSocketAddress = this.server.bind();
        Assertions.assertThat((Object)this.server).hasToString("MongoServer(port: " + inetSocketAddress.getPort() + ", ssl: false)");
    }

    @Test
    @Timeout(value=10L)
    public void testStopListening() throws Exception {
        InetSocketAddress serverAddress = this.server.bind();
        try (MongoClient client = new MongoClient(new ServerAddress(serverAddress));){
            this.pingServer(client);
            this.server.stopListening();
            this.pingServer(client);
            Assertions.assertThatExceptionOfType(IOException.class).isThrownBy(() -> {
                try (Socket socket = new Socket();){
                    socket.connect(serverAddress);
                }
            });
        }
    }

    @Test
    @Timeout(value=10L)
    public void testShutdownNow() throws Exception {
        InetSocketAddress serverAddress = this.server.bind();
        MongoClient client = new MongoClient(new ServerAddress(serverAddress));
        this.pingServer(client);
        this.server.shutdownNow();
    }

    @Test
    @Timeout(value=10L)
    public void testGetLocalAddress() throws Exception {
        Assertions.assertThat((Object)this.server.getLocalAddress()).isNull();
        InetSocketAddress serverAddress = this.server.bind();
        InetSocketAddress localAddress = this.server.getLocalAddress();
        Assertions.assertThat((Object)localAddress).isEqualTo((Object)serverAddress);
        this.server.shutdownNow();
        Assertions.assertThat((Object)this.server.getLocalAddress()).isNull();
    }

    @Test
    @Timeout(value=10L)
    public void testShutdownAndRestart() throws Exception {
        InetSocketAddress serverAddress = this.server.bind();
        try (MongoClient client = new MongoClient(new ServerAddress(serverAddress));){
            this.pingServer(client);
            this.server.shutdownNow();
            Assertions.assertThatExceptionOfType(MongoException.class).isThrownBy(() -> this.pingServer(client));
            this.server.bind((SocketAddress)serverAddress);
            this.pingServer(client);
        }
    }

    @Test
    @Timeout(value=10L)
    public void testSsl() throws Exception {
        this.server.enableSsl(this.getPrivateKey(), null, new X509Certificate[]{this.getCertificate()});
        InetSocketAddress serverAddress = this.server.bind();
        Assertions.assertThat((Object)this.server).hasToString("MongoServer(port: " + serverAddress.getPort() + ", ssl: true)");
        MongoClientOptions clientOptions = MongoClientOptions.builder().sslEnabled(true).sslContext(this.createSslContext(this.loadTestKeyStore())).build();
        try (MongoClient client = new MongoClient(new ServerAddress("localhost", serverAddress.getPort()), clientOptions);){
            this.pingServer(client);
        }
    }

    @Test
    void testEnableSslAfterAlreadyStarted() throws Exception {
        this.server.bind();
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> this.server.enableSsl(this.getPrivateKey(), null, new X509Certificate[]{this.getCertificate()})).withMessage("Server already started");
    }

    @Test
    void testEnableSslWithEmptyKeyCertChain() throws Exception {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> this.server.enableSsl(null, null, new X509Certificate[0])).withMessage("keyCertChain must be non-empty");
    }

    @Test
    void testEnableSslWithMissingPrivateKey() throws Exception {
        X509Certificate certificate = this.getCertificate();
        Assertions.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> this.server.enableSsl(null, null, new X509Certificate[]{certificate})).withMessage("key required for servers");
    }

    private PrivateKey getPrivateKey() throws Exception {
        return (PrivateKey)this.loadTestKeyStore().getKey("localhost", new char[0]);
    }

    private X509Certificate getCertificate() throws Exception {
        return (X509Certificate)this.loadTestKeyStore().getCertificate("localhost");
    }

    private KeyStore loadTestKeyStore() throws Exception {
        try (InputStream keyStoreStream = this.getClass().getResourceAsStream("/test-keystore.jks");){
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(keyStoreStream, new char[0]);
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }

    private SSLContext createSslContext(KeyStore keyStore) throws Exception {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
        return sslContext;
    }

    private void pingServer(MongoClient client) {
        client.getDatabase("admin").runCommand((Bson)new Document("ping", (Object)1));
    }
}

