/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.AbstractTest;
import de.bwaldvogel.mongo.backend.TestUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.assertj.core.api.Assertions;
import org.bson.BSON;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProtocolTest
extends AbstractTest {
    private static final Logger log = LoggerFactory.getLogger(AbstractProtocolTest.class);

    @Test
    public void testInsertOperation() throws Exception {
        AbstractProtocolTest.assertThat(collection.countDocuments()).isZero();
        try (Socket socket = new Socket(serverAddress.getAddress(), serverAddress.getPort());){
            OutputStream outputStream = socket.getOutputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeInt(baos, 1);
            this.writeInt(baos, 0);
            this.writeInt(baos, 2002);
            this.writeInt(baos, 0);
            this.writeString(baos, collection.getNamespace().getFullName());
            this.writeBson(baos, TestUtils.json("_id: 1"));
            byte[] bytes = baos.toByteArray();
            this.writeInt(outputStream, bytes.length + 4);
            outputStream.write(bytes);
            outputStream.flush();
        }
        this.awaitDocumentCount(() -> collection.estimatedDocumentCount() == 1L);
        AbstractProtocolTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1")});
    }

    @Test
    public void testDeleteOperation() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        AbstractProtocolTest.assertThat(collection.countDocuments()).isEqualTo(3L);
        try (Socket socket = new Socket(serverAddress.getAddress(), serverAddress.getPort());){
            OutputStream outputStream = socket.getOutputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeInt(baos, 1);
            this.writeInt(baos, 0);
            this.writeInt(baos, 2006);
            this.writeInt(baos, 0);
            this.writeString(baos, collection.getNamespace().getFullName());
            this.writeInt(baos, 0);
            this.writeBson(baos, new Document());
            byte[] bytes = baos.toByteArray();
            this.writeInt(outputStream, bytes.length + 4);
            outputStream.write(bytes);
            outputStream.flush();
        }
        this.awaitDocumentCount(() -> collection.estimatedDocumentCount() == 0L);
        AbstractProtocolTest.assertThat(collection.countDocuments()).isZero();
    }

    @Test
    public void testSingleDeleteOperation() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        AbstractProtocolTest.assertThat(collection.countDocuments()).isEqualTo(3L);
        try (Socket socket = new Socket(serverAddress.getAddress(), serverAddress.getPort());){
            OutputStream outputStream = socket.getOutputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeInt(baos, 1);
            this.writeInt(baos, 0);
            this.writeInt(baos, 2006);
            this.writeInt(baos, 0);
            this.writeString(baos, collection.getNamespace().getFullName());
            this.writeInt(baos, 1);
            this.writeBson(baos, new Document());
            byte[] bytes = baos.toByteArray();
            this.writeInt(outputStream, bytes.length + 4);
            outputStream.write(bytes);
            outputStream.flush();
        }
        this.awaitDocumentCount(() -> collection.estimatedDocumentCount() == 2L);
        AbstractProtocolTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 2"), TestUtils.json("_id: 3")});
    }

    @Test
    public void testUpdateOperation() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        AbstractProtocolTest.assertThat(collection.countDocuments()).isEqualTo(3L);
        try (Socket socket = new Socket(serverAddress.getAddress(), serverAddress.getPort());){
            OutputStream outputStream = socket.getOutputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeInt(baos, 1);
            this.writeInt(baos, 0);
            this.writeInt(baos, 2001);
            this.writeInt(baos, 0);
            this.writeString(baos, collection.getNamespace().getFullName());
            this.writeInt(baos, 3);
            this.writeBson(baos, TestUtils.json("_id: {$gte: 2}"));
            this.writeBson(baos, TestUtils.json("$set: {a: 2}"));
            byte[] bytes = baos.toByteArray();
            this.writeInt(outputStream, bytes.length + 4);
            outputStream.write(bytes);
            outputStream.flush();
        }
        this.awaitDocumentCount(() -> collection.countDocuments((Bson)TestUtils.json("a: 2")) == 2L);
        AbstractProtocolTest.assertThat(collection.find()).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: 2, a: 2"), TestUtils.json("_id: 3, a: 2")});
    }

    private void awaitDocumentCount(BooleanSupplier stoppingCriterion) throws Exception {
        for (int i = 0; i < 10; ++i) {
            if (stoppingCriterion.getAsBoolean()) {
                log.info("Stopping criterion reached.");
                return;
            }
            log.info("Stopping criterion not yet reached. Waiting\u2026");
            Thread.sleep(50L);
        }
        Assertions.fail((String)"Timeout waiting for change");
    }

    private void writeString(OutputStream outputStream, String string) throws Exception {
        outputStream.write(string.getBytes(StandardCharsets.UTF_8));
        this.writeByte(outputStream, 0);
    }

    private void writeByte(OutputStream outputStream, int value) throws Exception {
        outputStream.write(value);
    }

    private void writeBson(OutputStream outputStream, Document data) throws Exception {
        outputStream.write(BSON.encode((BSONObject)new BasicBSONObject((Map)data)));
    }

    private void writeInt(OutputStream out, int value) throws Exception {
        this.writeByte(out, value & 0xFF);
        this.writeByte(out, value >>> 8 & 0xFF);
        this.writeByte(out, value >>> 16 & 0xFF);
        this.writeByte(out, value >>> 24 & 0xFF);
    }
}

