/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import com.mongodb.DBRef;
import com.mongodb.DuplicateKeyException;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoQueryException;
import com.mongodb.MongoServerException;
import com.mongodb.MongoWriteException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.reactivestreams.client.Success;
import de.bwaldvogel.mongo.backend.AbstractTest;
import de.bwaldvogel.mongo.backend.TestUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.bson.BsonInt32;
import org.bson.BsonJavaScript;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.ObjectId;
import org.junit.Test;
import org.mockito.AdditionalAnswers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBackendTest
extends AbstractTest {
    private static final Logger log = LoggerFactory.getLogger(AbstractBackendTest.class);
    protected static final String OTHER_TEST_DATABASE_NAME = "bar";

    private Document runCommand(String commandName) {
        return this.runCommand(new Document(commandName, (Object)1));
    }

    private Document runCommand(Document command) {
        return this.getAdminDb().runCommand((Bson)command);
    }

    protected MongoCollection<Document> getCollection(String collectionName) {
        return db.getCollection(collectionName);
    }

    protected MongoDatabase getAdminDb() {
        return syncClient.getDatabase("admin");
    }

    private String getCollectionName() {
        return collection.getNamespace().getCollectionName();
    }

    @Test
    public void testSimpleInsert() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
    }

    @Test
    public void testSimpleInsertDelete() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.deleteOne((Bson)TestUtils.json("_id: 1"));
    }

    @Test
    public void testCreateCollection() throws Exception {
        String newCollectionName = "some-collection";
        Assertions.assertThat(TestUtils.toArray(db.listCollectionNames())).doesNotContain((Object[])new String[]{newCollectionName});
        db.createCollection(newCollectionName, new CreateCollectionOptions());
        Assertions.assertThat(TestUtils.toArray(db.listCollectionNames())).contains((Object[])new String[]{newCollectionName});
    }

    @Test
    public void testCreateCollectionAlreadyExists() throws Exception {
        db.createCollection("some-collection", new CreateCollectionOptions());
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> db.createCollection("some-collection", new CreateCollectionOptions())).withMessageContaining("Command failed with error 48 (NamespaceExists): 'a collection 'testdb.some-collection' already exists'");
    }

    @Test
    public void testUnsupportedModifier() throws Exception {
        collection.insertOne((Object)TestUtils.json(""));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$foo: {}")), 9, "FailedToParse", "Unknown modifier: $foo");
    }

    @Test
    public void testUpsertWithInc() {
        Document query = TestUtils.json("_id: {f: 'ca', '1': {l: 2}, t: {t: 11}}");
        Document update = TestUtils.json("'$inc': {'n.!' : 1 , 'n.a.b:false' : 1}");
        collection.updateOne((Bson)query, (Bson)update, new UpdateOptions().upsert(true));
        query.putAll((Map)TestUtils.json("n: {'!': 1, a: {'b:false': 1}}"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)query);
    }

    @Test
    public void testBasicUpdate() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, b: 5"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        collection.replaceOne((Bson)TestUtils.json("_id: 2"), (Object)TestUtils.json("_id: 2, a: 5"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 2")).first())).isEqualTo((Object)TestUtils.json("_id: 2, a: 5"));
    }

    @Test
    public void testCollectionStats() throws Exception {
        db.createCollection("other-collection");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(this::getCollStats).withMessageContaining("Command failed with error -1: 'Collection [testdb.testcoll] not found.'");
        collection.insertOne((Object)TestUtils.json(""));
        collection.insertOne((Object)TestUtils.json("abc: 'foo'"));
        Document stats = this.getCollStats();
        Assertions.assertThat((Double)stats.getDouble((Object)"ok")).isEqualTo(1.0);
        Assertions.assertThat((Integer)stats.getInteger((Object)"count")).isEqualTo(2);
        Assertions.assertThat((Integer)stats.getInteger((Object)"size")).isEqualTo(57);
        Assertions.assertThat((Integer)stats.getInteger((Object)"avgObjSize")).isEqualTo(28);
    }

    private Document getCollStats() {
        String collectionName = this.getCollectionName();
        return TestUtils.getCollectionStatistics(db, collectionName);
    }

    @Test
    public void testGetLogStartupWarnings() throws Exception {
        Document startupWarnings = this.getAdminDb().runCommand((Bson)TestUtils.json("getLog: 'startupWarnings'"));
        Assertions.assertThat((Double)startupWarnings.getDouble((Object)"ok")).isEqualTo(1.0);
        Assertions.assertThat((Object)startupWarnings.get((Object)"totalLinesWritten")).isInstanceOf(Number.class);
        Assertions.assertThat((Object)startupWarnings.get((Object)"log")).isEqualTo(Collections.emptyList());
    }

    @Test
    public void testGetLogWhichDoesNotExist() throws Exception {
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> this.getAdminDb().runCommand((Bson)TestUtils.json("getLog: 'illegal'"))).withMessageContaining("Command failed with error -1: 'no RamLog named: illegal'");
    }

    @Test
    public void testCompoundDateIdUpserts() {
        Document query = TestUtils.json("_id: {$lt: {n: 'a', t: 10}, $gte: {n: 'a', t: 1}}");
        List<Document> toUpsert = Arrays.asList(TestUtils.json("_id: {n: 'a', t: 1}"), TestUtils.json("_id: {n: 'a', t: 2}"), TestUtils.json("_id: {n: 'a', t: 3}"), TestUtils.json("_id: {n: 'a', t: 11}"));
        for (Document dbo : toUpsert) {
            collection.replaceOne((Bson)dbo, (Object)new Document((Map)dbo).append("foo", (Object)OTHER_TEST_DATABASE_NAME), new ReplaceOptions().upsert(true));
        }
        List results = TestUtils.toArray(collection.find((Bson)query));
        Assertions.assertThat(results).containsExactly((Object[])new Document[]{TestUtils.json("_id: {n: 'a', t: 1}, foo: 'bar'"), TestUtils.json("_id: {n: 'a', t: 2}, foo: 'bar'"), TestUtils.json("_id: {n: 'a', t: 3}, foo: 'bar'")});
    }

    @Test
    public void testCompoundSort() {
        collection.insertOne((Object)TestUtils.json("a:1, _id: 1"));
        collection.insertOne((Object)TestUtils.json("a:2, _id: 5"));
        collection.insertOne((Object)TestUtils.json("a:1, _id: 2"));
        collection.insertOne((Object)TestUtils.json("a:2, _id: 4"));
        collection.insertOne((Object)TestUtils.json("a:1, _id: 3"));
        List documents = TestUtils.toArray(collection.find().sort((Bson)TestUtils.json("a:1, _id: -1")));
        Assertions.assertThat(documents).containsExactly((Object[])new Document[]{TestUtils.json("a: 1, _id: 3"), TestUtils.json("a: 1, _id: 2"), TestUtils.json("a: 1, _id: 1"), TestUtils.json("a: 2, _id: 5"), TestUtils.json("a: 2, _id: 4")});
    }

    @Test
    public void testCountCommand() {
        Assertions.assertThat((long)collection.count()).isZero();
    }

    @Test
    public void testNonPrimaryCountCommand() {
        Assertions.assertThat((long)collection.withReadPreference(ReadPreference.nearest()).countDocuments()).isZero();
    }

    @Test
    public void testCountCommandWithQuery() {
        collection.insertOne((Object)TestUtils.json("n:1"));
        collection.insertOne((Object)TestUtils.json("n:2"));
        collection.insertOne((Object)TestUtils.json("n:2"));
        Assertions.assertThat((long)collection.count((Bson)TestUtils.json("n:2"))).isEqualTo(2L);
    }

    @Test
    public void testCountCommandWithSkipAndLimit() {
        collection.insertOne((Object)TestUtils.json("x: 1"));
        collection.insertOne((Object)TestUtils.json("x: 1"));
        collection.insertOne((Object)TestUtils.json("x: 2"));
        collection.insertOne((Object)TestUtils.json("x: 1"));
        collection.insertOne((Object)TestUtils.json("x: 2"));
        collection.insertOne((Object)TestUtils.json("x: 1"));
        Assertions.assertThat((long)collection.count((Bson)TestUtils.json("x: 1"), new CountOptions().skip(4).limit(2))).isEqualTo(0L);
        Assertions.assertThat((long)collection.count((Bson)TestUtils.json("x: 1"), new CountOptions().limit(3))).isEqualTo(3L);
        Assertions.assertThat((long)collection.count((Bson)TestUtils.json("x: 1"), new CountOptions().limit(10))).isEqualTo(4L);
        Assertions.assertThat((long)collection.count((Bson)TestUtils.json("x: 1"), new CountOptions().skip(1))).isEqualTo(3L);
    }

    @Test
    public void testCountDocuments() throws Exception {
        Assertions.assertThat((long)collection.countDocuments()).isZero();
    }

    @Test
    public void testCountDocumentsWithQuery() {
        collection.insertOne((Object)TestUtils.json("n:1"));
        collection.insertOne((Object)TestUtils.json("n:2"));
        collection.insertOne((Object)TestUtils.json("n:2"));
        Assertions.assertThat((long)collection.countDocuments((Bson)TestUtils.json("n:2"))).isEqualTo(2L);
    }

    @Test
    public void testEstimatedDocumentCount() throws Exception {
        Assertions.assertThat((long)collection.estimatedDocumentCount()).isEqualTo(0L);
        collection.insertOne((Object)TestUtils.json("n:1"));
        collection.insertOne((Object)TestUtils.json("n:2"));
        collection.insertOne((Object)TestUtils.json("n:2"));
        Assertions.assertThat((long)collection.estimatedDocumentCount()).isEqualTo(3L);
        Assertions.assertThat((long)collection.estimatedDocumentCount(new EstimatedDocumentCountOptions().maxTime(1L, TimeUnit.SECONDS))).isEqualTo(3L);
    }

    @Test
    public void testCreateIndexes() {
        collection.createIndex((Bson)new Document("n", (Object)1));
        collection.createIndex((Bson)new Document("b", (Object)1));
        Assertions.assertThat(TestUtils.toArray(collection.listIndexes())).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("key: {_id: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"_id_").append("v", (Object)2), TestUtils.json("key: {n: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"n_1").append("v", (Object)2), TestUtils.json("key: {b: 1}").append("ns", (Object)collection.getNamespace().getFullName()).append("name", (Object)"b_1").append("v", (Object)2)});
    }

    @Test
    public void testCurrentOperations() throws Exception {
        Document currentOperations = (Document)this.getAdminDb().getCollection("$cmd.sys.inprog").find().first();
        Assertions.assertThat((Map)currentOperations).isNotNull();
        Assertions.assertThat((Object)currentOperations.get((Object)"inprog")).isInstanceOf(List.class);
    }

    @Test
    public void testListCollectionsEmpty() throws Exception {
        Document result = db.runCommand((Bson)TestUtils.json("listCollections: 1"));
        Assertions.assertThat((Double)result.getDouble((Object)"ok")).isEqualTo(1.0);
        Document cursor = (Document)result.get((Object)"cursor");
        Assertions.assertThat((Iterable)cursor.keySet()).containsExactly((Object[])new String[]{"id", "ns", "firstBatch"});
        Assertions.assertThat((Object)cursor.get((Object)"id")).isEqualTo((Object)0L);
        Assertions.assertThat((Object)cursor.get((Object)"ns")).isEqualTo((Object)(db.getName() + ".$cmd.listCollections"));
        List firstBatch = (List)cursor.get((Object)"firstBatch");
        Assertions.assertThat((List)firstBatch).isEmpty();
    }

    @Test
    public void testListCollections() throws Exception {
        List<String> collections = Arrays.asList("coll1", "coll2", "coll3");
        for (String collection : collections) {
            this.getCollection(collection).insertOne((Object)TestUtils.json("_id: 1"));
        }
        Document result = db.runCommand((Bson)TestUtils.json("listCollections: 1"));
        Assertions.assertThat((Double)result.getDouble((Object)"ok")).isEqualTo(1.0);
        Document cursor = (Document)result.get((Object)"cursor");
        Assertions.assertThat((Iterable)cursor.keySet()).containsExactly((Object[])new String[]{"id", "ns", "firstBatch"});
        Assertions.assertThat((Object)cursor.get((Object)"id")).isEqualTo((Object)0L);
        Assertions.assertThat((Object)cursor.get((Object)"ns")).isEqualTo((Object)(db.getName() + ".$cmd.listCollections"));
        Assertions.assertThat((Object)cursor.get((Object)"firstBatch")).isInstanceOf(List.class);
        List firstBatch = (List)cursor.get((Object)"firstBatch");
        Assertions.assertThat((List)firstBatch).hasSameSizeAs(collections);
        HashSet<String> collectionNames = new HashSet<String>();
        for (Document collection : firstBatch) {
            Assertions.assertThat((Map)collection).containsOnlyKeys((Object[])new String[]{"name", "options", "type", "idIndex", "info"});
            String name = (String)collection.get((Object)"name");
            Assertions.assertThat((Object)collection.get((Object)"options")).isEqualTo((Object)TestUtils.json(""));
            Assertions.assertThat((Object)collection.get((Object)"name")).isInstanceOf(String.class);
            Assertions.assertThat((Object)collection.get((Object)"type")).isEqualTo((Object)"collection");
            Assertions.assertThat((Object)collection.get((Object)"idIndex")).isEqualTo((Object)TestUtils.json("key: {_id: 1}, name: '_id_', ns: 'testdb." + name + "', v: 2"));
            Assertions.assertThat((Object)collection.get((Object)"info")).isInstanceOf(Document.class);
            collectionNames.add(name);
        }
        Assertions.assertThat(collectionNames).containsExactlyInAnyOrderElementsOf(collections);
    }

    @Test
    public void testGetCollectionNames() throws Exception {
        this.getCollection("foo").insertOne((Object)TestUtils.json(""));
        this.getCollection(OTHER_TEST_DATABASE_NAME).insertOne((Object)TestUtils.json(""));
        List collectionNames = TestUtils.toArray(db.listCollectionNames());
        Assertions.assertThat(collectionNames).containsExactlyInAnyOrder((Object[])new String[]{"foo", OTHER_TEST_DATABASE_NAME});
    }

    @Test
    public void testSystemNamespaces() throws Exception {
        this.getCollection("foo").insertOne((Object)TestUtils.json(""));
        this.getCollection(OTHER_TEST_DATABASE_NAME).insertOne((Object)TestUtils.json(""));
        MongoCollection namespaces = db.getCollection("system.namespaces");
        Assertions.assertThat(TestUtils.toArray(namespaces.find())).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("name: 'testdb.foo'"), TestUtils.json("name: 'testdb.bar'")});
    }

    @Test
    public void testDatabaseStats() throws Exception {
        Document stats = db.runCommand((Bson)new Document("dbStats", (Object)1).append("scale", (Object)1));
        Assertions.assertThat((Double)stats.getDouble((Object)"ok")).isEqualTo(1.0);
        Assertions.assertThat((Integer)stats.getInteger((Object)"objects")).isZero();
        Assertions.assertThat((Integer)stats.getInteger((Object)"collections")).isZero();
        Assertions.assertThat((Integer)stats.getInteger((Object)"indexes")).isZero();
        Assertions.assertThat((Integer)stats.getInteger((Object)"dataSize")).isZero();
        this.getCollection("foo").insertOne((Object)TestUtils.json(""));
        this.getCollection("foo").insertOne((Object)TestUtils.json(""));
        this.getCollection(OTHER_TEST_DATABASE_NAME).insertOne((Object)TestUtils.json(""));
        stats = db.runCommand((Bson)new Document("dbStats", (Object)1).append("scale", (Object)1));
        Assertions.assertThat((Double)stats.getDouble((Object)"ok")).isEqualTo(1.0);
        Assertions.assertThat((Integer)stats.getInteger((Object)"objects")).isEqualTo(3);
        Assertions.assertThat((Integer)stats.getInteger((Object)"collections")).isEqualTo(2);
        Assertions.assertThat((Integer)stats.getInteger((Object)"indexes")).isEqualTo(2);
        Assertions.assertThat((Double)stats.getDouble((Object)"dataSize")).isEqualTo(66.0);
    }

    @Test
    public void testDeleteDecrementsCount() {
        collection.insertOne((Object)TestUtils.json("key: 'value'"));
        Assertions.assertThat((long)collection.countDocuments()).isEqualTo(1L);
        collection.deleteOne((Bson)TestUtils.json(""));
        Assertions.assertThat((long)collection.countDocuments()).isZero();
    }

    @Test
    public void testDeleteInSystemNamespace() throws Exception {
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> this.getCollection("system.foobar").deleteOne((Bson)TestUtils.json(""))).withMessageContaining("Command failed with error 73 (InvalidNamespace): 'cannot write to 'testdb.system.foobar'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> this.getCollection("system.namespaces").deleteOne((Bson)TestUtils.json(""))).withMessageContaining("Command failed with error 73 (InvalidNamespace): 'cannot write to 'testdb.system.namespaces'");
    }

    @Test
    public void testUpdateInSystemNamespace() throws Exception {
        for (String collectionName : Arrays.asList("system.foobar", "system.namespaces")) {
            MongoCollection<Document> collection = this.getCollection(collectionName);
            AbstractBackendTest.assertMongoWriteException(() -> collection.updateMany(Filters.eq((String)"some", (Object)"value"), Updates.set((String)"field", (Object)"value")), 10156, "cannot update system collection");
        }
    }

    @Test
    public void testDistinctQuery() {
        collection.insertOne((Object)TestUtils.json("_id: 1, n: null"));
        collection.insertOne((Object)TestUtils.json("_id: 2, n: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 3, n: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 4, n: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 5, n: 1.0"));
        collection.insertOne((Object)TestUtils.json("_id: 6, n: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 7, n: -0.0"));
        collection.insertOne((Object)TestUtils.json("_id: 8, n: 0"));
        Assertions.assertThat(TestUtils.toArray(collection.distinct("n", Integer.class))).containsExactly((Object[])new Integer[]{null, 3, 1, 2, 0});
        Assertions.assertThat(TestUtils.toArray(collection.distinct("n", (Bson)TestUtils.json("n: {$gt: 1}"), Integer.class))).containsExactly((Object[])new Integer[]{3, 2});
        Assertions.assertThat((Iterable)collection.distinct("foobar", String.class)).isEmpty();
        Assertions.assertThat((Iterable)collection.distinct("_id", Integer.class)).hasSize((int)collection.countDocuments());
    }

    @Test
    public void testDistinctUuids() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, n: null"));
        collection.insertOne((Object)TestUtils.json("_id: 2").append("n", (Object)new UUID(0L, 1L)));
        collection.insertOne((Object)TestUtils.json("_id: 3").append("n", (Object)new UUID(1L, 0L)));
        collection.insertOne((Object)TestUtils.json("_id: 4").append("n", (Object)new UUID(0L, 2L)));
        collection.insertOne((Object)TestUtils.json("_id: 5").append("n", (Object)new UUID(1L, 1L)));
        collection.insertOne((Object)TestUtils.json("_id: 6").append("n", (Object)new UUID(1L, 0L)));
        Assertions.assertThat(TestUtils.toArray(collection.distinct("n", UUID.class))).containsExactly((Object[])new UUID[]{null, new UUID(0L, 1L), new UUID(1L, 0L), new UUID(0L, 2L), new UUID(1L, 1L)});
    }

    @Test
    public void testDistinctArrayField() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, n: null"));
        collection.insertOne((Object)TestUtils.json("_id: 2").append("n", Arrays.asList(1, 2, 3)));
        collection.insertOne((Object)TestUtils.json("_id: 3").append("n", Arrays.asList(3, 4, 5)));
        collection.insertOne((Object)TestUtils.json("_id: 4").append("n", (Object)6));
        Assertions.assertThat(TestUtils.toArray(collection.distinct("n", Integer.class))).containsExactly((Object[])new Integer[]{null, 1, 2, 3, 4, 5, 6});
    }

    @Test
    public void testDistinct_documentArray() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, n: null"));
        collection.insertOne((Object)TestUtils.json("_id: 2, n: [{item: 1}, {item: 2}]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, n: {item: 3}"));
        collection.insertOne((Object)TestUtils.json("_id: 4, n: {item: [4, 5]}"));
        collection.insertOne((Object)TestUtils.json("_id: 5, n: {}"));
        Assertions.assertThat(TestUtils.toArray(collection.distinct("n.item", Integer.class))).containsExactly((Object[])new Integer[]{1, 2, 3, 4, 5});
    }

    @Test
    public void testInsertQueryAndSortBinaryTypes() throws Exception {
        byte[] highBytes = new byte[16];
        for (int i = 0; i < highBytes.length; ++i) {
            highBytes[i] = -1;
        }
        collection.insertOne((Object)TestUtils.json("_id: 1, n: null"));
        collection.insertOne((Object)TestUtils.json("_id: 2").append("n", (Object)new UUID(0L, 1L)));
        collection.insertOne((Object)TestUtils.json("_id: 3").append("n", (Object)new UUID(1L, 0L)));
        collection.insertOne((Object)TestUtils.json("_id: 4, n: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 5, n: 17"));
        collection.insertOne((Object)TestUtils.json("_id: 6, n: [1, 2, 3]"));
        collection.insertOne((Object)TestUtils.json("_id: 7").append("n", (Object)new byte[]{0, 0, 0, 1}));
        collection.insertOne((Object)TestUtils.json("_id: 8").append("n", (Object)highBytes));
        collection.insertOne((Object)TestUtils.json("_id: 9").append("n", (Object)new byte[0]));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("n: {$type: 5}")).sort((Bson)TestUtils.json("n: 1")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 9").append("n", (Object)new Binary(new byte[0])), TestUtils.json("_id: 7").append("n", (Object)new Binary(new byte[]{0, 0, 0, 1})), TestUtils.json("_id: 8").append("n", (Object)new Binary(highBytes)), TestUtils.json("_id: 2").append("n", (Object)new UUID(0L, 1L)), TestUtils.json("_id: 3").append("n", (Object)new UUID(1L, 0L))});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)new Document("n", (Object)new UUID(1L, 0L))))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 3").append("n", (Object)new UUID(1L, 0L))});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("")).sort((Bson)TestUtils.json("n: 1")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, n: null"), TestUtils.json("_id: 6, n: [1, 2, 3]"), TestUtils.json("_id: 5, n: 17"), TestUtils.json("_id: 4, n: 'abc'"), TestUtils.json("_id: 9").append("n", (Object)new Binary(new byte[0])), TestUtils.json("_id: 7").append("n", (Object)new Binary(new byte[]{0, 0, 0, 1})), TestUtils.json("_id: 8").append("n", (Object)new Binary(highBytes)), TestUtils.json("_id: 2").append("n", (Object)new UUID(0L, 1L)), TestUtils.json("_id: 3").append("n", (Object)new UUID(1L, 0L))});
    }

    @Test
    public void testUuidAsId() throws Exception {
        collection.insertOne((Object)new Document("_id", (Object)new UUID(0L, 1L)));
        collection.insertOne((Object)new Document("_id", (Object)new UUID(0L, 2L)));
        collection.insertOne((Object)new Document("_id", (Object)new UUID(999999L, 128L)));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)new Document("_id", (Object)new UUID(0L, 1L))), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { : BinData(3, 00000000000000000100000000000000) }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)new Document("_id", (Object)new UUID(999999L, 128L))), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { : BinData(3, 3F420F00000000008000000000000000) }");
        collection.deleteOne((Bson)new Document("_id", (Object)new UUID(0L, 2L)));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("")))).containsExactlyInAnyOrder((Object[])new Document[]{new Document("_id", (Object)new UUID(0L, 1L)), new Document("_id", (Object)new UUID(999999L, 128L))});
    }

    @Test
    public void testTypeMatching() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 'abc'"));
        collection.insertOne((Object)TestUtils.json("a: {b: {c: 123}}"));
        collection.insertOne((Object)TestUtils.json("_id: {'$numberDecimal': '2'}"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("_id: {$type: 2.0}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 'abc'")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("_id: {$type: [16, 'string']}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: 'abc'")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("_id: {$type: 'number'}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: {'$numberDecimal': '2'}")});
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find((Bson)TestUtils.json("n: {$type: []}")).first();
        }).withMessageContaining("Query failed with error code 9 and error message 'n must match at least one type'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find((Bson)TestUtils.json("'a.b.c': {$type: []}")).first();
        }).withMessageContaining("Query failed with error code 9 and error message 'a.b.c must match at least one type'");
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: {b: {$type: []}}")))).isEmpty();
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find((Bson)TestUtils.json("n: {$type: 'abc'}")).first();
        }).withMessageContaining("Query failed with error code 2 and error message 'Unknown type name alias: abc'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find((Bson)TestUtils.json("n: {$type: null}")).first();
        }).withMessageContaining("Query failed with error code 14 and error message 'type must be represented as a number or a string'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find((Bson)TestUtils.json("_id: {$type: 16.3}")).first();
        }).withMessageContaining("Query failed with error code 2 and error message 'Invalid numerical type code: 16.3'");
    }

    @Test
    public void testDistinctQueryWithDot() {
        collection.insertOne((Object)TestUtils.json("a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("a: {b: 2}"));
        collection.insertOne((Object)TestUtils.json("a: {b: 3}"));
        collection.insertOne((Object)TestUtils.json("a: {b: null}"));
        collection.insertOne((Object)TestUtils.json("a: null"));
        Assertions.assertThat(TestUtils.toArray(collection.distinct("a.b", Integer.class))).containsExactly((Object[])new Integer[]{1, 2, 3, null});
        Assertions.assertThat((Iterable)collection.distinct("a.c", Integer.class)).isEmpty();
    }

    @Test
    public void testDropCollection() throws Exception {
        collection.insertOne((Object)TestUtils.json(""));
        Assertions.assertThat(TestUtils.toArray(db.listCollectionNames())).contains((Object[])new String[]{this.getCollectionName()});
        collection.drop();
        Assertions.assertThat(TestUtils.toArray(db.listCollectionNames())).doesNotContain((Object[])new String[]{this.getCollectionName()});
    }

    @Test
    public void testDropCollectionAlsoDropsFromDB() throws Exception {
        collection.insertOne((Object)TestUtils.json(""));
        collection.drop();
        Assertions.assertThat((long)collection.countDocuments()).isZero();
        Assertions.assertThat(TestUtils.toArray(db.listCollectionNames())).doesNotContain((Object[])new String[]{this.getCollectionName()});
    }

    @Test
    public void testDropDatabaseAlsoDropsCollectionData() throws Exception {
        collection.insertOne((Object)TestUtils.json(""));
        db.drop();
        Assertions.assertThat((long)collection.countDocuments()).isZero();
    }

    @Test
    public void testDropDatabaseDropsAllData() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        MongoCollection<Document> collection2 = this.getCollection("testcoll2");
        collection2.insertOne((Object)TestUtils.json("_id: 1"));
        syncClient.dropDatabase(db.getName());
        Assertions.assertThat(this.listDatabaseNames()).doesNotContain((Object[])new String[]{db.getName()});
        Assertions.assertThat((long)collection.countDocuments()).isZero();
        Assertions.assertThat(TestUtils.toArray(db.listCollectionNames())).doesNotContain((Object[])new String[]{this.getCollectionName(), collection2.getNamespace().getCollectionName()});
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection2.insertOne((Object)TestUtils.json("_id: 1"));
    }

    @Test
    public void testEmbeddedSort() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4, counts: {done: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 5, counts: {done: 2}"));
        List objs = TestUtils.toArray(collection.find(Filters.ne((String)"c", (Object)true)).sort((Bson)TestUtils.json("\"counts.done\": -1, _id: 1")));
        Assertions.assertThat(objs).containsExactly((Object[])new Document[]{TestUtils.json("_id: 5, counts: {done: 2}"), TestUtils.json("_id: 4, counts: {done: 1}"), TestUtils.json("_id: 1"), TestUtils.json("_id: 2"), TestUtils.json("_id: 3")});
    }

    @Test
    public void testEmbeddedSort_arrayOfDocuments() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, counts: {done: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 3, counts: {done: 2}"));
        collection.insertOne((Object)TestUtils.json("_id: 4, counts: [{done: 2}, {done: 1}]"));
        collection.insertOne((Object)TestUtils.json("_id: 5, counts: [{done: 4}, {done: 2}]"));
        collection.insertOne((Object)TestUtils.json("_id: 6, counts: {done: [3]}"));
        collection.insertOne((Object)TestUtils.json("_id: 7, counts: {done: [1, 2]}"));
        collection.insertOne((Object)TestUtils.json("_id: 8, counts: [1, 2]"));
        List objs = TestUtils.toArray(collection.find((Bson)TestUtils.json("")).sort((Bson)TestUtils.json("\"counts.done\": -1, _id: 1")));
        Assertions.assertThat(objs).containsExactly((Object[])new Document[]{TestUtils.json("_id: 5, counts: [{done: 4}, {done: 2}]"), TestUtils.json("_id: 6, counts: {done: [3]}"), TestUtils.json("_id: 3, counts: {done: 2}"), TestUtils.json("_id: 4, counts: [{done: 2}, {done: 1}]"), TestUtils.json("_id: 7, counts: {done: [1, 2]}"), TestUtils.json("_id: 2, counts: {done: 1}"), TestUtils.json("_id: 1"), TestUtils.json("_id: 8, counts: [1, 2]")});
    }

    @Test
    public void testFindAndModifyCommandEmpty() throws Exception {
        Document cmd = new Document("findandmodify", (Object)this.getCollectionName());
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> db.runCommand((Bson)cmd)).withMessageContaining("Command failed with error 9 (FailedToParse): 'Either an update or remove=true must be specified'");
    }

    @Test
    public void testFindAndModifyCommandIllegalOp() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Document cmd = new Document("findAndModify", (Object)this.getCollectionName());
        cmd.put("query", (Object)TestUtils.json("_id: 1"));
        cmd.put("update", (Object)new Document("$inc", (Object)TestUtils.json("_id: 1")));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> db.runCommand((Bson)cmd)).withMessageContaining("Command failed with error 66 (ImmutableField): 'Performing an update on the path '_id' would modify the immutable field '_id'");
    }

    @Test
    public void testFindAndModifyCommandUpdate() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Document cmd = new Document("findAndModify", (Object)this.getCollectionName());
        cmd.put("query", (Object)TestUtils.json("_id: 1"));
        cmd.put("update", (Object)TestUtils.json("$inc: {a: 1}"));
        Document result = db.runCommand((Bson)cmd);
        Assertions.assertThat((Object)result.get((Object)"lastErrorObject")).isEqualTo((Object)TestUtils.json("updatedExisting: true, n: 1"));
        Assertions.assertThat((Double)result.getDouble((Object)"ok")).isEqualTo(1.0);
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, a: 1"));
    }

    @Test
    public void testFindAndModifyCommand_UpdateSameFields() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {x: 0, a: 1}, $set: {a: 2}"));
        }).withMessageContaining("Command failed with error 40 (ConflictingUpdateOperators): 'Updating the path 'a' would create a conflict at 'a'");
    }

    @Test
    public void testFindAndModifyCommand_UpdateFieldAndItsSubfield() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: {b: {c: 1}}"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'x': 1, 'a.b': {c: 1}}, $inc: {'a.b.c': 1}"));
        }).withMessageContaining("Command failed with error 40 (ConflictingUpdateOperators): 'Updating the path 'a.b.c' would create a conflict at 'a.b'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'x': 1, 'a.b.c': 1}, $unset: {'a.b': 1}"));
        }).withMessageContaining("Command failed with error 40 (ConflictingUpdateOperators): 'Updating the path 'a.b' would create a conflict at 'a.b'");
    }

    @Test
    public void testFindOneAndUpdateError() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {_id: 1}"));
        }).withMessageContaining("Command failed with error 66 (ImmutableField): 'Performing an update on the path '_id' would modify the immutable field '_id'");
    }

    @Test
    public void testFindOneAndUpdateFields() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1"));
        Document result = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {a: 1}"), new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
        Assertions.assertThat((Map)result).isEqualTo((Object)TestUtils.json("_id: 1, a: 2"));
    }

    @Test
    public void testFineOneAndUpdateNotFound() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1"));
        Document result = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 2"), (Bson)new Document("$inc", (Object)TestUtils.json("a: 1")));
        Assertions.assertThat((Map)result).isNull();
        Assertions.assertThat((long)collection.countDocuments()).isEqualTo(1L);
    }

    @Test
    public void testFineOneAndUpdateRemove() {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1"));
        Document result = (Document)collection.findOneAndDelete((Bson)TestUtils.json("_id: 1"));
        Assertions.assertThat((Map)result).isEqualTo((Object)TestUtils.json("_id: 1, a: 1"));
        Assertions.assertThat((long)collection.countDocuments()).isZero();
    }

    @Test
    public void testFineOneAndUpdateReturnNew() {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1, b: {c: 1}"));
        Document query = TestUtils.json("_id: 1");
        Document update = TestUtils.json("$inc: {a: 1, 'b.c': 1}");
        Document result = (Document)collection.findOneAndUpdate((Bson)query, (Bson)update, new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
        Assertions.assertThat((Map)result).isEqualTo((Object)TestUtils.json("_id: 1, a: 2, b: {c: 2}"));
    }

    @Test
    public void testFineOneAndUpdateMax() {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1, b: {c: 1}"));
        Document query = TestUtils.json("_id: 1");
        Document update = TestUtils.json("$max: {a: 2, 'b.c': 2, d : 'd'}");
        Document result = (Document)collection.findOneAndUpdate((Bson)query, (Bson)update, new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
        Assertions.assertThat((Map)result).isEqualTo((Object)TestUtils.json("_id: 1, a: 2, b: {c: 2}, d : 'd'"));
    }

    @Test
    public void testFineOneAndUpdateMin() {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 2, b: {c: 1}"));
        Document query = TestUtils.json("_id: 1");
        Document update = TestUtils.json("$min: {a: 1, 'b.c': 2, d : 'd'}");
        Document result = (Document)collection.findOneAndUpdate((Bson)query, (Bson)update, new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
        Assertions.assertThat((Map)result).isEqualTo((Object)TestUtils.json("_id: 1, a: 1, b: {c: 1}, d : 'd'"));
    }

    @Test
    public void testFindOneAndUpdateReturnOld() {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1, b: {c: 1}"));
        Document query = TestUtils.json("_id: 1");
        Document update = TestUtils.json("$inc: {a: 1, 'b.c': 1}");
        Document result = (Document)collection.findOneAndUpdate((Bson)query, (Bson)update, new FindOneAndUpdateOptions().returnDocument(ReturnDocument.BEFORE));
        Assertions.assertThat((Map)result).isEqualTo((Object)TestUtils.json("_id: 1, a: 1, b: {c: 1}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)query).first())).isEqualTo((Object)TestUtils.json("_id: 1, a: 2, b: {c: 2}"));
    }

    @Test
    public void testFindOneAndUpdateSorted() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 15"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 10"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: 20"));
        Document order = TestUtils.json("a: 1");
        Document result = (Document)collection.findOneAndUpdate((Bson)TestUtils.json(""), (Bson)TestUtils.json("$inc: {a: 1}"), new FindOneAndUpdateOptions().sort((Bson)order).returnDocument(ReturnDocument.AFTER));
        Assertions.assertThat((Map)result).isEqualTo((Object)TestUtils.json("_id: 2, a: 11"));
        order = TestUtils.json("a: -1");
        result = (Document)collection.findOneAndUpdate((Bson)TestUtils.json(""), (Bson)TestUtils.json("$inc: {a: 1}"), new FindOneAndUpdateOptions().sort((Bson)order).returnDocument(ReturnDocument.AFTER));
        Assertions.assertThat((Map)result).isEqualTo((Object)TestUtils.json("_id: 3, a: 21"));
    }

    @Test
    public void testFindOneAndUpdateUpsert() {
        Document result = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {a: 1}"), new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.AFTER));
        Assertions.assertThat((Map)result).isEqualTo((Object)TestUtils.json("_id: 1, a: 1"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, a: 1"));
    }

    @Test
    public void testFindOneAndUpdateUpsertReturnBefore() {
        Document result = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {a: 1}"), new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.BEFORE));
        Assertions.assertThat((Map)result).isEqualTo((Object)TestUtils.json(""));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, a: 1"));
    }

    @Test
    public void testFindOneAndUpdateWithArrayFilters() {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: [95, 102, 90, 150]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, values: [[1, 2, 3], 'other']"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: {b: [1, 2, 3]}"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.$[element]': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("element: {$gte: 100}"))));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, grades: [95, 'abc', 90, 'abc']"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$unset: {'grades.$[element]': 1}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("element: 'abc'"))));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, grades: [95, null, 90, null]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {'grades.$[element]': 1}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("element: 90"))));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, grades: [95, null, 91, null]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 2"), (Bson)TestUtils.json("$pull: {'values.$[element]': 2}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("element: {$type: 'array'}"))));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 2")).first())).isEqualTo((Object)TestUtils.json("_id: 2, values: [[1, 3], 'other']"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 3"), (Bson)TestUtils.json("$mul: {'a.b.$[element]': 10}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("element: 2"))));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 3")).first())).isEqualTo((Object)TestUtils.json("_id: 3, a: {b: [1, 20, 3]}"));
    }

    @Test
    public void testUpdateManyWithArrayFilters() {
        collection.insertOne((Object)TestUtils.json("_id: 1, values: [9, 102, 90, 150]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, values: [1, 2, 3, 50]"));
        collection.updateMany((Bson)TestUtils.json(""), (Bson)TestUtils.json("$set: {'values.$[x]': 20}"), new UpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("x: {$gt: 20}"))));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, values: [9, 20, 20, 20]"), TestUtils.json("_id: 2, values: [1, 2, 3, 20]")});
    }

    @Test
    public void testUpdateOneWithArrayFilter() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, values: [{name: 'A', active: false}, {name: 'B', active: false}]"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'values.$[elem].active': true}"), new UpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("'elem.name': {$in: ['A']}"))));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, values: [{name: 'A', active: true}, {name: 'B', active: false}]")});
    }

    @Test
    public void testUpsertWithArrayFilters() {
        collection.updateOne((Bson)TestUtils.json("_id: 1, values: [0, 1]"), (Bson)TestUtils.json("$set: {'values.$[x]': 20}"), new UpdateOptions().upsert(true).arrayFilters(Arrays.asList(TestUtils.json("x: 0"))));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, values: [20, 1]")});
    }

    @Test
    public void testUpdateWithMultipleArrayFilters() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, values: [9, 102, 90, 150]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, values: [1, 2, 30, 50]"));
        collection.updateMany((Bson)TestUtils.json(""), (Bson)TestUtils.json("$set: {'values.$[tooLow]': 10, 'values.$[tooHigh]': 40}"), new UpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("tooLow: {$lte: 10}"), TestUtils.json("tooHigh: {$gt: 40}"))));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, values: [10, 40, 40, 40]"), TestUtils.json("_id: 2, values: [10, 10, 30, 40]")});
    }

    @Test
    public void testFindOneAndUpdate_IllegalArrayFilters() {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: 'abc', a: {b: 123}"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("element: {$gte: 100}"))));
        }).withMessageContaining("Command failed with error 9 (FailedToParse): 'The array filter for identifier 'element' was not used in the update { $set: { grades: \"abc\" } }'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("element: {$gte: 100}"), TestUtils.json("element: {$lt: 100}"))));
        }).withMessageContaining("Command failed with error 9 (FailedToParse): 'Found multiple array filters with the same top-level field name element'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.$[element]': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("a: {$gte: 100}, b: {$gte: 100}, c: {$gte: 10}"))));
        }).withMessageContaining("Command failed with error 9 (FailedToParse): 'Error parsing array filter :: caused by :: Expected a single top-level field name, found 'a' and 'b'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.$[element]': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json(""))));
        }).withMessageContaining("Command failed with error 9 (FailedToParse): 'Cannot use an expression without a top-level field name in arrayFilters'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.$[element]': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("element: {$gte: 100}"))));
        }).withMessageContaining("Command failed with error 2 (BadValue): 'Cannot apply array updates to non-array element grades: \"abc\"'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'$[element]': 10}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("element: 2"))));
        }).withMessageContaining("Command failed with error 2 (BadValue): 'Cannot have array filter identifier (i.e. '$[<id>]') element in the first position in path '$[element]'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.subGrades.$[element]': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("element: {$gte: 100}"))));
        }).withMessageContaining("Command failed with error 2 (BadValue): 'The path 'grades.subGrades' must exist in the document in order to apply array updates.'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.$[some value]': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("'some value': {$gte: 100}"))));
        }).withMessageContaining("Command failed with error 2 (BadValue): 'Error parsing array filter :: caused by :: The top-level field name must be an alphanumeric string beginning with a lowercase letter, found 'some value''");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'a.b.$[x]': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("x: {$gte: 100}"))));
        }).withMessageContaining("Command failed with error 2 (BadValue): 'Cannot apply array updates to non-array element b: 123'");
    }

    @Test
    public void testFindOneAndUpdate_IllegalArrayFiltersPaths() {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: 'abc', a: {b: [1, 2, 3]}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, grades: 'abc', a: {b: [{c: 1}, {c: 2}, {c: 3}]}"));
        collection.insertOne((Object)TestUtils.json("_id: 3, grades: 'abc', a: {b: [[[1, 2], [3, 4]]]}"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'a.b.$[x].c': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("x: {$gt: 1}"))));
        }).withMessageContaining("Command failed with error 28 (PathNotViable): 'Cannot create field 'c' in element {1: 2}");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'a.b.$[x].c.d': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("x: {$gt: 1}"))));
        }).withMessageContaining("Command failed with error 28 (PathNotViable): 'Cannot create field 'c' in element {1: 2}");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 2"), (Bson)TestUtils.json("$set: {'a.b.$[].c.$[]': 'abc'}"));
        }).withMessageContaining("Command failed with error 2 (BadValue): 'Cannot apply array updates to non-array element c: 1");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 3"), (Bson)TestUtils.json("$set: {'a.b.$[].0.c': 'abc'}"));
        }).withMessageContaining("Command failed with error 28 (PathNotViable): 'Cannot create field 'c' in element {0: [ 1, 2 ]}");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 3"), (Bson)TestUtils.json("$set: {'a.b.$[].0.$[].c': 'abc'}"));
        }).withMessageContaining("Command failed with error 28 (PathNotViable): 'Cannot create field 'c' in element {0: 1}");
    }

    @Test
    public void testFindAndRemoveFromEmbeddedList() {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: [1]"));
        Document result = (Document)collection.findOneAndDelete((Bson)TestUtils.json("_id: 1"));
        Assertions.assertThat((Map)result).isEqualTo((Object)TestUtils.json("_id: 1, a: [1]"));
        Assertions.assertThat((long)collection.countDocuments()).isZero();
    }

    @Test
    public void testFindOne() {
        collection.insertOne((Object)TestUtils.json("key: 'value'"));
        collection.insertOne((Object)TestUtils.json("key: 'value'"));
        Document result = (Document)collection.find().first();
        Assertions.assertThat((Map)result).isNotNull();
        Assertions.assertThat((Object)result.get((Object)"_id")).isNotNull();
    }

    @Test
    public void testFindOneById() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Document result = (Document)collection.find((Bson)TestUtils.json("_id: 1")).first();
        Assertions.assertThat((Map)result).isEqualTo((Object)TestUtils.json("_id: 1"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 2")).first())).isNull();
    }

    @Test
    public void testFindOneIn() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Document result = (Document)collection.find((Bson)TestUtils.json("_id: {$in: [1, 2]}")).first();
        Assertions.assertThat((Map)result).isEqualTo((Object)TestUtils.json("_id: 1"));
    }

    @Test
    public void testFindWithLimit() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        List actual = TestUtils.toArray(collection.find().sort((Bson)TestUtils.json("_id: 1")).limit(2));
        Assertions.assertThat(actual).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: 2")});
        List actualNegativeLimit = TestUtils.toArray(collection.find().sort((Bson)TestUtils.json("_id: 1")).limit(-2));
        Assertions.assertThat(actualNegativeLimit).isEqualTo(actual);
    }

    @Test
    public void testFindInReverseNaturalOrder() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        List actual = TestUtils.toArray(collection.find().sort((Bson)TestUtils.json("$natural: -1")));
        Assertions.assertThat(actual).containsExactly((Object[])new Document[]{TestUtils.json("_id: 2"), TestUtils.json("_id: 1")});
    }

    @Test
    public void testFindWithPattern() {
        collection.insertOne((Object)TestUtils.json("_id: 'marta'"));
        collection.insertOne((Object)TestUtils.json("_id: 'john', foo: 'bar'"));
        collection.insertOne((Object)TestUtils.json("_id: 'jon', foo: 'ba'"));
        collection.insertOne((Object)TestUtils.json("_id: 'jo'"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)new Document("_id", (Object)Pattern.compile("mart"))))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 'marta'")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)new Document("foo", (Object)Pattern.compile("ba"))))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 'john', foo: 'bar'"), TestUtils.json("_id: 'jon', foo: 'ba'")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)new Document("foo", (Object)Pattern.compile("ba$"))))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 'jon', foo: 'ba'")});
    }

    @Test
    public void testFindWithQuery() {
        collection.insertOne((Object)TestUtils.json("name: 'jon'"));
        collection.insertOne((Object)TestUtils.json("name: 'leo'"));
        collection.insertOne((Object)TestUtils.json("name: 'neil'"));
        collection.insertOne((Object)TestUtils.json("name: 'neil'"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("name: 'neil'")))).hasSize(2);
    }

    @Test
    public void testFindWithSkipLimit() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        Assertions.assertThat(TestUtils.toArray(collection.find().sort((Bson)TestUtils.json("_id: 1")).limit(2).skip(2))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 3"), TestUtils.json("_id: 4")});
    }

    @Test
    public void testFindWithSkipLimitInReverseOrder() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        Assertions.assertThat(TestUtils.toArray(collection.find().sort((Bson)TestUtils.json("_id: -1")).limit(2).skip(2))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 2"), TestUtils.json("_id: 1")});
    }

    @Test
    public void testFindWithSkipLimitAfterDelete() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 5"));
        collection.deleteOne((Bson)TestUtils.json("_id: 1"));
        collection.deleteOne((Bson)TestUtils.json("_id: 3"));
        Assertions.assertThat(TestUtils.toArray(collection.find().sort((Bson)TestUtils.json("_id: 1")).limit(2).skip(2))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 5")});
    }

    @Test
    public void testFullUpdateWithSameId() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, b: 5"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        collection.replaceOne((Bson)TestUtils.json("_id: 2, b: 5"), (Object)TestUtils.json("_id: 2, a: 5"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 2")).first())).isEqualTo((Object)TestUtils.json("_id: 2, a: 5"));
    }

    @Test
    public void testGetCollection() {
        MongoCollection<Document> collection = this.getCollection("coll");
        this.getCollection("coll").insertOne((Object)TestUtils.json(""));
        Assertions.assertThat(collection).isNotNull();
        Assertions.assertThat(TestUtils.toArray(db.listCollectionNames())).contains((Object[])new String[]{"coll"});
    }

    @Test
    public void testNullId() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: null, name: 'test'"));
        Document result = (Document)collection.find((Bson)TestUtils.json("name: 'test'")).first();
        Assertions.assertThat((Map)result).isNotNull();
        Assertions.assertThat((Comparable)result.getObjectId((Object)"_id")).isNull();
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: null")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { : null }");
        Assertions.assertThat((long)collection.countDocuments()).isEqualTo(1L);
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: null")).first())).isEqualTo((Object)TestUtils.json("_id: null, name: 'test'"));
        collection.deleteOne((Bson)TestUtils.json("_id: null"));
        Assertions.assertThat((long)collection.countDocuments()).isZero();
    }

    @Test
    public void testIdInQueryResultsInIndexOrder() {
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("_id: {$in: [3, 2, 1]}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: 2"), TestUtils.json("_id: 3")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("_id: {$in: [[1, 2, 3]]}")))).isEmpty();
    }

    @Test
    public void testInQuery_Arrays() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, v: [1, 2, 3]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, v: [1, 2]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, v: 50"));
        collection.insertOne((Object)TestUtils.json("_id: 4, v: null"));
        collection.insertOne((Object)TestUtils.json("_id: 5"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("v: {$in: [[1, 2, 3], 50]}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, v: [1, 2, 3]"), TestUtils.json("_id: 3, v: 50")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("v: {$not: {$in: [[1, 2, 3], 50]}}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 2, v: [1, 2]"), TestUtils.json("_id: 4, v: null"), TestUtils.json("_id: 5")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("v: {$not: {$in: [2, 50]}}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 4, v: null"), TestUtils.json("_id: 5")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("v: {$not: {$in: [[1, 2], 50, null]}}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, v: [1, 2, 3]")});
    }

    @Test
    public void testIdNotAllowedToBeUpdated() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.replaceOne((Bson)TestUtils.json("_id: 1"), (Object)TestUtils.json("_id: 2, a: 4")), 66, "ImmutableField", "After applying the update, the (immutable) field '_id' was found to have been altered to _id: 2");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)new Document("$set", (Object)TestUtils.json("_id: 2"))), 66, "ImmutableField", "Performing an update on the path '_id' would modify the immutable field '_id'");
    }

    @Test
    public void testIllegalCommand() throws Exception {
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> db.runCommand((Bson)TestUtils.json("foo: 1"))).withMessageContaining("Command failed with error 59 (CommandNotFound): 'no such command: 'foo'");
    }

    @Test
    public void testInsert() throws Exception {
        Assertions.assertThat((long)collection.countDocuments()).isEqualTo(0L);
        for (int i = 0; i < 3; ++i) {
            collection.insertOne((Object)new Document("_id", (Object)i));
        }
        Assertions.assertThat((long)collection.countDocuments()).isEqualTo(3L);
        collection.insertOne((Object)TestUtils.json("foo: [1, 2, 3]"));
        collection.insertOne((Object)new Document("foo", (Object)new byte[10]));
        Document insertedObject = new Document("foo", (Object)UUID.randomUUID());
        collection.insertOne((Object)insertedObject);
        Document document = (Document)collection.find((Bson)insertedObject).first();
        Assertions.assertThat((Map)document).isEqualTo((Object)insertedObject);
    }

    @Test
    public void testInsertDuplicate() throws Exception {
        Assertions.assertThat((long)collection.countDocuments()).isEqualTo(0L);
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThat((long)collection.countDocuments()).isEqualTo(1L);
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 1.0")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { : 1.0 }");
        Assertions.assertThat((long)collection.countDocuments()).isEqualTo(1L);
    }

    @Test(expected=MongoException.class)
    public void testInsertDuplicateThrows() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
    }

    @Test(expected=MongoException.class)
    public void testInsertDuplicateWithConcernThrows() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).insertOne((Object)TestUtils.json("_id: 1"));
    }

    @Test
    public void testInsertIncrementsCount() {
        Assertions.assertThat((long)collection.countDocuments()).isZero();
        collection.insertOne((Object)TestUtils.json("key: 'value'"));
        Assertions.assertThat((long)collection.countDocuments()).isEqualTo(1L);
    }

    @Test
    public void testInsertQuery() throws Exception {
        Assertions.assertThat((long)collection.countDocuments()).isEqualTo(0L);
        Document insertedObject = TestUtils.json("_id: 1");
        insertedObject.put("foo", (Object)OTHER_TEST_DATABASE_NAME);
        collection.insertOne((Object)insertedObject);
        Assertions.assertThat((Map)((Map)collection.find((Bson)insertedObject).first())).isEqualTo((Object)insertedObject);
        Assertions.assertThat((Map)((Map)collection.find((Bson)new Document("_id", (Object)1L)).first())).isEqualTo((Object)insertedObject);
        Assertions.assertThat((Map)((Map)collection.find((Bson)new Document("_id", (Object)1.0)).first())).isEqualTo((Object)insertedObject);
        Assertions.assertThat((Map)((Map)collection.find((Bson)new Document("_id", (Object)Float.valueOf(1.0001f))).first())).isNull();
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("foo: 'bar'")).first())).isEqualTo((Object)insertedObject);
    }

    @Test
    public void testInsertRemove() throws Exception {
        for (int i = 0; i < 10; ++i) {
            collection.insertOne((Object)TestUtils.json("_id: 1"));
            Assertions.assertThat((long)collection.countDocuments()).isEqualTo(1L);
            collection.deleteOne((Bson)TestUtils.json("_id: 1"));
            Assertions.assertThat((long)collection.countDocuments()).isZero();
            collection.insertOne((Object)new Document("_id", (Object)i));
            collection.deleteOne((Bson)new Document("_id", (Object)i));
        }
        Assertions.assertThat((long)collection.countDocuments()).isZero();
        collection.deleteOne((Bson)TestUtils.json("'doesnt exist': 1"));
        Assertions.assertThat((long)collection.countDocuments()).isZero();
    }

    @Test
    public void testInsertInSystemNamespace() throws Exception {
        AbstractBackendTest.assertMongoWriteException(() -> this.getCollection("system.foobar").insertOne((Object)TestUtils.json("")), 16459, "attempt to insert in system namespace");
        AbstractBackendTest.assertMongoWriteException(() -> this.getCollection("system.namespaces").insertOne((Object)TestUtils.json("")), 16459, "attempt to insert in system namespace");
    }

    @Test
    public void testListDatabaseNames() throws Exception {
        Assertions.assertThat(this.listDatabaseNames()).isEmpty();
        collection.insertOne((Object)TestUtils.json(""));
        Assertions.assertThat(this.listDatabaseNames()).containsExactly((Object[])new String[]{db.getName()});
        this.getDatabase().getCollection("some-collection").insertOne((Object)TestUtils.json(""));
        Assertions.assertThat(this.listDatabaseNames()).containsExactly((Object[])new String[]{OTHER_TEST_DATABASE_NAME, db.getName()});
    }

    private MongoDatabase getDatabase() {
        return syncClient.getDatabase(OTHER_TEST_DATABASE_NAME);
    }

    private List<String> listDatabaseNames() {
        ArrayList<String> databaseNames = new ArrayList<String>();
        for (String databaseName : syncClient.listDatabaseNames()) {
            databaseNames.add(databaseName);
        }
        return databaseNames;
    }

    @Test
    public void testQuery() throws Exception {
        Document obj = (Document)collection.find((Bson)TestUtils.json("_id: 1")).first();
        Assertions.assertThat((Map)obj).isNull();
        Assertions.assertThat((long)collection.countDocuments()).isEqualTo(0L);
    }

    @Test
    public void testQueryAll() throws Exception {
        ArrayList<Document> inserted = new ArrayList<Document>();
        for (int i = 0; i < 10; ++i) {
            Document obj = new Document("_id", (Object)i);
            collection.insertOne((Object)obj);
            inserted.add(obj);
        }
        Assertions.assertThat((long)collection.countDocuments()).isEqualTo(10L);
        Assertions.assertThat(TestUtils.toArray(collection.find().sort((Bson)TestUtils.json("_id: 1")))).isEqualTo(inserted);
    }

    @Test
    public void testQueryCount() throws Exception {
        for (int i = 0; i < 100; ++i) {
            collection.insertOne((Object)TestUtils.json(""));
        }
        Assertions.assertThat((long)collection.countDocuments()).isEqualTo(100L);
        Document obj = TestUtils.json("_id: 1");
        Assertions.assertThat((long)collection.countDocuments((Bson)obj)).isEqualTo(0L);
        collection.insertOne((Object)obj);
        Assertions.assertThat((long)collection.countDocuments((Bson)obj)).isEqualTo(1L);
    }

    @Test
    public void testQueryLimitEmptyQuery() throws Exception {
        for (int i = 0; i < 5; ++i) {
            collection.insertOne((Object)TestUtils.json(""));
        }
        Assertions.assertThat((long)collection.countDocuments((Bson)TestUtils.json(""), new CountOptions().limit(1))).isEqualTo(1L);
        Assertions.assertThat((long)collection.countDocuments((Bson)TestUtils.json(""), new CountOptions().limit(-1))).isEqualTo(5L);
        Assertions.assertThat((long)collection.countDocuments((Bson)TestUtils.json(""))).isEqualTo(5L);
    }

    @Test
    public void testQueryLimitSimpleQuery() throws Exception {
        for (int i = 0; i < 5; ++i) {
            collection.insertOne((Object)TestUtils.json("a: 1"));
        }
        Assertions.assertThat((long)collection.countDocuments((Bson)TestUtils.json("a: 1"), new CountOptions().limit(1))).isEqualTo(1L);
        Assertions.assertThat((long)collection.countDocuments((Bson)TestUtils.json("a: 1"), new CountOptions().limit(-1))).isEqualTo(5L);
        Assertions.assertThat((long)collection.countDocuments((Bson)TestUtils.json("a: 1"))).isEqualTo(5L);
    }

    @Test
    public void testQueryNull() throws Exception {
        Document object = TestUtils.json("_id: 1");
        collection.insertOne((Object)object);
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("foo: null")).first())).isEqualTo((Object)object);
    }

    @Test
    public void testQuerySkipLimitEmptyQuery() throws Exception {
        Assertions.assertThat((long)collection.countDocuments((Bson)TestUtils.json(""), new CountOptions().skip(3))).isEqualTo(0L);
        for (int i = 0; i < 10; ++i) {
            collection.insertOne((Object)TestUtils.json(""));
        }
        Assertions.assertThat((long)collection.countDocuments((Bson)TestUtils.json(""), new CountOptions().skip(3))).isEqualTo(7L);
        Assertions.assertThat((long)collection.countDocuments((Bson)TestUtils.json(""), new CountOptions().skip(15))).isEqualTo(0L);
        Assertions.assertThat((long)collection.countDocuments((Bson)TestUtils.json(""), new CountOptions().skip(3).limit(5))).isEqualTo(5L);
    }

    @Test
    public void testQuerySkipLimitSimpleQuery() throws Exception {
        Assertions.assertThat((long)collection.countDocuments((Bson)TestUtils.json("a: 1"), new CountOptions().skip(3))).isEqualTo(0L);
        for (int i = 0; i < 10; ++i) {
            collection.insertOne((Object)TestUtils.json("a: 1"));
        }
        Assertions.assertThat((long)collection.countDocuments((Bson)TestUtils.json("a: 1"), new CountOptions().skip(3))).isEqualTo(7L);
        Assertions.assertThat((long)collection.countDocuments((Bson)TestUtils.json("a: 1"), new CountOptions().skip(3).limit(5))).isEqualTo(5L);
        Assertions.assertThat((long)collection.countDocuments((Bson)TestUtils.json("a: 1"), new CountOptions().skip(15).limit(5))).isEqualTo(0L);
    }

    @Test
    public void testQuerySort() throws Exception {
        double value;
        Random random = new Random(4711L);
        for (int i = 0; i < 10; ++i) {
            collection.insertOne((Object)new Document("_id", (Object)random.nextDouble()));
        }
        List<Object> objects = TestUtils.toArray(collection.find().sort((Bson)TestUtils.json("_id: 1")));
        double before = Double.MIN_VALUE;
        for (Document obj : objects) {
            value = obj.getDouble((Object)"_id");
            Assertions.assertThat((double)value).isGreaterThanOrEqualTo(before);
            before = value;
        }
        objects = TestUtils.toArray(collection.find().sort((Bson)TestUtils.json("_id: -1")));
        before = Double.MAX_VALUE;
        for (Document obj : objects) {
            value = obj.getDouble((Object)"_id");
            Assertions.assertThat((double)value).isLessThanOrEqualTo(before);
            before = value;
        }
    }

    @Test
    public void testQueryWithFieldSelector() throws Exception {
        collection.insertOne((Object)TestUtils.json("foo: 'bar'"));
        collection.insertOne((Object)TestUtils.json("foo: null"));
        Document obj = (Document)collection.find((Bson)TestUtils.json("")).projection((Bson)TestUtils.json("foo: 1")).first();
        Assertions.assertThat((Map)obj).containsOnlyKeys((Object[])new String[]{"_id", "foo"});
        obj = (Document)collection.find((Bson)TestUtils.json("foo: 'bar'")).projection((Bson)TestUtils.json("_id: 1")).first();
        Assertions.assertThat((Map)obj).containsOnlyKeys((Object[])new String[]{"_id"});
        obj = (Document)collection.find((Bson)TestUtils.json("foo: null")).projection((Bson)TestUtils.json("_id: 0, foo: 1")).first();
        Assertions.assertThat((Map)obj).isEqualTo((Object)TestUtils.json("foo: null"));
        obj = (Document)collection.find((Bson)TestUtils.json("foo: 'bar'")).projection((Bson)TestUtils.json("_id: 0, foo: 1")).first();
        Assertions.assertThat((Map)obj).containsOnlyKeys((Object[])new String[]{"foo"});
    }

    @Test
    public void testQueryWithDotNotationFieldSelector() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, index: false, foo: {a: 'a1', b: 0}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, foo: {a: null, b: null}"));
        Document obj = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("'foo.a': 1, 'foo.b': 1")).first();
        Assertions.assertThat((Map)obj).isEqualTo((Object)TestUtils.json("_id: 1, foo: {a: 'a1', b: 0}"));
        obj = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("'foo.a': 1")).first();
        Assertions.assertThat((Map)obj).isEqualTo((Object)TestUtils.json("_id: 1, foo: {a: 'a1'}"));
        obj = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("'foo.a': 1, index: 1, _id: 0")).first();
        Assertions.assertThat((Map)obj).isEqualTo((Object)TestUtils.json("foo: {a: 'a1'}, index: false"));
        obj = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("foo: 1, _id: 0")).first();
        Assertions.assertThat((Map)obj).isEqualTo((Object)TestUtils.json("foo: {a: 'a1', b: 0}"));
        obj = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("'foo.a.b.c.d': 1")).first();
        Assertions.assertThat((Map)obj).isEqualTo((Object)TestUtils.json("_id: 1, foo: {}"));
        obj = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("'foo..': 1")).first();
        Assertions.assertThat((Map)obj).isEqualTo((Object)TestUtils.json("_id: 1, foo: {}"));
        obj = (Document)collection.find((Bson)TestUtils.json("_id: 2")).projection((Bson)TestUtils.json("'foo.a.b': 1, 'foo.b': 1, 'foo.c': 1, 'foo.c.d': 1")).first();
        Assertions.assertThat((Map)obj).isEqualTo((Object)TestUtils.json("_id: 2, foo: {b: null}"));
        obj = (Document)collection.find((Bson)TestUtils.json("_id: 2")).projection((Bson)TestUtils.json("'foo.a': 1")).first();
        Assertions.assertThat((Map)obj).isEqualTo((Object)TestUtils.json("_id: 2, foo: {a: null}"));
        obj = (Document)collection.find((Bson)TestUtils.json("_id: 2")).projection((Bson)TestUtils.json("'foo.c': 1")).first();
        Assertions.assertThat((Map)obj).isEqualTo((Object)TestUtils.json("_id: 2, foo: {}"));
    }

    @Test
    public void testQueryWithDotNotationFieldSelector_Array() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, values: [1, 2, {x: 100, y: 10}, {x: 200}]"));
        Document obj = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("'values.0': 1, 'values.x': 1")).first();
        Assertions.assertThat((Map)obj).isEqualTo((Object)TestUtils.json("_id: 1, values: [{x: 100}, {x: 200}]"));
        obj = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("'values.y': 1")).first();
        Assertions.assertThat((Map)obj).isEqualTo((Object)TestUtils.json("_id: 1, values: [{y: 10}, {}]"));
        obj = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("'values.x': 1, 'values.y': 1")).first();
        Assertions.assertThat((Map)obj).isEqualTo((Object)TestUtils.json("_id: 1, values: [{x: 100, y: 10}, {x: 200}]"));
    }

    @Test
    public void testQueryWithIllegalFieldSelection() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("values: {x: 1, y: 1}")).first();
        }).withMessageContaining("Query failed with error code 2 and error message '>1 field in obj: { x: 1, y: 1 }'");
    }

    @Test
    public void testQuerySystemNamespace() throws Exception {
        Assertions.assertThat((Map)((Map)this.getCollection("system.foobar").find().first())).isNull();
        Assertions.assertThat((Iterable)db.listCollectionNames()).isEmpty();
        collection.insertOne((Object)TestUtils.json(""));
        Document expectedObj = new Document("name", (Object)collection.getNamespace().getFullName());
        Document coll = (Document)this.getCollection("system.namespaces").find((Bson)expectedObj).first();
        Assertions.assertThat((Map)coll).isEqualTo((Object)expectedObj);
    }

    @Test
    public void testQueryAllExpression() throws Exception {
        collection.insertOne((Object)TestUtils.json("a: [{x: 1}, {x: 2}]"));
        collection.insertOne((Object)TestUtils.json("a: [{x: 2}, {x: 3}]"));
        Assertions.assertThat((long)collection.countDocuments((Bson)TestUtils.json("'a.x': {$all: [1, 2]}"))).isEqualTo(1L);
        Assertions.assertThat((long)collection.countDocuments((Bson)TestUtils.json("'a.x': {$all: [2, 3]}"))).isEqualTo(1L);
    }

    @Test
    public void testAndQueryWithAllAndNin() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, tags: ['A', 'B']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, tags: ['A', 'D']"));
        collection.insertOne((Object)TestUtils.json("_id: 3, tags: ['A', 'C']"));
        collection.insertOne((Object)TestUtils.json("_id: 4, tags: ['C', 'D']"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("$and: [{'tags': {$all: ['A']}}, {'tags': {$nin: ['B', 'C']}}]")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 2, tags: ['A', 'D']")});
    }

    @Test
    public void testMatchesAllWithEmptyCollection() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, text: 'TextA', tags: []"));
        collection.insertOne((Object)TestUtils.json("_id: 2, text: 'TextB', tags: []"));
        collection.insertOne((Object)TestUtils.json("_id: 3, text: 'TextA', tags: ['A']"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("$and: [{'text': 'TextA'}, {'tags': {$all: []}}]")))).isEmpty();
    }

    @Test
    public void testQueryWithSubdocumentIndex() throws Exception {
        collection.createIndex((Bson)TestUtils.json("action: {actionId: 1}"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("action: {actionId: 1}, value: 'a'"));
        collection.insertOne((Object)TestUtils.json("action: {actionId: 2}, value: 'b'"));
        collection.insertOne((Object)TestUtils.json("action: {actionId: 3}, value: 'c'"));
        Document foundWithNestedDocument = (Document)collection.find((Bson)TestUtils.json("action: {actionId: 2}")).first();
        Assertions.assertThat((Object)foundWithNestedDocument.get((Object)"value")).isEqualTo((Object)"b");
        Document foundWithDotNotation = (Document)collection.find((Bson)TestUtils.json("'action.actionId': 2")).first();
        Assertions.assertThat((Object)foundWithDotNotation.get((Object)"value")).isEqualTo((Object)"b");
    }

    @Test
    public void testQueryBinaryData() throws Exception {
        byte[] firstBytes = new byte[]{1, 2, 3};
        byte[] secondBytes = new byte[]{3, 2, 1};
        collection.insertOne((Object)new Document("_id", (Object)1).append("test", (Object)firstBytes));
        collection.insertOne((Object)new Document("_id", (Object)2).append("test", (Object)secondBytes));
        Document first = (Document)collection.find((Bson)new Document("test", (Object)firstBytes)).first();
        Assertions.assertThat((Map)first).isNotNull();
        Assertions.assertThat((Object)first.get((Object)"_id")).isEqualTo((Object)1);
        Document second = (Document)collection.find((Bson)new Document("test", (Object)secondBytes)).first();
        Assertions.assertThat((Map)second).isNotNull();
        Assertions.assertThat((Object)second.get((Object)"_id")).isEqualTo((Object)2);
    }

    @Test
    public void testRemove() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        collection.deleteOne((Bson)TestUtils.json("_id: 2"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 2")).first())).isNull();
        Assertions.assertThat((long)collection.countDocuments()).isEqualTo(3L);
        collection.deleteMany((Bson)TestUtils.json("_id: {$gte: 3}"));
        Assertions.assertThat((long)collection.countDocuments()).isEqualTo(1L);
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1"));
    }

    @Test
    public void testRemoveSingle() throws Exception {
        Document obj = new Document("_id", (Object)ObjectId.get());
        collection.insertOne((Object)obj);
        collection.deleteOne((Bson)obj);
    }

    @Test
    public void testRemoveReturnsModifiedDocumentCount() {
        collection.insertOne((Object)TestUtils.json(""));
        collection.insertOne((Object)TestUtils.json(""));
        DeleteResult result = collection.deleteMany((Bson)TestUtils.json(""));
        Assertions.assertThat((long)result.getDeletedCount()).isEqualTo(2L);
        result = collection.deleteMany((Bson)TestUtils.json(""));
        Assertions.assertThat((long)result.getDeletedCount()).isEqualTo(0L);
    }

    @Test
    public void testReservedCollectionNames() throws Exception {
        AbstractBackendTest.assertMongoWriteException(() -> this.getCollection("foo$bar").insertOne((Object)TestUtils.json("")), 10093, "cannot insert into reserved $ collection");
        String veryLongString = AbstractBackendTest.repeat("verylongstring", 5);
        AbstractBackendTest.assertMongoWriteException(() -> this.getCollection(veryLongString).insertOne((Object)TestUtils.json("")), 10080, "ns name too long, max size is 128");
    }

    private static String repeat(String str, int num) {
        String repeated = str;
        for (int i = 0; i < num; ++i) {
            repeated = repeated + repeated;
        }
        return repeated;
    }

    @Test
    public void testServerStatus() throws Exception {
        Date before = new Date();
        Document serverStatus = this.runCommand("serverStatus");
        Assertions.assertThat((Double)serverStatus.getDouble((Object)"ok")).isEqualTo(1.0);
        Assertions.assertThat((Object)serverStatus.get((Object)"uptime")).isInstanceOf(Number.class);
        Assertions.assertThat((Object)serverStatus.get((Object)"uptimeMillis")).isInstanceOf(Long.class);
        Date serverTime = (Date)serverStatus.get((Object)"localTime");
        Assertions.assertThat((Date)serverTime).isNotNull();
        Assertions.assertThat((boolean)serverTime.after(new Date())).isFalse();
        Assertions.assertThat((boolean)before.after(serverTime)).isFalse();
        Document connections = (Document)serverStatus.get((Object)"connections");
        Assertions.assertThat((Object)connections.get((Object)"current")).isNotNull();
    }

    @Test
    public void testPing() throws Exception {
        Assertions.assertThat((Double)this.runCommand("ping").getDouble((Object)"ok")).isEqualTo(1.0);
        Assertions.assertThat((Double)this.runCommand(TestUtils.json("ping: true")).getDouble((Object)"ok")).isEqualTo(1.0);
        Assertions.assertThat((Double)this.runCommand(TestUtils.json("ping: 2.0")).getDouble((Object)"ok")).isEqualTo(1.0);
    }

    @Test
    public void testReplSetGetStatus() throws Exception {
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> this.runCommand("replSetGetStatus")).withMessageContaining("Command failed with error 76 (NoReplicationEnabled): 'not running with --replSet'");
    }

    @Test
    public void testWhatsMyUri() throws Exception {
        for (String dbName : new String[]{"admin", "local", "test"}) {
            Document result = syncClient.getDatabase(dbName).runCommand((Bson)new Document("whatsmyuri", (Object)1));
            Assertions.assertThat((Object)result.get((Object)"you")).isNotNull();
            Assertions.assertThat((String)result.get((Object)"you").toString()).startsWith((CharSequence)"127.0.0.1:");
        }
    }

    @Test
    public void testSortDocuments() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: {b: 2}"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: {c: 1}"));
        Assertions.assertThat(TestUtils.toArray(collection.find().sort((Bson)TestUtils.json("a: 1")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 3, a: 3"), TestUtils.json("_id: 1, a: {b: 1}"), TestUtils.json("_id: 2, a: {b: 2}"), TestUtils.json("_id: 4, a: {c: 1}")});
        Assertions.assertThat(TestUtils.toArray(collection.find().sort((Bson)TestUtils.json("a: -1")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 4, a: {c: 1}"), TestUtils.json("_id: 2, a: {b: 2}"), TestUtils.json("_id: 1, a: {b: 1}"), TestUtils.json("_id: 3, a: 3")});
    }

    @Test
    public void testSort() {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: null"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 7, a: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 8, a: 'zzz'"));
        collection.insertOne((Object)TestUtils.json("_id: 9, a: 1.0"));
        Assertions.assertThat(TestUtils.toArray(collection.find().sort((Bson)TestUtils.json("a: 1, _id: 1")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, a: null"), TestUtils.json("_id: 4"), TestUtils.json("_id: 2, a: 1"), TestUtils.json("_id: 9, a: 1.0"), TestUtils.json("_id: 3, a: 2"), TestUtils.json("_id: 5, a: 3"), TestUtils.json("_id: 6, a: 4"), TestUtils.json("_id: 7, a: 'abc'"), TestUtils.json("_id: 8, a: 'zzz'")});
        Assertions.assertThat(TestUtils.toArray(collection.find().sort((Bson)TestUtils.json("a: -1, _id: 1")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 8, a: 'zzz'"), TestUtils.json("_id: 7, a: 'abc'"), TestUtils.json("_id: 6, a: 4"), TestUtils.json("_id: 5, a: 3"), TestUtils.json("_id: 3, a: 2"), TestUtils.json("_id: 2, a: 1"), TestUtils.json("_id: 9, a: 1.0"), TestUtils.json("_id: 1, a: null"), TestUtils.json("_id: 4")});
    }

    @Test
    public void testSortByEmbeddedKey() {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: {b: 2}"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: {b: 3}"));
        List results = TestUtils.toArray(collection.find().sort((Bson)TestUtils.json("'a.b': -1")));
        Assertions.assertThat(results).containsExactly((Object[])new Document[]{TestUtils.json("_id: 3, a: {b: 3}"), TestUtils.json("_id: 2, a: {b: 2}"), TestUtils.json("_id: 1, a: {b: 1}")});
    }

    @Test
    public void testUpdate() throws Exception {
        Document object = TestUtils.json("_id: 1");
        Document newObject = TestUtils.json("_id: 1, foo: 'bar'");
        collection.insertOne((Object)object);
        UpdateResult result = collection.replaceOne((Bson)object, (Object)newObject);
        Assertions.assertThat((long)result.getModifiedCount()).isEqualTo(1L);
        Assertions.assertThat((Object)result.getUpsertedId()).isNull();
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)newObject);
    }

    @Test
    public void testUpdateNothing() throws Exception {
        Document object = TestUtils.json("_id: 1");
        UpdateResult result = collection.replaceOne((Bson)object, (Object)object);
        Assertions.assertThat((long)result.getModifiedCount()).isEqualTo(0L);
        Assertions.assertThat((long)result.getMatchedCount()).isEqualTo(0L);
        Assertions.assertThat((Object)result.getUpsertedId()).isNull();
    }

    @Test
    public void testUpdateBlank() throws Exception {
        Document document = TestUtils.json("'': 1, _id: 2, a: 3, b: 4");
        collection.insertOne((Object)document);
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$set: {c: 5}"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("'': 1, _id: 2, a: 3, b: 4, c: 5"));
    }

    @Test
    public void testUpdateEmptyPositional() throws Exception {
        collection.insertOne((Object)TestUtils.json(""));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$set: {'a.$.b': 1}")), 2, "BadValue", "The positional operator did not find the match needed from the query.");
    }

    @Test
    public void testUpdateMultiplePositional() throws Exception {
        collection.insertOne((Object)TestUtils.json("a: {b: {c: 1}}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("'a.b.c': 1"), (Bson)TestUtils.json("$set: {'a.$.b.$.c': 1}")), 2, "BadValue", "Too many positional (i.e. '$') elements found in path 'a.$.b.$.c'");
    }

    @Test
    public void testUpdateIllegalFieldName() throws Exception {
        collection.insertOne((Object)TestUtils.json("x: 1"));
        collection.updateOne((Bson)TestUtils.json("x: 1"), (Bson)TestUtils.json("$set: {y: 1}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("x: 1"), (Bson)TestUtils.json("$set: {$z: 1}")), 15896, "Modified field name may not start with $");
        collection.updateOne((Bson)TestUtils.json("x: 1"), (Bson)TestUtils.json("$unset: {$z: 1}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("x: 1"), (Bson)TestUtils.json("$inc: {$z: 1}")), 15896, "Modified field name may not start with $");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("x: 1"), (Bson)TestUtils.json("$pushAll: {$z: [1, 2, 3]}")), 15896, "Modified field name may not start with $");
    }

    @Test
    public void testUpdateSubdocument() throws Exception {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("'a.b.c': 123"))).withMessage("Invalid BSON field name a.b.c");
    }

    @Test
    public void testInsertWithIllegalFieldNames() throws Exception {
        for (String illegalFieldName : Arrays.asList("a.", "a.b.", "a.....111", "a.b")) {
            Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> collection.insertOne((Object)new Document(illegalFieldName, (Object)1))).withMessage("Invalid BSON field name " + illegalFieldName);
        }
    }

    @Test
    public void testUpdateIdNoChange() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.replaceOne((Bson)TestUtils.json("_id: 1"), (Object)TestUtils.json("_id: 1, a: 5"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, a: 5"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {_id: 1, b: 3}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, a: 5, b: 3"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {_id: 1, a: 7}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, a: 7, b: 3"));
    }

    @Test
    public void testUpdatePush() throws Exception {
        Document idObj = TestUtils.json("_id: 1");
        collection.insertOne((Object)idObj);
        collection.updateOne((Bson)idObj, (Bson)TestUtils.json("$push: {'field.subfield.subsubfield': 'value'}"));
        Document expected = TestUtils.json("_id: 1, field: {subfield: {subsubfield: ['value']}}");
        Assertions.assertThat((Map)((Map)collection.find((Bson)idObj).first())).isEqualTo((Object)expected);
        collection.updateOne((Bson)idObj, (Bson)TestUtils.json("$set: {field: 'value'}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)idObj, (Bson)TestUtils.json("$push: {field: 'value'}")), 2, "BadValue", "The field 'field' must be an array but is of type string in document {_id: 1}");
        Document pushObj = TestUtils.json("$push: {field1: 'value', field2: 'value2'}");
        collection.updateOne((Bson)idObj, (Bson)pushObj);
        expected = TestUtils.json("_id: 1, field: 'value', field1: ['value'], field2: ['value2']");
        Assertions.assertThat((Map)((Map)collection.find((Bson)idObj).first())).isEqualTo((Object)expected);
        pushObj = TestUtils.json("$push: {field1: 'value'}");
        collection.updateOne((Bson)idObj, (Bson)pushObj);
        expected.put("field1", Arrays.asList("value", "value"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)idObj).first())).isEqualTo((Object)expected);
    }

    @Test
    public void testUpdatePushAll() throws Exception {
        Document idObj = TestUtils.json("_id: 1");
        collection.insertOne((Object)idObj);
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)idObj, (Bson)TestUtils.json("$pushAll: {field: 'value'}")), 10153, "Modifier $pushAll allowed for arrays only");
        collection.updateOne((Bson)idObj, (Bson)TestUtils.json("$pushAll: {field: ['value', 'value2']}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)idObj).first())).isEqualTo((Object)TestUtils.json("_id: 1, field: ['value', 'value2']"));
    }

    @Test
    public void testUpdateAddToSet() throws Exception {
        Document idObj = TestUtils.json("_id: 1");
        collection.insertOne((Object)idObj);
        collection.updateOne((Bson)idObj, (Bson)TestUtils.json("$addToSet: {'field.subfield.subsubfield': 'value'}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)idObj).first())).isEqualTo((Object)TestUtils.json("_id: 1, field: {subfield: {subsubfield: ['value']}}"));
        collection.updateOne((Bson)idObj, (Bson)TestUtils.json("$set: {field: 'value'}"));
        Assertions.assertThatExceptionOfType(MongoWriteException.class).isThrownBy(() -> collection.updateOne((Bson)idObj, (Bson)TestUtils.json("$addToSet: {field: 'value'}"))).withMessageContaining("Cannot apply $addToSet to non-array field. Field named 'field' has non-array type string");
        collection.updateOne((Bson)idObj, (Bson)TestUtils.json("$addToSet: {field1: 'value', field2: 'value2'}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)idObj).first())).isEqualTo((Object)TestUtils.json("_id: 1, field: 'value', field1: ['value'], field2: ['value2']"));
        collection.updateOne((Bson)idObj, (Bson)TestUtils.json("$addToSet: {field1: 'value'}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)idObj).first())).isEqualTo((Object)TestUtils.json("_id: 1, field: 'value', field1: ['value'], field2: ['value2']"));
    }

    @Test
    public void testUpdateAddToSetEach() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), Updates.addEachToSet((String)"a", Arrays.asList(6, 5, 4)));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, a: [6, 5, 4]"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), Updates.addEachToSet((String)"a", Arrays.asList(3, 2, 1)));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, a: [6, 5, 4, 3, 2, 1]"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), Updates.addEachToSet((String)"a", Arrays.asList(7, 7, 9, 2)));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, a: [6, 5, 4, 3, 2, 1, 7, 9]"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), Updates.addEachToSet((String)"a", Arrays.asList(12, 13, 12)));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, a: [6, 5, 4, 3, 2, 1, 7, 9, 12, 13]"));
    }

    @Test
    public void testUpdateDatasize() throws Exception {
        Document obj = TestUtils.json("_id: 1, a: {x: [1, 2, 3]}");
        collection.insertOne((Object)obj);
        Integer oldSize = this.getCollStats().getInteger((Object)"size");
        collection.updateOne((Bson)TestUtils.json("_id: 1"), Updates.set((String)"a.x.0", (Object)3));
        Assertions.assertThat((Object)((Document)collection.find().first()).get((Object)"a")).isEqualTo((Object)TestUtils.json("x: [3, 2, 3]"));
        Integer newSize = this.getCollStats().getInteger((Object)"size");
        Assertions.assertThat((Object)newSize).isEqualTo((Object)oldSize);
        collection.updateOne((Bson)TestUtils.json("_id: 1"), Updates.set((String)"a.x.0", (Object)"abc"));
        Integer yetNewSize = this.getCollStats().getInteger((Object)"size");
        Assertions.assertThat((int)(yetNewSize - oldSize)).isEqualTo(4);
    }

    @Test
    public void testUpdatePull() throws Exception {
        Document obj = TestUtils.json("_id: 1");
        collection.insertOne((Object)obj);
        collection.updateOne((Bson)obj, (Bson)TestUtils.json("$pull: {field1: 'value2', field2: 'value3'}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)obj).first())).isEqualTo((Object)obj);
        collection.updateOne((Bson)obj, Updates.set((String)"field", (Object)"value"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)obj, Updates.pull((String)"field", (Object)"value")), 2, "BadValue", "Cannot apply $pull to a non-array value");
        collection.updateOne((Bson)obj, (Bson)TestUtils.json("$set: {field: ['value1', 'value2', 'value1']}"));
        collection.updateOne((Bson)obj, Updates.pull((String)"field", (Object)"value1"));
        Assertions.assertThat((Object)((Document)collection.find((Bson)obj).first()).get((Object)"field")).isEqualTo(Collections.singletonList("value2"));
        collection.updateOne((Bson)obj, (Bson)TestUtils.json("$set: {field1: ['value1', 'value2', 'value1']}"));
        collection.updateOne((Bson)obj, (Bson)TestUtils.json("$set: {field2: ['value3', 'value3', 'value1']}"));
        collection.updateOne((Bson)obj, (Bson)TestUtils.json("$pull: {field1: 'value2', field2: 'value3'}"));
        Assertions.assertThat((Object)((Document)collection.find((Bson)obj).first()).get((Object)"field1")).isEqualTo(Arrays.asList("value1", "value1"));
        Assertions.assertThat((Object)((Document)collection.find((Bson)obj).first()).get((Object)"field2")).isEqualTo(Collections.singletonList("value1"));
    }

    @Test
    public void testUpdatePullValueWithCondition() {
        collection.insertOne((Object)TestUtils.json("_id: 1, votes: [ 3, 5, 6, 7, 7, 8 ]"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$pull: {votes: {$gte: 6}}"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, votes: [3, 5]"));
    }

    @Test
    public void testUpdatePullDocuments() {
        collection.insertOne((Object)TestUtils.json("_id: 1, results: [{item: 'A', score: 5}, {item: 'B', score: 8, comment: 'foobar'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, results: [{item: 'C', score: 8, comment: 'foobar'}, {item: 'B', score: 4}]"));
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$pull: {results: {score: 8 , item: 'B'}}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, results: [{item: 'A', score: 5}]"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 2")).first())).isEqualTo((Object)TestUtils.json("_id: 2, results: [{item: 'C', score: 8, comment: 'foobar'}, {item: 'B', score: 4}]"));
    }

    @Test
    public void testUpdatePullLeavesEmptyArray() {
        Document obj = TestUtils.json("_id: 1");
        collection.insertOne((Object)obj);
        collection.updateOne((Bson)obj, (Bson)TestUtils.json("$set: {field: [{'key1': 'value1', 'key2': 'value2'}]}"));
        collection.updateOne((Bson)obj, (Bson)TestUtils.json("$pull: {field: {'key1': 'value1'}}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)obj).first())).isEqualTo((Object)TestUtils.json("_id: 1, field: []"));
    }

    @Test
    public void testUpdatePullAll() throws Exception {
        Document obj = TestUtils.json("_id: 1");
        collection.insertOne((Object)obj);
        collection.updateOne((Bson)obj, (Bson)TestUtils.json("$set: {field: 'value'}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)obj, (Bson)TestUtils.json("$pullAll: {field: 'value'}")), 2, "BadValue", "$pullAll requires an array argument but was given a string");
        collection.updateOne((Bson)obj, (Bson)TestUtils.json("$set: {field1: ['value1', 'value2', 'value1', 'value3', 'value4', 'value3']}"));
        collection.updateOne((Bson)obj, (Bson)TestUtils.json("$pullAll: {field1: ['value1', 'value3']}"));
        Assertions.assertThat((Object)((Document)collection.find((Bson)obj).first()).get((Object)"field1")).isEqualTo(Arrays.asList("value2", "value4"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)obj, (Bson)TestUtils.json("$pullAll: {field1: 'bar'}")), 2, "BadValue", "$pullAll requires an array argument but was given a string");
    }

    @Test
    public void testUpdatePullAll_Documents() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, persons: [{id: 1}, {id: 2}, {id: 5}, {id: 5}, {id: 1}, {id: 0}]"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$pullAll: {persons: [{id: 0.0}, {id: 5}]}"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, persons: [{id: 1}, {id: 2}, {id: 1}]")});
    }

    @Test
    public void testUpdateSet() throws Exception {
        Document object = TestUtils.json("_id: 1");
        collection.insertOne((Object)object);
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)object);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$set: {foo: 'bar'}"));
        Document expected = TestUtils.json("");
        expected.putAll((Map)object);
        expected.put("foo", (Object)OTHER_TEST_DATABASE_NAME);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$set: {bar: 'bla'}"));
        expected.put(OTHER_TEST_DATABASE_NAME, (Object)"bla");
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)expected);
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)object, (Bson)TestUtils.json("$set: {'foo.bar': 'bla'}")), 28, "PathNotViable", "Cannot create field 'bar' in element {foo: \"bar\"}");
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)expected);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$set: {'other.foo': '123'}"));
        expected.putAll((Map)TestUtils.json("other: {foo: '123'}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)expected);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$set: {'other.foo': 42}"));
        expected.putAll((Map)TestUtils.json("other: {foo: 42}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)expected);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$set: {'other.bar': 'x'}"));
        expected.putAll((Map)TestUtils.json("other: {foo: 42, bar: 'x'}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)expected);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$set: {'other': null}"));
        expected.putAll((Map)TestUtils.json("other: null"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)expected);
    }

    @Test
    public void testUpdateSet_arrayOfDocuments() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, foo: [{bar: 1}, {bar: 2}]"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'foo.bar': 3}")), 28, "PathNotViable", "Cannot create field 'bar' in element {foo: [ { bar: 1 }, { bar: 2 } ]}");
    }

    @Test
    public void testUpdateSetOnInsert() throws Exception {
        Document object = TestUtils.json("_id: 1");
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$set: {b: 3}, $setOnInsert: {a: 3}"), new UpdateOptions().upsert(true));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, b: 3, a: 3"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$set: {b: 4}, $setOnInsert: {a: 5}"), new UpdateOptions().upsert(true));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, b: 4, a: 3"));
    }

    @Test
    public void testUpdateSetWithArrayIndices() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: [{x: 0}]"));
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$set: {'a.0.x': 3}"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, a: [{x: 3}]"));
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$set: {'a.1.z': 17}"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, a: [{x: 3}, {z: 17}]"));
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$set: {'a.0.y': 7}"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, a: [{x: 3, y: 7}, {z: 17}]"));
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$set: {'a.1': 'test'}"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, a: [{x: 3, y: 7}, 'test']"));
    }

    @Test
    public void testUpdateUnsetWithArrayIndices() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: [{x: 0}]"));
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$unset: {'a.0.x': 1}"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, a: [{}]"));
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$unset: {'a.0': 1}"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, a: [null]"));
        collection.updateOne((Bson)TestUtils.json(""), (Bson)TestUtils.json("$unset: {'a.10': 1}"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, a: [null]"));
    }

    @Test
    public void testUpdateMax() throws Exception {
        Document object = TestUtils.json("_id: 1");
        collection.insertOne((Object)object);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$max: {'foo.bar': 1}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : 1}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$max: {'foo.bar': 1}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : 1}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$max: {'foo.bar': 10}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : 10}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$max: {'foo.bar': -100}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : 10}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$max: {'foo.bar': '1'}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : '1'}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$max: {'foo.bar': null}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : '1'}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$max: {'foo.bar': '2', 'buz' : 1}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : '2'}, buz : 1"));
    }

    @Test
    public void testUpdateMin() throws Exception {
        Document object = TestUtils.json("_id: 1");
        collection.insertOne((Object)object);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$min: {'foo.bar': 'b'}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : 'b'}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$min: {'foo.bar': 'a'}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : 'a'}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$min: {'foo.bar': 10}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : 10}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$min: {'foo.bar': 10}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : 10}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$min: {'foo.bar': 1}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : 1}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$min: {'foo.bar': 100}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : 1}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$min: {'foo.bar': null}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : null}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$min: {'foo.bar': 'a'}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)TestUtils.json("_id: 1, foo : {bar : null}"));
    }

    @Test
    public void testUpdateMinMaxWithLists() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: [1, 2], b: [3, 4]"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: null, b: null"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: 'abc', b: 'xyz'"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: 1, b: 2"));
        collection.updateMany((Bson)TestUtils.json(""), (Bson)TestUtils.json("$min: {a: [2, 3], b: [1, 2]}"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: [1, 2], b: [1, 2]"), TestUtils.json("_id: 2, a: [2, 3], b: [1, 2]"), TestUtils.json("_id: 3, a: null, b: null"), TestUtils.json("_id: 4, a: 'abc', b: 'xyz'"), TestUtils.json("_id: 5, a: 1, b: 2")});
        collection.updateMany((Bson)TestUtils.json(""), (Bson)TestUtils.json("$max: {a: [1, 3], b: [2, 3]}"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: [1, 3], b: [2, 3]"), TestUtils.json("_id: 2, a: [2, 3], b: [2, 3]"), TestUtils.json("_id: 3, a: [1, 3], b: [2, 3]"), TestUtils.json("_id: 4, a: [1, 3], b: [2, 3]"), TestUtils.json("_id: 5, a: [1, 3], b: [2, 3]")});
    }

    @Test
    public void testUpdateMaxCompareNumbers() throws Exception {
        Document object = TestUtils.json("_id: 1, highScore: 800, lowScore: 200");
        collection.insertOne((Object)object);
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$max: {highScore: 950}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, highScore: 950, lowScore: 200"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$max: {highScore: 870}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, highScore: 950, lowScore: 200"));
    }

    @Test
    public void testUpdateMaxCompareDates() throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
        Document object = new Document("_id", (Object)1).append("desc", (Object)"crafts").append("dateEntered", (Object)df.parse("2013-10-01T05:00:00")).append("dateExpired", (Object)df.parse("2013-10-01T16:38:16"));
        collection.insertOne((Object)object);
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)new Document("$max", (Object)new Document("dateExpired", (Object)df.parse("2013-09-30T00:00:00"))));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, desc: 'crafts'").append("dateEntered", (Object)df.parse("2013-10-01T05:00:00")).append("dateExpired", (Object)df.parse("2013-10-01T16:38:16")));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)new Document("$max", (Object)new Document("dateExpired", (Object)df.parse("2014-01-07T00:00:00"))));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, desc: 'crafts'").append("dateEntered", (Object)df.parse("2013-10-01T05:00:00")).append("dateExpired", (Object)df.parse("2014-01-07T00:00:00")));
    }

    @Test
    public void testUpdateMinCompareNumbers() throws Exception {
        Document object = TestUtils.json("_id: 1, highScore: 800, lowScore: 200");
        collection.insertOne((Object)object);
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$min: {lowScore: 150}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, highScore: 800, lowScore: 150"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$min: {lowScore: 250}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, highScore: 800, lowScore: 150"));
    }

    @Test
    public void testUpdateMinCompareDates() throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
        Document object = new Document("_id", (Object)1).append("desc", (Object)"crafts").append("dateEntered", (Object)df.parse("2013-10-01T05:00:00")).append("dateExpired", (Object)df.parse("2013-10-01T16:38:16"));
        collection.insertOne((Object)object);
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)new Document("$min", (Object)new Document("dateEntered", (Object)df.parse("2013-09-25T00:00:00"))));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, desc: 'crafts'").append("dateEntered", (Object)df.parse("2013-09-25T00:00:00")).append("dateExpired", (Object)df.parse("2013-10-01T16:38:16")));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)new Document("$min", (Object)new Document("dateEntered", (Object)df.parse("2014-01-07T00:00:00"))));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, desc: 'crafts'").append("dateEntered", (Object)df.parse("2013-09-25T00:00:00")).append("dateExpired", (Object)df.parse("2013-10-01T16:38:16")));
    }

    @Test
    public void testUpdatePop() throws Exception {
        Document object = TestUtils.json("_id: 1");
        collection.insertOne((Object)object);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$pop: {'foo.bar': 1}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)object);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$set: {'foo.bar': [1, 2, 3]}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)TestUtils.json("_id: 1, foo: {bar: [1, 2, 3]}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$pop: {'foo.bar': 1.0}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)TestUtils.json("_id: 1, foo: {bar: [1, 2]}"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$pop: {'foo.bar': -1}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)TestUtils.json("_id: 1, foo: {bar: [2]}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)object, (Bson)TestUtils.json("$pop: {'foo.bar': null}")), 9, "FailedToParse", "Expected a number in: foo.bar: null");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)object, (Bson)TestUtils.json("$pop: {'foo.bar': 'x'}")), 9, "FailedToParse", "Expected a number in: foo.bar: \"x\"");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)object, (Bson)TestUtils.json("$pop: {'foo.bar': 2}")), 9, "FailedToParse", "$pop expects 1 or -1, found: 2");
    }

    @Test
    public void testUpdateUnset() throws Exception {
        Document obj = TestUtils.json("_id: 1, a: 1, b: null, c: 'value'");
        collection.insertOne((Object)obj);
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)obj, (Bson)TestUtils.json("$unset: {_id: ''}")), 66, "ImmutableField", "Performing an update on the path '_id' would modify the immutable field '_id'");
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$unset: {'a.b.z':1}"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, a: 1, b: null, c: 'value'"));
        collection.updateOne((Bson)obj, (Bson)TestUtils.json("$unset: {a:'', b:''}"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, c: 'value'"));
        collection.updateOne((Bson)obj, Updates.unset((String)"c.y"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, c: 'value'"));
        collection.replaceOne((Bson)TestUtils.json("_id: 1"), (Object)TestUtils.json("a: {b: 'foo', c: 'bar'}"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$unset: {'a.b':1}"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, a: {c: 'bar'}"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$unset: {'a.b.z':1}"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, a: {c: 'bar'}"));
    }

    @Test
    public void testUpdateWithIdIn() {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Document update = TestUtils.json("$push: {n: {_id: 2, u: 3}}, $inc: {c: 4}");
        Document expected = TestUtils.json("_id: 1, n: [{_id: 2, u: 3}], c: 4");
        collection.updateOne((Bson)TestUtils.json("_id: {$in: [1]}"), (Bson)update);
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)expected);
    }

    @Test
    public void testUpdateMulti() throws Exception {
        collection.insertOne((Object)TestUtils.json("a: 1"));
        collection.insertOne((Object)TestUtils.json("a: 1"));
        UpdateResult result = collection.updateOne((Bson)TestUtils.json("a: 1"), (Bson)TestUtils.json("$set: {b: 2}"));
        Assertions.assertThat((long)result.getModifiedCount()).isEqualTo(1L);
        Assertions.assertThat((long)collection.countDocuments((Bson)new Document("b", (Object)2))).isEqualTo(1L);
        result = collection.updateMany((Bson)TestUtils.json("a: 1"), (Bson)TestUtils.json("$set: {b: 3}"));
        Assertions.assertThat((long)result.getModifiedCount()).isEqualTo(2L);
        Assertions.assertThat((long)collection.countDocuments((Bson)new Document("b", (Object)2))).isEqualTo(0L);
        Assertions.assertThat((long)collection.countDocuments((Bson)new Document("b", (Object)3))).isEqualTo(2L);
    }

    @Test
    public void testUpdateIllegalInt() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: {x: 1}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {a: 1}")), 14, "TypeMismatch", "Cannot apply $inc to a value of non-numeric type. {_id: 1} has the field 'a' of non-numeric type object");
        Assertions.assertThatExceptionOfType(MongoServerException.class).isThrownBy(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {'a.x': 'b'}"))).withMessage("Cannot increment with non-numeric argument: {a.x: \"b\"}");
    }

    @Test
    public void testUpdateWithIdInMulti() {
        collection.insertMany(Arrays.asList(TestUtils.json("_id: 1"), TestUtils.json("_id: 2")));
        collection.updateMany((Bson)TestUtils.json("_id: {$in: [1, 2]}"), (Bson)TestUtils.json("$set: {n: 1}"));
        List results = TestUtils.toArray(collection.find());
        Assertions.assertThat(results).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, n: 1"), TestUtils.json("_id: 2, n: 1")});
    }

    @Test
    public void testUpdateWithIdInMultiReturnModifiedDocumentCount() {
        collection.insertMany(Arrays.asList(TestUtils.json("_id: 1"), TestUtils.json("_id: 2")));
        UpdateResult result = collection.updateMany((Bson)TestUtils.json("_id: {$in: [1, 2]}"), (Bson)TestUtils.json("$set: {n: 1}"));
        Assertions.assertThat((long)result.getModifiedCount()).isEqualTo(2L);
    }

    @Test
    public void testUpdateWithIdQuery() {
        collection.insertMany(Arrays.asList(TestUtils.json("_id: 1"), TestUtils.json("_id: 2")));
        collection.updateMany((Bson)TestUtils.json("_id: {$gt:1}"), (Bson)TestUtils.json("$set: {n: 1}"));
        List results = TestUtils.toArray(collection.find());
        Assertions.assertThat(results).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: 2, n: 1")});
    }

    @Test
    public void testUpdateWithObjectId() {
        collection.insertOne((Object)TestUtils.json("_id: {n: 1}"));
        UpdateResult result = collection.updateOne((Bson)TestUtils.json("_id: {n: 1}"), (Bson)TestUtils.json("$set: {a: 1}"));
        Assertions.assertThat((long)result.getModifiedCount()).isEqualTo(1L);
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: {n: 1}, a: 1"));
    }

    @Test
    public void testUpdateArrayMatch() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: [{x: 1, y: 1}, {x: 2,y: 2}, {x: 3, y: 3}]"));
        collection.updateOne((Bson)TestUtils.json("'a.x': 2"), (Bson)TestUtils.json("$inc: {'a.$.y': 1}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("'a.x': 2")).first())).isEqualTo((Object)TestUtils.json("_id: 1, a: [{x: 1, y: 1}, {x: 2, y: 3}, {x: 3, y: 3}]"));
        collection.insertOne((Object)TestUtils.json("'array': [{'123a': {'name': 'old'}}]"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("'array.123a.name': 'old'")).first())).isNotNull();
        collection.updateOne((Bson)TestUtils.json("'array.123a.name': 'old'"), (Bson)TestUtils.json("$set: {'array.$.123a.name': 'new'}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("'array.123a.name': 'new'")).first())).isNotNull();
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("'array.123a.name': 'old'")).first())).isNull();
    }

    @Test
    public void testUpdateWithNotAndSizeOperator() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, array: ['a', 'b']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, array: ['b']"));
        collection.insertOne((Object)TestUtils.json("_id: 3, array: ['a']"));
        collection.updateMany((Bson)TestUtils.json("array: {$not: {$size: 1}}"), (Bson)TestUtils.json("$pull: {array: 'a'}"));
        Assertions.assertThat(TestUtils.toArray(collection.find())).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, array: ['b']"), TestUtils.json("_id: 2, array: ['b']"), TestUtils.json("_id: 3, array: ['a']")});
    }

    @Test
    public void testMultiUpdateArrayMatch() throws Exception {
        collection.insertOne((Object)TestUtils.json(""));
        collection.insertOne((Object)TestUtils.json("x: [1, 2, 3]"));
        collection.insertOne((Object)TestUtils.json("x: 99"));
        collection.updateMany((Bson)TestUtils.json("x: 2"), (Bson)TestUtils.json("$inc: {'x.$': 1}"));
        Assertions.assertThat((Object)((Document)collection.find((Bson)TestUtils.json("x: 1")).first()).get((Object)"x")).isEqualTo(Arrays.asList(1, 3, 3));
    }

    @Test
    public void testUpsert() {
        UpdateResult result = collection.updateMany((Bson)TestUtils.json("n:'jon'"), (Bson)TestUtils.json("$inc: {a: 1}"), new UpdateOptions().upsert(true));
        Assertions.assertThat((long)result.getModifiedCount()).isEqualTo(0L);
        Document object = (Document)collection.find().first();
        Assertions.assertThat((Object)result.getUpsertedId()).isEqualTo((Object)new BsonObjectId(object.getObjectId((Object)"_id")));
        object.remove((Object)"_id");
        Assertions.assertThat((Map)object).isEqualTo((Object)TestUtils.json("n: 'jon', a: 1"));
        result = collection.updateOne((Bson)TestUtils.json("_id: 17, n: 'jon'"), (Bson)TestUtils.json("$inc: {a: 1}"), new UpdateOptions().upsert(true));
        Assertions.assertThat((Object)result.getUpsertedId()).isEqualTo((Object)new BsonInt32(17));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 17")).first())).isEqualTo((Object)TestUtils.json("_id: 17, n: 'jon', a: 1"));
    }

    @Test
    public void testUpsertFieldOrder() throws Exception {
        collection.updateOne((Bson)TestUtils.json("'x.y': 2"), (Bson)TestUtils.json("$inc: {a: 7}"), new UpdateOptions().upsert(true));
        Document obj = (Document)collection.find().first();
        obj.remove((Object)"_id");
        Assertions.assertThat((Map)obj).isEqualTo((Object)TestUtils.json("x: {y: 2}, a: 7"));
    }

    @Test
    public void testUpsertWithoutId() {
        UpdateResult result = collection.updateOne(Filters.eq((String)"a", (Object)1), Updates.set((String)"a", (Object)2), new UpdateOptions().upsert(true));
        Assertions.assertThat((long)result.getModifiedCount()).isEqualTo(0L);
        Assertions.assertThat((Object)result.getUpsertedId()).isNotNull();
        Assertions.assertThat((Object)((Document)collection.find().first()).get((Object)"_id")).isInstanceOf(ObjectId.class);
        Assertions.assertThat((Object)((Document)collection.find().first()).get((Object)"a")).isEqualTo((Object)2);
    }

    @Test
    public void testUpsertOnIdWithPush() {
        Document update1 = TestUtils.json("$push: {c: {a: 1, b: 2}}");
        Document update2 = TestUtils.json("$push: {c: {a: 3, b: 4}}");
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)update1, new UpdateOptions().upsert(true));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)update2, new UpdateOptions().upsert(true));
        Document expected = TestUtils.json("_id: 1, c: [{a: 1, b: 2}, {a: 3, b: 4}]");
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("'c.a':3, 'c.b':4")).first())).isEqualTo((Object)expected);
    }

    @Test
    public void testUpsertWithConditional() {
        Document query = TestUtils.json("_id: 1, b: {$gt: 5}");
        Document update = TestUtils.json("$inc: {a: 1}");
        UpdateResult updateResult = collection.updateOne((Bson)query, (Bson)update, new UpdateOptions().upsert(true));
        Assertions.assertThat((long)updateResult.getModifiedCount()).isZero();
        Assertions.assertThat((long)updateResult.getMatchedCount()).isZero();
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, a: 1"));
    }

    @Test
    public void testUpsertWithoutChange() {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 2, b: 3"));
        Document query = TestUtils.json("_id: 1");
        Document update = TestUtils.json("$set: {a: 2}");
        UpdateResult updateResult = collection.updateOne((Bson)query, (Bson)update, new UpdateOptions().upsert(true));
        Assertions.assertThat((long)updateResult.getModifiedCount()).isZero();
        Assertions.assertThat((long)updateResult.getMatchedCount()).isOne();
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, a: 2, b: 3"));
    }

    @Test
    public void testUpsertWithEmbeddedQuery() {
        collection.updateOne((Bson)TestUtils.json("_id: 1, 'e.i': 1"), (Bson)TestUtils.json("$set: {a: 1}"), new UpdateOptions().upsert(true));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, e: {i: 1}, a: 1"));
    }

    @Test
    public void testUpsertWithIdIn() throws Exception {
        Document query = TestUtils.json("_id: {$in: [1]}");
        Document update = TestUtils.json("$push: {n: {_id: 2 ,u : 3}}, $inc: {c: 4}");
        Document expected = TestUtils.json("_id: 1, n: [{_id: 2 ,u : 3}], c: 4");
        UpdateResult updateResult = collection.updateOne((Bson)query, (Bson)update, new UpdateOptions().upsert(true));
        Assertions.assertThat((long)updateResult.getModifiedCount()).isZero();
        Assertions.assertThat((long)updateResult.getMatchedCount()).isZero();
        Document actual = (Document)collection.find().first();
        Assertions.assertThat((Map)actual).isEqualTo((Object)expected);
    }

    @Test
    public void testUpsertWithId() throws Exception {
        Document query = TestUtils.json("somekey: 'somevalue'");
        Document update = TestUtils.json("$set: { _id: 'someid', somekey: 'some value' }");
        UpdateResult updateResult = collection.updateOne((Bson)query, (Bson)update, new UpdateOptions().upsert(true));
        Assertions.assertThat((long)updateResult.getModifiedCount()).isZero();
        Assertions.assertThat((long)updateResult.getMatchedCount()).isZero();
        Assertions.assertThat((Object)updateResult.getUpsertedId()).isEqualTo((Object)new BsonString("someid"));
        Assertions.assertThat(TestUtils.toArray(collection.find())).containsExactly((Object[])new Document[]{TestUtils.json("_id: 'someid', somekey: 'some value' ")});
    }

    @Test
    public void testUpsertWithId_duplicateKey() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 'someid', somekey: 'other value'"));
        Document query = TestUtils.json("somekey: 'some value'");
        Document update = TestUtils.json("$set: { _id: 'someid', somekey: 'some value' }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)query, (Bson)update, new UpdateOptions().upsert(true)), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { : \"someid\" }");
    }

    @Test
    public void testBulkUpsert() throws Exception {
        List<ReplaceOneModel> models = Arrays.asList(new ReplaceOneModel(Filters.eq((String)"_id", (Object)1), (Object)TestUtils.json("_id: 1, a: 1"), new ReplaceOptions().upsert(true)), new ReplaceOneModel(Filters.eq((String)"_id", (Object)2), (Object)TestUtils.json("_id: 2, a: 1"), new ReplaceOptions().upsert(true)));
        BulkWriteResult result = collection.bulkWrite(models, new BulkWriteOptions().ordered(false));
        Assertions.assertThat((List)result.getUpserts()).extracting(BulkWriteUpsert::getId).containsExactly((Object[])new BsonValue[]{new BsonInt32(1), new BsonInt32(2)});
        Assertions.assertThat((List)result.getUpserts()).extracting(BulkWriteUpsert::getIndex).containsExactly((Object[])new Integer[]{0, 1});
        Assertions.assertThat(TestUtils.toArray(collection.find())).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: 1"), TestUtils.json("_id: 2, a: 1")});
        models = Arrays.asList(new ReplaceOneModel(Filters.eq((String)"_id", (Object)1), (Object)TestUtils.json("_id: 1, a: 2"), new ReplaceOptions().upsert(true)), new ReplaceOneModel(Filters.eq((String)"_id", (Object)3), (Object)TestUtils.json("_id: 3, a: 2"), new ReplaceOptions().upsert(true)), new ReplaceOneModel(Filters.eq((String)"_id", (Object)2), (Object)TestUtils.json("_id: 2, a: 2"), new ReplaceOptions().upsert(true)));
        result = collection.bulkWrite(models, new BulkWriteOptions().ordered(false));
        Assertions.assertThat((List)result.getUpserts()).extracting(BulkWriteUpsert::getId).containsExactly((Object[])new BsonValue[]{new BsonInt32(3)});
        Assertions.assertThat((List)result.getUpserts()).extracting(BulkWriteUpsert::getIndex).containsExactly((Object[])new Integer[]{1});
        Assertions.assertThat(TestUtils.toArray(collection.find())).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: 2"), TestUtils.json("_id: 2, a: 2"), TestUtils.json("_id: 3, a: 2")});
    }

    @Test
    public void testUpdateWithMultiplyOperator() throws Exception {
        Document object = TestUtils.json("_id: 1");
        collection.insertOne((Object)object);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$mul: {a: 2}, $set: {b: 2}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)TestUtils.json("_id: 1, a: 0, b: 2"));
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$mul: {b: 2.5}, $inc: {a: 0.5}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)TestUtils.json("_id: 1, a: 0.5, b: 5.0"));
    }

    @Test
    public void testUpdateWithIllegalMultiplyFails() throws Exception {
        Document object = TestUtils.json("_id: 1, foo: 'x', bar: 1");
        collection.insertOne((Object)object);
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)object, (Bson)TestUtils.json("$mul: {_id: 2}")), 66, "ImmutableField", "Performing an update on the path '_id' would modify the immutable field '_id'");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)object, (Bson)TestUtils.json("$mul: {foo: 2}")), 14, "TypeMismatch", "Cannot apply $mul to a value of non-numeric type. {_id: 1} has the field 'foo' of non-numeric type string");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)object, (Bson)TestUtils.json("$mul: {bar: 'x'}")), 14, "TypeMismatch", "Cannot multiply with non-numeric argument: {bar: \"x\"}");
    }

    @Test
    public void testIsMaster() throws Exception {
        Document isMaster = this.runCommand("isMaster");
        Assertions.assertThat((Boolean)isMaster.getBoolean((Object)"ismaster")).isTrue();
        Assertions.assertThat((Date)isMaster.getDate((Object)"localTime")).isInstanceOf(Date.class);
        Integer maxBsonObjectSize = isMaster.getInteger((Object)"maxBsonObjectSize");
        Assertions.assertThat((Integer)maxBsonObjectSize).isEqualTo(0x1000000);
        Assertions.assertThat((Integer)isMaster.getInteger((Object)"maxMessageSizeBytes")).isGreaterThan((Comparable)maxBsonObjectSize);
    }

    @Test
    public void testFindWithNullOrNoFieldFilter() {
        collection.insertOne((Object)TestUtils.json("name: 'jon', group: 'group1'"));
        collection.insertOne((Object)TestUtils.json("name: 'leo', group: 'group1'"));
        collection.insertOne((Object)TestUtils.json("name: 'neil1', group: 'group2'"));
        collection.insertOne((Object)TestUtils.json("name: 'neil2', group: null"));
        collection.insertOne((Object)TestUtils.json("name: 'neil3'"));
        List objs = TestUtils.toArray(collection.find((Bson)TestUtils.json("group: null")));
        ((ListAssert)Assertions.assertThat(objs).as("should have two neils (neil2, neil3)", new Object[0])).hasSize(2);
        objs = TestUtils.toArray(collection.find(Filters.exists((String)"group", (boolean)false)));
        ((ListAssert)Assertions.assertThat(objs).as("should have one neils (neil3)", new Object[0])).hasSize(1);
        objs = TestUtils.toArray(collection.find((Bson)TestUtils.json("other: null")));
        ((ListAssert)Assertions.assertThat(objs).as("should return all documents", new Object[0])).hasSize(5);
        objs = TestUtils.toArray(collection.find(Filters.exists((String)"other", (boolean)false)));
        ((ListAssert)Assertions.assertThat(objs).as("should return all documents", new Object[0])).hasSize(5);
    }

    @Test
    public void testInsertWithIllegalId() throws Exception {
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: [1, 2, 3]")), 2, "BadValue", "can't use an array for _id");
    }

    @Test
    public void testInsertsWithUniqueIndex() {
        collection.createIndex((Bson)new Document("uniqueKeyField", (Object)1), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("uniqueKeyField: 'abc1', afield: 'avalue'"));
        collection.insertOne((Object)TestUtils.json("uniqueKeyField: 'abc2', afield: 'avalue'"));
        collection.insertOne((Object)TestUtils.json("uniqueKeyField: 'abc3', afield: 'avalue'"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("uniqueKeyField: 'abc2', afield: 'avalue'")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: uniqueKeyField_1 dup key: { : \"abc2\" }");
        collection.insertOne((Object)TestUtils.json("uniqueKeyField: 1"));
        collection.insertOne((Object)TestUtils.json("uniqueKeyField: 1.1"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("uniqueKeyField: 1.0")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: uniqueKeyField_1 dup key: { : 1.0 }");
    }

    @Test
    public void testInsertBinaryData() throws Exception {
        collection.insertOne((Object)new Document("test", (Object)new byte[]{1, 2, 3}));
    }

    @Test
    public void testUniqueIndexWithSubdocument() {
        collection.createIndex((Bson)TestUtils.json("'action.actionId': 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1, action: 'abc1'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, action: {actionId: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 3, action: {actionId: 2}"));
        collection.insertOne((Object)TestUtils.json("_id: 4, action: {actionId: 3}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("action: {actionId: 1.0}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: action.actionId_1 dup key: { : 1.0 }");
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("action: 'abc1'")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, action: 'abc1'")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'action.actionId': 2")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 3, action: {actionId: 2}")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("action: {actionId: 2}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 3, action: {actionId: 2}")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'action.actionId.subKey': 23")))).isEmpty();
    }

    @Test
    public void testUniqueIndexWithDeepDocuments() throws Exception {
        collection.createIndex((Bson)TestUtils.json("a: 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: {b: 0}"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: {b: {c: 1}}"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: {b: {c: 1, d: 1}}"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: {b: {d: 1, c: 1}}"));
        collection.insertOne((Object)TestUtils.json("_id: 7, a: {b: 1, c: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 8, a: {c: 1, d: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 9, a: {c: 1}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: 0}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { : { b: 0 } }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: 0.00}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { : { b: 0.0 } }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: -0.0}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { : { b: -0.0 } }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: {c: 1.0}}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { : { b: { c: 1.0 } } }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: {c: 1, d: 1.0}}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { : { b: { c: 1, d: 1.0 } } }");
    }

    @Test
    public void testSecondaryUniqueIndexUpdate() throws Exception {
        collection.createIndex((Bson)TestUtils.json("text: 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1, text: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, text: 'def'"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 4")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: text_1 dup key: { : null }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)new Document("$set", (Object)TestUtils.json("text: 'def'"))), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: text_1 dup key: { : \"def\" }");
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)new Document("$set", (Object)TestUtils.json("text: 'xyz'")));
        collection.updateOne((Bson)TestUtils.json("_id: 2"), (Bson)new Document("$set", (Object)TestUtils.json("text: 'abc'")));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 2"), (Bson)new Document("$set", (Object)TestUtils.json("text: null"))), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: text_1 dup key: { : null }");
        collection.deleteOne((Bson)TestUtils.json("text: 'xyz'"));
        Assertions.assertThat(TestUtils.toArray(collection.find())).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 2, text: 'abc'"), TestUtils.json("_id: 3")});
    }

    @Test
    public void testSecondarySparseUniqueIndex() throws Exception {
        collection.createIndex((Bson)TestUtils.json("text: 1"), new IndexOptions().unique(true).sparse(true));
        collection.insertOne((Object)TestUtils.json("_id: 1, text: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, text: 'def'"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 5, text: null"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 6, text: null")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: text_1 dup key: { : null }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 7, text: 'abc'")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: text_1 dup key: { : \"abc\" }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 2"), (Bson)new Document("$set", (Object)TestUtils.json("text: null"))), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: text_1 dup key: { : null }");
        collection.deleteOne((Bson)TestUtils.json("_id: 5"));
        collection.updateOne((Bson)TestUtils.json("_id: 2"), (Bson)new Document("$set", (Object)TestUtils.json("text: null")));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)new Document("$set", (Object)TestUtils.json("text: 'def'")));
        collection.deleteMany((Bson)TestUtils.json("text: null"));
        Assertions.assertThat(TestUtils.toArray(collection.find())).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, text: 'def'")});
    }

    @Test
    public void testCompoundSparseUniqueIndex() throws Exception {
        collection.createIndex((Bson)TestUtils.json("a: 1, b: 1"), new IndexOptions().unique(true).sparse(true));
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 10, b: 20"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 10"));
        collection.insertOne((Object)TestUtils.json("_id: 3, b: 20"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 5"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: null"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 7, a: null")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1_b_1 dup key: { : null, : null }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 7, b: null")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1_b_1 dup key: { : null, : null }");
        collection.deleteMany((Bson)TestUtils.json("a: null, b: null"));
        Assertions.assertThat(TestUtils.toArray(collection.find())).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: 10, b: 20"), TestUtils.json("_id: 2, a: 10"), TestUtils.json("_id: 3, b: 20")});
    }

    @Test
    public void testCompoundSparseUniqueIndexOnEmbeddedDocuments() throws Exception {
        collection.createIndex((Bson)TestUtils.json("'a.x': 1, 'b.x': 1"), new IndexOptions().unique(true).sparse(true));
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 10, b: 20"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 10"));
        collection.insertOne((Object)TestUtils.json("_id: 3, b: 20"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: {x: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 5, b: {x: 2}"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: {x: 1}, b: {x: 2}"));
        collection.insertOne((Object)TestUtils.json("_id: 7, a: {x: 2}, b: {x: 2}"));
        collection.insertOne((Object)TestUtils.json("_id: 8, a: {x: null}, b: {x: null}"));
        collection.insertOne((Object)TestUtils.json("_id: 9"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 10, a: {x: 1.0}, b: {x: 2.0}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.x_1_b.x_1 dup key: { : 1.0, : 2.0 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 11, a: {x: null}, b: {x: null}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.x_1_b.x_1 dup key: { : null, : null }");
        collection.deleteMany((Bson)TestUtils.json("a: {x: null}, b: {x: null}"));
        collection.deleteMany((Bson)TestUtils.json("a: 10"));
        collection.deleteMany((Bson)TestUtils.json("b: 20"));
        Assertions.assertThat(TestUtils.toArray(collection.find())).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 4, a: {x: 1}"), TestUtils.json("_id: 5, b: {x: 2}"), TestUtils.json("_id: 6, a: {x: 1}, b: {x: 2}"), TestUtils.json("_id: 7, a: {x: 2}, b: {x: 2}"), TestUtils.json("_id: 9")});
    }

    @Test
    public void testSparseUniqueIndexOnEmbeddedDocument() throws Exception {
        collection.createIndex((Bson)TestUtils.json("'a.b.c': 1"), new IndexOptions().unique(true).sparse(true));
        collection.insertOne((Object)TestUtils.json("a: 1"));
        collection.insertOne((Object)TestUtils.json("a: 1"));
        collection.insertOne((Object)TestUtils.json("a: null"));
        collection.insertOne((Object)TestUtils.json("a: null"));
        collection.insertOne((Object)TestUtils.json("a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("a: {b: null}"));
        collection.insertOne((Object)TestUtils.json("a: {b: null}"));
        collection.insertOne((Object)TestUtils.json("a: {b: {c: 1}}"));
        collection.insertOne((Object)TestUtils.json("a: {b: {c: 2}}"));
        collection.insertOne((Object)TestUtils.json("a: {b: {c: null}}"));
        collection.insertOne((Object)TestUtils.json("a: {b: {c: {d: 1}}}"));
        collection.insertOne((Object)TestUtils.json("a: {b: {c: {d: null}}}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: {c: 1}}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b.c_1 dup key: { : 1 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: {c: null}}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b.c_1 dup key: { : null }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: {c: 1, x: 100}}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b.c_1 dup key: { : 1 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: {c: {d: 1}}}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b.c_1 dup key: { : { d: 1 } }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: {c: {d: null}}}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b.c_1 dup key: { : { d: null } }");
    }

    @Test
    public void testAddNonUniqueIndexOnNonIdField() {
        collection.insertOne((Object)TestUtils.json("someField: 'abc'"));
        Assertions.assertThat(TestUtils.toArray(collection.listIndexes())).hasSize(1);
        collection.createIndex((Bson)new Document("someField", (Object)1), new IndexOptions().unique(false));
        Assertions.assertThat(TestUtils.toArray(collection.listIndexes())).hasSize(2);
        collection.insertOne((Object)TestUtils.json("someField: 'abc'"));
    }

    @Test
    public void testAddSparseIndexOnNonIdField() {
        collection.insertOne((Object)TestUtils.json("someField: 'abc'"));
        Assertions.assertThat(TestUtils.toArray(collection.listIndexes())).hasSize(1);
        collection.createIndex((Bson)new Document("someField", (Object)1), new IndexOptions().sparse(true));
        Assertions.assertThat(TestUtils.toArray(collection.listIndexes())).hasSize(2);
        collection.insertOne((Object)TestUtils.json("someField: 'abc'"));
    }

    @Test
    public void testDeleteAllDocumentsWithUniqueSparseIndex() {
        collection.createIndex((Bson)new Document("someField.values", (Object)1), new IndexOptions().unique(true).sparse(true));
        collection.insertOne((Object)TestUtils.json("_id: 1, someField: {values: ['abc']}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, someField: {values: ['other']}"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4, someField: ['abc']"));
        collection.insertOne((Object)TestUtils.json("_id: 5, someField: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 6, someField: null"));
        collection.deleteMany((Bson)TestUtils.json(""));
        Assertions.assertThat((long)collection.countDocuments()).isZero();
    }

    @Test
    public void testAddPartialIndexOnNonIdField() {
        collection.insertOne((Object)TestUtils.json("someField: 'abc'"));
        Assertions.assertThat(TestUtils.toArray(collection.listIndexes())).hasSize(1);
        collection.createIndex((Bson)new Document("someField", (Object)1), new IndexOptions().partialFilterExpression((Bson)TestUtils.json("someField: {$gt: 5}")));
        Assertions.assertThat(TestUtils.toArray(collection.listIndexes())).hasSize(2);
        collection.insertOne((Object)TestUtils.json("someField: 'abc'"));
    }

    @Test
    public void testCompoundUniqueIndices() {
        collection.createIndex((Bson)TestUtils.json("a: 1, b: 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 'foo'"));
        collection.insertOne((Object)TestUtils.json("_id: 3, b: 'foo'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: 'foo', b: 'foo'"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: 'foo', b: 'bar'"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: 'bar', b: 'foo'"));
        collection.insertOne((Object)TestUtils.json("_id: 7, a: {x: 1, y: 1}, b: 'foo'"));
        collection.insertOne((Object)TestUtils.json("_id: 8, a: {x: 1, y: 2}, b: 'foo'"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: 'foo', b: 'foo'")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1_b_1 dup key: { : \"foo\", : \"foo\" }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("b: 'foo'")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1_b_1 dup key: { : null, : \"foo\" }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {x: 1, y: 1}, b: 'foo'")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1_b_1 dup key: { : { x: 1, y: 1 }, : \"foo\" }");
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: 'bar'")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 6, a: 'bar', b: 'foo'")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("b: 'foo', a: 'bar'")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 6, a: 'bar', b: 'foo'")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: 'foo'")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 2, a: 'foo'"), TestUtils.json("_id: 4, a: 'foo', b: 'foo'"), TestUtils.json("_id: 5, a: 'foo', b: 'bar'")});
    }

    @Test
    public void testCompoundUniqueIndices_Subdocument() {
        collection.createIndex((Bson)TestUtils.json("a: 1, 'b.c': 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 'foo', b: 'foo'"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: 'bar', b: {c: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: 'bar', b: {c: 2}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: 'bar', b: {c: 1}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1_b.c_1 dup key: { : \"bar\", : 1 }");
    }

    @Test
    public void testCompoundUniqueIndicesWithInQuery() {
        collection.createIndex((Bson)TestUtils.json("a: 1, b: 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 'foo'"));
        collection.insertOne((Object)TestUtils.json("_id: 3, b: 'foo'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: 'foo', b: 'foo'"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: 'foo', b: 'bar'"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: 'foo', b: { $in: ['bar'] }")))).hasSize(1);
    }

    @Test
    public void testAddUniqueIndexOnExistingDocuments() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, value: 'a'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, value: 'b'"));
        collection.insertOne((Object)TestUtils.json("_id: 3, value: 'c'"));
        collection.createIndex((Bson)TestUtils.json("value: 1"), new IndexOptions().unique(true));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("value: 'c'")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: value_1 dup key: { : \"c\" }");
        collection.insertOne((Object)TestUtils.json("_id: 4, value: 'd'"));
    }

    @Test
    public void testAddUniqueIndexOnExistingDocuments_violatingUniqueness() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, value: 'a'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, value: 'b'"));
        collection.insertOne((Object)TestUtils.json("_id: 3, value: 'c'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, value: 'b'"));
        Assertions.assertThatExceptionOfType(DuplicateKeyException.class).isThrownBy(() -> collection.createIndex((Bson)TestUtils.json("value: 1"), new IndexOptions().unique(true))).withMessage("Write failed with error code 11000 and error message 'E11000 duplicate key error collection: testdb.testcoll index: value_1 dup key: { : \"b\" }'");
        Assertions.assertThat(TestUtils.toArray(collection.listIndexes())).containsExactly((Object[])new Document[]{TestUtils.json("name: '_id_', ns: 'testdb.testcoll', key: {_id: 1}, v: 2")});
        collection.insertOne((Object)TestUtils.json("_id: 5, value: 'a'"));
    }

    @Test
    public void testCursorOptionNoTimeout() throws Exception {
        try (MongoCursor cursor = collection.find().noCursorTimeout(true).iterator();){
            Assertions.assertThat((boolean)cursor.hasNext()).isFalse();
        }
    }

    @Test
    public void testBulkInsert() throws Exception {
        ArrayList<InsertOneModel> inserts = new ArrayList<InsertOneModel>();
        inserts.add(new InsertOneModel((Object)TestUtils.json("_id: 1")));
        inserts.add(new InsertOneModel((Object)TestUtils.json("_id: 2")));
        inserts.add(new InsertOneModel((Object)TestUtils.json("_id: 3")));
        BulkWriteResult result = collection.bulkWrite(inserts);
        Assertions.assertThat((int)result.getInsertedCount()).isEqualTo(3);
    }

    @Test
    public void testBulkUpdateOrdered() throws Exception {
        this.testBulkUpdate(true);
    }

    @Test
    public void testBulkUpdateUnordered() throws Exception {
        this.testBulkUpdate(false);
    }

    private void testBulkUpdate(boolean ordered) {
        this.insertUpdateInBulk(ordered);
        this.removeInBulk(ordered);
        this.insertUpdateInBulkNoMatch(ordered);
    }

    @Test
    public void testUpdateCurrentDateIllegalTypeSpecification() throws Exception {
        Document object = TestUtils.json("_id: 1");
        collection.insertOne((Object)object);
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)object, (Bson)TestUtils.json("$currentDate: {lastModified: null}")), 2, "BadValue", "null is not valid type for $currentDate. Please use a boolean ('true') or a $type expression ({$type: 'timestamp/date'}).");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)object, (Bson)TestUtils.json("$currentDate: {lastModified: 123.456}")), 2, "BadValue", "double is not valid type for $currentDate. Please use a boolean ('true') or a $type expression ({$type: 'timestamp/date'}).");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)object, (Bson)TestUtils.json("$currentDate: {lastModified: 'foo'}")), 2, "BadValue", "string is not valid type for $currentDate. Please use a boolean ('true') or a $type expression ({$type: 'timestamp/date'}).");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)object, (Bson)TestUtils.json("$currentDate: {lastModified: {$type: 'foo'}}")), 2, "BadValue", "The '$type' string field is required to be 'date' or 'timestamp': {$currentDate: {field : {$type: 'date'}}}");
        Assertions.assertThat((Map)((Map)collection.find((Bson)object).first())).isEqualTo((Object)object);
    }

    @Test
    public void testUpdateCurrentDate() throws Exception {
        Document object = TestUtils.json("_id: 1");
        collection.insertOne((Object)object);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$currentDate: {'x.lastModified': true}"));
        Assertions.assertThat((Object)((Document)((Document)collection.find((Bson)object).first()).get((Object)"x")).get((Object)"lastModified")).isInstanceOf(Date.class);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$currentDate: {'x.lastModified': {$type: 'date'}}"));
        Assertions.assertThat((Object)((Document)((Document)collection.find((Bson)object).first()).get((Object)"x")).get((Object)"lastModified")).isInstanceOf(Date.class);
        collection.updateOne((Bson)object, (Bson)TestUtils.json("$currentDate: {'x.lastModified': {$type: 'timestamp'}}"));
        Assertions.assertThat((Object)((Document)((Document)collection.find((Bson)object).first()).get((Object)"x")).get((Object)"lastModified")).isInstanceOf(BsonTimestamp.class);
    }

    @Test
    public void testRenameField() throws Exception {
        Document object = TestUtils.json("_id: 1, foo: 'x', bar: 'y'");
        collection.insertOne((Object)object);
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {foo: 'foo2', bar: 'bar2'}"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, foo2: 'x', bar2: 'y'"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {'bar2': 'foo', foo2: 'bar'}"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, bar: 'x', foo: 'y'"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {'bar': 'bar2', 'missing': 'foo'}"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, bar2: 'x', foo: 'y'"));
    }

    @Test
    public void testRenameField_embeddedDocument() {
        Document object = TestUtils.json("_id: 1, foo: { a: 1, b: 2 }, bar: { c: 3, d: 4 }}");
        collection.insertOne((Object)object);
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {'foo.a': 'foo.z', 'bar.c': 'bar.x'}"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, foo: { z: 1, b: 2 }, bar: { x: 3, d: 4 }}"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {'foo.z': 'foo.a', 'bar.a': 'bar.b'}"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, foo: { a: 1, b: 2 }, bar: { x: 3, d: 4 }}"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {'missing.a': 'missing.b'}"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, foo: { a: 1, b: 2 }, bar: { x: 3, d: 4 }}"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {'foo.a': 'a', 'bar.x': 'bar.c'}"));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, foo: { b: 2 }, bar: { c: 3, d: 4 }, a: 1}"));
        Assertions.assertThatExceptionOfType(MongoWriteException.class).isThrownBy(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {'foo.b.c': 'foo.b.d'}")));
    }

    @Test
    public void testRenameFieldIllegalValue() throws Exception {
        Document object = TestUtils.json("_id: 1, foo: 'x', bar: 'y'");
        collection.insertOne((Object)object);
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {foo: 12345}")), 2, "BadValue", "The 'to' field for $rename must be a string: foo: 12345");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {'_id': 'id'}")), 66, "ImmutableField", "Performing an update on the path '_id' would modify the immutable field '_id'");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {foo: '_id'}")), 66, "ImmutableField", "Performing an update on the path '_id' would modify the immutable field '_id'");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {foo: 'bar', 'bar': 'bar2'}")), 40, "ConflictingUpdateOperators", "Updating the path 'bar' would create a conflict at 'bar'");
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$rename: {bar: 'foo', bar2: 'foo'}")), 40, "ConflictingUpdateOperators", "Updating the path 'foo' would create a conflict at 'foo'");
    }

    @Test
    public void testRenameCollection() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.renameCollection(new MongoNamespace(collection.getNamespace().getDatabaseName(), "other-collection-name"));
        List collectionNames = TestUtils.toArray(db.listCollectionNames());
        Assertions.assertThat(collectionNames).containsExactly((Object[])new String[]{"other-collection-name"});
        Assertions.assertThat((long)this.getCollection("other-collection-name").countDocuments()).isEqualTo(3L);
    }

    @Test
    public void testRenameCollection_targetAlreadyExists() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        MongoCollection otherCollection = db.getCollection("other-collection-name");
        otherCollection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> collection.renameCollection(new MongoNamespace(db.getName(), "other-collection-name"))).withMessageContaining("Command failed with error 48 (NamespaceExists): 'target namespace exists'");
        List collectionNames = TestUtils.toArray(db.listCollectionNames());
        Assertions.assertThat(collectionNames).containsExactlyInAnyOrder((Object[])new String[]{this.getCollectionName(), "other-collection-name"});
        Assertions.assertThat((long)collection.countDocuments()).isEqualTo(3L);
        Assertions.assertThat((long)this.getCollection("other-collection-name").countDocuments()).isEqualTo(1L);
    }

    @Test
    public void testRenameCollection_dropTarget() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        MongoCollection otherCollection = db.getCollection("other-collection-name");
        otherCollection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.renameCollection(new MongoNamespace(db.getName(), "other-collection-name"), new RenameCollectionOptions().dropTarget(true));
        List collectionNames = TestUtils.toArray(db.listCollectionNames());
        Assertions.assertThat(collectionNames).containsExactly((Object[])new String[]{"other-collection-name"});
        Assertions.assertThat((long)this.getCollection("other-collection-name").countDocuments()).isEqualTo(3L);
    }

    @Test
    public void testListIndexes_empty() throws Exception {
        Assertions.assertThat((Iterable)collection.listIndexes()).isEmpty();
    }

    @Test
    public void testListIndexes() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        MongoCollection other = db.getCollection("other");
        other.insertOne((Object)TestUtils.json("_id: 1"));
        collection.createIndex((Bson)TestUtils.json("bla: 1"));
        collection.createIndex((Bson)new Document("a", (Object)1), new IndexOptions().unique(true));
        collection.createIndex((Bson)new Document("a", (Object)1).append("b", (Object)-1.0), new IndexOptions().unique(true));
        Assertions.assertThat(TestUtils.toArray(collection.listIndexes())).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("name: '_id_', ns: 'testdb.testcoll', key: {_id: 1}, v: 2"), TestUtils.json("name: 'bla_1', ns: 'testdb.testcoll', key: {bla: 1}, v: 2"), TestUtils.json("name: 'a_1', ns: 'testdb.testcoll', key: {a: 1}, unique: true, v: 2"), TestUtils.json("name: 'a_1_b_-1', ns: 'testdb.testcoll', key: {a: 1, b: -1.0}, unique: true, v: 2")});
        Assertions.assertThat(TestUtils.toArray(other.listIndexes())).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("name: '_id_', ns: 'testdb.other', key: {_id: 1}, v: 2")});
    }

    @Test
    public void testFieldSelection_deselectId() {
        collection.insertOne((Object)TestUtils.json("_id: 1, order:1, visits: 2"));
        Document document = (Document)collection.find((Bson)TestUtils.json("")).projection((Bson)TestUtils.json("_id: 0")).first();
        Assertions.assertThat((Map)document).isEqualTo((Object)TestUtils.json("order:1, visits:2"));
    }

    @Test
    public void testFieldSelection_deselectOneField() {
        Document obj = TestUtils.json("_id: 1, order:1, visits: 2, eid: 12345");
        collection.insertOne((Object)obj);
        Document document = (Document)collection.find((Bson)new Document()).projection((Bson)TestUtils.json("visits: 0")).first();
        Assertions.assertThat((Map)document).isEqualTo((Object)TestUtils.json("_id: 1, order:1, eid: 12345"));
    }

    @Test
    public void testFieldSelection_deselectTwoFields() {
        Document obj = TestUtils.json("_id: 1, order:1, visits: 2, eid: 12345");
        collection.insertOne((Object)obj);
        Document document = (Document)collection.find((Bson)new Document()).projection((Bson)TestUtils.json("visits: 0, eid: 0")).first();
        Assertions.assertThat((Map)document).isEqualTo((Object)TestUtils.json("_id: 1, order:1"));
    }

    @Test
    public void testFieldSelection_selectAndDeselectFields() {
        Document obj = TestUtils.json("_id: 1, order:1, visits: 2, eid: 12345");
        collection.insertOne((Object)obj);
        Document document = (Document)collection.find((Bson)new Document()).projection((Bson)TestUtils.json("visits: 0, eid: 1")).first();
        Assertions.assertThat((Map)document).isEqualTo((Object)TestUtils.json("_id: 1, eid: 12345"));
    }

    @Test
    public void testPullWithInPattern() {
        collection.insertOne((Object)TestUtils.json("_id: 1, tags: ['aa', 'bb', 'ab', 'cc']"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), Updates.pullByFilter((Bson)Filters.in((String)"tags", (Object[])new Pattern[]{Pattern.compile("a+")})));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, tags: ['bb', 'cc']"));
    }

    @Test
    public void testPullWithInPatternAnchored() {
        collection.insertOne((Object)TestUtils.json("_id: 1, tags: ['aa', 'bb', 'ab', 'cc']"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), Updates.pullByFilter((Bson)Filters.in((String)"tags", (Object[])new Pattern[]{Pattern.compile("^a+$")})));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, tags: ['bb', 'ab', 'cc']"));
    }

    @Test
    public void testPullWithInNumbers() {
        collection.insertOne((Object)TestUtils.json("_id: 1, values: [1, 2, 2.5, 3.0, 4]"));
        collection.updateOne((Bson)TestUtils.json("_id: 1"), Updates.pullByFilter((Bson)Filters.in((String)"values", Arrays.asList(2.0, 3, 4L))));
        Assertions.assertThat((Map)((Map)collection.find().first())).isEqualTo((Object)TestUtils.json("_id: 1, values: [1, 2.5]"));
    }

    @Test
    public void testDocumentWithHashMap() {
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("foo", OTHER_TEST_DATABASE_NAME);
        collection.insertOne((Object)new Document("_id", (Object)1).append("map", value));
        Bson document = (Bson)collection.find().first();
        Assertions.assertThat((Object)document).isEqualTo((Object)TestUtils.json("_id: 1, map: {foo: 'bar'}"));
    }

    @Test
    public void testFindAndOfOrs() throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        collection.insertOne((Object)new Document("_id", (Object)1).append("published", (Object)true).append("startDate", (Object)dateFormat.parse("2015-03-01 13:20:05")));
        collection.insertOne((Object)new Document("_id", (Object)2).append("published", (Object)true).append("expiration", (Object)dateFormat.parse("2020-12-31 18:00:00")));
        collection.insertOne((Object)new Document("_id", (Object)3).append("published", (Object)true));
        collection.insertOne((Object)new Document("_id", (Object)4).append("published", (Object)false));
        collection.insertOne((Object)new Document("_id", (Object)5).append("published", (Object)true).append("startDate", (Object)dateFormat.parse("2017-01-01 00:00:00")));
        collection.insertOne((Object)new Document("_id", (Object)6).append("published", (Object)true).append("expiration", (Object)dateFormat.parse("2016-01-01 00:00:00")));
        Date now = dateFormat.parse("2016-01-01 00:00:00");
        Bson query = Filters.and((Bson[])new Bson[]{Filters.ne((String)"published", (Object)false), Filters.or((Bson[])new Bson[]{Filters.exists((String)"startDate", (boolean)false), Filters.lt((String)"startDate", (Object)now)}), Filters.or((Bson[])new Bson[]{Filters.exists((String)"expiration", (boolean)false), Filters.gt((String)"expiration", (Object)now)})});
        List documents = TestUtils.toArray(collection.find(query).projection((Bson)TestUtils.json("_id: 1")));
        Assertions.assertThat(documents).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: 2"), TestUtils.json("_id: 3")});
    }

    @Test
    public void testInOperatorWithNullValue() {
        collection.insertMany(Arrays.asList(TestUtils.json("_id: 1, a: 1"), TestUtils.json("_id: 2, a: 2"), TestUtils.json("_id: 3, a: 3"), TestUtils.json("_id: 4, a: 4"), TestUtils.json("_id: 5")));
        Bson inQueryWithNull = Filters.in((String)"a", (Object[])new Integer[]{2, null, 3});
        List results = TestUtils.toArray(collection.find(inQueryWithNull).projection((Bson)TestUtils.json("_id: 1")));
        Assertions.assertThat(results).containsExactly((Object[])new Document[]{TestUtils.json("_id: 2"), TestUtils.json("_id: 3"), TestUtils.json("_id: 5")});
    }

    @Test
    public void testQueryWithReference() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        String collectionName = this.getCollectionName();
        collection.insertOne((Object)new Document("_id", (Object)2).append("ref", (Object)new DBRef(collectionName, (Object)1)));
        collection.insertOne((Object)new Document("_id", (Object)3).append("ref", (Object)new DBRef(collectionName, (Object)2)));
        Document doc = (Document)collection.find((Bson)new Document("ref", (Object)new DBRef(collectionName, (Object)1))).projection((Bson)TestUtils.json("_id: 1")).first();
        Assertions.assertThat((Map)doc).isEqualTo((Object)TestUtils.json("_id: 2"));
    }

    @Test
    public void testQueryWithIllegalReference() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        String collectionName = this.getCollectionName();
        collection.insertOne((Object)new Document("_id", (Object)2).append("ref", (Object)new DBRef(collectionName, (Object)1)));
        collection.insertOne((Object)new Document("_id", (Object)3).append("ref", (Object)new DBRef(collectionName, (Object)2)));
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find((Bson)TestUtils.json("ref: {$ref: 'coll'}")).first();
        }).withMessageContaining("Query failed with error code 2 and error message 'unknown operator: $ref'");
    }

    @Test
    public void testAndOrNorWithEmptyArray() throws Exception {
        collection.insertOne((Object)TestUtils.json(""));
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find(Filters.and((Bson[])new Bson[0])).first();
        }).withMessageContaining("Query failed with error code 2 and error message '$and/$or/$nor must be a nonempty array'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find(Filters.nor((Bson[])new Bson[0])).first();
        }).withMessageContaining("Query failed with error code 2 and error message '$and/$or/$nor must be a nonempty array'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find(Filters.or((Bson[])new Bson[0])).first();
        }).withMessageContaining("Query failed with error code 2 and error message '$and/$or/$nor must be a nonempty array'");
    }

    @Test
    public void testInsertLargeDocument() throws Exception {
        this.insertAndFindLargeDocument(100, 1);
        this.insertAndFindLargeDocument(1000, 2);
        this.insertAndFindLargeDocument(10000, 3);
    }

    @Test
    public void testInsertAndUpdateAsynchronously() throws Exception {
        int numDocuments = 1000;
        final CountDownLatch latch = new CountDownLatch(numDocuments);
        final LinkedBlockingQueue errors = new LinkedBlockingQueue();
        final Semaphore concurrentOperationsOnTheFly = new Semaphore(50);
        for (int i = 1; i <= numDocuments; ++i) {
            final Document document = new Document("_id", (Object)i);
            for (int j = 0; j < 10; ++j) {
                document.append("key-" + i + "-" + j, (Object)("value-" + i + "-" + j));
            }
            concurrentOperationsOnTheFly.acquire();
            asyncCollection.insertOne((Object)document).subscribe((Subscriber)new Subscriber<Success>(){

                public void onSubscribe(Subscription s) {
                    s.request(Integer.MAX_VALUE);
                }

                public void onNext(Success success) {
                    log.info("inserted {}", (Object)document);
                    final Document query = new Document("_id", (Object)document.getInteger((Object)"_id"));
                    AbstractTest.asyncCollection.updateOne((Bson)query, Updates.set((String)"updated", (Object)true)).subscribe((Subscriber)new Subscriber<UpdateResult>(){

                        public void onSubscribe(Subscription s) {
                            s.request(Integer.MAX_VALUE);
                        }

                        public void onNext(UpdateResult updateResult) {
                            log.info("updated {}: {}", (Object)query, (Object)updateResult);
                        }

                        public void onError(Throwable t) {
                            this.handleError("update", t);
                        }

                        public void onComplete() {
                            this.release();
                        }
                    });
                }

                public void onError(Throwable t) {
                    this.handleError("insert", t);
                }

                public void onComplete() {
                    log.info("insert completed");
                }

                private void handleError(String operation, Throwable t) {
                    log.error(operation + " of {} failed", (Object)document, (Object)t);
                    RuntimeException exception = new RuntimeException("Failed to " + operation + " " + document, t);
                    errors.add(exception);
                    this.release();
                    throw exception;
                }

                private void release() {
                    latch.countDown();
                    concurrentOperationsOnTheFly.release();
                }
            });
        }
        boolean success = latch.await(30L, TimeUnit.SECONDS);
        Assertions.assertThat((boolean)success).isTrue();
        if (!errors.isEmpty()) {
            throw (RuntimeException)errors.poll();
        }
        log.info("finished");
        for (int i = 1; i <= numDocuments; ++i) {
            Document query = new Document("_id", (Object)i);
            Document document = (Document)collection.find((Bson)query).first();
            ((MapAssert)Assertions.assertThat((Map)document).describedAs(query.toJson(), new Object[0])).isNotNull();
            ((AbstractBooleanAssert)Assertions.assertThat((Boolean)document.getBoolean((Object)"updated")).describedAs(document.toJson(), new Object[0])).isTrue();
        }
        long count = collection.countDocuments();
        Assertions.assertThat((long)count).isEqualTo((long)numDocuments);
    }

    @Test
    public void testAllQuery() throws Exception {
        collection.insertOne((Object)new Document("_id", (Object)new ObjectId("5234cc89687ea597eabee675")).append("code", (Object)"xyz").append("tags", Arrays.asList("school", "book", "bag", "headphone", "appliance")).append("qty", Arrays.asList(new Document().append("size", (Object)"S").append("num", (Object)10).append("color", (Object)"blue"), new Document().append("size", (Object)"M").append("num", (Object)45).append("color", (Object)"blue"), new Document().append("size", (Object)"L").append("num", (Object)100).append("color", (Object)"green"))));
        collection.insertOne((Object)new Document("_id", (Object)new ObjectId("5234cc8a687ea597eabee676")).append("code", (Object)"abc").append("tags", Arrays.asList("appliance", "school", "book")).append("qty", Arrays.asList(new Document().append("size", (Object)"6").append("num", (Object)100).append("color", (Object)"green"), new Document().append("size", (Object)"6").append("num", (Object)50).append("color", (Object)"blue"), new Document().append("size", (Object)"8").append("num", (Object)100).append("color", (Object)"brown"))));
        collection.insertOne((Object)new Document("_id", (Object)new ObjectId("5234ccb7687ea597eabee677")).append("code", (Object)"efg").append("tags", Arrays.asList("school", "book")).append("qty", Arrays.asList(new Document().append("size", (Object)"S").append("num", (Object)10).append("color", (Object)"blue"), new Document().append("size", (Object)"M").append("num", (Object)100).append("color", (Object)"blue"), new Document().append("size", (Object)"L").append("num", (Object)100).append("color", (Object)"green"))));
        collection.insertOne((Object)new Document("_id", (Object)new ObjectId("52350353b2eff1353b349de9")).append("code", (Object)"ijk").append("tags", Arrays.asList("electronics", "school")).append("qty", Collections.singletonList(new Document().append("size", (Object)"M").append("num", (Object)100).append("color", (Object)"green"))));
        List documents = TestUtils.toArray(collection.find((Bson)TestUtils.json("tags: {$all: ['appliance', 'school', 'book']}")));
        Assertions.assertThat(documents).extracting(d -> d.get((Object)"_id")).containsExactly(new Object[]{new ObjectId("5234cc89687ea597eabee675"), new ObjectId("5234cc8a687ea597eabee676")});
    }

    @Test
    public void testMatchesElementQuery() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, results: [82, 85, 88]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, results: [75, 88, 89]"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("results: {$elemMatch: {$gte: 80, $lt: 85}}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, results: [82, 85, 88]")});
    }

    @Test
    public void testMatchesElementInEmbeddedDocuments() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, results: [{product: 'abc', score: 10}, {product: 'xyz', score: 5}]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, results: [{product: 'abc', score:  9}, {product: 'xyz', score: 7}]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, results: [{product: 'abc', score:  7}, {product: 'xyz', score: 8}]"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("results: {$elemMatch: {product: 'xyz', score: {$gte: 8}}}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 3, results: [{product: 'abc', score:  7}, {product: 'xyz', score: 8}]")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("results: {$elemMatch: {product: 'xyz'}}}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, results: [{product: 'abc', score: 10}, {product: 'xyz', score: 5}]"), TestUtils.json("_id: 2, results: [{product: 'abc', score:  9}, {product: 'xyz', score: 7}]"), TestUtils.json("_id: 3, results: [{product: 'abc', score:  7}, {product: 'xyz', score: 8}]")});
    }

    @Test
    public void testElemMatchWithExpression() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, languages: [{key: 'C'}, {key: 'Java'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, languages: [{key: 'Python'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, languages: [{key: 'C++'}, {key: 'C'}]"));
        Assertions.assertThat((Iterable)collection.find((Bson)TestUtils.json("languages: {$elemMatch: {$or: [{key: 'C'}, {key: 'C++'}]}}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, languages: [{key: 'C'}, {key: 'Java'}]"), TestUtils.json("_id: 3, languages: [{key: 'C++'}, {key: 'C'}]")});
        Assertions.assertThat((Iterable)collection.find((Bson)TestUtils.json("languages: {$elemMatch: {$and: [{key: 'Java'}, {key: {$ne: 'Python'}}]}}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, languages: [{key: 'C'}, {key: 'Java'}]")});
        Assertions.assertThat((Iterable)collection.find((Bson)TestUtils.json("languages: {$elemMatch: {$nor: [{key: 'C'}, {key: 'C++'}, {key: 'Java'}]}}"))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 2, languages: [{key: 'Python'}]")});
    }

    @Test
    public void testQueryWithElemMatch() {
        collection.insertOne((Object)TestUtils.json("_id: 1, materials: [{materialId: 'A'}, {materialId: 'B'}, {materialId: 'C'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, materials: [{materialId: 'B'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, materials: []"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 5, materials: 'ABC'"));
        collection.insertOne((Object)TestUtils.json("_id: 6, materials: {materialId: 'A'}"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("materials: {$elemMatch: {materialId: 'A'}}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, materials: [{materialId: 'A'}, {materialId: 'B'}, {materialId: 'C'}]")});
    }

    @Test
    public void testProjectionWithElemMatch() {
        collection.insertOne((Object)TestUtils.json("_id: 1, zipcode: 63109, students: [{name: 'john'}, {name: 'jess'}, {name: 'jeff'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, zipcode: 63110, students: [{name: 'ajax'}, {name: 'achilles'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, zipcode: 63109, students: [{name: 'ajax'}, {name: 'achilles'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 4, zipcode: 63109, students: [{name: 'barney'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 5, zipcode: 63109, students: [1, 2, 3]"));
        collection.insertOne((Object)TestUtils.json("_id: 6, zipcode: 63109, students: {name: 'achilles'}"));
        Document query = TestUtils.json("zipcode: 63109");
        Document projection = TestUtils.json("students: {$elemMatch: {name: 'achilles'}}");
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)query).projection((Bson)projection))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: 3, students: [{name: 'achilles'}]"), TestUtils.json("_id: 4"), TestUtils.json("_id: 5"), TestUtils.json("_id: 6")});
    }

    @Test
    public void testProjectionWithElemMatch_BigSubdocument() {
        collection.insertOne((Object)TestUtils.json("_id: 1, zipcode: 63109, students: [              {name: 'john', school: 102, age: 10},              {name: 'jess', school: 102, age: 11},              {name: 'jeff', school: 108, age: 15}           ]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, zipcode: 63110, students: [              {name: 'ajax', school: 100, age: 7},              {name: 'achilles', school: 100, age: 8 }           ]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, zipcode: 63109, students: [              {name: 'ajax', school: 100, age: 7},              {name: 'achilles', school: 100, age: 8}           ]"));
        collection.insertOne((Object)TestUtils.json("_id: 4, zipcode: 63109, students: [              {name: 'barney', school: 102, age: 7}           ]"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("zipcode: 63109")).projection((Bson)TestUtils.json("students: {$elemMatch: {school: 102}}}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, students: [{name: 'john', school: 102, age: 10}]"), TestUtils.json("_id: 3"), TestUtils.json("_id: 4, students: [{name: 'barney', school: 102, age: 7}]")});
    }

    @Test
    public void testProjectionWithSlice() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, values: ['a', 'b', 'c', 'd', 'e']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, values: 'xyz'"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("values: {$slice: 1}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, values: ['a']")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("values: {$slice: ['xyz', 2]}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, values: ['a', 'b']")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("values: {$slice: [-3, 2]}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, values: ['c', 'd']")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("_id: 2")).projection((Bson)TestUtils.json("values: {$slice: 1}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 2, values: 'xyz'")});
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("values: {$slice: ['$_id', '$_id']}")).first();
        }).withMessageContaining("Query failed with error code 2 and error message '$slice limit must be positive'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("values: {$slice: [1, 0]}")).first();
        }).withMessageContaining("Query failed with error code 2 and error message '$slice limit must be positive'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("values: {$slice: [1, 'xyz']}")).first();
        }).withMessageContaining("Query failed with error code 2 and error message '$slice limit must be positive'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("values: {$slice: [1, 2, 3]}")).first();
        }).withMessageContaining("Query failed with error code 2 and error message '$slice array wrong size'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find((Bson)TestUtils.json("_id: 1")).projection((Bson)TestUtils.json("values: {$slice: 'abc'}")).first();
        }).withMessageContaining("Query failed with error code 2 and error message '$slice only supports numbers and [skip, limit] arrays'");
    }

    @Test
    public void testMatchesNullOrMissing() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, x: null"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3, x: 123"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("x: null")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, x: null"), TestUtils.json("_id: 2")});
    }

    @Test
    public void testIllegalElementMatchQuery() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, results: [ 82, 85, 88 ]"));
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find((Bson)TestUtils.json("results: {$elemMatch: [ 85 ]}")).first();
        }).withMessageContaining("Query failed with error code 2 and error message '$elemMatch needs an Object'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find((Bson)TestUtils.json("results: {$elemMatch: 1}")).first();
        }).withMessageContaining("Query failed with error code 2 and error message '$elemMatch needs an Object'");
    }

    @Test
    public void testQueryWithOperatorAndWithoutOperator() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, x: {y: 23}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, x: 9"));
        collection.insertOne((Object)TestUtils.json("_id: 3, x: 100"));
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find((Bson)TestUtils.json("x: {$lt: 10, y: 23}")).first();
        }).withMessageContaining("Query failed with error code 2 and error message 'unknown operator: y'");
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("x: {y: 23, $lt: 10}")))).isEmpty();
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("x: {y: {$lt: 100, z: 23}}")))).isEmpty();
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: 123, x: {y: {$lt: 100, z: 23}}")))).isEmpty();
    }

    @Test
    public void testQueryWithComment() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, x: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 2, x: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 3, x: 4"));
        List documents = TestUtils.toArray(collection.find((Bson)TestUtils.json("x: {$mod: [2, 0 ]}, $comment: \"Find even values.\"")));
        Assertions.assertThat(documents).extracting(d -> d.get((Object)"_id")).containsExactly(new Object[]{1, 3});
    }

    @Test
    public void testValidate() throws Exception {
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> db.runCommand((Bson)new Document("validate", (Object)this.getCollectionName()))).withMessageContaining("Command failed with error 26 (NamespaceNotFound): 'ns not found'");
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        collection.deleteOne((Bson)TestUtils.json("_id: 2"));
        Document result = db.runCommand((Bson)new Document("validate", (Object)this.getCollectionName()));
        Assertions.assertThat((Object)result.get((Object)"nrecords")).isEqualTo((Object)2);
    }

    @Test
    public void testGetLastError() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Document actual = db.runCommand((Bson)TestUtils.json("getlasterror: 1"));
        Assertions.assertThat((Object)actual.get((Object)"n")).isEqualTo((Object)0);
        Assertions.assertThat((Map)actual).containsKey((Object)"err");
        Assertions.assertThat((Object)actual.get((Object)"err")).isNull();
        Assertions.assertThat((Object)actual.get((Object)"ok")).isEqualTo((Object)1.0);
        Assertions.assertThatExceptionOfType(MongoWriteException.class).isThrownBy(() -> collection.insertOne((Object)TestUtils.json("_id: 1.0"))).withMessageContaining("E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { : 1.0 }");
        Document lastError = db.runCommand((Bson)TestUtils.json("getlasterror: 1"));
        Assertions.assertThat((Object)lastError.get((Object)"code")).isEqualTo((Object)11000);
        Assertions.assertThat((String)lastError.getString((Object)"err")).contains(new CharSequence[]{"duplicate key"});
        Assertions.assertThat((String)lastError.getString((Object)"codeName")).isEqualTo("DuplicateKey");
        Assertions.assertThat((Object)lastError.get((Object)"ok")).isEqualTo((Object)1.0);
    }

    @Test
    public void testGetPrevError() throws Exception {
        this.restart();
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThat((Map)db.runCommand((Bson)TestUtils.json("getpreverror: 1"))).isEqualTo((Object)TestUtils.json("n: 0, nPrev: -1, err: null, ok: 1.0"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 1.0")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { : 1.0 }");
        Document lastError = db.runCommand((Bson)TestUtils.json("getpreverror: 1"));
        Assertions.assertThat((Object)lastError.get((Object)"code")).isEqualTo((Object)11000);
        Assertions.assertThat((String)lastError.getString((Object)"err")).contains(new CharSequence[]{"duplicate key"});
        Assertions.assertThat((Double)lastError.getDouble((Object)"ok")).isEqualTo(1.0);
    }

    @Test
    public void testResetError() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoWriteException.class).isThrownBy(() -> collection.insertOne((Object)TestUtils.json("_id: 1.0"))).withMessageContaining("duplicate key error collection: testdb.testcoll index: _id_ dup key: { : 1.0 }");
        Assertions.assertThat((Map)db.runCommand((Bson)TestUtils.json("reseterror: 1"))).isEqualTo((Object)TestUtils.json("ok: 1.0"));
        Assertions.assertThat((Map)db.runCommand((Bson)TestUtils.json("getpreverror: 1"))).isEqualTo((Object)TestUtils.json("nPrev: -1, err: null, n: 0, ok: 1.0"));
        Assertions.assertThat((Map)db.runCommand((Bson)TestUtils.json("getlasterror: 1"))).containsAllEntriesOf((Map)TestUtils.json("err: null, n: 0, ok: 1.0"));
    }

    @Test
    public void testIllegalTopLevelOperator() throws Exception {
        Document query = TestUtils.json("$illegalOperator: 1");
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find((Bson)query).first();
        }).withMessageContaining("Query failed with error code 2 and error message 'unknown top level operator: $illegalOperator'");
    }

    @Test
    public void testExprQuery() throws Exception {
        Document query = TestUtils.json("$expr: {$gt: ['$spent', '$budget']}");
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)query))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, category: 'food', budget: 400, spent: 450"));
        collection.insertOne((Object)TestUtils.json("_id: 2, category: 'drinks', budget: 100, spent: 150"));
        collection.insertOne((Object)TestUtils.json("_id: 3, category: 'clothes', budget: 100, spent: 50"));
        collection.insertOne((Object)TestUtils.json("_id: 4, category: 'misc', budget: 500, spent: 300"));
        collection.insertOne((Object)TestUtils.json("_id: 5, category: 'travel', budget: 200, spent: 650"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)query))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, category: 'food', budget: 400, spent: 450"), TestUtils.json("_id: 2, category: 'drinks', budget: 100, spent: 150"), TestUtils.json("_id: 5, category: 'travel', budget: 200, spent: 650")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("_id: {$gt: 3}")))).hasSize(2);
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("_id: {$gt: {$expr: {$literal: 3}}}")))).isEmpty();
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("$expr: {$eq: ['$budget', {$multiply: ['$spent', 2]}]}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 3, category: 'clothes', budget: 100, spent: 50")});
    }

    @Test
    public void testExprQuery_IllegalFieldPath() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find((Bson)TestUtils.json("$expr: {$eq: ['$a.', 10]}")).first();
        }).withMessageContaining("Query failed with error code 40353 and error message 'FieldPath must not end with a '.'.'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find((Bson)TestUtils.json("$expr: {$eq: ['$.a', 10]}")).first();
        }).withMessageContaining("Query failed with error code 15998 and error message 'FieldPath field names may not be empty strings.'");
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find((Bson)TestUtils.json("$expr: {$eq: ['$a..1', 10]}")).first();
        }).withMessageContaining("Query failed with error code 15998 and error message 'FieldPath field names may not be empty strings.'");
    }

    @Test
    public void testQueryEmbeddedDocument() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, b: null"));
        collection.insertOne((Object)TestUtils.json("_id: 2, b: {c: null}"));
        collection.insertOne((Object)TestUtils.json("_id: 3, b: {c: 123}"));
        collection.insertOne((Object)TestUtils.json("_id: 4, b: {c: ['a', null, 'b']}"));
        collection.insertOne((Object)TestUtils.json("_id: 5, b: {c: [1, 2, 3]}"));
        collection.insertOne((Object)TestUtils.json("_id: 6"));
        collection.insertOne((Object)TestUtils.json("_id: 7, b: {c: 1, d: 2}"));
        collection.insertOne((Object)TestUtils.json("_id: 8, b: {c: {d: 1, e: 2}}"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'b.c': 1")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 5, b: {c: [1, 2, 3]}"), TestUtils.json("_id: 7, b: {c: 1, d: 2}")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("b: {c: 1}")))).isEmpty();
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'b.c': null")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, b: null"), TestUtils.json("_id: 2, b: {c: null}"), TestUtils.json("_id: 4, b: {c: ['a', null, 'b']}"), TestUtils.json("_id: 6")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("b: {c: null}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 2, b: {c: null}")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'b.c': {d: 1}")))).isEmpty();
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'b.c': {d: {$gte: 1}}")))).isEmpty();
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'b.c': {d: {$gte: 1}, e: {$lte: 2}}")))).isEmpty();
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'b.c.d': {$gte: 1}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 8, b: {c: {d: 1, e: 2}}")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'b.c': {d: 1, e: 2}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 8, b: {c: {d: 1, e: 2}}")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'b.c.e': 2")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 8, b: {c: {d: 1, e: 2}}")});
    }

    @Test
    public void testQueryWithEquivalentEmbeddedDocument() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id:  1, a: {b: 1, c: 0}"));
        collection.insertOne((Object)TestUtils.json("_id:  2, a: {b: 1, c: 0.0}"));
        collection.insertOne((Object)TestUtils.json("_id:  3, a: {b: 1.0, c: 0.0}"));
        collection.insertOne((Object)TestUtils.json("_id:  4, a: {b: 1.0, c: 0}"));
        collection.insertOne((Object)TestUtils.json("_id:  5, a: {b: {c: 1.0}}"));
        collection.insertOne((Object)TestUtils.json("_id:  6, a: {b: {c: 1}}"));
        collection.insertOne((Object)TestUtils.json("_id:  7, a: {b: {c: 1, d: 1.0}}"));
        collection.insertOne((Object)TestUtils.json("_id:  8, a: {c: 0, b: 1.0}"));
        collection.insertOne((Object)TestUtils.json("_id:  9, a: {c: 0}"));
        collection.insertOne((Object)TestUtils.json("_id: 10, a: {b: 1}"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: {b: 1.0, c: -0.0}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: {b: 1, c: 0}"), TestUtils.json("_id: 2, a: {b: 1, c: 0.0}"), TestUtils.json("_id: 3, a: {b: 1.0, c: 0.0}"), TestUtils.json("_id: 4, a: {b: 1.0, c: 0}")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: {b: {c: 1}}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 5, a: {b: {c: 1.0}}"), TestUtils.json("_id: 6, a: {b: {c: 1}}")});
    }

    @Test
    public void testOrderByMissingAndNull() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id:  1, a: null"));
        collection.insertOne((Object)TestUtils.json("_id:  2"));
        collection.insertOne((Object)TestUtils.json("_id:  3, a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("_id:  4, a: null"));
        collection.insertOne((Object)TestUtils.json("_id:  5"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("")).sort((Bson)TestUtils.json("a: 1, _id: 1")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, a: null"), TestUtils.json("_id: 2"), TestUtils.json("_id: 4, a: null"), TestUtils.json("_id: 5"), TestUtils.json("_id: 3, a: {b: 1}")});
    }

    @Test
    public void testOrderByEmbeddedDocument() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id:  1, a: {b: 1, c: 0}"));
        collection.insertOne((Object)TestUtils.json("_id:  2, a: {b: 1, c: 0.0}"));
        collection.insertOne((Object)TestUtils.json("_id:  3, a: {b: 1, c: null}"));
        collection.insertOne((Object)TestUtils.json("_id:  4, a: {b: 1.0, c: 0}"));
        collection.insertOne((Object)TestUtils.json("_id:  5, a: {b: 1.0, c: 0.0}"));
        collection.insertOne((Object)TestUtils.json("_id:  6, a: {b: 1.0, c: 0}"));
        collection.insertOne((Object)TestUtils.json("_id:  7, a: {b: {c: 1.0}}"));
        collection.insertOne((Object)TestUtils.json("_id:  8, a: {c: 0, b: 1.0}"));
        collection.insertOne((Object)TestUtils.json("_id:  9, a: {c: 0}"));
        collection.insertOne((Object)TestUtils.json("_id: 10, a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 11, a: {b: {c: 0.0}}"));
        collection.insertOne((Object)TestUtils.json("_id: 12, a: {c: 2}"));
        collection.insertOne((Object)TestUtils.json("_id: 13, a: {b: null, c: 0}"));
        collection.insertOne((Object)TestUtils.json("_id: 14, a: {b: 'abc'}"));
        collection.insertOne((Object)TestUtils.json("_id: 15, a: null, b: 123"));
        collection.insertOne((Object)TestUtils.json("_id: 16, b: 123"));
        collection.insertOne((Object)TestUtils.json("_id: 17, a: null, b: 123"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("")).sort((Bson)TestUtils.json("a: 1, _id: 1")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 15, a: null, b: 123"), TestUtils.json("_id: 16, b: 123"), TestUtils.json("_id: 17, a: null, b: 123"), TestUtils.json("_id: 13, a: {b: null, c: 0}"), TestUtils.json("_id: 10, a: {b: 1}"), TestUtils.json("_id:  3, a: {b: 1, c: null}"), TestUtils.json("_id:  1, a: {b: 1, c: 0}"), TestUtils.json("_id:  2, a: {b: 1, c: 0.0}"), TestUtils.json("_id:  4, a: {b: 1.0, c: 0}"), TestUtils.json("_id:  5, a: {b: 1.0, c: 0.0}"), TestUtils.json("_id:  6, a: {b: 1.0, c: 0}"), TestUtils.json("_id:  9, a: {c: 0}"), TestUtils.json("_id:  8, a: {c: 0, b: 1.0}"), TestUtils.json("_id: 12, a: {c: 2}"), TestUtils.json("_id: 14, a: {b: 'abc'}"), TestUtils.json("_id: 11, a: {b: {c: 0.0}}"), TestUtils.json("_id:  7, a: {b: {c: 1.0}}")});
    }

    @Test
    public void testFindByListValue() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: [2, 1]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: [2, 1.0]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: [1, 2]"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: [1, 2, 3]"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: [3, 2]"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: [2, 3]"));
        collection.insertOne((Object)TestUtils.json("_id: 7, a: [3]"));
        collection.insertOne((Object)TestUtils.json("_id: 8, a: [3, 2]"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: [2, 1]")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: [2, 1]"), TestUtils.json("_id: 2, a: [2, 1.0]")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: [1, 2]")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 3, a: [1, 2]")});
    }

    @Test
    public void testFindAndOrderByWithListValues() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id:  1, a: []"));
        collection.insertOne((Object)TestUtils.json("_id:  2, a: null"));
        collection.insertOne((Object)TestUtils.json("_id:  3, a: [2, 1]"));
        collection.insertOne((Object)TestUtils.json("_id:  4, a: [2, 1.0]"));
        collection.insertOne((Object)TestUtils.json("_id:  5, a: [1, 2]"));
        collection.insertOne((Object)TestUtils.json("_id:  6, a: [1, 2, 3]"));
        collection.insertOne((Object)TestUtils.json("_id:  7, a: [3, 2]"));
        collection.insertOne((Object)TestUtils.json("_id:  8, a: [2, 3]"));
        collection.insertOne((Object)TestUtils.json("_id:  9, a: [3]"));
        collection.insertOne((Object)TestUtils.json("_id: 10, a: [3, 2]"));
        collection.insertOne((Object)TestUtils.json("_id: 11, a: [null, 1, 2]"));
        collection.insertOne((Object)TestUtils.json("_id: 12, a: [1, 'abc', 2]"));
        collection.insertOne((Object)TestUtils.json("_id: 13"));
        collection.insertOne((Object)TestUtils.json("_id: 14, a: 'xyz'"));
        collection.insertOne((Object)TestUtils.json("_id: 15, a: {b: 5}"));
        collection.insertOne((Object)TestUtils.json("_id: 16, a: 1"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("")).sort((Bson)TestUtils.json("a: 1, _id: -1")))).containsExactly((Object[])new Document[]{TestUtils.json("_id:  1, a: []"), TestUtils.json("_id: 13"), TestUtils.json("_id: 11, a: [null, 1, 2]"), TestUtils.json("_id:  2, a: null"), TestUtils.json("_id: 16, a: 1"), TestUtils.json("_id: 12, a: [1, 'abc', 2]"), TestUtils.json("_id:  6, a: [1, 2, 3]"), TestUtils.json("_id:  5, a: [1, 2]"), TestUtils.json("_id:  4, a: [2, 1.0]"), TestUtils.json("_id:  3, a: [2, 1]"), TestUtils.json("_id: 10, a: [3, 2]"), TestUtils.json("_id:  8, a: [2, 3]"), TestUtils.json("_id:  7, a: [3, 2]"), TestUtils.json("_id:  9, a: [3]"), TestUtils.json("_id: 14, a: 'xyz'"), TestUtils.json("_id: 15, a: {b: 5}")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("")).sort((Bson)TestUtils.json("a: 1, _id: 1")))).containsExactly((Object[])new Document[]{TestUtils.json("_id:  1, a: []"), TestUtils.json("_id:  2, a: null"), TestUtils.json("_id: 11, a: [null, 1, 2]"), TestUtils.json("_id: 13"), TestUtils.json("_id:  3, a: [2, 1]"), TestUtils.json("_id:  4, a: [2, 1.0]"), TestUtils.json("_id:  5, a: [1, 2]"), TestUtils.json("_id:  6, a: [1, 2, 3]"), TestUtils.json("_id: 12, a: [1, 'abc', 2]"), TestUtils.json("_id: 16, a: 1"), TestUtils.json("_id:  7, a: [3, 2]"), TestUtils.json("_id:  8, a: [2, 3]"), TestUtils.json("_id: 10, a: [3, 2]"), TestUtils.json("_id:  9, a: [3]"), TestUtils.json("_id: 14, a: 'xyz'"), TestUtils.json("_id: 15, a: {b: 5}")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("")).sort((Bson)TestUtils.json("a: -1, _id: -1")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 15, a: {b: 5}"), TestUtils.json("_id: 14, a: 'xyz'"), TestUtils.json("_id: 12, a: [1, 'abc', 2]"), TestUtils.json("_id: 10, a: [3, 2]"), TestUtils.json("_id:  9, a: [3]"), TestUtils.json("_id:  8, a: [2, 3]"), TestUtils.json("_id:  7, a: [3, 2]"), TestUtils.json("_id:  6, a: [1, 2, 3]"), TestUtils.json("_id: 11, a: [null, 1, 2]"), TestUtils.json("_id:  5, a: [1, 2]"), TestUtils.json("_id:  4, a: [2, 1.0]"), TestUtils.json("_id:  3, a: [2, 1]"), TestUtils.json("_id: 16, a: 1"), TestUtils.json("_id: 13"), TestUtils.json("_id:  2, a: null"), TestUtils.json("_id:  1, a: []")});
    }

    @Test
    public void testDistinctEmbeddedDocument() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id:  1, a: {b: 1, c: 0}"));
        collection.insertOne((Object)TestUtils.json("_id:  2, a: {b: null}"));
        collection.insertOne((Object)TestUtils.json("_id:  3, a: {b: 1, c: null}"));
        collection.insertOne((Object)TestUtils.json("_id:  4, a: {b: 1.0, c: 0}"));
        collection.insertOne((Object)TestUtils.json("_id:  5, a: {b: 1.0, c: 0.0}"));
        collection.insertOne((Object)TestUtils.json("_id:  6, a: {b: 1.0, c: null}"));
        collection.insertOne((Object)TestUtils.json("_id:  7, a: {b: {c: 1.0}}"));
        collection.insertOne((Object)TestUtils.json("_id:  8, a: {c: 0, b: 1.0}"));
        collection.insertOne((Object)TestUtils.json("_id:  9, a: {c: 0, b: null}"));
        collection.insertOne((Object)TestUtils.json("_id: 10, a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 11, a: {b: {c: 0.0}}"));
        collection.insertOne((Object)TestUtils.json("_id: 12"));
        collection.insertOne((Object)TestUtils.json("_id: 13, a: {c: 0}"));
        collection.insertOne((Object)TestUtils.json("_id: 14, a: {c: null}"));
        collection.insertOne((Object)TestUtils.json("_id: 15, a: null"));
        Assertions.assertThat(TestUtils.toArray(collection.distinct("a", Document.class))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("b: 1, c: 0"), TestUtils.json("b: null"), TestUtils.json("b: 1, c: null"), TestUtils.json("b: {c: 1.0}"), TestUtils.json("b: 1.0, c: 0"), TestUtils.json("b: null, c: 0"), TestUtils.json("b: 1"), TestUtils.json("b: {c: 0.0}"), TestUtils.json("c: 0"), TestUtils.json("c: null"), null});
    }

    @Test
    public void testEmptyArrayQuery() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoQueryException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.find(Filters.and((Bson[])new Bson[0])).first();
        }).withMessageContaining("must be a nonempty array");
    }

    @Test
    public void testFindAllReferences() throws Exception {
        collection.insertOne((Object)new Document("_id", (Object)1).append("ref", (Object)new DBRef("coll1", (Object)1)));
        collection.insertOne((Object)new Document("_id", (Object)2).append("ref", (Object)new DBRef("coll1", (Object)2)));
        collection.insertOne((Object)new Document("_id", (Object)3).append("ref", (Object)new DBRef("coll2", (Object)1)));
        collection.insertOne((Object)new Document("_id", (Object)4).append("ref", (Object)new DBRef("coll2", (Object)2)));
        collection.insertOne((Object)TestUtils.json("_id: 5, ref: [1, 2, 3, 4]"));
        collection.insertOne((Object)TestUtils.json("_id: 6"));
        List documents = TestUtils.toArray(collection.find((Bson)TestUtils.json("ref: {$ref: 'coll1', $id: 1}")).projection((Bson)TestUtils.json("_id: 1")));
        Assertions.assertThat(documents).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1")});
    }

    @Test
    public void testInsertAndQueryNegativeZero() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, value: -0.0"));
        collection.insertOne((Object)TestUtils.json("_id: 2, value: 0.0"));
        collection.insertOne((Object)TestUtils.json("_id: 3, value: -0.0"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("value: -0.0")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, value: -0.0"), TestUtils.json("_id: 2, value: 0.0"), TestUtils.json("_id: 3, value: -0.0")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("value: {$lt: 0.0}")))).isEmpty();
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("value: 0")).sort((Bson)TestUtils.json("value: 1, _id: 1")))).extracting(doc -> doc.getDouble((Object)"value")).containsExactly((Object[])new Double[]{-0.0, 0.0, -0.0});
    }

    @Test
    public void testUniqueIndexWithNegativeZero() throws Exception {
        collection.createIndex((Bson)TestUtils.json("value: 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1, value: -0.0"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 2, value: 0.0")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: value_1 dup key: { : 0.0 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 3, value: -0.0")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: value_1 dup key: { : -0.0 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: 4, value: 0")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: value_1 dup key: { : 0 }");
    }

    @Test
    public void testDecimal128() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: {'$numberDecimal': '1'}"));
        collection.insertOne((Object)TestUtils.json("_id: {'$numberDecimal': '2'}"));
        collection.insertOne((Object)TestUtils.json("_id: {'$numberDecimal': '3.0'}"));
        collection.insertOne((Object)TestUtils.json("_id: {'$numberDecimal': '200000000000000000000000000000000.5'}"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("_id: {'$numberDecimal': '1'}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: _id_ dup key: { : 1 }");
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("_id: {$eq: {'$numberDecimal': '3'}}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: {'$numberDecimal': '3.0'}")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("_id: {$gt: {'$numberDecimal': '100000'}}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: {'$numberDecimal': '200000000000000000000000000000000.5'}")});
    }

    @Test
    public void testArrayNe() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 'a', values: [-1]"));
        collection.insertOne((Object)TestUtils.json("_id: 'b', values: [0]"));
        collection.insertOne((Object)TestUtils.json("_id: 'c', values: 1.0"));
        collection.insertOne((Object)TestUtils.json("_id: 'd', values: {'$numberDecimal': '1.0'}"));
        collection.insertOne((Object)TestUtils.json("_id: 'e', values: {'$numberDecimal': '0.0'}"));
        collection.insertOne((Object)TestUtils.json("_id: 'f', values: [-0.0]"));
        collection.insertOne((Object)TestUtils.json("_id: 'g', values: [0, 1]"));
        collection.insertOne((Object)TestUtils.json("_id: 'h', values: 0.0"));
        collection.insertOne((Object)TestUtils.json("_id: 'i', values: []"));
        collection.insertOne((Object)TestUtils.json("_id: 'j', values: null"));
        collection.insertOne((Object)TestUtils.json("_id: 'k'"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("values: {$ne: 0}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 'a', values: [-1]"), TestUtils.json("_id: 'c', values: 1.0"), TestUtils.json("_id: 'd', values: {'$numberDecimal': '1.0'}"), TestUtils.json("_id: 'i', values: []"), TestUtils.json("_id: 'j', values: null"), TestUtils.json("_id: 'k'")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("values: {$ne: []}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 'a', values: [-1]"), TestUtils.json("_id: 'b', values: [0]"), TestUtils.json("_id: 'c', values: 1.0"), TestUtils.json("_id: 'd', values: {'$numberDecimal': '1.0'}"), TestUtils.json("_id: 'e', values: {'$numberDecimal': '0.0'}"), TestUtils.json("_id: 'f', values: [-0.0]"), TestUtils.json("_id: 'g', values: [0, 1]"), TestUtils.json("_id: 'h', values: 0.0"), TestUtils.json("_id: 'j', values: null"), TestUtils.json("_id: 'k'")});
    }

    @Test
    public void testExistsQuery() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: null"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: {b: null}"));
        collection.insertOne((Object)TestUtils.json("_id: 4"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'a.b': {$exists: false}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 2, a: null"), TestUtils.json("_id: 4")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'a.b': {$exists: true}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: {b: 1}"), TestUtils.json("_id: 3, a: {b: null}")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: {b: {$exists: true}}")))).isEmpty();
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("a: {$exists: true}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: {b: 1}"), TestUtils.json("_id: 2, a: null"), TestUtils.json("_id: 3, a: {b: null}")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("b: {$exists: true}")))).isEmpty();
    }

    @Test
    public void testExistsQueryWithArray() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: ['X', 'Y', 'Z']"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: [[1, 2], [3, 4]]"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: ['x']"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: []"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: null"));
        collection.insertOne((Object)TestUtils.json("_id: 7"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'a.1': {$exists: true}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 2, a: ['X', 'Y', 'Z']"), TestUtils.json("_id: 3, a: [[1, 2], [3, 4]]")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'a.0': {$exists: false}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: {b: 1}"), TestUtils.json("_id: 5, a: []"), TestUtils.json("_id: 6, a: null"), TestUtils.json("_id: 7")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'a.0.1': {$exists: true}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 3, a: [[1, 2], [3, 4]]")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'a.0.1': {$exists: false}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: {b: 1}"), TestUtils.json("_id: 2, a: ['X', 'Y', 'Z']"), TestUtils.json("_id: 4, a: ['x']"), TestUtils.json("_id: 5, a: []"), TestUtils.json("_id: 6, a: null"), TestUtils.json("_id: 7")});
    }

    @Test
    public void testExistsQueryWithTrailingDot() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: ['X', 'Y', 'Z']"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: [[1, 2], [3, 4]]"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: ['x']"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: []"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: null"));
        collection.insertOne((Object)TestUtils.json("_id: 7"));
        collection.insertOne((Object)TestUtils.json("_id: 8, a: {b: {c: 'd'}}"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'a.': {$exists: true}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 2, a: ['X', 'Y', 'Z']"), TestUtils.json("_id: 3, a: [[1, 2], [3, 4]]"), TestUtils.json("_id: 4, a: ['x']"), TestUtils.json("_id: 5, a: []")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'a.1.': {$exists: true}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 3, a: [[1, 2], [3, 4]]")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'.a': {$exists: true}")))).isEmpty();
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'a.b.': {$exists: true}")))).isEmpty();
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'a..': {$exists: true}")))).isEmpty();
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'a.....111': {$exists: true}")))).isEmpty();
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'a.': {$exists: false}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: {b: 1}"), TestUtils.json("_id: 6, a: null"), TestUtils.json("_id: 7"), TestUtils.json("_id: 8, a: {b: {c: 'd'}}")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'a.1.': {$exists: false}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: {b: 1}"), TestUtils.json("_id: 2, a: ['X', 'Y', 'Z']"), TestUtils.json("_id: 4, a: ['x']"), TestUtils.json("_id: 5, a: []"), TestUtils.json("_id: 6, a: null"), TestUtils.json("_id: 7"), TestUtils.json("_id: 8, a: {b: {c: 'd'}}")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("'a..': {$exists: false}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: {b: 1}"), TestUtils.json("_id: 2, a: ['X', 'Y', 'Z']"), TestUtils.json("_id: 3, a: [[1, 2], [3, 4]]"), TestUtils.json("_id: 4, a: ['x']"), TestUtils.json("_id: 5, a: []"), TestUtils.json("_id: 6, a: null"), TestUtils.json("_id: 7"), TestUtils.json("_id: 8, a: {b: {c: 'd'}}")});
    }

    @Test
    public void testRegExQuery() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 'one', name: 'karl'"));
        collection.insertOne((Object)TestUtils.json("_id: 'two', name: 'Karl'"));
        collection.insertOne((Object)TestUtils.json("_id: 'Three', name: 'KARL'"));
        collection.insertOne((Object)TestUtils.json("_id: null"));
        collection.insertOne((Object)TestUtils.json("_id: 123, name: ['karl', 'john']"));
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("_id: {$regex: '^T.+$', $options: 'i'}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 'two', name: 'Karl'"), TestUtils.json("_id: 'Three', name: 'KARL'")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("_id: {$regex: 't.+'}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 'two', name: 'Karl'")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("_id: {$regex: '^(one|1.+)$'}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 'one', name: 'karl'")});
        Assertions.assertThat(TestUtils.toArray(collection.find((Bson)TestUtils.json("name: {$regex: 'arl', $options: 'i'}")))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 'one', name: 'karl'"), TestUtils.json("_id: 'two', name: 'Karl'"), TestUtils.json("_id: 'Three', name: 'KARL'"), TestUtils.json("_id: 123, name: ['karl', 'john']")});
    }

    @Test
    public void testInsertAndFindJavaScriptContent() throws Exception {
        collection.insertOne((Object)new Document("_id", (Object)1).append("data", (Object)new BsonJavaScript("int i = 0")));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).extracting(document -> document.get("data")).isEqualTo((Object)new Code("int i = 0"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)new Document("data", (Object)new BsonJavaScript("int i = 0"))).first())).extracting(document -> document.get("_id")).isEqualTo((Object)1);
    }

    private void insertAndFindLargeDocument(int numKeyValues, int id) {
        Document document = new Document("_id", (Object)id);
        for (int i = 0; i < numKeyValues; ++i) {
            document.put("key-" + i, (Object)("value-" + i));
        }
        collection.insertOne((Object)document);
        Document persistentDocument = (Document)collection.find((Bson)new Document("_id", (Object)id)).first();
        Assertions.assertThat((Map)persistentDocument).hasSize(numKeyValues + 1);
    }

    private void insertUpdateInBulk(boolean ordered) {
        ArrayList<Object> ops = new ArrayList<Object>();
        ops.add(new InsertOneModel((Object)TestUtils.json("_id: 1, field: 'x'")));
        ops.add(new InsertOneModel((Object)TestUtils.json("_id: 2, field: 'x'")));
        ops.add(new InsertOneModel((Object)TestUtils.json("_id: 3, field: 'x'")));
        ops.add(new UpdateManyModel((Bson)TestUtils.json("field: 'x'"), Updates.set((String)"field", (Object)"y")));
        BulkWriteResult result = collection.bulkWrite(ops, new BulkWriteOptions().ordered(ordered));
        Assertions.assertThat((int)result.getInsertedCount()).isEqualTo(3);
        Assertions.assertThat((int)result.getDeletedCount()).isEqualTo(0);
        Assertions.assertThat((int)result.getModifiedCount()).isEqualTo(3);
        Assertions.assertThat((int)result.getMatchedCount()).isEqualTo(3);
        long totalDocuments = collection.countDocuments();
        Assertions.assertThat((long)totalDocuments).isEqualTo(3L);
        long documentsWithY = collection.countDocuments((Bson)TestUtils.json("field: 'y'"));
        Assertions.assertThat((long)documentsWithY).isEqualTo(3L);
    }

    private void insertUpdateInBulkNoMatch(boolean ordered) {
        collection.insertOne((Object)TestUtils.json("foo: 'bar'"));
        ArrayList<UpdateOneModel> ops = new ArrayList<UpdateOneModel>();
        ops.add(new UpdateOneModel(Filters.ne((String)"foo", (Object)OTHER_TEST_DATABASE_NAME), Updates.set((String)"field", (Object)"y")));
        BulkWriteResult result = collection.bulkWrite(ops, new BulkWriteOptions().ordered(ordered));
        Assertions.assertThat((int)result.getInsertedCount()).isEqualTo(0);
        Assertions.assertThat((int)result.getDeletedCount()).isEqualTo(0);
        Assertions.assertThat((int)result.getModifiedCount()).isEqualTo(0);
        Assertions.assertThat((int)result.getMatchedCount()).isEqualTo(0);
    }

    private void removeInBulk(boolean ordered) {
        DeleteManyModel deleteOp = new DeleteManyModel((Bson)TestUtils.json("field: 'y'"));
        BulkWriteResult result = collection.bulkWrite(Collections.singletonList(deleteOp), new BulkWriteOptions().ordered(ordered));
        Assertions.assertThat((int)result.getDeletedCount()).isEqualTo(3);
        Assertions.assertThat((long)collection.countDocuments()).isZero();
    }

    private static void assertMongoWriteException(Callable callable, int expectedErrorCode, String expectedMessage) {
        AbstractBackendTest.assertMongoWriteException(callable, expectedErrorCode, "Location" + expectedErrorCode, expectedMessage);
    }

    private static void assertMongoWriteException(Callable callable, int expectedErrorCode, String expectedCodeName, String expectedMessage) {
        try {
            callable.call();
            Assertions.fail((String)"MongoWriteException expected");
        }
        catch (MongoWriteException e) {
            Assertions.assertThat((Throwable)e).hasMessage(expectedMessage);
            Assertions.assertThat((int)e.getError().getCode()).isEqualTo(expectedErrorCode);
            Document actual = db.runCommand((Bson)TestUtils.json("getlasterror: 1"));
            Assertions.assertThat((String)actual.getString((Object)"codeName")).isEqualTo(expectedCodeName);
        }
    }

    @Test
    public void testInsertWithoutId() throws Exception {
        DocumentCodec documentCodec = (DocumentCodec)Mockito.spy((Object)new DocumentCodec());
        ((DocumentCodec)Mockito.doAnswer((Answer)AdditionalAnswers.returnsFirstArg()).when((Object)documentCodec)).generateIdIfAbsentFromDocument((Document)Mockito.any());
        MongoClientOptions mongoClientOptions = MongoClientOptions.builder().codecRegistry(CodecRegistries.fromCodecs((Codec[])new Codec[]{documentCodec})).build();
        try (MongoClient mongoClient = new MongoClient(new ServerAddress(serverAddress), mongoClientOptions);){
            MongoDatabase database = mongoClient.getDatabase(db.getName());
            MongoCollection collection = database.getCollection(this.getCollectionName());
            collection.insertOne((Object)TestUtils.json("x: 1"));
            ((ObjectAssert)Assertions.assertThat((Object)((Document)collection.find((Bson)TestUtils.json("x: 1")).first()).get((Object)"_id")).isNotNull()).isInstanceOf(ObjectId.class);
        }
        ((DocumentCodec)Mockito.verify((Object)documentCodec)).generateIdIfAbsentFromDocument((Document)Mockito.any());
    }

    @Test
    public void testMultikeyIndex_simpleArrayValues() throws Exception {
        collection.createIndex((Bson)TestUtils.json("a: 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: [2, 3]"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: [4, 5, 4]"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: [[1, 2], [3, 4]]"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: [[1, 3], [4, 5]]"));
        collection.insertOne((Object)TestUtils.json("_id: 7, a: [[2, 1], [4, 3]]"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: [1]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { : 1 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: [6, 1]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { : 1 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: [2.0, 4.0]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { : 2.0 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: [[1, 4], [3, 4]]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { : [ 3, 4 ] }");
        collection.deleteOne((Bson)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 8, a: [2, 3]"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.replaceOne((Bson)TestUtils.json("_id: 1"), (Object)TestUtils.json("_id: 1, a: [3, 4]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { : 3 }");
        collection.replaceOne((Bson)TestUtils.json("_id: 4"), (Object)TestUtils.json("_id: 4, a: ['x', 'y']"));
        collection.insertOne((Object)TestUtils.json("_id: 9, a: [4, 6]"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.updateOne((Bson)TestUtils.json("_id: 9"), (Bson)TestUtils.json("$push: {a: 2}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1 dup key: { : 2 }");
        Document result = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 8"), (Bson)TestUtils.json("$pull: {a: 2}"), new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
        Assertions.assertThat((Map)result).isEqualTo((Object)TestUtils.json("_id: 8, a: [3]"));
        result = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 9"), (Bson)TestUtils.json("$push: {a: 2}"), new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
        Assertions.assertThat((Map)result).isEqualTo((Object)TestUtils.json("_id: 9, a: [4, 6, 2]"));
        result = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 9"), (Bson)TestUtils.json("$push: {a: 2}"), new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
        Assertions.assertThat((Map)result).isEqualTo((Object)TestUtils.json("_id: 9, a: [4, 6, 2, 2]"));
    }

    @Test
    public void testCompoundMultikeyIndex_simpleArrayValues() throws Exception {
        collection.createIndex((Bson)TestUtils.json("a: 1, b: 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: [2, 3], b: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: [4, 5], b: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: [1, 2, 3, 4, 5], b: 2"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: [1]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1_b_1 dup key: { : 1, : null }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: [6, 2], b: 1")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1_b_1 dup key: { : 2, : 1 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: ['abc'], b: [1, 2, 3]")), 171, "CannotIndexParallelArrays", "cannot index parallel arrays [b] [a]");
        collection.deleteOne((Bson)TestUtils.json("_id: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: [2, 3], b: 1"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.replaceOne((Bson)TestUtils.json("_id: 1"), (Object)TestUtils.json("_id: 1, a: [3, 4], b: 1")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a_1_b_1 dup key: { : 3, : 1 }");
        collection.replaceOne((Bson)TestUtils.json("_id: 4"), (Object)TestUtils.json("_id: 4, a: ['x', 'y'], b: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 7, a: [4, 6], b: 1"));
    }

    @Test
    public void testCompoundMultikeyIndex_threeKeys() throws Exception {
        collection.createIndex((Bson)TestUtils.json("b: 1, a: 1, c: 1"), new IndexOptions().unique(true));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("b: [1, 2, 3], a: ['abc'], c: ['x', 'y']")), 171, "CannotIndexParallelArrays", "cannot index parallel arrays [a] [b]");
    }

    @Test
    public void testCompoundMultikeyIndex_documents() throws Exception {
        collection.createIndex((Bson)TestUtils.json("item: 1, 'stock.size': 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'abc', stock: [{size: 'S', color: 'red'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: 'abc', stock: [{size: 'L', color: 'black'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: 'abc', stock: [{size: 'M'}, {size: 'XL'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 6, item: 'xyz', stock: [{size: 'S'}, {size: 'M'}]"));
        collection.insertOne((Object)TestUtils.json("_id: 7, item: 'xyz', stock: [1, 2, 3]"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("item: 'abc'")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: item_1_stock.size_1 dup key: { : \"abc\", : null }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("item: 'abc', stock: [{color: 'black'}]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: item_1_stock.size_1 dup key: { : \"abc\", : null }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("item: 'abc', stock: [{size: 'S'}]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: item_1_stock.size_1 dup key: { : \"abc\", : \"S\" }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("item: 'abc', stock: [{size: 'XL'}]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: item_1_stock.size_1 dup key: { : \"abc\", : \"XL\" }");
    }

    @Test
    public void testCompoundMultikeyIndex_deepDocuments() throws Exception {
        collection.createIndex((Bson)TestUtils.json("'a.b.c': 1"), new IndexOptions().unique(true));
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: {b: {c: 1}}"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: {b: {c: 2}}"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: [{b: {c: 3}}, {b: {c: 4}}]"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: [{b: [{c: 5}, {c: 6}]}, {b: [{c: 7}, {c: 8}]}]"));
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: 1}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b.c_1 dup key: { : null }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: [{b: 1}, {b: 2}]")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b.c_1 dup key: { : null }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: {c: 1}}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b.c_1 dup key: { : 1 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: {c: [1, 2]}}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b.c_1 dup key: { : 1 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: {c: 4}}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b.c_1 dup key: { : 4 }");
        AbstractBackendTest.assertMongoWriteException(() -> collection.insertOne((Object)TestUtils.json("a: {b: {c: 8}}")), 11000, "DuplicateKey", "E11000 duplicate key error collection: testdb.testcoll index: a.b.c_1 dup key: { : 8 }");
    }

    @Test
    public void testUpdateArrayWithPositionalAll() {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: [95, 102, 90, 150]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {'grades.$[]': -10}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, grades: [85, 92, 80, 140]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.$[]': 'abc'}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, grades: ['abc', 'abc', 'abc', 'abc']"));
    }

    @Test
    public void testUpdateArrayWithPositionalAll_NullValue() {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: [1, 2, null, 3]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.$[]': 'abc'}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, grades: ['abc', 'abc', 'abc', 'abc']"));
    }

    @Test
    public void testUpdateArrayWithPositionalAllAndArrayFilter() {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: [{x: [1, 2, 3]}, {x: [3, 4, 5]}, {x: [1, 2, 3]}]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {'grades.$[].x.$[element]': 1}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("element: {$gte: 3}"))));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, grades: [{x: [1, 2, 4]}, {x: [4, 5, 6]}, {x: [1, 2, 4]}]"));
    }

    @Test
    public void testUpdateArrayOfDocumentsWithPositionalAll() {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: [{value: 20}, {value: 30}, {value: 40}]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {'grades.$[].value': 10}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, grades: [{value: 30}, {value: 40}, {value: 50}]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.$[].value': 10}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, grades: [{value: 10}, {value: 10}, {value: 10}]"));
    }

    @Test
    public void testIllegalUpdateWithPositionalAll() {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: {b: [1, 2, 3]}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: {b: 5}"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'a.$[]': 'abc'}"));
        }).withMessageContaining("Command failed with error 2 (BadValue): 'Cannot apply array updates to non-array element a: { b: [ 1, 2, 3 ] }");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 2"), (Bson)TestUtils.json("$set: {'a.b.$[]': 'abc'}"));
        }).withMessageContaining("Command failed with error 2 (BadValue): 'Cannot apply array updates to non-array element b: 5");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'a.b.$[].c': 'abc'}"));
        }).withMessageContaining("Command failed with error 28 (PathNotViable): 'Cannot create field 'c' in element {0: 1}");
    }

    @Test
    public void testUpsertWithPositionalAll() throws Exception {
        Document result = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1, a: [5, 8]"), (Bson)TestUtils.json("$set: {'a.$[]': 1}"), new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.AFTER));
        Assertions.assertThat((Map)result).isEqualTo((Object)TestUtils.json("_id: 1, a: [1, 1]"));
    }

    @Test
    public void testUpdateWithMultipleArrayFiltersInOnePath() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: [{value: 10, x: [1, 2]}, {value: 20, x: [3, 4]}]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.$[element].x.$[]': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("'element.value': {$gt: 10}"))));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, grades: [{value: 10, x: [1, 2]}, {value: 20, x: ['abc', 'abc']}]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.0.x.$[element]': 'abc'}"), new FindOneAndUpdateOptions().arrayFilters(Arrays.asList(TestUtils.json("'element': {$gt: 1}"))));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, grades: [{value: 10, x: [1, 'abc']}, {value: 20, x: ['abc', 'abc']}]"));
    }

    @Test
    public void testUpdateArrayWithMultiplePositionalAll() {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: [[1, 2], [3, 4]]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, grades: [{c: [1, 2]}, {c: [3, 4]}]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, grades: [{c: [1, 2]}, {c: [3, 4]}, {d: [5, 6]}]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {'grades.$[].$[]': 1}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, grades: [[2, 3], [4, 5]]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 2"), (Bson)TestUtils.json("$inc: {'grades.$[].c.$[]': 1}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 2")).first())).isEqualTo((Object)TestUtils.json("_id: 2, grades: [{c: [2, 3]}, {c: [4, 5]}]"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 3"), (Bson)TestUtils.json("$inc: {'grades.$[].c.$[]': 1}"));
        }).withMessageContaining("Command failed with error 2 (BadValue): 'The path 'grades.2.c' must exist in the document in order to apply array updates.");
    }

    @Test
    public void testUpdateArrayWithMultiplePositionalAll_Simple() {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: [[1, 2], [3, 4]]"));
        collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$set: {'grades.$[].$[]': 1}"));
        Assertions.assertThat((Map)((Map)collection.find((Bson)TestUtils.json("_id: 1")).first())).isEqualTo((Object)TestUtils.json("_id: 1, grades: [[1, 1], [1, 1]]"));
    }

    @Test
    public void testUpdateArrayWithIllegalMultiplePositionalAll() {
        collection.insertOne((Object)TestUtils.json("_id: 1, grades: [[[1, 2], [3, 4]], [[4, 5], [2, 3]]]"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.findOneAndUpdate((Bson)TestUtils.json("_id: 1"), (Bson)TestUtils.json("$inc: {'grades.$[].$[]': 1}"));
        }).withMessageContaining("Command failed with error 14 (TypeMismatch): 'Cannot apply $inc to a value of non-numeric type. {_id: 1} has the field '0' of non-numeric type array");
    }

    @FunctionalInterface
    private static interface Callable {
        public void call();
    }
}

