/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import com.mongodb.client.MongoDatabase;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.Document;
import org.bson.conversions.Bson;

public class TestUtils {
    private TestUtils() {
    }

    public static <T> List<T> toArray(Iterable<T> iterable) {
        ArrayList<T> array = new ArrayList<T>();
        for (T obj : iterable) {
            array.add(obj);
        }
        return array;
    }

    public static Document json(String string) {
        if (!(string = string.trim()).startsWith("{")) {
            string = "{" + string + "}";
        }
        return Document.parse((String)string);
    }

    static List<Document> jsonList(String ... json) {
        return Stream.of(json).map(TestUtils::json).collect(Collectors.toList());
    }

    public static Document getCollectionStatistics(MongoDatabase database, String collectionName) {
        Document collStats = new Document("collStats", (Object)collectionName);
        return database.runCommand((Bson)collStats);
    }

    static Date date(String instant) {
        return Date.from(Instant.parse(instant));
    }
}

