/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import com.mongodb.MongoCommandException;
import com.mongodb.client.MongoCollection;
import de.bwaldvogel.mongo.backend.AbstractTest;
import de.bwaldvogel.mongo.backend.TestUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.junit.Test;

public abstract class AbstractAggregationTest
extends AbstractTest {
    @Test
    public void testUnrecognizedAggregatePipelineStage() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$unknown: {}");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(pipeline).first();
        }).withMessageContaining("Command failed with error 40324 (Location40324): 'Unrecognized pipeline stage name: '$unknown'");
    }

    @Test
    public void testIllegalAggregatePipelineStage() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$unknown: {}, bar: 1");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(pipeline).first();
        }).withMessageContaining("Command failed with error 40323 (Location40323): 'A pipeline stage specification object must contain exactly one field.'");
    }

    @Test
    public void testAggregateWithMissingCursor() throws Exception {
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> db.runCommand((Bson)TestUtils.json("aggregate: 'collection', pipeline: [{$match: {}}]"))).withMessageContaining("Command failed with error 9 (FailedToParse): 'The 'cursor' option is required, except for aggregate with the explain argument'");
    }

    @Test
    public void testAggregateWithComplexGroupBySumPipeline() throws Exception {
        Document query = TestUtils.json("_id: null, n: {$sum: 1}, sumOfA: {$sum: '$a'}, sumOfB: {$sum: '$b.value'}");
        List<Document> pipeline = Collections.singletonList(new Document("$group", (Object)query));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 30, b: {value: 20}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 15, b: {value: 10.5}"));
        collection.insertOne((Object)TestUtils.json("_id: 3, b: {value: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: {value: 5}"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, n: 4, sumOfA: 45, sumOfB: 31.5")});
    }

    @Test
    public void testAggregateWithGroupByMinAndMax() throws Exception {
        Document query = TestUtils.json("_id: null, minA: {$min: '$a'}, maxB: {$max: '$b.value'}, maxC: {$max: '$c'}, minC: {$min: '$c'}");
        List<Document> pipeline = Collections.singletonList(new Document("$group", (Object)query));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 30, b: {value: 20}, c: 1.0"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 15, b: {value: 10}, c: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3, c: 'zzz'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, c: 'aaa'"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, minA: 15, maxB: 20, minC: 1.0, maxC: 'zzz'")});
    }

    @Test
    public void testAggregateWithGroupByMinAndMaxOnArrayField() throws Exception {
        Document query = TestUtils.json("_id: null, min: {$min: '$v'}, max: {$max: '$v'}");
        List<Document> pipeline = Collections.singletonList(new Document("$group", (Object)query));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, v: [10, 20, 30]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, v: [3, 40]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, v: [11, 25]"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, max: [11, 25], min: [3, 40]")});
    }

    @Test
    public void testAggregateWithGroupByMinAndMaxOnArrayFieldAndNonArrayFields() throws Exception {
        Document query = TestUtils.json("_id: null, min: {$min: '$v'}, max: {$max: '$v'}");
        List<Document> pipeline = Collections.singletonList(new Document("$group", (Object)query));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, v: [10, 20, 30]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, v: [3, 40]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, v: [11, 25]"));
        collection.insertOne((Object)TestUtils.json("_id: 4, v: 50"));
        collection.insertOne((Object)TestUtils.json("_id: 5, v: null"));
        collection.insertOne((Object)TestUtils.json("_id: 6"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, max: [11, 25], min: 50")});
    }

    @Test
    public void testAggregateWithGroupByNonExistingMinAndMax() throws Exception {
        Document query = TestUtils.json("_id: null, minOfA: {$min: '$doesNotExist'}, maxOfB: {$max: '$doesNotExist'}");
        List<Document> pipeline = Collections.singletonList(new Document("$group", (Object)query));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 30, b: {value: 20}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 15, b: {value: 10}"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, minOfA: null, maxOfB: null")});
    }

    @Test
    public void testAggregateWithUnknownGroupOperator() throws Exception {
        Document query = TestUtils.json("_id: null, n: {$foo: 1}");
        List<Document> pipeline = Collections.singletonList(new Document("$group", (Object)query));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(pipeline).first();
        }).withMessageContaining("Command failed with error 15952 (Location15952): 'unknown group operator '$foo''");
    }

    @Test
    public void testAggregateWithTooManyGroupOperators() throws Exception {
        Document query = TestUtils.json("_id: null, n: {$sum: 1, $max: 1}");
        List<Document> pipeline = Collections.singletonList(new Document("$group", (Object)query));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(pipeline).first();
        }).withMessageContaining("Command failed with error 40238 (Location40238): 'The field 'n' must specify one accumulator'");
    }

    @Test
    public void testAggregateWithEmptyPipeline() throws Exception {
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(Collections.emptyList()))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(Collections.emptyList()))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: 2")});
    }

    @Test
    public void testAggregateWithMissingIdInGroupSpecification() throws Exception {
        List<Document> pipeline = Collections.singletonList(new Document("$group", (Object)TestUtils.json("n: {$sum: 1}")));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> TestUtils.toArray(collection.aggregate(pipeline))).withMessageContaining("Command failed with error 15955 (Location15955): 'a group specification must include an _id'");
    }

    @Test
    public void testAggregateWithGroupBySumPipeline() throws Exception {
        Document query = TestUtils.json("_id: null, n: {$sum: 1}");
        List<Document> pipeline = Collections.singletonList(new Document("$group", (Object)query));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, n: 2")});
        query.putAll((Map)TestUtils.json("n: {$sum: 'abc'}"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, n: 0")});
        query.putAll((Map)TestUtils.json("n: {$sum: 2}"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, n: 4")});
        query.putAll((Map)TestUtils.json("n: {$sum: 1.75}"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, n: 3.5")});
        query.putAll((Map)new Document("n", (Object)new Document("$sum", (Object)10000000000L)));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, n: 20000000000")});
        query.putAll((Map)new Document("n", (Object)new Document("$sum", (Object)Float.valueOf(-2.5f))));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, n: -5.0")});
    }

    @Test
    public void testAggregateWithGroupByAvg() throws Exception {
        Document query = TestUtils.json("_id: null, avg: {$avg: 1}");
        List<Document> pipeline = Collections.singletonList(new Document("$group", (Object)query));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 6.0, b: 'zzz'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 3.0, b: 'aaa'"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, avg: 1.0")});
        query.putAll((Map)TestUtils.json("avg: {$avg: '$a'}, avgB: {$avg: '$b'}"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, avg: 4.5, avgB: null")});
    }

    @Test
    public void testAggregateWithGroupByKey() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$group: {_id: '$a', count: {$sum: 1}, avg: {$avg: '$b'}}");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: 2, b: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: 2, b: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: 5, b: 10"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: 7, c: 'a'"));
        collection.insertOne((Object)TestUtils.json("_id: 7"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, count: 2, avg: null"), TestUtils.json("_id: 2, count: 2, avg: 3.5"), TestUtils.json("_id: 5, count: 1, avg: 10.0"), TestUtils.json("_id: 7, count: 1, avg: null"), TestUtils.json("_id: null, count: 1, avg: null")});
    }

    @Test
    public void testAggregateWithGroupByNumberEdgeCases() throws Exception {
        String groupBy = "$group: {_id: '$a', count: {$sum: 1}, avg: {$avg: '$a'}, min: {$min: '$a'}, max: {$max: '$a'}}";
        List<Document> pipeline = TestUtils.jsonList(groupBy);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1.0"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: -0.0"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: 0.0"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: 0"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: 1.5"));
        collection.insertOne((Object)TestUtils.json("_id: 7, a: null"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: -0.0, count: 3, avg: 0.0, min: -0.0, max: -0.0"), TestUtils.json("_id: 1.0, count: 2, avg: 1.0, min: 1.0, max: 1.0"), TestUtils.json("_id: 1.5, count: 1, avg: 1.5, min: 1.5, max: 1.5"), TestUtils.json("_id: null, count: 1, avg: null, min: null, max: null")});
    }

    @Test
    public void testAggregateWithGroupByDocuments() throws Exception {
        String groupBy = "$group: {_id: '$a', count: {$sum: 1}}";
        String sort = "$sort: {_id: 1}";
        List<Document> pipeline = Arrays.asList(TestUtils.json(groupBy), TestUtils.json(sort));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id:  1, a: 1.0"));
        collection.insertOne((Object)TestUtils.json("_id:  2, a: {b: 1}"));
        collection.insertOne((Object)TestUtils.json("_id:  3, a: {b: 1.0}"));
        collection.insertOne((Object)TestUtils.json("_id:  4, a: {b: 1, c: 1}"));
        collection.insertOne((Object)TestUtils.json("_id:  5, a: {b: {c: 1}}"));
        collection.insertOne((Object)TestUtils.json("_id:  6, a: {b: {c: 1.0}}"));
        collection.insertOne((Object)TestUtils.json("_id:  7, a: {b: {c: 1.0, d: 1}}"));
        collection.insertOne((Object)TestUtils.json("_id:  8, a: {b: {d: 1, c: 1.0}}"));
        collection.insertOne((Object)TestUtils.json("_id:  9, a: {c: 1, b: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 10, a: null"));
        collection.insertOne((Object)TestUtils.json("_id: 11, a: {b: 1, c: 1}"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, count: 1"), TestUtils.json("_id: 1.0, count: 1"), TestUtils.json("_id: {b: 1}, count: 2"), TestUtils.json("_id: {b: 1, c: 1}, count: 2"), TestUtils.json("_id: {c: 1, b: 1}, count: 1"), TestUtils.json("_id: {b: {c: 1}}, count: 2"), TestUtils.json("_id: {b: {c: 1.0, d: 1}}, count: 1"), TestUtils.json("_id: {b: {d: 1, c: 1.0}}, count: 1")});
    }

    @Test
    public void testAggregateWithGroupByIllegalKey() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id:  1, a: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(TestUtils.jsonList("$group: {_id: '$a.'}")).first();
        }).withMessageContaining("Command failed with error 40353 (Location40353): 'FieldPath must not end with a '.'.'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(TestUtils.jsonList("$group: {_id: '$a..1'}")).first();
        }).withMessageContaining("Command failed with error 15998 (Location15998): 'FieldPath field names may not be empty strings.'");
    }

    @Test
    public void testAggregateWithSimpleExpressions() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$group: {_id: {$abs: '$value'}, count: {$sum: 1}}");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, value: 1"));
        collection.insertOne((Object)TestUtils.json("_id: -2, value: -1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, value: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 4, value: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 5, value: -2.5"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, count: 2"), TestUtils.json("_id: 2, count: 2"), TestUtils.json("_id: 2.5, count: 1")});
    }

    @Test
    public void testAggregateWithMultipleExpressionsInKey() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$group: {_id: {abs: {$abs: '$value'}, sum: {$subtract: ['$end', '$start']}}, count: {$sum: 1}}");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, value: NaN"));
        collection.insertOne((Object)TestUtils.json("_id: 2, value: 1, start: 5, end: 8"));
        collection.insertOne((Object)TestUtils.json("_id: 3, value: -1, start: 4, end: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 4, value: 2, start: 9, end: 7"));
        collection.insertOne((Object)TestUtils.json("_id: 5, value: 2, start: 6, end: 7"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: {abs: NaN, sum: null}, count: 1"), TestUtils.json("_id: {abs: 1, sum: 3}, count: 1"), TestUtils.json("_id: {abs: 1, sum: 0}, count: 1"), TestUtils.json("_id: {abs: 2, sum: -2}, count: 1"), TestUtils.json("_id: {abs: 2, sum: 1}, count: 1")});
    }

    @Test
    public void testAggregateWithAddToSet() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$group: {_id: { day: { $dayOfYear: '$date'}, year: { $year: '$date' } }, itemsSold: { $addToSet: '$item' }}");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, item: 'zzz', price:  5, quantity: 10").append("date", (Object)TestUtils.date("2014-02-15T09:12:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'abc', price: 10, quantity:  2").append("date", (Object)TestUtils.date("2014-01-01T08:00:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'jkl', price: 20, quantity:  1").append("date", (Object)TestUtils.date("2014-02-03T09:00:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: 'xyz', price:  5, quantity:  5").append("date", (Object)TestUtils.date("2014-02-03T09:05:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: 'abc', price: 10, quantity: 10").append("date", (Object)TestUtils.date("2014-02-15T08:00:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 6, item: 'xyz', price:  5, quantity: 10").append("date", (Object)TestUtils.date("2014-02-15T09:12:00Z")));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: { day:  1, year: 2014 }, itemsSold: [ 'abc' ]"), TestUtils.json("_id: { day: 34, year: 2014 }, itemsSold: [ 'xyz', 'jkl' ]"), TestUtils.json("_id: { day: 46, year: 2014 }, itemsSold: [ 'xyz', 'abc', 'zzz' ]")});
    }

    @Test
    public void testAggregateWithEmptyAddToSet() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$group: {_id: 1, set: { $addToSet: '$foo' }}");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, set: [ ]")});
    }

    @Test
    public void testAggregateWithAdd() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$project: { item: 1, total: { $add: [ '$price', '$fee' ] } }");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, item: 'abc', price: 10, fee: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'jkl', price: 20, fee: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'xyz', price: 5, fee: 0"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, item: 'abc', total: 12"), TestUtils.json("_id: 2, item: 'jkl', total: 21"), TestUtils.json("_id: 3, item: 'xyz', total: 5 ")});
    }

    @Test
    public void testAggregateWithSort() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$sort: { price: -1, fee: 1 }");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, price: 10, fee: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, price: 20, fee: 0"));
        collection.insertOne((Object)TestUtils.json("_id: 3, price: 10, fee: 0"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 2, price: 20, fee: 0"), TestUtils.json("_id: 3, price: 10, fee: 0"), TestUtils.json("_id: 1, price: 10, fee: 1")});
    }

    @Test
    public void testAggregateWithProjection() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$project: {_id: 1, value: '$x', n: '$foo.bar', other: null}");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, x: 10, foo: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, x: 20"));
        collection.insertOne((Object)TestUtils.json("_id: 3, x: 30, foo: {bar: 7.3}"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, value: 10, other: null"), TestUtils.json("_id: 2, value: 20, other: null"), TestUtils.json("_id: 3, value: 30, n: 7.3, other: null")});
    }

    @Test
    public void testAggregateWithProjection_IllegalFieldPath() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, x: 10"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(TestUtils.jsonList("$project: {_id: 0, v: '$x.1.'}")).first();
        }).withMessageContaining("Command failed with error 40353 (Location40353): 'FieldPath must not end with a '.'.'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(TestUtils.jsonList("$project: {_id: 0, v: '$x..1'}")).first();
        }).withMessageContaining("Command failed with error 15998 (Location15998): 'FieldPath field names may not be empty strings.'");
    }

    @Test
    public void testAggregateWithExpressionProjection() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$project: {_id: 0, idHex: {$toString: '$_id'}}");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)new Document("_id", (Object)new ObjectId("abcd01234567890123456789")));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("idHex: 'abcd01234567890123456789'")});
    }

    @Test
    public void testAggregateWithAddFields() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$addFields: {value: '$x'}");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, x: 10"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3, value: 123"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, x: 10, value: 10"), TestUtils.json("_id: 2"), TestUtils.json("_id: 3")});
    }

    @Test
    public void testAggregateWithMultipleMatches() throws Exception {
        Document match1 = TestUtils.json("$match: {price: {$lt: 100}}");
        Document match2 = TestUtils.json("$match: {quality: {$gt: 10}}");
        List<Document> pipeline = Arrays.asList(match1, match2);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, price: 10, quality: 50"));
        collection.insertOne((Object)TestUtils.json("_id: 2, price: 150, quality: 500"));
        collection.insertOne((Object)TestUtils.json("_id: 3, price: 50, quality: 150"));
        collection.insertOne((Object)TestUtils.json("_id: 4, price: 10, quality: 5"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, price: 10, quality: 50"), TestUtils.json("_id: 3, price: 50, quality: 150")});
    }

    @Test
    public void testAggregateWithCeil() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$project: {a: 1, ceil: {$ceil: '$a'}}");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 9.25"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 8.73"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: 4.32"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: -5.34"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: 9.25, ceil: 10.0"), TestUtils.json("_id: 2, a: 8.73, ceil: 9.0"), TestUtils.json("_id: 3, a: 4.32, ceil: 5.0"), TestUtils.json("_id: 4, a: -5.34, ceil: -5.0")});
    }

    @Test
    public void testAggregateWithNumericOperators() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$project: {a: 1, exp: {$exp: '$a'}, ln: {$ln: '$a'}, log10: {$log10: '$a'}, sqrt: {$sqrt: '$a'}}");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, a: 1, exp: 2.718281828459045, ln: 0.0, log10: 0.0, sqrt: 1.0")});
    }

    @Test
    public void testAggregateWithCount() throws Exception {
        Document match = TestUtils.json("$match: {score: {$gt: 80}}");
        Document count = TestUtils.json("$count: 'passing_scores'");
        List<Document> pipeline = Arrays.asList(match, count);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, subject: 'History', score: 88"));
        collection.insertOne((Object)TestUtils.json("_id: 2, subject: 'History', score: 92"));
        collection.insertOne((Object)TestUtils.json("_id: 3, subject: 'History', score: 97"));
        collection.insertOne((Object)TestUtils.json("_id: 4, subject: 'History', score: 71"));
        collection.insertOne((Object)TestUtils.json("_id: 5, subject: 'History', score: 79"));
        collection.insertOne((Object)TestUtils.json("_id: 6, subject: 'History', score: 83"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("passing_scores: 4")});
    }

    @Test
    public void testAggregateWithFirstAndLast() throws Exception {
        Document sort = TestUtils.json("$sort: { item: 1, date: 1 }");
        Document group = TestUtils.json("$group: {_id: '$item', firstSale: { $first: '$date' }, lastSale: { $last: '$date'} }");
        List<Document> pipeline = Arrays.asList(sort, group);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, item: 'abc', price: 10, quantity:  2").append("date", (Object)TestUtils.date("2014-01-01T08:00:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'jkl', price: 20, quantity:  1").append("date", (Object)TestUtils.date("2014-02-03T09:00:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'xyz', price:  5, quantity:  5").append("date", (Object)TestUtils.date("2014-02-03T09:05:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: 'abc', price: 10, quantity: 10").append("date", (Object)TestUtils.date("2014-02-15T08:00:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: 'xyz', price:  5, quantity: 10").append("date", (Object)TestUtils.date("2014-02-15T09:12:00Z")));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 'abc'").append("firstSale", (Object)TestUtils.date("2014-01-01T08:00:00Z")).append("lastSale", (Object)TestUtils.date("2014-02-15T08:00:00Z")), TestUtils.json("_id: 'jkl'").append("firstSale", (Object)TestUtils.date("2014-02-03T09:00:00Z")).append("lastSale", (Object)TestUtils.date("2014-02-03T09:00:00Z")), TestUtils.json("_id: 'xyz'").append("firstSale", (Object)TestUtils.date("2014-02-03T09:05:00Z")).append("lastSale", (Object)TestUtils.date("2014-02-15T09:12:00Z"))});
    }

    @Test
    public void testAggregateWithPush() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$group: {_id: null, a: {$push: '$a'}, b: {$push: {v: '$b'}}, c: {$push: '$c'}}");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 10, b: 0.1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 20, b: 0.2"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, a: [10, 20], b: [{v: 0.1}, {v: 0.2}], c: []")});
    }

    @Test
    public void testAggregateWithUndefinedVariable() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$project: {result: '$$UNDEFINED'}");
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(pipeline).first();
        }).withMessageContaining("Command failed with error 17276 (Location17276): 'Use of undefined variable: UNDEFINED'");
    }

    @Test
    public void testAggregateWithRootVariable() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$project: {_id: 0, doc: '$$ROOT', a: '$$ROOT.a', a_v: '$$ROOT.a.v'}");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: {v: 10}"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("doc: {_id: 1, a: {v: 10}}, a: {v: 10}, a_v: 10")});
    }

    @Test
    public void testAggregateWithRootVariable_IllegalFieldPath() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, x: 10"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(TestUtils.jsonList("$project: {_id: '$$ROOT.a.'}")).first();
        }).withMessageContaining("Command failed with error 40353 (Location40353): 'FieldPath must not end with a '.'.'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(TestUtils.jsonList("$project: {_id: '$$ROOT.a..1'}")).first();
        }).withMessageContaining("Command failed with error 15998 (Location15998): 'FieldPath field names may not be empty strings.'");
    }

    @Test
    public void testAggregateWithSetOperations() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$project: {union: {$setUnion: ['$a', '$b']}, diff: {$setDifference: ['$a', '$b']}, intersection: {$setIntersection: ['$a', '$b']}}");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: [3, 2, 1]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: [1.0, -0.0], b: [3, 2, 0]"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: [{a: 0}, {a: 1}], b: [{a: 0.0}, {a: 0.5}]"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, diff: null, intersection: null, union: null"), TestUtils.json("_id: 2, diff: [1.0], intersection: [-0.0], union: [-0.0, 1.0, 2, 3]"), TestUtils.json("_id: 3, diff: [{a: 1}], intersection: [{a: 0}], union: [{a: 0}, {a: 0.5}, {a: 1}]")});
    }

    @Test
    public void testAggregateWithComparisonOperations() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, v: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, v: null"));
        collection.insertOne((Object)TestUtils.json("_id: 3, v: 10"));
        collection.insertOne((Object)TestUtils.json("_id: 4, v: [10, 20, 30]"));
        collection.insertOne((Object)TestUtils.json("_id: 5, v: ['abc']"));
        collection.insertOne((Object)TestUtils.json("_id: 6, v: [30, 40]"));
        collection.insertOne((Object)TestUtils.json("_id: 7, v: [5]"));
        List<Document> pipeline = TestUtils.jsonList("$project: {cmp1: {$cmp: ['$v', 10]}, cmp2: {$cmp: ['$v', [10]]}}");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, cmp1:  1, cmp2: -1"), TestUtils.json("_id: 2, cmp1: -1, cmp2: -1"), TestUtils.json("_id: 3, cmp1:  0, cmp2: -1"), TestUtils.json("_id: 4, cmp1:  1, cmp2:  1"), TestUtils.json("_id: 5, cmp1:  1, cmp2:  1"), TestUtils.json("_id: 6, cmp1:  1, cmp2:  1"), TestUtils.json("_id: 7, cmp1:  1, cmp2: -1")});
        Document project = TestUtils.json("$project: {gt1: {$gt: ['$v', 10]}, gt2: {$gt: ['$v', [10]]}}");
        pipeline = Collections.singletonList(project);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, gt1: true, gt2: false"), TestUtils.json("_id: 2, gt1: false, gt2: false"), TestUtils.json("_id: 3, gt1: false, gt2: false"), TestUtils.json("_id: 4, gt1: true, gt2: true"), TestUtils.json("_id: 5, gt1: true, gt2: true"), TestUtils.json("_id: 6, gt1: true, gt2: true"), TestUtils.json("_id: 7, gt1: true, gt2: false")});
        project = TestUtils.json("$project: {lt1: {$lt: ['$v', 10]}, lt2: {$lt: ['$v', [10]]}}");
        pipeline = Collections.singletonList(project);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, lt1: false, lt2: true"), TestUtils.json("_id: 2, lt1: true, lt2: true"), TestUtils.json("_id: 3, lt1: false, lt2: true"), TestUtils.json("_id: 4, lt1: false, lt2: false"), TestUtils.json("_id: 5, lt1: false, lt2: false"), TestUtils.json("_id: 6, lt1: false, lt2: false"), TestUtils.json("_id: 7, lt1: false, lt2: true")});
    }

    @Test
    public void testAggregateWithSlice() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$project: {name: 1, threeFavorites: {$slice: ['$favorites', 3]}}");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, name: 'dave123', favorites: ['chocolate', 'cake', 'butter', 'apples']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, name: 'li', favorites: ['apples', 'pudding', 'pie']"));
        collection.insertOne((Object)TestUtils.json("_id: 3, name: 'ahn', favorites: ['pears', 'pecans', 'chocolate', 'cherries']"));
        collection.insertOne((Object)TestUtils.json("_id: 4, name: 'ty', favorites: ['ice cream']"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, name: 'dave123', threeFavorites: ['chocolate', 'cake', 'butter']"), TestUtils.json("_id: 2, name: 'li', threeFavorites: ['apples', 'pudding', 'pie']"), TestUtils.json("_id: 3, name: 'ahn', threeFavorites: ['pears', 'pecans', 'chocolate']"), TestUtils.json("_id: 4, name: 'ty', threeFavorites: ['ice cream']")});
    }

    @Test
    public void testAggregateWithSplit() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$project: {_id: 1, names: {$split: ['$name', ' ']}}");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, name: 'first document'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, name: 'second document'"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, names: ['first', 'document']"), TestUtils.json("_id: 2, names: ['second', 'document']")});
    }

    @Test
    public void testAggregateWithUnwind() throws Exception {
        this.testAggregateWithUnwind(TestUtils.json("$unwind: '$sizes'"));
    }

    @Test
    public void testAggregateWithUnwind_Path() throws Exception {
        this.testAggregateWithUnwind(TestUtils.json("$unwind: {path: '$sizes'}"));
    }

    private void testAggregateWithUnwind(Document unwind) throws Exception {
        List<Document> pipeline = Collections.singletonList(unwind);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, item: 'ABC', sizes: ['S', 'M', 'L']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'EFG', sizes: []"));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'IJK', sizes: 'M'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: 'LMN'"));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: 'XYZ', sizes: null"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, item: 'ABC', sizes: 'S'"), TestUtils.json("_id: 1, item: 'ABC', sizes: 'M'"), TestUtils.json("_id: 1, item: 'ABC', sizes: 'L'"), TestUtils.json("_id: 3, item: 'IJK', sizes: 'M'")});
    }

    @Test
    public void testAggregateWithUnwind_preserveNullAndEmptyArrays() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$unwind: {path: '$sizes', preserveNullAndEmptyArrays: true}");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, item: 'ABC', sizes: ['S', 'M', 'L']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'EFG', sizes: []"));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'IJK', sizes: 'M'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: 'LMN'"));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: 'XYZ', sizes: null"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, item: 'ABC', sizes: 'S'"), TestUtils.json("_id: 1, item: 'ABC', sizes: 'M'"), TestUtils.json("_id: 1, item: 'ABC', sizes: 'L'"), TestUtils.json("_id: 2, item: 'EFG'"), TestUtils.json("_id: 3, item: 'IJK', sizes: 'M'"), TestUtils.json("_id: 4, item: 'LMN'"), TestUtils.json("_id: 5, item: 'XYZ', sizes: null")});
    }

    @Test
    public void testAggregateWithUnwind_IncludeArrayIndex() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$unwind: {path: '$sizes', includeArrayIndex: 'idx'}");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, item: 'ABC', sizes: ['S', 'M', 'L']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'EFG', sizes: []"));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'IJK', sizes: 'M'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: 'LMN'"));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: 'XYZ', sizes: null"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, item: 'ABC', sizes: 'S'").append("idx", (Object)0L), TestUtils.json("_id: 1, item: 'ABC', sizes: 'M'").append("idx", (Object)1L), TestUtils.json("_id: 1, item: 'ABC', sizes: 'L'").append("idx", (Object)2L), TestUtils.json("_id: 3, item: 'IJK', sizes: 'M'").append("idx", null)});
    }

    @Test
    public void testAggregateWithUnwind_IncludeArrayIndex_OverwriteExistingField() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$unwind: {path: '$sizes', includeArrayIndex: 'item'}");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, item: 'ABC', sizes: ['S', 'M', 'L']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'EFG', sizes: []"));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'IJK', sizes: 'M'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: 'LMN'"));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: 'XYZ', sizes: null"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, sizes: 'S'").append("item", (Object)0L), TestUtils.json("_id: 1, sizes: 'M'").append("item", (Object)1L), TestUtils.json("_id: 1, sizes: 'L'").append("item", (Object)2L), TestUtils.json("_id: 3, sizes: 'M'").append("item", null)});
    }

    @Test
    public void testAggregateWithUnwind_IncludeArrayIndex_NestedIndexField() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$unwind: {path: '$sizes', includeArrayIndex: 'item.idx'}");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, item: {value: 'ABC'}, sizes: ['S', 'M', 'L']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: {value: 'EFG'}, sizes: []"));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: {value: 'IJK'}, sizes: 'M'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: {value: 'LMN'}"));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: {value: 'XYZ'}, sizes: null"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, sizes: 'S'").append("item", (Object)TestUtils.json("value: 'ABC'").append("idx", (Object)0L)), TestUtils.json("_id: 1, sizes: 'M'").append("item", (Object)TestUtils.json("value: 'ABC'").append("idx", (Object)1L)), TestUtils.json("_id: 1, sizes: 'L'").append("item", (Object)TestUtils.json("value: 'ABC'").append("idx", (Object)2L)), TestUtils.json("_id: 3, sizes: 'M'").append("item", (Object)TestUtils.json("value: 'IJK'").append("idx", null))});
    }

    @Test
    public void testAggregateWithUnwind_preserveNullAndEmptyArraysAndIncludeArrayIndex() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$unwind: {path: '$sizes', preserveNullAndEmptyArrays: true, includeArrayIndex: 'idx'}");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, item: 'ABC', sizes: ['S', 'M', 'L']"));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'EFG', sizes: []"));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'IJK', sizes: 'M'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: 'LMN'"));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: 'XYZ', sizes: null"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, item: 'ABC', sizes: 'S'").append("idx", (Object)0L), TestUtils.json("_id: 1, item: 'ABC', sizes: 'M'").append("idx", (Object)1L), TestUtils.json("_id: 1, item: 'ABC', sizes: 'L'").append("idx", (Object)2L), TestUtils.json("_id: 2, item: 'EFG'").append("idx", null), TestUtils.json("_id: 3, item: 'IJK', sizes: 'M'").append("idx", null), TestUtils.json("_id: 4, item: 'LMN'").append("idx", null), TestUtils.json("_id: 5, item: 'XYZ', sizes: null").append("idx", null)});
    }

    @Test
    public void testAggregateWithLookup() {
        MongoCollection authorsCollection = db.getCollection("authors");
        authorsCollection.insertOne((Object)TestUtils.json("_id: 1, name: 'Uncle Bob'"));
        authorsCollection.insertOne((Object)TestUtils.json("_id: 2, name: 'Martin Fowler'"));
        authorsCollection.insertOne((Object)TestUtils.json("_id: null, name: 'Null Author'"));
        List<Document> pipeline = TestUtils.jsonList("$lookup: {from: 'authors', localField: 'authorId', foreignField: '_id', as: 'author'}");
        Assertions.assertThat((Iterable)collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, title: 'Refactoring', authorId: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 2, title: 'Clean Code', authorId: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, title: 'Clean Coder', authorId: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 4, title: 'Unknown author', authorId: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 5, title: 'No author', authorId: null"));
        collection.insertOne((Object)TestUtils.json("_id: 6, title: 'Missing author'"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, title: 'Refactoring', authorId: 2, author: [{_id: 2, name: 'Martin Fowler'}]"), TestUtils.json("_id: 2, title: 'Clean Code', authorId: 1, author: [{_id: 1, name: 'Uncle Bob'}]"), TestUtils.json("_id: 3, title: 'Clean Coder', authorId: 1, author: [{_id: 1, name: 'Uncle Bob'}]"), TestUtils.json("_id: 4, title: 'Unknown author', authorId: 3, author: []"), TestUtils.json("_id: 5, title: 'No author', authorId: null, author: [{_id: null, name: 'Null Author'}]"), TestUtils.json("_id: 6, title: 'Missing author', author: [{_id: null, name: 'Null Author'}]")});
    }

    @Test
    public void testAggregateWithReplaceRoot() {
        List<Document> pipeline = TestUtils.jsonList("$replaceRoot: { newRoot: '$a.b' }");
        Assertions.assertThat((Iterable)collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: { b: { c: 10 } }"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("c: 10")});
    }

    @Test
    public void testAggregateWithIllegalReplaceRoot() {
        List<Document> pipeline = TestUtils.jsonList("$replaceRoot: { newRoot: '$a.b' }");
        collection.insertOne((Object)TestUtils.json("_id: 1, a: { b: 10 }, c: 123"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(pipeline).first();
        }).withMessageContaining("Command failed with error 40228 (Location40228): ''newRoot' expression must evaluate to an object, but resulting value was: 10. Type of resulting value: 'int'.").withMessageContaining("a: {b: 10}");
    }

    @Test
    public void testAggregateWithProjectingReplaceRoot() {
        List<Document> pipeline = TestUtils.jsonList("$replaceRoot: { newRoot: { x: '$a.b' } }");
        Assertions.assertThat((Iterable)collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: { b: { c: 10 } }"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("x: { c: 10 }")});
    }

    @Test
    public void testAggregateWithMergeObjects() throws Exception {
        MongoCollection orders = db.getCollection("orders");
        orders.insertOne((Object)TestUtils.json("_id: 1, item: 'abc', 'price': 12, ordered: 2"));
        orders.insertOne((Object)TestUtils.json("_id: 2, item: 'jkl', 'price': 20, ordered: 1"));
        MongoCollection items = db.getCollection("items");
        items.insertOne((Object)TestUtils.json("_id: 1, item: 'abc', description: 'product 1', instock: 120"));
        items.insertOne((Object)TestUtils.json("_id: 2, item: 'def', description: 'product 2', instock: 80"));
        items.insertOne((Object)TestUtils.json("_id: 3, item: 'jkl', description: 'product 3', instock: 60"));
        List<Document> pipeline = TestUtils.jsonList("$lookup: {from: 'items', localField: 'item', foreignField: 'item', as: 'fromItems'}", "$replaceRoot: {newRoot: {$mergeObjects: [{$arrayElemAt: ['$fromItems', 0 ]}, '$$ROOT']}}", "$project: { fromItems: 0 }");
        Assertions.assertThat(TestUtils.toArray(orders.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, description: 'product 1', instock: 120, item: 'abc', ordered: 2, price: 12"), TestUtils.json("_id: 2, description: 'product 3', instock: 60, item: 'jkl', ordered: 1, price: 20")});
    }

    @Test
    public void testAggregateWithSortByCount() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, item: 'abc', 'price': 12, ordered: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'jkl', 'price': 20, ordered: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'jkl', 'price': 20, ordered: 7"));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: 'jkl', 'price': 40, ordered: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: 'abc', 'price': 90, ordered: 5"));
        collection.insertOne((Object)TestUtils.json("_id: 6, item: 'zzz'"));
        collection.insertOne((Object)TestUtils.json("_id: 7"));
        collection.insertOne((Object)TestUtils.json("_id: 8, item: null"));
        List<Document> pipeline = TestUtils.jsonList("$sortByCount: '$item'");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 'jkl', count: 3"), TestUtils.json("_id: null, count: 2"), TestUtils.json("_id: 'abc', count: 2"), TestUtils.json("_id: 'zzz', count: 1")});
    }

    @Test
    public void testObjectToArrayExpression() throws Exception {
        List<Document> pipeline = TestUtils.jsonList("$project: {_id: 1, a: {$objectToArray: '$value'}}");
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, value: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(pipeline).first();
        }).withMessageContaining("Command failed with error 40390 (Location40390): '$objectToArray requires a document input, found: int'");
        collection.replaceOne((Bson)TestUtils.json("_id: 1"), (Object)TestUtils.json("_id: 1, value: {a: 1, b: 'foo', c: {x: 10}}"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, a: [{k: 'a', v: 1}, {k: 'b', v: 'foo'}, {k: 'c', v: {x: 10}}]")});
        Document illegalQuery = TestUtils.json("$project: {_id: 1, a: {$objectToArray: ['$value', 1]}}");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(Collections.singletonList(illegalQuery)).first();
        }).withMessageContaining("Command failed with error 16020 (Location16020): 'Expression $objectToArray takes exactly 1 arguments. 2 were passed in.'");
    }

    @Test
    public void testArrayToObjectExpression() throws Exception {
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1, b: 'xyz', kv: [['a', 'b'], ['c', 'd']]"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: {$literal: [['a', 'foo']]}}}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, x: {a: 'foo'}")});
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: '$kv'}}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, x: {a: 'b', c: 'd'}")});
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: {$literal: [{k: 'k1', v: 'v1'}, {k: 'k2', v: 'v2'}]}}}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, x: {k1: 'v1', k2: 'v2'}")});
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: {$literal: [{k: 'k1', v: 'v1'}, {k: 'k1', v: 'v2'}]}}}")))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, x: {k1: 'v2'}")});
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: 'illegal-type'}}")).first();
        }).withMessageContaining("Command failed with error 40386 (Location40386): '$arrayToObject requires an array input, found: string'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: []}}")).first();
        }).withMessageContaining("Command failed with error 16020 (Location16020): 'Expression $arrayToObject takes exactly 1 arguments. 0 were passed in.'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: {$literal: [['foo']]}}}}")).first();
        }).withMessageContaining("Command failed with error 40397 (Location40397): '$arrayToObject requires an array of size 2 arrays,found array of size: 1'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: {$literal: [123, 456]}}}}")).first();
        }).withMessageContaining("Command failed with error 40398 (Location40398): 'Unrecognised input type format for $arrayToObject: int'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: {$literal: [[123, 456]]}}}}")).first();
        }).withMessageContaining("Command failed with error 40395 (Location40395): '$arrayToObject requires an array of key-value pairs, where the key must be of type string. Found key type: int'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: {$literal: [{}]}}}}")).first();
        }).withMessageContaining("Command failed with error 40392 (Location40392): '$arrayToObject requires an object keys of 'k' and 'v'. Found incorrect number of keys:0'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: {$literal: [{k: 123, v: 'value'}]}}}}")).first();
        }).withMessageContaining("Command failed with error 40394 (Location40394): '$arrayToObject requires an object with keys 'k' and 'v', where the value of 'k' must be of type string. Found type: int'");
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(TestUtils.jsonList("$project: {_id: 1, x: {$arrayToObject: {$literal: [{k: 'key', z: 'value'}]}}}}")).first();
        }).withMessageContaining("Command failed with error 40393 (Location40393): '$arrayToObject requires an object with keys 'k' and 'v'. Missing either or both keys from: {k: \"key\", z: \"value\"}'");
    }
}

