/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import com.mongodb.MongoCommandException;
import com.mongodb.client.MongoCollection;
import de.bwaldvogel.mongo.backend.AbstractTest;
import de.bwaldvogel.mongo.backend.TestUtils;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.junit.Test;

public abstract class AbstractAggregationTest
extends AbstractTest {
    @Test
    public void testUnrecognizedAggregatePipelineStage() throws Exception {
        List<Document> pipeline = Collections.singletonList(TestUtils.json("$unknown: {}"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(pipeline).first();
        }).withMessageContaining("Command failed with error 40324 (Location40324): 'Unrecognized pipeline stage name: '$unknown'");
    }

    @Test
    public void testIllegalAggregatePipelineStage() throws Exception {
        List<Document> pipeline = Collections.singletonList(TestUtils.json("$unknown: {}, bar: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(pipeline).first();
        }).withMessageContaining("Command failed with error 40323 (Location40323): 'A pipeline stage specification object must contain exactly one field.'");
    }

    @Test
    public void testAggregateWithMissingCursor() throws Exception {
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> db.runCommand((Bson)TestUtils.json("aggregate: 'collection', pipeline: [{$match: {}}]"))).withMessageContaining("Command failed with error 9 (FailedToParse): 'The 'cursor' option is required, except for aggregate with the explain argument'");
    }

    @Test
    public void testAggregateWithComplexGroupBySumPipeline() throws Exception {
        Document query = TestUtils.json("_id: null, n: {$sum: 1}, sumOfA: {$sum: '$a'}, sumOfB: {$sum: '$b.value'}");
        List<Document> pipeline = Collections.singletonList(new Document("$group", (Object)query));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a:30, b: {value: 20}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a:15, b: {value: 10.5}"));
        collection.insertOne((Object)TestUtils.json("_id: 3, b: {value: 1}"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: {value: 5}"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, n:4, sumOfA: 45, sumOfB: 31.5")});
    }

    @Test
    public void testAggregateWithGroupByMinAndMax() throws Exception {
        Document query = TestUtils.json("_id: null, minA: {$min: '$a'}, maxB: {$max: '$b.value'}, maxC: {$max: '$c'}, minC: {$min: '$c'}");
        List<Document> pipeline = Collections.singletonList(new Document("$group", (Object)query));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a:30, b: {value: 20}, c: 1.0"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a:15, b: {value: 10}, c: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3, c: 'zzz'"));
        collection.insertOne((Object)TestUtils.json("_id: 4, c: 'aaa'"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, minA: 15, maxB: 20, minC: 1.0, maxC: 'zzz'")});
    }

    @Test
    public void testAggregateWithGroupByNonExistingMinAndMax() throws Exception {
        Document query = TestUtils.json("_id: null, minOfA: {$min: '$doesNotExist'}, maxOfB: {$max: '$doesNotExist'}");
        List<Document> pipeline = Collections.singletonList(new Document("$group", (Object)query));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 30, b: {value: 20}"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 15, b: {value: 10}"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, minOfA: null, maxOfB: null")});
    }

    @Test
    public void testAggregateWithUnknownGroupOperator() throws Exception {
        Document query = TestUtils.json("_id: null, n: {$foo: 1}");
        List<Document> pipeline = Collections.singletonList(new Document("$group", (Object)query));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(pipeline).first();
        }).withMessageContaining("Command failed with error 15952 (Location15952): 'unknown group operator '$foo''");
    }

    @Test
    public void testAggregateWithTooManyGroupOperators() throws Exception {
        Document query = TestUtils.json("_id: null, n: {$sum: 1, $max: 1}");
        List<Document> pipeline = Collections.singletonList(new Document("$group", (Object)query));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(pipeline).first();
        }).withMessageContaining("Command failed with error 40238 (Location40238): 'The field 'n' must specify one accumulator'");
    }

    @Test
    public void testAggregateWithEmptyPipeline() throws Exception {
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(Collections.emptyList()))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(Collections.emptyList()))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1"), TestUtils.json("_id: 2")});
    }

    @Test
    public void testAggregateWithMissingIdInGroupSpecification() throws Exception {
        List<Document> pipeline = Collections.singletonList(new Document("$group", (Object)TestUtils.json("n: {$sum: 1}")));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> TestUtils.toArray(collection.aggregate(pipeline))).withMessageContaining("Command failed with error 15955 (Location15955): 'a group specification must include an _id'");
    }

    @Test
    public void testAggregateWithGroupBySumPipeline() throws Exception {
        Document query = TestUtils.json("_id: null, n: {$sum: 1}");
        List<Document> pipeline = Collections.singletonList(new Document("$group", (Object)query));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, n: 2")});
        query.putAll((Map)TestUtils.json("n: {$sum: 'abc'}"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, n: 0")});
        query.putAll((Map)TestUtils.json("n: {$sum: 2}"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, n: 4")});
        query.putAll((Map)TestUtils.json("n: {$sum: 1.75}"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, n: 3.5")});
        query.putAll((Map)new Document("n", (Object)new Document("$sum", (Object)10000000000L)));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, n: 20000000000")});
        query.putAll((Map)new Document("n", (Object)new Document("$sum", (Object)Float.valueOf(-2.5f))));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, n: -5.0")});
    }

    @Test
    public void testAggregateWithGroupByAvg() throws Exception {
        Document query = TestUtils.json("_id: null, avg: {$avg: 1}");
        List<Document> pipeline = Collections.singletonList(new Document("$group", (Object)query));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 6.0, b: 'zzz'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 3.0, b: 'aaa'"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, avg: 1.0")});
        query.putAll((Map)TestUtils.json("avg: {$avg: '$a'}, avgB: {$avg: '$b'}"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, avg: 4.5, avgB: null")});
    }

    @Test
    public void testAggregateWithGroupByKey() throws Exception {
        List<Document> pipeline = Collections.singletonList(TestUtils.json("$group: {_id: '$a', count: {$sum: 1}, avg: {$avg: '$b'}}"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: 2, b: 3"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: 2, b: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 5, a: 5, b: 10"));
        collection.insertOne((Object)TestUtils.json("_id: 6, a: 7, c: 'a'"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, count: 2, avg: null"), TestUtils.json("_id: 2, count: 2, avg: 3.5"), TestUtils.json("_id: 5, count: 1, avg: 10.0"), TestUtils.json("_id: 7, count: 1, avg: null")});
    }

    @Test
    public void testAggregateWithSimpleExpressions() throws Exception {
        Document query = TestUtils.json("$group: {_id: {$abs: '$value'}, count: {$sum: 1}}");
        List<Document> pipeline = Collections.singletonList(query);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, value: 1"));
        collection.insertOne((Object)TestUtils.json("_id: -2, value: -1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, value: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 4, value: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 5, value: -2.5"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, count: 2"), TestUtils.json("_id: 2, count: 2"), TestUtils.json("_id: 2.5, count: 1")});
    }

    @Test
    public void testAggregateWithMultipleExpressionsInKey() throws Exception {
        Document query = TestUtils.json("$group: {_id: {abs: {$abs: '$value'}, sum: {$subtract: ['$end', '$start']}}, count: {$sum: 1}}");
        List<Document> pipeline = Collections.singletonList(query);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, value: NaN"));
        collection.insertOne((Object)TestUtils.json("_id: 2, value: 1, start: 5, end: 8"));
        collection.insertOne((Object)TestUtils.json("_id: 3, value: -1, start: 4, end: 4"));
        collection.insertOne((Object)TestUtils.json("_id: 4, value: 2, start: 9, end: 7"));
        collection.insertOne((Object)TestUtils.json("_id: 5, value: 2, start: 6, end: 7"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: {abs: NaN, sum: null}, count: 1"), TestUtils.json("_id: {abs: 1, sum: 3}, count: 1"), TestUtils.json("_id: {abs: 1, sum: 0}, count: 1"), TestUtils.json("_id: {abs: 2, sum: -2}, count: 1"), TestUtils.json("_id: {abs: 2, sum: 1}, count: 1")});
    }

    @Test
    public void testAggregateWithAddToSet() throws Exception {
        Document query = TestUtils.json("$group: {_id: { day: { $dayOfYear: '$date'}, year: { $year: '$date' } }, itemsSold: { $addToSet: '$item' }}");
        List<Document> pipeline = Collections.singletonList(query);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, item: 'zzz', price:  5, quantity: 10").append("date", (Object)AbstractAggregationTest.date("2014-02-15T09:12:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'abc', price: 10, quantity:  2").append("date", (Object)AbstractAggregationTest.date("2014-01-01T08:00:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'jkl', price: 20, quantity:  1").append("date", (Object)AbstractAggregationTest.date("2014-02-03T09:00:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: 'xyz', price:  5, quantity:  5").append("date", (Object)AbstractAggregationTest.date("2014-02-03T09:05:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: 'abc', price: 10, quantity: 10").append("date", (Object)AbstractAggregationTest.date("2014-02-15T08:00:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 6, item: 'xyz', price:  5, quantity: 10").append("date", (Object)AbstractAggregationTest.date("2014-02-15T09:12:00Z")));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: { day:  1, year: 2014 }, itemsSold: [ 'abc' ]"), TestUtils.json("_id: { day: 34, year: 2014 }, itemsSold: [ 'xyz', 'jkl' ]"), TestUtils.json("_id: { day: 46, year: 2014 }, itemsSold: [ 'xyz', 'abc', 'zzz' ]")});
    }

    @Test
    public void testAggregateWithEmptyAddToSet() throws Exception {
        Document query = TestUtils.json("$group: {_id: 1, set: { $addToSet: '$foo' }}");
        List<Document> pipeline = Collections.singletonList(query);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, set: [ ]")});
    }

    @Test
    public void testAggregateWithAdd() throws Exception {
        Document query = TestUtils.json("$project: { item: 1, total: { $add: [ '$price', '$fee' ] } }");
        List<Document> pipeline = Collections.singletonList(query);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, item: 'abc', price: 10, fee: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'jkl', price: 20, fee: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'xyz', price: 5, fee: 0"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, item: 'abc', total: 12"), TestUtils.json("_id: 2, item: 'jkl', total: 21"), TestUtils.json("_id: 3, item: 'xyz', total: 5 ")});
    }

    @Test
    public void testAggregateWithSort() throws Exception {
        Document query = TestUtils.json("$sort: { price: -1, fee: 1 }");
        List<Document> pipeline = Collections.singletonList(query);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, price: 10, fee: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, price: 20, fee: 0"));
        collection.insertOne((Object)TestUtils.json("_id: 3, price: 10, fee: 0"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 2, price: 20, fee: 0"), TestUtils.json("_id: 3, price: 10, fee: 0"), TestUtils.json("_id: 1, price: 10, fee: 1")});
    }

    @Test
    public void testAggregateWithProjection() throws Exception {
        Document query = TestUtils.json("$project: {_id: 1, value: '$x', n: '$foo.bar', other: null}");
        List<Document> pipeline = Collections.singletonList(query);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, x: 10, foo: 'abc'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, x: 20"));
        collection.insertOne((Object)TestUtils.json("_id: 3, x: 30, foo: {bar: 7.3}"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, value: 10, other: null"), TestUtils.json("_id: 2, value: 20, other: null"), TestUtils.json("_id: 3, value: 30, n: 7.3, other: null")});
    }

    @Test
    public void testAggregateWithExpressionProjection() throws Exception {
        Document query = TestUtils.json("$project: {_id: 0, idHex: {$toString: '$_id'}}");
        List<Document> pipeline = Collections.singletonList(query);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)new Document("_id", (Object)new ObjectId("abcd01234567890123456789")));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("idHex: 'abcd01234567890123456789'")});
    }

    @Test
    public void testAggregateWithAddFields() throws Exception {
        Document addFields = TestUtils.json("$addFields: {value: '$x'}");
        List<Document> pipeline = Collections.singletonList(addFields);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, x: 10"));
        collection.insertOne((Object)TestUtils.json("_id: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 3, value: 123"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, x: 10, value: 10"), TestUtils.json("_id: 2"), TestUtils.json("_id: 3")});
    }

    @Test
    public void testAggregateWithMultipleMatches() throws Exception {
        Document match1 = TestUtils.json("$match: {price: {$lt: 100}}");
        Document match2 = TestUtils.json("$match: {quality: {$gt: 10}}");
        List<Document> pipeline = Arrays.asList(match1, match2);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, price: 10, quality: 50"));
        collection.insertOne((Object)TestUtils.json("_id: 2, price: 150, quality: 500"));
        collection.insertOne((Object)TestUtils.json("_id: 3, price: 50, quality: 150"));
        collection.insertOne((Object)TestUtils.json("_id: 4, price: 10, quality: 5"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, price: 10, quality: 50"), TestUtils.json("_id: 3, price: 50, quality: 150")});
    }

    @Test
    public void testAggregateWithCeil() throws Exception {
        Document query = TestUtils.json("$project: {a: 1, ceil: {$ceil: '$a'}}");
        List<Document> pipeline = Collections.singletonList(query);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 9.25"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 8.73"));
        collection.insertOne((Object)TestUtils.json("_id: 3, a: 4.32"));
        collection.insertOne((Object)TestUtils.json("_id: 4, a: -5.34"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, a: 9.25, ceil: 10.0"), TestUtils.json("_id: 2, a: 8.73, ceil: 9.0"), TestUtils.json("_id: 3, a: 4.32, ceil: 5.0"), TestUtils.json("_id: 4, a: -5.34, ceil: -5.0")});
    }

    @Test
    public void testAggregateWithNumericOperators() throws Exception {
        Document query = TestUtils.json("$project: {a: 1, exp: {$exp: '$a'}, ln: {$ln: '$a'}, log10: {$log10: '$a'}, sqrt: {$sqrt: '$a'}}");
        List<Document> pipeline = Collections.singletonList(query);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 1"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, a: 1, exp: 2.718281828459045, ln: 0.0, log10: 0.0, sqrt: 1.0")});
    }

    @Test
    public void testAggregateWithCount() throws Exception {
        Document match = TestUtils.json("$match: {score: {$gt: 80}}");
        Document count = TestUtils.json("$count: 'passing_scores'");
        List<Document> pipeline = Arrays.asList(match, count);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, subject: 'History', score: 88"));
        collection.insertOne((Object)TestUtils.json("_id: 2, subject: 'History', score: 92"));
        collection.insertOne((Object)TestUtils.json("_id: 3, subject: 'History', score: 97"));
        collection.insertOne((Object)TestUtils.json("_id: 4, subject: 'History', score: 71"));
        collection.insertOne((Object)TestUtils.json("_id: 5, subject: 'History', score: 79"));
        collection.insertOne((Object)TestUtils.json("_id: 6, subject: 'History', score: 83"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("passing_scores: 4")});
    }

    @Test
    public void testAggregateWithFirstAndLast() throws Exception {
        Document sort = TestUtils.json("$sort: { item: 1, date: 1 }");
        Document group = TestUtils.json("$group: {_id: '$item', firstSale: { $first: '$date' }, lastSale: { $last: '$date'} }");
        List<Document> pipeline = Arrays.asList(sort, group);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, item: 'abc', price: 10, quantity:  2").append("date", (Object)AbstractAggregationTest.date("2014-01-01T08:00:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 2, item: 'jkl', price: 20, quantity:  1").append("date", (Object)AbstractAggregationTest.date("2014-02-03T09:00:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 3, item: 'xyz', price:  5, quantity:  5").append("date", (Object)AbstractAggregationTest.date("2014-02-03T09:05:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 4, item: 'abc', price: 10, quantity: 10").append("date", (Object)AbstractAggregationTest.date("2014-02-15T08:00:00Z")));
        collection.insertOne((Object)TestUtils.json("_id: 5, item: 'xyz', price:  5, quantity: 10").append("date", (Object)AbstractAggregationTest.date("2014-02-15T09:12:00Z")));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 'abc'").append("firstSale", (Object)AbstractAggregationTest.date("2014-01-01T08:00:00Z")).append("lastSale", (Object)AbstractAggregationTest.date("2014-02-15T08:00:00Z")), TestUtils.json("_id: 'jkl'").append("firstSale", (Object)AbstractAggregationTest.date("2014-02-03T09:00:00Z")).append("lastSale", (Object)AbstractAggregationTest.date("2014-02-03T09:00:00Z")), TestUtils.json("_id: 'xyz'").append("firstSale", (Object)AbstractAggregationTest.date("2014-02-03T09:05:00Z")).append("lastSale", (Object)AbstractAggregationTest.date("2014-02-15T09:12:00Z"))});
    }

    @Test
    public void testAggregateWithPush() throws Exception {
        Document group = TestUtils.json("$group: {_id: null, a: {$push: '$a'}, b: {$push: {v: '$b'}}, c: {$push: '$c'}}");
        List<Document> pipeline = Collections.singletonList(group);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: 10, b: 0.1"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: 20, b: 0.2"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: null, a: [10, 20], b: [{v: 0.1}, {v: 0.2}], c: []")});
    }

    @Test
    public void testAggregateWithUndefinedVariable() throws Exception {
        Document project = TestUtils.json("$project: {result: '$$UNDEFINED'}");
        List<Document> pipeline = Collections.singletonList(project);
        collection.insertOne((Object)TestUtils.json("_id: 1"));
        Assertions.assertThatExceptionOfType(MongoCommandException.class).isThrownBy(() -> {
            Document cfr_ignored_0 = (Document)collection.aggregate(pipeline).first();
        }).withMessageContaining("Command failed with error 17276 (Location17276): 'Use of undefined variable: UNDEFINED'");
    }

    @Test
    public void testAggregateWithRootVariable() throws Exception {
        Document project = TestUtils.json("$project: {_id: 0, doc: '$$ROOT', a: '$$ROOT.a', a_v: '$$ROOT.a.v'}");
        List<Document> pipeline = Collections.singletonList(project);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: {v: 10}"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("doc: {_id: 1, a: {v: 10}}, a: {v: 10}, a_v: 10")});
    }

    @Test
    public void testAggregateWithSetUnion() throws Exception {
        Document project = TestUtils.json("$project: {all: {$setUnion: ['$a', '$b']}}");
        List<Document> pipeline = Collections.singletonList(project);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, a: [3, 2, 1]"));
        collection.insertOne((Object)TestUtils.json("_id: 2, a: [1], b: [3, 2]"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactlyInAnyOrder((Object[])new Document[]{TestUtils.json("_id: 1, all: null"), TestUtils.json("_id: 2, all: [1, 2, 3]")});
    }

    @Test
    public void testAggregateWithSplit() throws Exception {
        Document project = TestUtils.json("$project: {_id: 1, names: {$split: ['$name', ' ']}}");
        List<Document> pipeline = Collections.singletonList(project);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, name: 'first document'"));
        collection.insertOne((Object)TestUtils.json("_id: 2, name: 'second document'"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, names: ['first', 'document']"), TestUtils.json("_id: 2, names: ['second', 'document']")});
    }

    @Test
    public void testAggregateWithUnwind() throws Exception {
        Document unwind = TestUtils.json("$unwind: '$sizes'");
        List<Document> pipeline = Collections.singletonList(unwind);
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, item: 'ABC1', sizes: ['S', 'M', 'L']"));
        Assertions.assertThat(TestUtils.toArray(collection.aggregate(pipeline))).containsExactly((Object[])new Document[]{TestUtils.json("_id: 1, item: 'ABC1', sizes: 'S'"), TestUtils.json("_id: 1, item: 'ABC1', sizes: 'M'"), TestUtils.json("_id: 1, item: 'ABC1', sizes: 'L'")});
    }

    @Test
    public void testAggregateWithLookup() {
        MongoCollection authorsCollection = db.getCollection("authors");
        authorsCollection.insertOne((Object)TestUtils.json("_id: 1, name: 'Uncle Bob'"));
        authorsCollection.insertOne((Object)TestUtils.json("_id: 2, name: 'Martin Fowler'"));
        Document lookup = TestUtils.json("$lookup: {from: 'authors', localField: 'authorId', foreignField: '_id', as: 'author'}");
        List<Document> pipeline = Collections.singletonList(lookup);
        Assertions.assertThat((Iterable)collection.aggregate(pipeline)).isEmpty();
        collection.insertOne((Object)TestUtils.json("_id: 1, title: 'Refactoring', authorId: 2"));
        collection.insertOne((Object)TestUtils.json("_id: 2, title: 'Clean Code', authorId: 1"));
        collection.insertOne((Object)TestUtils.json("_id: 3, title: 'Clean Coder', authorId: 1"));
        Assertions.assertThat((Iterable)collection.aggregate(pipeline)).containsOnly((Object[])new Document[]{TestUtils.json("_id: 1, title: 'Refactoring', authorId: 2, author: [{_id: 2, name: 'Martin Fowler'}]"), TestUtils.json("_id: 2, title: 'Clean Code', authorId: 1, author: [{_id: 1, name: 'Uncle Bob'}]"), TestUtils.json("_id: 3, title: 'Clean Coder', authorId: 1, author: [{_id: 1, name: 'Uncle Bob'}]")});
    }

    private static Date date(String instant) {
        return Date.from(Instant.parse(instant));
    }
}

