/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.memory;

import de.bwaldvogel.mongo.backend.AbstractMongoCollection;
import de.bwaldvogel.mongo.backend.DocumentComparator;
import de.bwaldvogel.mongo.exception.MongoServerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import org.bson.BSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryCollection
extends AbstractMongoCollection<Integer> {
    private static final Logger log = LoggerFactory.getLogger(MemoryCollection.class);
    private List<BSONObject> documents = new ArrayList<BSONObject>();
    private Queue<Integer> emptyPositions = new LinkedList<Integer>();
    private AtomicLong dataSize = new AtomicLong();

    public MemoryCollection(String databaseName, String collectionName, String idField) {
        super(databaseName, collectionName, idField);
    }

    protected void updateDataSize(long sizeDelta) {
        this.dataSize.addAndGet(sizeDelta);
    }

    protected long getDataSize() {
        return this.dataSize.get();
    }

    protected Integer addDocumentInternal(BSONObject document) {
        Integer pos = this.emptyPositions.poll();
        if (pos == null) {
            pos = this.documents.size();
        }
        if (pos.intValue() == this.documents.size()) {
            this.documents.add(document);
        } else {
            this.documents.set(pos, document);
        }
        return pos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Iterable<BSONObject> matchDocuments(BSONObject query, Iterable<Integer> keys, BSONObject orderBy, int numberToSkip, int numberToReturn) throws MongoServerException {
        List<Object> matchedDocuments = new ArrayList<BSONObject>();
        for (Integer key : keys) {
            BSONObject document = this.getDocument(key);
            if (!this.documentMatchesQuery(document, query)) continue;
            matchedDocuments.add(document);
        }
        if (orderBy != null && !orderBy.keySet().isEmpty()) {
            if (((String)orderBy.keySet().iterator().next()).equals("$natural")) {
                int sortValue = (Integer)orderBy.get("$natural");
                if (sortValue != 1) {
                    if (sortValue != -1) throw new IllegalArgumentException("Illegal sort value: " + sortValue);
                    Collections.reverse(matchedDocuments);
                }
            } else {
                Collections.sort(matchedDocuments, new DocumentComparator(orderBy));
            }
        }
        if (numberToSkip > 0) {
            matchedDocuments = matchedDocuments.subList(numberToSkip, matchedDocuments.size());
        }
        if (numberToReturn <= 0) return matchedDocuments;
        if (matchedDocuments.size() <= numberToReturn) return matchedDocuments;
        return matchedDocuments.subList(0, numberToReturn);
    }

    protected Iterable<BSONObject> matchDocuments(BSONObject query, BSONObject orderBy, int numberToSkip, int numberToReturn) throws MongoServerException {
        int sortValue;
        List<Object> matchedDocuments = new ArrayList<BSONObject>();
        boolean ascending = true;
        if (orderBy != null && !orderBy.keySet().isEmpty() && ((String)orderBy.keySet().iterator().next()).equals("$natural") && (sortValue = ((Integer)orderBy.get("$natural")).intValue()) == -1) {
            ascending = false;
        }
        for (BSONObject document : this.iterateAllDocuments(ascending)) {
            if (!this.documentMatchesQuery(document, query)) continue;
            matchedDocuments.add(document);
        }
        if (orderBy != null && !orderBy.keySet().isEmpty() && !((String)orderBy.keySet().iterator().next()).equals("$natural")) {
            Collections.sort(matchedDocuments, new DocumentComparator(orderBy));
        }
        if (numberToSkip > 0) {
            matchedDocuments = matchedDocuments.subList(numberToSkip, matchedDocuments.size());
        }
        if (numberToReturn > 0 && matchedDocuments.size() > numberToReturn) {
            matchedDocuments = matchedDocuments.subList(0, numberToReturn);
        }
        return matchedDocuments;
    }

    private Iterable<BSONObject> iterateAllDocuments(boolean ascending) {
        if (ascending) {
            return new DocumentIterable(this.documents);
        }
        return new ReverseDocumentIterable(this.documents);
    }

    public synchronized int count() {
        return this.documents.size() - this.emptyPositions.size();
    }

    protected Integer findDocument(BSONObject document) {
        int position = this.documents.indexOf(document);
        if (position < 0) {
            return null;
        }
        return position;
    }

    protected int getRecordCount() {
        return this.documents.size();
    }

    protected int getDeletedCount() {
        return this.emptyPositions.size();
    }

    protected void removeDocumentWithKey(Integer position) {
        this.documents.set(position, null);
        this.emptyPositions.add(position);
    }

    protected BSONObject getDocument(Integer position) {
        return this.documents.get(position);
    }

    public void drop() {
        log.debug("dropping {}", (Object)this);
    }

    private static class ReverseDocumentIterable
    implements Iterable<BSONObject> {
        private List<BSONObject> documents;

        public ReverseDocumentIterable(List<BSONObject> documents) {
            this.documents = documents;
        }

        @Override
        public Iterator<BSONObject> iterator() {
            return new ReverseDocumentIterator(this.documents);
        }
    }

    private static class DocumentIterable
    implements Iterable<BSONObject> {
        private List<BSONObject> documents;

        public DocumentIterable(List<BSONObject> documents) {
            this.documents = documents;
        }

        @Override
        public Iterator<BSONObject> iterator() {
            return new DocumentIterator(this.documents);
        }
    }

    private static class ReverseDocumentIterator
    extends AbstractDocumentIterator {
        protected ReverseDocumentIterator(List<BSONObject> documents) {
            super(documents, documents.size() - 1);
        }

        @Override
        protected BSONObject getNext() {
            while (this.pos >= 0) {
                BSONObject document;
                if ((document = (BSONObject)this.documents.get(this.pos--)) == null) continue;
                return document;
            }
            return null;
        }
    }

    private static class DocumentIterator
    extends AbstractDocumentIterator {
        protected DocumentIterator(List<BSONObject> documents) {
            super(documents, 0);
        }

        @Override
        protected BSONObject getNext() {
            while (this.pos < this.documents.size()) {
                BSONObject document;
                if ((document = (BSONObject)this.documents.get(this.pos++)) == null) continue;
                return document;
            }
            return null;
        }
    }

    private static abstract class AbstractDocumentIterator
    implements Iterator<BSONObject> {
        protected int pos;
        protected final List<BSONObject> documents;
        protected BSONObject current;

        protected AbstractDocumentIterator(List<BSONObject> documents, int pos) {
            this.documents = documents;
            this.pos = pos;
        }

        protected abstract BSONObject getNext();

        @Override
        public boolean hasNext() {
            if (this.current == null) {
                this.current = this.getNext();
            }
            return this.current != null;
        }

        @Override
        public BSONObject next() {
            BSONObject document = this.current;
            this.current = this.getNext();
            return document;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

