/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.memory;

import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.backend.AbstractMongoDatabase;
import de.bwaldvogel.mongo.backend.memory.MemoryCollection;
import de.bwaldvogel.mongo.backend.memory.index.MemoryUniqueIndex;
import de.bwaldvogel.mongo.exception.MongoServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryDatabase
extends AbstractMongoDatabase<Integer> {
    public static final Logger log = LoggerFactory.getLogger(MemoryDatabase.class);

    public MemoryDatabase(MongoBackend backend, String databaseName) throws MongoServerException {
        super(databaseName, backend);
        this.initializeNamespacesAndIndexes();
    }

    public MemoryCollection openOrCreateCollection(String collectionName, String idField) {
        return new MemoryCollection(this.getDatabaseName(), collectionName, idField);
    }

    protected MemoryUniqueIndex openOrCreateUniqueIndex(String collectionName, String key, boolean ascending) {
        return new MemoryUniqueIndex(key, ascending);
    }
}

