/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo;

import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.MongoServer;
import de.bwaldvogel.mongo.backend.memory.MemoryBackend;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryMongoServer
extends MongoServer {
    private static final Logger log = LoggerFactory.getLogger(InMemoryMongoServer.class);

    public static void main(String[] args) throws Exception {
        final InMemoryMongoServer mongoServer = new InMemoryMongoServer();
        mongoServer.bind(new InetSocketAddress(InetAddress.getByAddress(new byte[]{0, 0, 0, 0}), 27017));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                log.info("shutting down {}", (Object)mongoServer);
                mongoServer.shutdownNow();
            }
        });
    }

    public InMemoryMongoServer() {
        super((MongoBackend)new MemoryBackend());
    }
}

