/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.memory;

import de.bwaldvogel.mongo.MongoDatabase;
import de.bwaldvogel.mongo.backend.AbstractMongoCollection;
import de.bwaldvogel.mongo.backend.DocumentComparator;
import de.bwaldvogel.mongo.backend.DocumentWithPosition;
import de.bwaldvogel.mongo.backend.memory.DocumentIterable;
import de.bwaldvogel.mongo.bson.Document;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class MemoryCollection
extends AbstractMongoCollection<Integer> {
    private List<Document> documents = new ArrayList<Document>();
    private Queue<Integer> emptyPositions = new LinkedList<Integer>();
    private AtomicInteger dataSize = new AtomicInteger();

    public MemoryCollection(MongoDatabase database, String collectionName, String idField) {
        super(database, collectionName, idField);
    }

    protected void updateDataSize(int sizeDelta) {
        this.dataSize.addAndGet(sizeDelta);
    }

    protected int getDataSize() {
        return this.dataSize.get();
    }

    protected Integer addDocumentInternal(Document document) {
        Integer position = this.emptyPositions.poll();
        if (position == null) {
            position = this.documents.size();
        }
        if (position.intValue() == this.documents.size()) {
            this.documents.add(document);
        } else {
            this.documents.set(position, document);
        }
        return position;
    }

    protected Iterable<Document> matchDocuments(Document query, Document orderBy, int numberToSkip, int numberToReturn) {
        ArrayList<Document> matchedDocuments = new ArrayList<Document>();
        for (Document document : this.iterateAllDocuments(orderBy)) {
            if (!this.documentMatchesQuery(document, query)) continue;
            matchedDocuments.add(document);
        }
        DocumentComparator documentComparator = MemoryCollection.deriveComparator((Document)orderBy);
        if (documentComparator != null) {
            matchedDocuments.sort((Comparator<Document>)documentComparator);
        }
        return MemoryCollection.applySkipAndLimit(matchedDocuments, (int)numberToSkip, (int)numberToReturn);
    }

    private Iterable<Document> iterateAllDocuments(Document orderBy) {
        DocumentIterable documentIterable = new DocumentIterable(this.documents);
        if (MemoryCollection.isNaturalDescending((Document)orderBy)) {
            return documentIterable.reversed();
        }
        return documentIterable;
    }

    public synchronized int count() {
        return this.documents.size() - this.emptyPositions.size();
    }

    public synchronized boolean isEmpty() {
        return this.documents.isEmpty() || super.isEmpty();
    }

    protected Integer findDocumentPosition(Document document) {
        int position = this.documents.indexOf(document);
        if (position < 0) {
            return null;
        }
        return position;
    }

    protected Stream<DocumentWithPosition<Integer>> streamAllDocumentsWithPosition() {
        return IntStream.range(0, this.documents.size()).mapToObj(index -> new DocumentWithPosition(this.documents.get(index), (Object)index));
    }

    protected void removeDocument(Integer position) {
        this.documents.set(position, null);
        this.emptyPositions.add(position);
    }

    protected Document getDocument(Integer position) {
        return this.documents.get(position);
    }

    protected void handleUpdate(Integer position, Document oldDocument, Document newDocument) {
    }
}

