/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.memory;

import de.bwaldvogel.mongo.backend.AbstractMongoCollection;
import de.bwaldvogel.mongo.backend.DocumentComparator;
import de.bwaldvogel.mongo.backend.DocumentWithPosition;
import de.bwaldvogel.mongo.bson.Document;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryCollection
extends AbstractMongoCollection<Integer> {
    private static final Logger log = LoggerFactory.getLogger(MemoryCollection.class);
    private List<Document> documents = new ArrayList<Document>();
    private Queue<Integer> emptyPositions = new LinkedList<Integer>();
    private AtomicInteger dataSize = new AtomicInteger();

    public MemoryCollection(String databaseName, String collectionName, String idField) {
        super(databaseName, collectionName, idField);
    }

    protected void updateDataSize(int sizeDelta) {
        this.dataSize.addAndGet(sizeDelta);
    }

    protected int getDataSize() {
        return this.dataSize.get();
    }

    protected Integer addDocumentInternal(Document document) {
        Integer position = this.emptyPositions.poll();
        if (position == null) {
            position = this.documents.size();
        }
        if (position.intValue() == this.documents.size()) {
            this.documents.add(document);
        } else {
            this.documents.set(position, document);
        }
        return position;
    }

    protected Iterable<Document> matchDocuments(Document query, Iterable<Integer> positions, Document orderBy, int numberToSkip, int numberToReturn) {
        List<Object> matchedDocuments = new ArrayList<Document>();
        for (Integer position : positions) {
            Document document = this.getDocument(position);
            if (!this.documentMatchesQuery(document, query)) continue;
            matchedDocuments.add(document);
        }
        this.sortDocumentsInMemory(matchedDocuments, orderBy);
        if (numberToSkip > 0) {
            matchedDocuments = matchedDocuments.subList(numberToSkip, matchedDocuments.size());
        }
        if (numberToReturn > 0 && matchedDocuments.size() > numberToReturn) {
            matchedDocuments = matchedDocuments.subList(0, numberToReturn);
        }
        return matchedDocuments;
    }

    protected Iterable<Document> matchDocuments(Document query, Document orderBy, int numberToSkip, int numberToReturn) {
        int sortValue;
        List<Object> matchedDocuments = new ArrayList<Document>();
        boolean ascending = true;
        if (orderBy != null && !orderBy.keySet().isEmpty() && ((String)orderBy.keySet().iterator().next()).equals("$natural") && (sortValue = ((Integer)orderBy.get((Object)"$natural")).intValue()) == -1) {
            ascending = false;
        }
        for (Document document : this.iterateAllDocuments(ascending)) {
            if (!this.documentMatchesQuery(document, query)) continue;
            matchedDocuments.add(document);
        }
        if (orderBy != null && !orderBy.keySet().isEmpty() && !((String)orderBy.keySet().iterator().next()).equals("$natural")) {
            matchedDocuments.sort((Comparator<Document>)new DocumentComparator(orderBy));
        }
        if (numberToSkip > 0) {
            if (numberToSkip < matchedDocuments.size()) {
                matchedDocuments = matchedDocuments.subList(numberToSkip, matchedDocuments.size());
            } else {
                return Collections.emptyList();
            }
        }
        if (numberToReturn > 0 && matchedDocuments.size() > numberToReturn) {
            matchedDocuments = matchedDocuments.subList(0, numberToReturn);
        }
        return matchedDocuments;
    }

    private Iterable<Document> iterateAllDocuments(boolean ascending) {
        if (ascending) {
            return new DocumentIterable(this.documents);
        }
        return new ReverseDocumentIterable(this.documents);
    }

    public synchronized int count() {
        return this.documents.size() - this.emptyPositions.size();
    }

    protected Integer findDocumentPosition(Document document) {
        int position = this.documents.indexOf(document);
        if (position < 0) {
            return null;
        }
        return position;
    }

    protected Stream<DocumentWithPosition<Integer>> streamAllDocumentsWithPosition() {
        return IntStream.range(0, this.documents.size()).mapToObj(index -> new DocumentWithPosition(this.documents.get(index), (Object)index));
    }

    protected void removeDocument(Integer position) {
        this.documents.set(position, null);
        this.emptyPositions.add(position);
    }

    protected Document getDocument(Integer position) {
        return this.documents.get(position);
    }

    protected void handleUpdate(Document document) {
    }

    private static class ReverseDocumentIterable
    implements Iterable<Document> {
        private List<Document> documents;

        public ReverseDocumentIterable(List<Document> documents) {
            this.documents = documents;
        }

        @Override
        public Iterator<Document> iterator() {
            return new ReverseDocumentIterator(this.documents);
        }
    }

    private static class DocumentIterable
    implements Iterable<Document> {
        private List<Document> documents;

        public DocumentIterable(List<Document> documents) {
            this.documents = documents;
        }

        @Override
        public Iterator<Document> iterator() {
            return new DocumentIterator(this.documents);
        }
    }

    private static class ReverseDocumentIterator
    extends AbstractDocumentIterator {
        protected ReverseDocumentIterator(List<Document> documents) {
            super(documents, documents.size() - 1);
        }

        @Override
        protected Document getNext() {
            while (this.pos >= 0) {
                Document document;
                if ((document = (Document)this.documents.get(this.pos--)) == null) continue;
                return document;
            }
            return null;
        }
    }

    private static class DocumentIterator
    extends AbstractDocumentIterator {
        protected DocumentIterator(List<Document> documents) {
            super(documents, 0);
        }

        @Override
        protected Document getNext() {
            while (this.pos < this.documents.size()) {
                Document document;
                if ((document = (Document)this.documents.get(this.pos++)) == null) continue;
                return document;
            }
            return null;
        }
    }

    private static abstract class AbstractDocumentIterator
    implements Iterator<Document> {
        protected int pos;
        protected final List<Document> documents;
        protected Document current;

        protected AbstractDocumentIterator(List<Document> documents, int pos) {
            this.documents = documents;
            this.pos = pos;
        }

        protected abstract Document getNext();

        @Override
        public boolean hasNext() {
            if (this.current == null) {
                this.current = this.getNext();
            }
            return this.current != null;
        }

        @Override
        public Document next() {
            Document document = this.current;
            this.current = this.getNext();
            return document;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

