/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.memory.index;

import de.bwaldvogel.mongo.backend.AbstractUniqueIndex;
import de.bwaldvogel.mongo.backend.IndexKey;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MemoryUniqueIndex
extends AbstractUniqueIndex<Integer> {
    private final Map<List<Object>, Integer> index = new ConcurrentHashMap<List<Object>, Integer>();

    public MemoryUniqueIndex(List<IndexKey> keys, boolean sparse) {
        super(keys, sparse);
    }

    public long getCount() {
        return this.index.size();
    }

    public long getDataSize() {
        return this.getCount();
    }

    protected Integer removeDocument(List<Object> key) {
        return this.index.remove(key);
    }

    protected boolean containsKey(List<Object> key) {
        return this.index.containsKey(key);
    }

    protected boolean putKeyPosition(List<Object> key, Integer position) {
        Integer oldValue = this.index.putIfAbsent(key, position);
        return oldValue == null;
    }

    protected Integer getPosition(List<Object> key) {
        return this.index.get(key);
    }

    protected Iterable<Map.Entry<List<Object>, Integer>> getIterable() {
        return this.index.entrySet();
    }
}

