/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import java.util.HashMap;
import java.util.Map;

enum UpdateOperator {
    INC("$inc"),
    MUL("$mul"),
    RENAME("$rename"),
    SET_ON_INSERT("$setOnInsert"),
    SET("$set"),
    UNSET("$unset"),
    MIN("$min"),
    MAX("$max"),
    CURRENT_DATE("$currentDate"),
    ADD_TO_SET("$addToSet"),
    POP("$pop"),
    PULL_ALL("$pullAll"),
    PULL("$pull"),
    PUSH_ALL("$pushAll"),
    PUSH("$push"),
    BIT("$bit");

    private String value;
    private static Map<String, UpdateOperator> MAP;

    private UpdateOperator(String value) {
        this.value = value;
    }

    String getValue() {
        return this.value;
    }

    static UpdateOperator fromValue(String value) throws IllegalArgumentException {
        UpdateOperator op = MAP.get(value);
        if (op == null) {
            throw new IllegalArgumentException("Illegal operator: " + value);
        }
        return op;
    }

    public String toString() {
        return this.getValue();
    }

    static {
        MAP = new HashMap<String, UpdateOperator>();
        for (UpdateOperator operator : UpdateOperator.values()) {
            UpdateOperator old = MAP.put(operator.getValue(), operator);
            if (old == null) continue;
            throw new IllegalStateException("Duplicate operator value: " + operator.getValue());
        }
    }
}

