/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo;

import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.wire.MongoDatabaseHandler;
import de.bwaldvogel.mongo.wire.MongoExceptionHandler;
import de.bwaldvogel.mongo.wire.MongoWireEncoder;
import de.bwaldvogel.mongo.wire.MongoWireProtocolHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoServer {
    private static final Logger log = LoggerFactory.getLogger(MongoServer.class);
    private MongoBackend backend;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private ChannelGroup channelGroup;
    private Channel channel;

    public MongoServer(MongoBackend backend) {
        this.backend = backend;
    }

    public void bind(String hostname, int port) {
        this.bind(new InetSocketAddress(hostname, port));
    }

    public void bind(SocketAddress socketAddress) {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        this.channelGroup = new DefaultChannelGroup("mongodb-channels", (EventExecutor)this.workerGroup.next());
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).localAddress(socketAddress)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new MongoWireEncoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{new MongoWireProtocolHandler()});
                    ch.pipeline().addLast(new ChannelHandler[]{new MongoDatabaseHandler(MongoServer.this.backend, MongoServer.this.channelGroup)});
                    ch.pipeline().addLast(new ChannelHandler[]{new MongoExceptionHandler()});
                }
            });
            this.channel = bootstrap.bind().syncUninterruptibly().channel();
            log.info("started {}", (Object)this);
        }
        catch (RuntimeException e) {
            this.shutdownNow();
            throw e;
        }
    }

    public InetSocketAddress bind() {
        this.bind(new InetSocketAddress("localhost", 0));
        return this.getLocalAddress();
    }

    public InetSocketAddress getLocalAddress() {
        if (this.channel == null) {
            return null;
        }
        return (InetSocketAddress)this.channel.localAddress();
    }

    public void shutdown() {
        this.stopListenting();
        this.bossGroup.shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
        this.workerGroup.shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
        this.bossGroup.terminationFuture().syncUninterruptibly();
        this.workerGroup.terminationFuture().syncUninterruptibly();
        this.backend.close();
        log.info("completed shutdown of {}", (Object)this);
    }

    public void stopListenting() {
        if (this.channel != null) {
            log.info("closing server channel");
            this.channel.close().syncUninterruptibly();
            this.channel = null;
        }
    }

    public void shutdownNow() {
        this.stopListenting();
        this.closeClients();
        this.shutdown();
    }

    private void closeClients() {
        int numClients = this.channelGroup.size();
        if (numClients > 0) {
            log.warn("Closing {} clients", (Object)numClients);
        }
        this.channelGroup.close().syncUninterruptibly();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("(");
        InetSocketAddress socketAddress = this.getLocalAddress();
        if (socketAddress != null) {
            sb.append("port: ").append(socketAddress.getPort());
        }
        sb.append(")");
        return sb.toString();
    }
}

