/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.projection;

import de.bwaldvogel.mongo.backend.DefaultQueryMatcher;
import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.backend.QueryOperator;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.BadValueException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Projection {
    public static Document projectDocument(Document document, Document fields, String idField) {
        Projection.validateFields(fields);
        if (document == null) {
            return null;
        }
        Document newDocument = new Document();
        if (!fields.containsKey(idField)) {
            newDocument.put(idField, document.get(idField));
        }
        if (Projection.onlyExclusions(fields)) {
            newDocument.putAll(document);
            for (String excludedField : fields.keySet()) {
                newDocument.remove(excludedField);
            }
        } else {
            for (Map.Entry<String, Object> entry : fields.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (!Utils.isTrue(value)) continue;
                Projection.projectField(document, newDocument, key, value);
            }
        }
        return newDocument;
    }

    private static void validateFields(Document fields) {
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            Document document;
            Object value = entry.getValue();
            if (!(value instanceof Document) || (document = (Document)value).size() <= 1) continue;
            throw new BadValueException(">1 field in obj: " + document.toString(true, "{ ", " }"));
        }
    }

    private static boolean onlyExclusions(Document fields) {
        for (String key : fields.keySet()) {
            if (!Utils.isTrue(fields.get(key))) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void projectField(Document document, Document newDocument, String key, Object projectionValue) {
        if (key.contains(".")) {
            List<String> pathFragments = Utils.splitPath(key);
            String mainKey = pathFragments.get(0);
            String subKey = Utils.joinTail(pathFragments);
            Object object = document.get(mainKey);
            if (object instanceof Document) {
                Document subDocument = (Document)newDocument.computeIfAbsent(mainKey, k -> new Document());
                Projection.projectField((Document)object, subDocument, subKey, projectionValue);
                return;
            } else {
                if (!(object instanceof List)) return;
                List values = (List)object;
                List projectedValues = (List)newDocument.computeIfAbsent(mainKey, k -> new ArrayList());
                boolean wasEmpty = projectedValues.isEmpty();
                int idx = 0;
                if ("$".equals(subKey) && !values.isEmpty()) {
                    Object firstValue = values.get(0);
                    if (!(firstValue instanceof Document)) return;
                    projectedValues.add((Document)firstValue);
                    return;
                } else {
                    for (Object value : values) {
                        Document projectedDocument;
                        if (!(value instanceof Document)) continue;
                        if (wasEmpty) {
                            projectedDocument = new Document();
                            projectedValues.add(projectedDocument);
                        } else {
                            projectedDocument = (Document)projectedValues.get(idx);
                        }
                        Projection.projectField((Document)value, projectedDocument, subKey, projectionValue);
                        ++idx;
                    }
                }
            }
            return;
        } else {
            Object value = document.getOrMissing(key);
            if (projectionValue instanceof Document) {
                Document projectionDocument = (Document)projectionValue;
                if (projectionDocument.keySet().equals(Collections.singleton(QueryOperator.ELEM_MATCH.getValue()))) {
                    Document elemMatch = (Document)projectionDocument.get(QueryOperator.ELEM_MATCH.getValue());
                    Projection.projectElemMatch(newDocument, elemMatch, key, value);
                    return;
                } else {
                    if (!projectionDocument.keySet().equals(Collections.singleton("$slice"))) throw new IllegalArgumentException("Unsupported projection: " + projectionValue);
                    Object slice = projectionDocument.get("$slice");
                    Projection.projectSlice(newDocument, slice, key, value);
                }
                return;
            } else {
                if (value instanceof Missing) return;
                newDocument.put(key, value);
            }
        }
    }

    private static void projectElemMatch(Document newDocument, Document elemMatch, String key, Object value) {
        DefaultQueryMatcher queryMatcher = new DefaultQueryMatcher();
        if (value instanceof List) {
            ((List)value).stream().filter(sourceObject -> sourceObject instanceof Document).filter(sourceObject -> queryMatcher.matches((Document)sourceObject, elemMatch)).findFirst().ifPresent(v -> newDocument.put(key, (Object)Collections.singletonList(v)));
        }
    }

    private static void projectSlice(Document newDocument, Object slice, String key, Object value) {
        if (!(value instanceof List)) {
            newDocument.put(key, value);
            return;
        }
        List values = (List)value;
        int fromIndex = 0;
        int toIndex = values.size();
        if (slice instanceof Integer) {
            int num = (Integer)slice;
            if (num < 0) {
                fromIndex = values.size() + num;
            } else {
                toIndex = num;
            }
        } else if (slice instanceof List) {
            List sliceParams = (List)slice;
            if (sliceParams.size() != 2) {
                throw new BadValueException("$slice array wrong size");
            }
            if (sliceParams.get(0) instanceof Number) {
                fromIndex = ((Number)sliceParams.get(0)).intValue();
            }
            if (fromIndex < 0) {
                fromIndex += values.size();
            }
            int limit = 0;
            if (sliceParams.get(1) instanceof Number) {
                limit = ((Number)sliceParams.get(1)).intValue();
            }
            if (limit <= 0) {
                throw new BadValueException("$slice limit must be positive");
            }
            toIndex = fromIndex + limit;
        } else {
            throw new BadValueException("$slice only supports numbers and [skip, limit] arrays");
        }
        List slicedValue = values.subList(Math.max(0, fromIndex), Math.min(values.size(), toIndex));
        newDocument.put(key, (Object)slicedValue);
    }
}

