/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.ValueComparator;
import de.bwaldvogel.mongo.bson.Document;
import java.util.Comparator;

public class DocumentComparator
implements Comparator<Document> {
    private Document orderBy;

    public DocumentComparator(Document orderBy) {
        Assert.notNull(orderBy);
        Assert.notEmpty(orderBy.keySet());
        this.orderBy = orderBy;
    }

    @Override
    public int compare(Document document1, Document document2) {
        for (String sortKey : this.orderBy.keySet()) {
            Object value1 = Utils.getSubdocumentValue(document1, sortKey);
            Object value2 = Utils.getSubdocumentValue(document2, sortKey);
            ValueComparator comparator = ((Number)this.orderBy.get(sortKey)).intValue() > 0 ? ValueComparator.asc() : ValueComparator.desc();
            int cmp = comparator.compare(value1, value2);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }
}

