/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.log4j;

import com.sun.jna.Native;
import de.bwaldvogel.log4j.SystemdJournalLibrary;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

@Plugin(name="SystemdJournal", category="Core", elementType="appender", printObject=true)
public class SystemdJournalAppender
extends AbstractAppender {
    private final SystemdJournalLibrary journalLibrary;
    private final boolean logStacktrace;
    private final boolean logSource;
    private final boolean logThreadName;
    private final boolean logLoggerName;
    private final boolean logAppenderName;
    private final boolean logThreadContext;
    private final String threadContextPrefix;
    private final String syslogIdentifier;
    private final String syslogFacility;

    SystemdJournalAppender(String name, Filter filter, Layout<?> layout, boolean ignoreExceptions, SystemdJournalLibrary journalLibrary, boolean logSource, boolean logStacktrace, boolean logThreadName, boolean logLoggerName, boolean logAppenderName, boolean logThreadContext, String threadContextPrefix, String syslogIdentifier, String syslogFacility) {
        super(name, filter, layout, ignoreExceptions, null);
        this.journalLibrary = journalLibrary;
        this.logSource = logSource;
        this.logStacktrace = logStacktrace;
        this.logThreadName = logThreadName;
        this.logLoggerName = logLoggerName;
        this.logAppenderName = logAppenderName;
        this.logThreadContext = logThreadContext;
        this.threadContextPrefix = threadContextPrefix == null ? "THREAD_CONTEXT_" : SystemdJournalAppender.normalizeKey(threadContextPrefix);
        this.syslogIdentifier = syslogIdentifier;
        this.syslogFacility = syslogFacility;
    }

    @PluginFactory
    public static SystemdJournalAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="ignoreExceptions") String ignoreExceptionsString, @PluginAttribute(value="logSource") String logSourceString, @PluginAttribute(value="logStacktrace") String logStacktraceString, @PluginAttribute(value="logLoggerName") String logLoggerNameString, @PluginAttribute(value="logAppenderName") String logAppenderNameString, @PluginAttribute(value="logThreadName") String logThreadNameString, @PluginAttribute(value="logThreadContext") String logThreadContextString, @PluginAttribute(value="threadContextPrefix") String threadContextPrefix, @PluginAttribute(value="syslogIdentifier") String syslogIdentifier, @PluginAttribute(value="syslogFacility") String syslogFacility, @PluginElement(value="Layout") Layout<?> layout, @PluginElement(value="Filter") Filter filter, @PluginConfiguration Configuration config) {
        SystemdJournalLibrary journalLibrary;
        boolean ignoreExceptions = Booleans.parseBoolean((String)ignoreExceptionsString, (boolean)true);
        boolean logSource = Booleans.parseBoolean((String)logSourceString, (boolean)false);
        boolean logStacktrace = Booleans.parseBoolean((String)logStacktraceString, (boolean)true);
        boolean logThreadName = Booleans.parseBoolean((String)logThreadNameString, (boolean)true);
        boolean logLoggerName = Booleans.parseBoolean((String)logLoggerNameString, (boolean)true);
        boolean logAppenderName = Booleans.parseBoolean((String)logAppenderNameString, (boolean)true);
        boolean logThreadContext = Booleans.parseBoolean((String)logThreadContextString, (boolean)true);
        if (name == null) {
            LOGGER.error("No name provided for SystemdJournalAppender");
            return null;
        }
        try {
            journalLibrary = (SystemdJournalLibrary)Native.load((String)"systemd", SystemdJournalLibrary.class);
        }
        catch (UnsatisfiedLinkError e) {
            throw new RuntimeException("Failed to load systemd library. Please note that JNA requires an executable temporary folder. It can be explicitly defined with -Djna.tmpdir", e);
        }
        return new SystemdJournalAppender(name, filter, layout, ignoreExceptions, journalLibrary, logSource, logStacktrace, logThreadName, logLoggerName, logAppenderName, logThreadContext, threadContextPrefix, syslogIdentifier, syslogFacility);
    }

    private int log4jLevelToJournalPriority(Level level) {
        switch (level.getStandardLevel()) {
            case FATAL: {
                return 2;
            }
            case ERROR: {
                return 3;
            }
            case WARN: {
                return 4;
            }
            case INFO: {
                return 6;
            }
            case DEBUG: 
            case TRACE: {
                return 7;
            }
        }
        throw new IllegalArgumentException("Cannot map log level: " + level);
    }

    public void append(LogEvent event) {
        ReadOnlyStringMap context;
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.buildFormattedMessage(event));
        args.add("PRIORITY=%d");
        args.add(this.log4jLevelToJournalPriority(event.getLevel()));
        if (this.logThreadName) {
            args.add("THREAD_NAME=%s");
            args.add(event.getThreadName());
        }
        if (this.logLoggerName) {
            args.add("LOG4J_LOGGER=%s");
            args.add(event.getLoggerName());
        }
        if (this.logAppenderName) {
            args.add("LOG4J_APPENDER=%s");
            args.add(this.getName());
        }
        if (this.logStacktrace && event.getThrown() != null) {
            StringWriter stacktrace = new StringWriter();
            event.getThrown().printStackTrace(new PrintWriter(stacktrace));
            args.add("STACKTRACE=%s");
            args.add(stacktrace.toString());
        }
        if (this.logSource && event.getSource() != null) {
            String fileName = event.getSource().getFileName();
            args.add("CODE_FILE=%s");
            args.add(fileName);
            String methodName = event.getSource().getMethodName();
            args.add("CODE_FUNC=%s");
            args.add(methodName);
            int lineNumber = event.getSource().getLineNumber();
            args.add("CODE_LINE=%d");
            args.add(lineNumber);
        }
        if (this.logThreadContext && (context = event.getContextData()) != null) {
            for (Map.Entry entry : context.toMap().entrySet()) {
                String key = (String)entry.getKey();
                args.add(this.threadContextPrefix + SystemdJournalAppender.normalizeKey(key) + "=%s");
                args.add(entry.getValue());
            }
        }
        if (this.syslogIdentifier != null && !this.syslogIdentifier.isEmpty()) {
            args.add("SYSLOG_IDENTIFIER=%s");
            args.add(this.syslogIdentifier);
        }
        if (this.syslogFacility != null && !this.syslogFacility.isEmpty()) {
            args.add("SYSLOG_FACILITY=%d");
            args.add(Integer.valueOf(this.syslogFacility));
        }
        args.add(null);
        this.journalLibrary.sd_journal_send("MESSAGE=%s", args.toArray());
    }

    private String buildFormattedMessage(LogEvent event) {
        if (this.getLayout() != null) {
            byte[] message = this.getLayout().toByteArray(event);
            return new String(message, StandardCharsets.UTF_8);
        }
        return event.getMessage().getFormattedMessage();
    }

    private static String normalizeKey(String key) {
        return key.toUpperCase().replaceAll("[^_A-Z0-9]", "_");
    }
}

