/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.log4j;

import com.sun.jna.Native;
import de.bwaldvogel.log4j.SystemdJournalLibrary;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.util.Booleans;

@Plugin(name="SystemdJournal", category="Core", elementType="appender", printObject=true)
public class SystemdJournalAppender
extends AbstractAppender {
    private final SystemdJournalLibrary journalLibrary;
    private final boolean logStacktrace;
    private final boolean logSource;
    private final boolean logThreadName;
    private final boolean logLoggerName;
    private final boolean logThreadContext;
    private final String threadContextPrefix;

    SystemdJournalAppender(String name, Filter filter, boolean ignoreExceptions, SystemdJournalLibrary journalLibrary, boolean logSource, boolean logStacktrace, boolean logThreadName, boolean logLoggerName, boolean logThreadContext, String threadContextPrefix) {
        super(name, filter, null, ignoreExceptions);
        this.journalLibrary = journalLibrary;
        this.logSource = logSource;
        this.logStacktrace = logStacktrace;
        this.logThreadName = logThreadName;
        this.logLoggerName = logLoggerName;
        this.logThreadContext = logThreadContext;
        this.threadContextPrefix = threadContextPrefix == null ? "THREAD_CONTEXT_" : SystemdJournalAppender.normalizeKey(threadContextPrefix);
    }

    @PluginFactory
    public static SystemdJournalAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="ignoreExceptions") String ignoreExceptionsString, @PluginAttribute(value="logSource") String logSourceString, @PluginAttribute(value="logStacktrace") String logStacktraceString, @PluginAttribute(value="logLoggerName") String logLoggerNameString, @PluginAttribute(value="logThreadName") String logThreadNameString, @PluginAttribute(value="logThreadContext") String logThreadContextString, @PluginAttribute(value="threadContextPrefix") String threadContextPrefix, @PluginElement(value="Filter") Filter filter, @PluginConfiguration Configuration config) {
        boolean ignoreExceptions = Booleans.parseBoolean((String)ignoreExceptionsString, (boolean)true);
        boolean logSource = Booleans.parseBoolean((String)logSourceString, (boolean)false);
        boolean logStacktrace = Booleans.parseBoolean((String)logStacktraceString, (boolean)true);
        boolean logThreadName = Booleans.parseBoolean((String)logThreadNameString, (boolean)true);
        boolean logLoggerName = Booleans.parseBoolean((String)logLoggerNameString, (boolean)true);
        boolean logThreadContext = Booleans.parseBoolean((String)logThreadContextString, (boolean)true);
        if (name == null) {
            LOGGER.error("No name provided for FileAppender");
            return null;
        }
        SystemdJournalLibrary journalLibrary = (SystemdJournalLibrary)Native.loadLibrary((String)"systemd-journal", SystemdJournalLibrary.class);
        return new SystemdJournalAppender(name, filter, ignoreExceptions, journalLibrary, logSource, logStacktrace, logThreadName, logLoggerName, logThreadContext, threadContextPrefix);
    }

    private int log4jLevelToJournalPriority(Level level) {
        switch (level.getStandardLevel()) {
            case FATAL: {
                return 2;
            }
            case ERROR: {
                return 3;
            }
            case WARN: {
                return 4;
            }
            case INFO: {
                return 6;
            }
            case DEBUG: 
            case TRACE: {
                return 7;
            }
        }
        throw new IllegalArgumentException("Cannot map log level: " + level);
    }

    public void append(LogEvent event) {
        Map context;
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(event.getMessage().getFormattedMessage());
        args.add("PRIORITY=%d");
        args.add(this.log4jLevelToJournalPriority(event.getLevel()));
        if (this.logThreadName) {
            args.add("THREAD_NAME=%s");
            args.add(event.getThreadName());
        }
        if (this.logLoggerName) {
            args.add("LOG4J_LOGGER=%s");
            args.add(event.getLoggerName());
        }
        if (this.logStacktrace && event.getThrown() != null) {
            StringWriter stacktrace = new StringWriter();
            event.getThrown().printStackTrace(new PrintWriter(stacktrace));
            args.add("STACKTRACE=%s");
            args.add(stacktrace.toString());
        }
        if (this.logSource && event.getSource() != null) {
            String fileName = event.getSource().getFileName();
            args.add("CODE_FILE=%s");
            args.add(fileName);
            String methodName = event.getSource().getMethodName();
            args.add("CODE_FUNC=%s");
            args.add(methodName);
            int lineNumber = event.getSource().getLineNumber();
            args.add("CODE_LINE=%d");
            args.add(lineNumber);
        }
        if (this.logThreadContext && (context = event.getContextMap()) != null) {
            for (Map.Entry entry : context.entrySet()) {
                String key = (String)entry.getKey();
                args.add(this.threadContextPrefix + SystemdJournalAppender.normalizeKey(key) + "=%s");
                args.add(entry.getValue());
            }
        }
        this.journalLibrary.sd_journal_send("MESSAGE=%s", args.toArray());
    }

    private static String normalizeKey(String key) {
        return key.toUpperCase().replaceAll("[^_A-Z0-9]", "_");
    }
}

