/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.log4j;

import com.sun.jna.Native;
import de.bwaldvogel.log4j.SystemdJournalLibrary;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

public class SystemdJournalAppender
extends AppenderSkeleton {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final SystemdJournalLibrary journalLibrary;
    private boolean logStacktrace = true;
    private boolean logThreadName = true;
    private boolean logLoggerName = true;
    private boolean logMdc = true;
    private String mdcPrefix = "LOG4J_MDC_";
    private String syslogIdentifier;

    public SystemdJournalAppender() {
        this.journalLibrary = (SystemdJournalLibrary)Native.loadLibrary((String)"systemd", SystemdJournalLibrary.class);
    }

    SystemdJournalAppender(SystemdJournalLibrary journalLibrary) {
        this.journalLibrary = journalLibrary;
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    private int log4jLevelToJournalPriority(Level level) {
        switch (level.toInt()) {
            case 50000: {
                return 2;
            }
            case 40000: {
                return 3;
            }
            case 30000: {
                return 4;
            }
            case 20000: {
                return 6;
            }
            case 5000: 
            case 10000: {
                return 7;
            }
        }
        throw new IllegalArgumentException("Cannot map log level: " + level);
    }

    protected void append(LoggingEvent event) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(event.getRenderedMessage());
        args.add("PRIORITY=%d");
        args.add(this.log4jLevelToJournalPriority(event.getLevel()));
        if (this.syslogIdentifier != null && !this.syslogIdentifier.isEmpty()) {
            args.add("SYSLOG_IDENTIFIER=%s");
            args.add(this.syslogIdentifier);
        }
        if (this.logThreadName) {
            args.add("THREAD_NAME=%s");
            args.add(event.getThreadName());
        }
        if (this.logLoggerName) {
            args.add("LOG4J_LOGGER=%s");
            args.add(event.getLogger().getName());
        }
        if (this.logStacktrace && event.getThrowableStrRep() != null) {
            StringBuilder sb = new StringBuilder();
            for (String stackTrace : event.getThrowableStrRep()) {
                sb.append(stackTrace).append(LINE_SEPARATOR);
            }
            args.add("STACKTRACE=%s");
            args.add(sb.toString());
        }
        Map properties = event.getProperties();
        if (this.logMdc && properties != null) {
            for (Map.Entry entry : properties.entrySet()) {
                Object key = entry.getKey();
                args.add(this.mdcPrefix + SystemdJournalAppender.normalizeKey(key) + "=%s");
                args.add(entry.getValue().toString());
            }
        }
        args.add(null);
        this.journalLibrary.sd_journal_send("MESSAGE=%s", args.toArray());
    }

    private static String normalizeKey(Object key) {
        return key.toString().toUpperCase().replaceAll("[^_A-Z0-9]", "_");
    }

    public void setLogStacktrace(boolean logStacktrace) {
        this.logStacktrace = logStacktrace;
    }

    public void setLogThreadName(boolean logThreadName) {
        this.logThreadName = logThreadName;
    }

    public void setLogLoggerName(boolean logLoggerName) {
        this.logLoggerName = logLoggerName;
    }

    public void setLogMdc(boolean logMdc) {
        this.logMdc = logMdc;
    }

    public void setMdcPrefix(String mdcPrefix) {
        this.mdcPrefix = SystemdJournalAppender.normalizeKey(mdcPrefix);
    }

    public String getSyslogIdentifier() {
        return this.syslogIdentifier;
    }

    public void setSyslogIdentifier(String syslogIdentifier) {
        this.syslogIdentifier = syslogIdentifier;
    }
}

