/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.log4j;

import de.bwaldvogel.log4j.SystemdJournalAdapter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.MDC;
import org.apache.log4j.spi.LoggingEvent;

public class SystemdJournalAppender
extends AppenderSkeleton {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    private String log4jLevelToJournalPriority(Level level) {
        if (level == Level.FATAL) {
            return "2";
        }
        if (level == Level.ERROR) {
            return "3";
        }
        if (level == Level.WARN) {
            return "4";
        }
        if (level == Level.INFO) {
            return "6";
        }
        if (level == Level.DEBUG) {
            return "7";
        }
        throw new IllegalArgumentException("Cannot map log level: " + level);
    }

    protected void append(LoggingEvent event) {
        String[] keys;
        Hashtable context;
        HashMap<String, String> logData = new HashMap<String, String>();
        logData.put("MESSAGE", event.getRenderedMessage());
        logData.put("PRIORITY", this.log4jLevelToJournalPriority(event.getLevel()));
        logData.put("THREAD_NAME", event.getThreadName());
        logData.put("LOG4J_LOGGER", event.getLogger().getName());
        if (event.getThrowableStrRep() != null) {
            StringBuilder sb = new StringBuilder();
            for (String stackTrace : event.getThrowableStrRep()) {
                sb.append(stackTrace).append(LINE_SEPARATOR);
            }
            logData.put("EXCEPTION", sb.toString());
        }
        if ((context = MDC.getContext()) != null) {
            keys = context.keys();
            while (keys.hasMoreElements()) {
                Object nextElement = keys.nextElement();
                String key = "LOG4J_MDC_" + nextElement;
                logData.put(key, context.get(nextElement).toString());
            }
        }
        keys = new String[logData.size()];
        String[] values = new String[logData.size()];
        int i = 0;
        for (Map.Entry entry : logData.entrySet()) {
            keys[i] = ((String)entry.getKey()).toUpperCase().replaceAll("[^_A-Z0-9]", "_");
            values[i] = (String)entry.getValue();
            ++i;
        }
        assert (logData.size() == keys.length);
        assert (logData.size() == values.length);
        SystemdJournalAdapter.sendv(logData.size(), keys, values);
    }
}

