/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.liblinear;

import de.bwaldvogel.liblinear.SolverType;
import java.util.Arrays;

public final class Parameter
implements Cloneable {
    double C;
    double eps;
    int max_iters = 1000;
    SolverType solverType;
    double[] weight = null;
    int[] weightLabel = null;
    double p = 0.1;
    double nu = 0.5;
    double[] init_sol = null;
    boolean regularize_bias = true;

    public Parameter(SolverType solver, double C, double eps) {
        this.setSolverType(solver);
        this.setC(C);
        this.setEps(eps);
    }

    public Parameter(SolverType solver, double C, int max_iters, double eps) {
        this.setSolverType(solver);
        this.setC(C);
        this.setEps(eps);
        this.setMaxIters(max_iters);
    }

    public Parameter(SolverType solverType, double C, double eps, double p) {
        this.setSolverType(solverType);
        this.setC(C);
        this.setEps(eps);
        this.setP(p);
    }

    public Parameter(SolverType solverType, double C, double eps, int max_iters, double p) {
        this.setSolverType(solverType);
        this.setC(C);
        this.setEps(eps);
        this.setMaxIters(max_iters);
        this.setP(p);
    }

    public void setWeights(double[] weights, int[] weightLabels) {
        if (weights == null) {
            throw new IllegalArgumentException("'weight' must not be null");
        }
        if (weightLabels == null || weightLabels.length != weights.length) {
            throw new IllegalArgumentException("'weightLabels' must have same length as 'weight'");
        }
        this.weightLabel = Arrays.copyOf(weightLabels, weightLabels.length);
        this.weight = Arrays.copyOf(weights, weights.length);
    }

    public double[] getWeights() {
        if (this.weight == null) {
            return null;
        }
        return Arrays.copyOf(this.weight, this.weight.length);
    }

    public int[] getWeightLabels() {
        if (this.weightLabel == null) {
            return null;
        }
        return Arrays.copyOf(this.weightLabel, this.weightLabel.length);
    }

    public int getNumWeights() {
        if (this.weight == null) {
            return 0;
        }
        return this.weight.length;
    }

    public void setC(double C) {
        if (C <= 0.0) {
            throw new IllegalArgumentException("C must not be <= 0");
        }
        this.C = C;
    }

    public double getC() {
        return this.C;
    }

    public void setEps(double eps) {
        if (eps <= 0.0) {
            throw new IllegalArgumentException("eps must not be <= 0");
        }
        this.eps = eps;
    }

    public double getEps() {
        return this.eps;
    }

    public void setMaxIters(int iters) {
        if (iters <= 0) {
            throw new IllegalArgumentException("max iters not be <= 0");
        }
        this.max_iters = iters;
    }

    public int getMaxIters() {
        return this.max_iters;
    }

    public void setSolverType(SolverType solverType) {
        if (solverType == null) {
            throw new IllegalArgumentException("solver type must not be null");
        }
        this.solverType = solverType;
    }

    public SolverType getSolverType() {
        return this.solverType;
    }

    public void setP(double p) {
        if (p < 0.0) {
            throw new IllegalArgumentException("p must not be less than 0");
        }
        this.p = p;
    }

    public double getP() {
        return this.p;
    }

    public void setInitSol(double[] init_sol) {
        this.init_sol = (double[])(init_sol == null ? null : Arrays.copyOf(init_sol, init_sol.length));
    }

    public double[] getInitSol() {
        if (this.init_sol == null) {
            return null;
        }
        return Arrays.copyOf(this.init_sol, this.init_sol.length);
    }

    public void setNu(double nu) {
        if (nu <= 0.0) {
            throw new IllegalArgumentException("nu must not be <=0");
        }
        if (nu >= 1.0) {
            throw new IllegalArgumentException("nu must not be >=1");
        }
        this.nu = nu;
    }

    public double getNu() {
        return this.nu;
    }

    public void setRegularizeBias(boolean regularizeBias) {
        this.regularize_bias = regularizeBias;
    }

    public boolean isRegularizeBias() {
        return this.regularize_bias;
    }

    public Parameter clone() {
        Parameter clone = new Parameter(this.solverType, this.C, this.eps, this.max_iters, this.p);
        clone.weight = this.weight == null ? null : (double[])this.weight.clone();
        clone.weightLabel = this.weightLabel == null ? null : (int[])this.weightLabel.clone();
        clone.init_sol = this.init_sol;
        clone.p = this.p;
        clone.nu = this.nu;
        clone.regularize_bias = this.regularize_bias;
        return clone;
    }
}

