/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.liblinear;

import de.bwaldvogel.liblinear.Feature;
import de.bwaldvogel.liblinear.L2R_ErmFunction;
import de.bwaldvogel.liblinear.Parameter;
import de.bwaldvogel.liblinear.Problem;
import de.bwaldvogel.liblinear.SparseOperator;

class L2R_LrFunction
extends L2R_ErmFunction {
    private final double[] D;

    L2R_LrFunction(Problem prob, Parameter param, double[] C) {
        super(prob, param, C);
        int l = prob.l;
        this.D = new double[l];
    }

    @Override
    protected double C_times_loss(int i, double wx_i) {
        double ywx_i = wx_i * this.prob.y[i];
        if (ywx_i >= 0.0) {
            return this.C[i] * Math.log(1.0 + Math.exp(-ywx_i));
        }
        return this.C[i] * (-ywx_i + Math.log(1.0 + Math.exp(ywx_i)));
    }

    @Override
    public void grad(double[] w, double[] g) {
        int i;
        double[] y = this.prob.y;
        int l = this.prob.l;
        int w_size = this.get_nr_variable();
        for (i = 0; i < l; ++i) {
            this.tmp[i] = 1.0 / (1.0 + Math.exp(-y[i] * this.wx[i]));
            this.D[i] = this.tmp[i] * (1.0 - this.tmp[i]);
            this.tmp[i] = this.C[i] * (this.tmp[i] - 1.0) * y[i];
        }
        this.XTv(this.tmp, g);
        for (i = 0; i < w_size; ++i) {
            g[i] = w[i] + g[i];
        }
        if (!this.regularize_bias) {
            int n = w_size - 1;
            g[n] = g[n] - w[w_size - 1];
        }
    }

    @Override
    public void get_diag_preconditioner(double[] M) {
        int i;
        int l = this.prob.l;
        int w_size = this.get_nr_variable();
        Feature[][] x = this.prob.x;
        for (i = 0; i < w_size; ++i) {
            M[i] = 1.0;
        }
        if (!this.regularize_bias) {
            M[w_size - 1] = 0.0;
        }
        for (i = 0; i < l; ++i) {
            for (Feature xi : x[i]) {
                int n = xi.getIndex() - 1;
                M[n] = M[n] + xi.getValue() * xi.getValue() * this.C[i] * this.D[i];
            }
        }
    }

    @Override
    public void Hv(double[] s, double[] Hs) {
        int i;
        int l = this.prob.l;
        int w_size = this.get_nr_variable();
        Feature[][] x = this.prob.x;
        for (i = 0; i < w_size; ++i) {
            Hs[i] = 0.0;
        }
        for (i = 0; i < l; ++i) {
            Feature[] xi = x[i];
            double xTs = SparseOperator.dot(s, xi);
            xTs = this.C[i] * this.D[i] * xTs;
            SparseOperator.axpy(xTs, xi, Hs);
        }
        for (i = 0; i < w_size; ++i) {
            Hs[i] = s[i] + Hs[i];
        }
        if (!this.regularize_bias) {
            int n = w_size - 1;
            Hs[n] = Hs[n] - s[w_size - 1];
        }
    }
}

