/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.liblinear;

import de.bwaldvogel.liblinear.Feature;
import de.bwaldvogel.liblinear.Linear;

class Heap {
    private int size = 0;
    private final HeapType type;
    private final Feature[] a;

    Heap(int max_size, HeapType type) {
        this.a = new Feature[max_size];
        this.type = type;
    }

    private boolean cmp(Feature left, Feature right) {
        if (this.type == HeapType.MIN) {
            return left.getValue() > right.getValue();
        }
        return left.getValue() < right.getValue();
    }

    int size() {
        return this.size;
    }

    void push(Feature node) {
        int p;
        this.a[this.size] = node;
        ++this.size;
        int i = this.size - 1;
        while (i > 0 && this.cmp(this.a[p = (i - 1) / 2], this.a[i])) {
            Linear.swap(this.a, i, p);
            i = p;
        }
    }

    void pop() {
        --this.size;
        this.a[0] = this.a[this.size];
        int i = 0;
        while (i * 2 + 1 < this.size) {
            int l = i * 2 + 1;
            int r = i * 2 + 2;
            if (r < this.size && this.cmp(this.a[l], this.a[r])) {
                l = r;
            }
            if (!this.cmp(this.a[i], this.a[l])) break;
            Linear.swap(this.a, i, l);
            i = l;
        }
    }

    Feature top() {
        return this.a[0];
    }

    static enum HeapType {
        MIN,
        MAX;

    }
}

