/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.liblinear;

import de.bwaldvogel.liblinear.Feature;
import de.bwaldvogel.liblinear.Function;
import de.bwaldvogel.liblinear.Problem;
import de.bwaldvogel.liblinear.SparseOperator;

class L2R_LrFunction
implements Function {
    private final double[] C;
    private final double[] z;
    private final double[] D;
    private final Problem prob;

    public L2R_LrFunction(Problem prob, double[] C) {
        int l = prob.l;
        this.prob = prob;
        this.z = new double[l];
        this.D = new double[l];
        this.C = C;
    }

    private void Xv(double[] v, double[] Xv) {
        int l = this.prob.l;
        Feature[][] x = this.prob.x;
        for (int i = 0; i < l; ++i) {
            Xv[i] = SparseOperator.dot(v, x[i]);
        }
    }

    private void XTv(double[] v, double[] XTv) {
        int i;
        int l = this.prob.l;
        int w_size = this.get_nr_variable();
        Feature[][] x = this.prob.x;
        for (i = 0; i < w_size; ++i) {
            XTv[i] = 0.0;
        }
        for (i = 0; i < l; ++i) {
            SparseOperator.axpy(v[i], x[i], XTv);
        }
    }

    @Override
    public double fun(double[] w) {
        int i;
        double f = 0.0;
        double[] y = this.prob.y;
        int l = this.prob.l;
        int w_size = this.get_nr_variable();
        this.Xv(w, this.z);
        for (i = 0; i < w_size; ++i) {
            f += w[i] * w[i];
        }
        f /= 2.0;
        for (i = 0; i < l; ++i) {
            double yz = y[i] * this.z[i];
            if (yz >= 0.0) {
                f += this.C[i] * Math.log(1.0 + Math.exp(-yz));
                continue;
            }
            f += this.C[i] * (-yz + Math.log(1.0 + Math.exp(yz)));
        }
        return f;
    }

    @Override
    public void grad(double[] w, double[] g) {
        int i;
        double[] y = this.prob.y;
        int l = this.prob.l;
        int w_size = this.get_nr_variable();
        for (i = 0; i < l; ++i) {
            this.z[i] = 1.0 / (1.0 + Math.exp(-y[i] * this.z[i]));
            this.D[i] = this.z[i] * (1.0 - this.z[i]);
            this.z[i] = this.C[i] * (this.z[i] - 1.0) * y[i];
        }
        this.XTv(this.z, g);
        for (i = 0; i < w_size; ++i) {
            g[i] = w[i] + g[i];
        }
    }

    @Override
    public void Hv(double[] s, double[] Hs) {
        int i;
        int l = this.prob.l;
        int w_size = this.get_nr_variable();
        Feature[][] x = this.prob.x;
        for (i = 0; i < w_size; ++i) {
            Hs[i] = 0.0;
        }
        for (i = 0; i < l; ++i) {
            Feature[] xi = x[i];
            double xTs = SparseOperator.dot(s, xi);
            xTs = this.C[i] * this.D[i] * xTs;
            SparseOperator.axpy(xTs, xi, Hs);
        }
        for (i = 0; i < w_size; ++i) {
            Hs[i] = s[i] + Hs[i];
        }
    }

    @Override
    public int get_nr_variable() {
        return this.prob.n;
    }
}

