/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.serviceapi.core.serviceimpl;

import de.bund.bva.isyfact.logging.IsyLogger;
import de.bund.bva.isyfact.logging.IsyLoggerFactory;
import de.bund.bva.isyfact.logging.LogKategorie;
import de.bund.bva.isyfact.serviceapi.core.serviceimpl.MethodMapSicherheitAttributeSource;
import de.bund.bva.isyfact.serviceapi.core.serviceimpl.Validatable;
import de.bund.bva.isyfact.sicherheit.annotation.GesichertInterceptor;
import de.bund.bva.isyfact.sicherheit.annotation.SicherheitAttributeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.interceptor.TransactionProxyFactoryBean;

@Deprecated
public class ServiceFactoryBean
extends TransactionProxyFactoryBean {
    private static final long serialVersionUID = 1L;
    private static final IsyLogger LOG = IsyLoggerFactory.getLogger(ServiceFactoryBean.class);
    private final List<Object> interceptors = new ArrayList<Object>();
    private Class<?> remoteBeanInterface;
    private Object target;
    private Map<String, String[]> benoetigtesRecht;
    private boolean validateConfiguration = true;

    public void setRemoteBeanInterface(Class<?> remoteBeanInterface) {
        if (!remoteBeanInterface.isInterface()) {
            throw new IllegalArgumentException(remoteBeanInterface.getName() + " ist kein Interface");
        }
        this.setProxyInterfaces(new Class[]{remoteBeanInterface});
        this.remoteBeanInterface = remoteBeanInterface;
    }

    public void setPreInterceptors(Object[] preInterceptors) {
        super.setPreInterceptors(preInterceptors);
        this.interceptors.addAll(Arrays.asList(preInterceptors));
    }

    public void setPostInterceptors(Object[] postInterceptors) {
        super.setPostInterceptors(postInterceptors);
        this.interceptors.addAll(Arrays.asList(postInterceptors));
    }

    public void setTarget(Object target) {
        super.setTarget(target);
        this.target = target;
    }

    public void setBenoetigtesRecht(Map<String, String[]> benoetigtesRecht) {
        this.benoetigtesRecht = benoetigtesRecht;
    }

    public void setValidateConfiguration(boolean validateConfiguration) {
        this.validateConfiguration = validateConfiguration;
    }

    public void afterPropertiesSet() {
        GesichertInterceptor gesichert;
        if (this.benoetigtesRecht != null && this.benoetigtesRecht.size() > 0 && (gesichert = this.getInterceptor(GesichertInterceptor.class)) != null) {
            SicherheitAttributeSource sicherheitAttributeSource = gesichert.getSicherheitAttributeSource();
            if (!(sicherheitAttributeSource instanceof MethodMapSicherheitAttributeSource)) {
                throw new IllegalArgumentException("Die Konfiguration der ben\u00f6tigten Rechte erfordert eine " + MethodMapSicherheitAttributeSource.class.getSimpleName() + " im " + GesichertInterceptor.class.getName() + ", konfiguriert ist aber eine " + sicherheitAttributeSource.getClass().getName());
            }
            MethodMapSicherheitAttributeSource methodMapSicherheitAttributeSource = (MethodMapSicherheitAttributeSource)sicherheitAttributeSource;
            for (Map.Entry<String, String[]> entry : this.benoetigtesRecht.entrySet()) {
                if (entry.getKey().contains(".")) {
                    throw new IllegalArgumentException("Ung\u00fcltiger Punkt in Methoden-Pattern '" + entry.getKey() + "' in Konfiguration des Service " + this.remoteBeanInterface.getName());
                }
                methodMapSicherheitAttributeSource.addGesichertMethod(this.remoteBeanInterface.getName() + "." + entry.getKey(), entry.getValue());
            }
        }
        if (this.validateConfiguration) {
            LOG.info(LogKategorie.JOURNAL, "EPLSAC00004", "Validiere Konfiguration f\u00fcr Service-Implementierung {}", new Object[]{this.remoteBeanInterface.getName()});
            for (Object interceptor : this.interceptors) {
                if (!(interceptor instanceof Validatable)) continue;
                ((Validatable)interceptor).validateConfiguration(this.remoteBeanInterface, this.target);
            }
        }
        super.afterPropertiesSet();
    }

    private <T> T getInterceptor(Class<T> interceptorClass) {
        for (Object interceptor : this.interceptors) {
            if (!interceptorClass.isInstance(interceptor)) continue;
            return interceptorClass.cast(interceptor);
        }
        return null;
    }
}

