/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.serviceapi.core.serviceimpl;

import de.bund.bva.isyfact.exception.BaseException;
import de.bund.bva.isyfact.exception.TechnicalRuntimeException;
import de.bund.bva.isyfact.logging.IsyLogger;
import de.bund.bva.isyfact.logging.IsyLoggerFactory;
import de.bund.bva.isyfact.logging.LogKategorie;
import de.bund.bva.isyfact.serviceapi.common.exception.ExceptionMapper;
import de.bund.bva.isyfact.serviceapi.core.serviceimpl.AusnahmeIdErmittler;
import de.bund.bva.isyfact.serviceapi.core.serviceimpl.ExceptionMappingSource;
import de.bund.bva.isyfact.serviceapi.core.serviceimpl.MethodMappingSource;
import de.bund.bva.isyfact.serviceapi.core.serviceimpl.Validatable;
import de.bund.bva.pliscommon.exception.service.PlisTechnicalToException;
import de.bund.bva.pliscommon.exception.service.PlisToException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;

@Deprecated
public class ServiceExceptionFassade
implements MethodInterceptor,
Validatable {
    private static final IsyLogger LOG = IsyLoggerFactory.getLogger(ServiceExceptionFassade.class);
    private final MethodMappingSource methodMappingSource;
    private final ExceptionMappingSource exceptionMappingSource;
    private final AusnahmeIdErmittler ausnahmeIdErmittler;
    private Constructor<? extends TechnicalRuntimeException> appTechnicalRuntimeExceptionCon;
    private String logLevelExceptions = "ERROR";

    public ServiceExceptionFassade(MethodMappingSource methodMappingSource, ExceptionMappingSource exceptionMappingSource, AusnahmeIdErmittler ausnahmeIdErmittler, Class<? extends TechnicalRuntimeException> appTechnicalRuntimeException) {
        this.methodMappingSource = methodMappingSource;
        this.exceptionMappingSource = exceptionMappingSource;
        this.ausnahmeIdErmittler = ausnahmeIdErmittler;
        this.setAppTechnicalRuntimeException(appTechnicalRuntimeException);
    }

    private void setAppTechnicalRuntimeException(Class<? extends TechnicalRuntimeException> appTechnicalRuntimeException) {
        try {
            this.appTechnicalRuntimeExceptionCon = appTechnicalRuntimeException.getConstructor(String.class, Throwable.class, String[].class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Die Klasse " + appTechnicalRuntimeException.getName() + " hat nicht den ben\u00f6tigten Konstruktor (String ausnahmeId, Throwable cause, String... parameter)");
        }
    }

    public void setLogLevelExceptions(String logLevelExceptions) {
        this.logLevelExceptions = logLevelExceptions;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method remoteBeanMethod = invocation.getMethod();
        try {
            return invocation.proceed();
        }
        catch (BaseException e) {
            Class<? extends PlisToException> targetExceptionClass;
            if (this.logLevelExceptions != null) {
                switch (this.logLevelExceptions) {
                    case "INFO": {
                        LOG.info(LogKategorie.JOURNAL, "Fehler in der Serviceoperation {}", e, new Object[]{this.getMethodSignatureString(invocation)});
                        break;
                    }
                    case "DEBUG": {
                        LOG.debug("Fehler in der Serviceoperation {}: {}", new Object[]{this.getMethodSignatureString(invocation), e.getMessage()});
                        break;
                    }
                    case "WARN": {
                        LOG.warn("Fehler in der Serviceoperation {}", e, new Object[]{this.getMethodSignatureString(invocation)});
                        break;
                    }
                    case "ERROR": {
                        LOG.error("Fehler in der Serviceoperation {}", e, new Object[]{this.getMethodSignatureString(invocation)});
                        break;
                    }
                    case "FATAL": {
                        LOG.fatal("Fehler in der Serviceoperation {}", e, new Object[]{this.getMethodSignatureString(invocation)});
                        break;
                    }
                    case "TRACE": {
                        LOG.trace("Fehler in der Serviceoperation {}: {}", new Object[]{this.getMethodSignatureString(invocation), e.getMessage()});
                    }
                }
            }
            if ((targetExceptionClass = this.exceptionMappingSource.getToExceptionClass(remoteBeanMethod, ((Object)((Object)e)).getClass())) == null) {
                targetExceptionClass = this.exceptionMappingSource.getGenericTechnicalToException(remoteBeanMethod);
                LOG.warn("EPLSAC00002", "F\u00fcr die Serviceoperation {} ist kein Exception-Mapping f\u00fcr Exceptionklasse {} definiert. Benutze stattdessen technische TO-Exception {}", new Object[]{this.getMethodSignatureString(invocation), ((Object)((Object)e)).getClass(), targetExceptionClass.getName()});
            }
            throw ExceptionMapper.mapException(e, targetExceptionClass);
        }
        catch (TechnicalRuntimeException e) {
            LOG.error("Fehler in der Serviceoperation {}", e, new Object[]{this.getMethodSignatureString(invocation)});
            throw ExceptionMapper.mapException(e, this.exceptionMappingSource.getGenericTechnicalToException(remoteBeanMethod));
        }
        catch (Throwable t) {
            TechnicalRuntimeException runtimeException = null;
            try {
                runtimeException = this.appTechnicalRuntimeExceptionCon.newInstance(this.ausnahmeIdErmittler.ermittleAusnahmeId(t), t, new String[]{Optional.ofNullable(t.getMessage()).orElse("<Kein Fehlertext>")});
                LOG.error("Fehler in der Serviceoperation ", runtimeException, new Object[]{this.getMethodSignatureString(invocation)});
            }
            catch (Throwable t2) {
                LOG.error("EPLSAC00003", "Fehler bei der Fehlerbehandlung", t2, new Object[0]);
                LOG.error("EPLSAC00003", "Uspr\u00fcnglicher Fehler war {}", t, new Object[]{t.getMessage()});
            }
            throw ExceptionMapper.mapException(runtimeException, this.exceptionMappingSource.getGenericTechnicalToException(remoteBeanMethod));
        }
    }

    protected String getMethodSignatureString(MethodInvocation invocation) {
        Method method = invocation.getMethod();
        return this.getMethodSignatureString(method);
    }

    protected String getMethodSignatureString(Method method) {
        return method.getDeclaringClass().getName() + "." + method.getName();
    }

    @Override
    public void validateConfiguration(Class<?> remoteBeanInterface, Object target) {
        Class targetClass = AopUtils.getTargetClass((Object)target);
        for (Method remoteBeanMethod : remoteBeanInterface.getMethods()) {
            Class<? extends PlisTechnicalToException> genericTechnicalToExceptionClass = this.exceptionMappingSource.getGenericTechnicalToException(remoteBeanMethod);
            if (genericTechnicalToExceptionClass == null) {
                throw new IllegalStateException("Fehler in der statischen Konfiguration der Exception-Fassade f\u00fcr " + remoteBeanInterface.getName() + ": Keine generische TO-Exception definiert");
            }
            if (!Arrays.asList(remoteBeanMethod.getExceptionTypes()).contains(genericTechnicalToExceptionClass)) {
                throw new IllegalStateException("Fehler in der statischen Konfiguration der Exception-Fassade f\u00fcr " + this.getMethodSignatureString(remoteBeanMethod) + ": Die generische TO-Exception " + genericTechnicalToExceptionClass.getSimpleName() + " ist nicht im RemoteBean-Interface deklariert");
            }
            Method coreMethod = this.methodMappingSource.getTargetMethod(remoteBeanMethod, targetClass);
            for (Class<?> exceptionClass : coreMethod.getExceptionTypes()) {
                if (!BaseException.class.isAssignableFrom(exceptionClass)) continue;
                Class<?> isyExceptionClass = exceptionClass;
                Class<? extends PlisToException> toExceptionClass = this.exceptionMappingSource.getToExceptionClass(remoteBeanMethod, isyExceptionClass);
                if (toExceptionClass == null) {
                    throw new IllegalStateException("Fehler in der statischen Konfiguration der Exception-Fassade f\u00fcr " + this.getMethodSignatureString(remoteBeanMethod) + ": Keine TO-Exception f\u00fcr AWK-Exception " + isyExceptionClass.getSimpleName() + " definiert");
                }
                if (Arrays.asList(remoteBeanMethod.getExceptionTypes()).contains(toExceptionClass)) continue;
                throw new IllegalStateException("Fehler in der statischen Konfiguration der Exception-Fassade f\u00fcr " + this.getMethodSignatureString(remoteBeanMethod) + ": Die TO-Exception " + toExceptionClass.getSimpleName() + " ist nicht im RemoteBean-Interface deklariert");
            }
        }
    }
}

