/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.serviceapi.core.httpinvoker;

import de.bund.bva.isyfact.logging.IsyLogger;
import de.bund.bva.isyfact.logging.IsyLoggerFactory;
import de.bund.bva.isyfact.logging.util.LogHelper;
import de.bund.bva.isyfact.logging.util.MdcHelper;
import de.bund.bva.isyfact.serviceapi.core.aufrufkontext.AufrufKontextToResolver;
import de.bund.bva.pliscommon.serviceapi.service.httpinvoker.v1_0_0.AufrufKontextTo;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.UUID;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.remoting.httpinvoker.HttpInvokerClientInterceptor;
import org.springframework.remoting.support.RemoteInvocationFactory;

@Deprecated
public class IsyHttpInvokerClientInterceptor
extends HttpInvokerClientInterceptor {
    private static final IsyLogger LOGGER = IsyLoggerFactory.getLogger(IsyHttpInvokerClientInterceptor.class);
    private LogHelper logHelper = new LogHelper(false, false, true, false, false, 0L);
    private String remoteSystemName;
    private AufrufKontextToResolver aufrufKontextToResolver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        String korrelationsId = UUID.randomUUID().toString();
        Method methode = methodInvocation.getMethod();
        LOGGER.debug("Erzeuge neue Korrelations-ID {}", new Object[]{korrelationsId});
        MdcHelper.pushKorrelationsId((String)korrelationsId);
        Optional<AufrufKontextTo> aufrufKontextToOptional = this.aufrufKontextToResolver.leseAufrufKontextTo(methodInvocation.getArguments());
        aufrufKontextToOptional.ifPresent(aufrufKontextTo -> aufrufKontextTo.setKorrelationsId(MdcHelper.liesKorrelationsId()));
        this.logHelper.loggeNachbarsystemAufruf(LOGGER, methode, this.remoteSystemName, this.getServiceUrl());
        long startzeit = 0L;
        boolean aufrufErfolgreich = false;
        try {
            startzeit = this.logHelper.ermittleAktuellenZeitpunkt();
            Object ergebnis = super.invoke(methodInvocation);
            aufrufErfolgreich = true;
            Object object = ergebnis;
            return object;
        }
        finally {
            long endezeit = this.logHelper.ermittleAktuellenZeitpunkt();
            long dauer = endezeit - startzeit;
            this.logHelper.loggeNachbarsystemErgebnis(LOGGER, methode, this.remoteSystemName, this.getServiceUrl(), aufrufErfolgreich);
            this.logHelper.loggeNachbarsystemDauer(LOGGER, methode, dauer, this.remoteSystemName, this.getServiceUrl(), aufrufErfolgreich);
            MdcHelper.entferneKorrelationsId();
            aufrufKontextToOptional.ifPresent(aufrufKontextTo -> aufrufKontextTo.setKorrelationsId(MdcHelper.liesKorrelationsId()));
        }
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.remoteSystemName == null) {
            throw new IllegalArgumentException("Property 'remoteSystemName' is required");
        }
        if (this.aufrufKontextToResolver == null) {
            throw new IllegalArgumentException("Property 'aufrufKontextToResolver' is required");
        }
    }

    public void setRemoteSystemName(String remoteSystemName) {
        this.remoteSystemName = remoteSystemName;
    }

    public void setLogHelper(LogHelper logHelper) {
        this.logHelper = logHelper;
    }

    @Autowired
    public void setAufrufKontextToResolver(AufrufKontextToResolver aufrufKontextToResolver) {
        this.aufrufKontextToResolver = aufrufKontextToResolver;
    }

    @Autowired(required=false)
    public void setRemoteInvocationFactory(RemoteInvocationFactory remoteInvocationFactory) {
        super.setRemoteInvocationFactory(remoteInvocationFactory);
    }

    public AufrufKontextToResolver getAufrufKontextToResolver() {
        return this.aufrufKontextToResolver;
    }
}

