/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.serviceapi.core.serviceimpl;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import ma.glasnost.orika.MapperFacade;
import org.springframework.util.ClassUtils;

final class MappingHelper {
    private static final List<Class<?>> MAPPING_BLACKLIST = Arrays.asList(String.class, Class.class, Object.class);

    MappingHelper() {
    }

    static Object map(MapperFacade mapper, Object source, Type destinationType) {
        if (source == null) {
            return null;
        }
        if (destinationType instanceof ParameterizedType) {
            ParameterizedType parDestinationType = (ParameterizedType)destinationType;
            Class rawClass = (Class)parDestinationType.getRawType();
            if (List.class.isAssignableFrom(rawClass)) {
                return MappingHelper.mapCollection(mapper, source, parDestinationType, new ArrayList<Object>());
            }
            if (SortedSet.class.isAssignableFrom(rawClass)) {
                return MappingHelper.mapCollection(mapper, source, parDestinationType, new TreeSet<Object>());
            }
            if (Set.class.isAssignableFrom(rawClass)) {
                return MappingHelper.mapCollection(mapper, source, parDestinationType, new HashSet<Object>());
            }
            if (SortedMap.class.isAssignableFrom(rawClass)) {
                return MappingHelper.mapMap(mapper, source, parDestinationType, new TreeMap<Object, Object>());
            }
            if (Map.class.isAssignableFrom(rawClass)) {
                return MappingHelper.mapMap(mapper, source, parDestinationType, new HashMap<Object, Object>());
            }
            destinationType = parDestinationType.getRawType();
        }
        if (destinationType instanceof GenericArrayType) {
            if (!source.getClass().isArray()) {
                throw new IllegalArgumentException("Ein Mapping auf den Array-Typ " + destinationType + " wird nicht unterst\u00fctzt, wenn das Quellobjekt kein Array ist. Typ des Quellobjekts: " + source.getClass());
            }
            Type elementType = ((GenericArrayType)destinationType).getGenericComponentType();
            Object[] sourceArray = (Object[])source;
            Object[] destinationArray = (Object[])Array.newInstance((Class)elementType, sourceArray.length);
            for (int i = 0; i < sourceArray.length; ++i) {
                destinationArray[i] = MappingHelper.map(mapper, sourceArray[i], elementType);
            }
            return destinationArray;
        }
        if (destinationType instanceof Class && ((Class)destinationType).isArray()) {
            if (!source.getClass().isArray()) {
                throw new IllegalArgumentException("Ein Mapping auf den Array-Typ " + destinationType + " wird nicht unterst\u00fctzt, wenn das Quellobjekt kein Array ist. Typ des Quellobjekts: " + source.getClass());
            }
            Class destinationTypeClass = (Class)destinationType;
            Class<?> elementType = destinationTypeClass.getComponentType();
            Object[] sourceArray = (Object[])source;
            Object[] destinationArray = (Object[])Array.newInstance(elementType, sourceArray.length);
            for (int i = 0; i < sourceArray.length; ++i) {
                destinationArray[i] = MappingHelper.map(mapper, sourceArray[i], elementType);
            }
            return destinationArray;
        }
        if (!(destinationType instanceof Class)) {
            throw new IllegalArgumentException("Ein Mapping auf Typ " + destinationType + " wird nicht unterst\u00fctzt");
        }
        Class destinationClass = (Class)destinationType;
        if (ClassUtils.isPrimitiveOrWrapper((Class)destinationClass) || MAPPING_BLACKLIST.contains(destinationClass)) {
            return source;
        }
        if (destinationClass.isEnum()) {
            if (!(source instanceof Enum)) {
                throw new IllegalArgumentException("Ein Mapping auf ein Enum " + destinationClass + " wird nicht unterst\u00fctzt, da das Quellobjekt kein Enumobjekt ist (Quellobjektstyp: " + source.getClass().toString() + ").");
            }
            return Enum.valueOf(destinationClass, ((Enum)source).name());
        }
        return mapper.map(source, destinationClass);
    }

    private static Collection<Object> mapCollection(MapperFacade mapper, Object source, ParameterizedType parDestinationType, Collection<Object> result) {
        if (!(source instanceof Collection)) {
            throw new IllegalArgumentException("Ein Objekt vom Typ " + source.getClass() + " kann nicht auf " + parDestinationType + " gemappt werden");
        }
        Collection sourceCollection = (Collection)source;
        Type destElemType = parDestinationType.getActualTypeArguments()[0];
        for (Object sourceElem : sourceCollection) {
            Object destElem = MappingHelper.map(mapper, sourceElem, destElemType);
            result.add(destElem);
        }
        return result;
    }

    private static Map<Object, Object> mapMap(MapperFacade mapper, Object source, ParameterizedType parDestinationType, Map<Object, Object> result) {
        if (!(source instanceof Map)) {
            throw new IllegalArgumentException("Ein Objekt vom Typ " + source.getClass() + " kann nicht auf " + parDestinationType + " gemappt werden");
        }
        Map sourceMap = (Map)source;
        Type destKeyType = parDestinationType.getActualTypeArguments()[0];
        Type destValueType = parDestinationType.getActualTypeArguments()[1];
        for (Map.Entry entry : sourceMap.entrySet()) {
            Object key = MappingHelper.map(mapper, entry.getKey(), destKeyType);
            Object value = MappingHelper.map(mapper, entry.getValue(), destValueType);
            result.put(key, value);
        }
        return result;
    }
}

