/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.serviceapi.core.serviceimpl;

import de.bund.bva.isyfact.exception.BaseException;
import de.bund.bva.isyfact.exception.service.TechnicalToException;
import de.bund.bva.isyfact.exception.service.ToException;
import de.bund.bva.isyfact.serviceapi.core.serviceimpl.ExceptionMapping;
import de.bund.bva.isyfact.serviceapi.core.serviceimpl.ExceptionMappingSource;
import de.bund.bva.isyfact.serviceapi.core.serviceimpl.Mapping;
import java.lang.reflect.Method;

public class AnnotationExceptionMappingSource
implements ExceptionMappingSource {
    @Override
    public Class<? extends ToException> getToExceptionClass(Method remoteBeanMethod, Class<? extends BaseException> exceptionClass) {
        Class<?> remoteBeanInterface = remoteBeanMethod.getDeclaringClass();
        ExceptionMapping exceptionMapping = this.getExceptionMapping(remoteBeanInterface);
        for (Mapping mapping : exceptionMapping.mappings()) {
            if (!mapping.exception().equals(exceptionClass)) continue;
            return mapping.toException();
        }
        return null;
    }

    @Override
    public Class<? extends TechnicalToException> getGenericTechnicalToException(Method remoteBeanMethod) {
        Class<?> remoteBeanInterface = remoteBeanMethod.getDeclaringClass();
        ExceptionMapping exceptionMapping = this.getExceptionMapping(remoteBeanInterface);
        return exceptionMapping.technicalToException();
    }

    private ExceptionMapping getExceptionMapping(Class<?> remoteBeanInterface) {
        String implPackageName = remoteBeanInterface.getPackage().getName() + ".impl";
        Package implPackage = Package.getPackage(implPackageName);
        if (implPackage == null) {
            throw new IllegalStateException("F\u00fcr den Service " + remoteBeanInterface.getName() + " fehlt das erwartete Implementierungspackage " + implPackageName);
        }
        ExceptionMapping exceptionMapping = implPackage.getAnnotation(ExceptionMapping.class);
        return exceptionMapping;
    }
}

