/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.serviceapi.core.aufrufkontext;

import de.bund.bva.isyfact.aufrufkontext.AufrufKontext;
import de.bund.bva.isyfact.aufrufkontext.AufrufKontextFactory;
import de.bund.bva.isyfact.aufrufkontext.AufrufKontextVerwalter;
import de.bund.bva.isyfact.logging.IsyLogger;
import de.bund.bva.isyfact.logging.IsyLoggerFactory;
import de.bund.bva.isyfact.serviceapi.core.aufrufkontext.AufrufKontextToResolver;
import de.bund.bva.isyfact.serviceapi.service.httpinvoker.v1_0_0.AufrufKontextTo;
import java.util.Optional;
import ma.glasnost.orika.MapperFacade;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.Ordered;

public class StelltAllgemeinenAufrufKontextBereitInterceptor<T extends AufrufKontext>
implements MethodInterceptor,
Ordered {
    private static final IsyLogger LOGISY = IsyLoggerFactory.getLogger(StelltAllgemeinenAufrufKontextBereitInterceptor.class);
    private static final int DEFAULT_ORDER = 9000;
    private final MapperFacade mapper;
    private final AufrufKontextFactory<T> aufrufKontextFactory;
    private final AufrufKontextVerwalter<T> aufrufKontextVerwalter;
    private final AufrufKontextToResolver aufrufKontextToResolver;
    private int order = 9000;

    public StelltAllgemeinenAufrufKontextBereitInterceptor(MapperFacade mapper, AufrufKontextFactory<T> aufrufKontextFactory, AufrufKontextVerwalter<T> aufrufKontextVerwalter, AufrufKontextToResolver aufrufKontextToResolver) {
        this.mapper = mapper;
        this.aufrufKontextFactory = aufrufKontextFactory;
        this.aufrufKontextVerwalter = aufrufKontextVerwalter;
        this.aufrufKontextToResolver = aufrufKontextToResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        AufrufKontext alterAufrufKontext = this.aufrufKontextVerwalter.getAufrufKontext();
        Optional<AufrufKontextTo> aufrufKontextToOptional = this.aufrufKontextToResolver.leseAufrufKontextTo(invocation.getArguments());
        if (!aufrufKontextToOptional.isPresent()) {
            LOGISY.debug("Es wurde kein AufrufKontext uebermittelt.", new Object[0]);
        }
        AufrufKontext aufrufKontext = aufrufKontextToOptional.map(this::mapToGenericAufrufKontext).orElse(null);
        this.aufrufKontextVerwalter.setAufrufKontext(aufrufKontext);
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            this.aufrufKontextVerwalter.setAufrufKontext(alterAufrufKontext);
        }
    }

    private T mapToGenericAufrufKontext(AufrufKontextTo aufrufKontextTo) {
        AufrufKontext aufrufKontext = this.aufrufKontextFactory.erzeugeAufrufKontext();
        this.mapper.map((Object)aufrufKontextTo, (Object)aufrufKontext);
        this.aufrufKontextFactory.nachAufrufKontextVerarbeitung(aufrufKontext);
        return (T)aufrufKontext;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

