/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.serviceapi.core.aop;

import de.bund.bva.isyfact.logging.IsyLogger;
import de.bund.bva.isyfact.logging.IsyLoggerFactory;
import de.bund.bva.isyfact.logging.util.MdcHelper;
import de.bund.bva.isyfact.serviceapi.core.aop.StelltLoggingKontextBereit;
import de.bund.bva.isyfact.serviceapi.core.aufrufkontext.AufrufKontextToResolver;
import de.bund.bva.isyfact.serviceapi.service.httpinvoker.v1_0_0.AufrufKontextTo;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.UUID;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.util.ClassUtils;

public class StelltLoggingKontextBereitInterceptor
implements MethodInterceptor {
    private static final IsyLogger LOG = IsyLoggerFactory.getLogger(StelltLoggingKontextBereitInterceptor.class);
    private final AufrufKontextToResolver aufrufKontextToResolver;

    public StelltLoggingKontextBereitInterceptor(AufrufKontextToResolver aufrufKontextToResolver) {
        this.aufrufKontextToResolver = aufrufKontextToResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Class targetClass = invocation.getThis() != null ? AopUtils.getTargetClass((Object)invocation.getThis()) : null;
        StelltLoggingKontextBereit stelltLoggingKontextBereit = this.ermittleStelltLoggingKontextBereitAnnotation(invocation.getMethod(), targetClass);
        String korrelationsId = stelltLoggingKontextBereit != null ? this.determineKorrelationsIdAccordingToAnnotation(stelltLoggingKontextBereit, invocation) : this.determineKorrelationsIdDefaultHandling(invocation);
        try {
            LOG.debug("Setze Korrelations-ID: " + korrelationsId, new Object[0]);
            MdcHelper.pushKorrelationsId((String)korrelationsId);
            if (stelltLoggingKontextBereit == null || stelltLoggingKontextBereit.nutzeAufrufKontext()) {
                Optional<AufrufKontextTo> aufrufKontextToOptional = this.aufrufKontextToResolver.leseAufrufKontextTo(invocation.getArguments());
                aufrufKontextToOptional.ifPresent(aufrufKontextTo -> {
                    if (aufrufKontextTo.getKorrelationsId() == null || aufrufKontextTo.getKorrelationsId().isEmpty()) {
                        aufrufKontextTo.setKorrelationsId(korrelationsId);
                    }
                });
            }
            Object object = invocation.proceed();
            return object;
        }
        finally {
            MdcHelper.entferneKorrelationsIds();
        }
    }

    private String determineKorrelationsIdAccordingToAnnotation(StelltLoggingKontextBereit stelltLoggingKontextBereit, MethodInvocation invocation) {
        if (stelltLoggingKontextBereit.nutzeAufrufKontext()) {
            Optional<AufrufKontextTo> aufrufKontextToOptional = this.aufrufKontextToResolver.leseAufrufKontextTo(invocation.getArguments());
            if (!aufrufKontextToOptional.isPresent()) {
                throw new IllegalArgumentException("Die Annotation StelltLoggingKontextBereit gibt an, dass die Methode " + invocation.getMethod() + " einen Aufrufkontext als Parameter enth\u00e4lt. Dieser Parameter ist aber null oder nicht vorhanden.");
            }
            return aufrufKontextToOptional.map(AufrufKontextTo::getKorrelationsId).filter(kor -> !kor.isEmpty()).orElseGet(StelltLoggingKontextBereitInterceptor::createNewCorrelationID);
        }
        return StelltLoggingKontextBereitInterceptor.createNewCorrelationID();
    }

    public String determineKorrelationsIdDefaultHandling(MethodInvocation invocation) {
        Optional<AufrufKontextTo> aufrufKontextToOptional = this.aufrufKontextToResolver.leseAufrufKontextTo(invocation.getArguments());
        return aufrufKontextToOptional.map(AufrufKontextTo::getKorrelationsId).filter(kor -> !kor.isEmpty()).orElseGet(StelltLoggingKontextBereitInterceptor::createNewCorrelationID);
    }

    private static String createNewCorrelationID() {
        LOG.debug("Erzeuge neue Korrelations-ID.", new Object[0]);
        return UUID.randomUUID().toString();
    }

    private StelltLoggingKontextBereit ermittleStelltLoggingKontextBereitAnnotation(Method method, Class<?> targetClass) {
        Class userClass = ClassUtils.getUserClass(targetClass);
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, (Class)userClass);
        StelltLoggingKontextBereit stelltLoggingKontextBereit = (specificMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod)).getAnnotation(StelltLoggingKontextBereit.class);
        if (stelltLoggingKontextBereit != null) {
            return stelltLoggingKontextBereit;
        }
        stelltLoggingKontextBereit = specificMethod.getDeclaringClass().getAnnotation(StelltLoggingKontextBereit.class);
        if (stelltLoggingKontextBereit != null) {
            return stelltLoggingKontextBereit;
        }
        if (specificMethod != method) {
            stelltLoggingKontextBereit = method.getAnnotation(StelltLoggingKontextBereit.class);
            if (stelltLoggingKontextBereit != null) {
                return stelltLoggingKontextBereit;
            }
            return method.getDeclaringClass().getAnnotation(StelltLoggingKontextBereit.class);
        }
        return null;
    }
}

