/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.serviceapi.core.serviceimpl;

import de.bund.bva.isyfact.serviceapi.core.serviceimpl.MethodHashKey;
import de.bund.bva.isyfact.serviceapi.core.serviceimpl.MethodMappingSource;
import de.bund.bva.isyfact.serviceapi.service.httpinvoker.v1_0_0.AufrufKontextTo;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.aop.support.AopUtils;

public class ReflectiveMethodMappingSource
implements MethodMappingSource {
    private final Map<MethodHashKey, Method> methodCache = new ConcurrentHashMap<MethodHashKey, Method>();

    @Override
    public Method getTargetMethod(Method calledMethod, Class<?> targetClass) {
        MethodHashKey key = new MethodHashKey(calledMethod, targetClass);
        Method method = this.methodCache.get(key);
        if (method != null) {
            return method;
        }
        HashMap<Method, Method> matchesMap = new HashMap<Method, Method>();
        for (Class<?> intf : targetClass.getInterfaces()) {
            for (Method possibleMatch : intf.getMethods()) {
                if (!this.isMatch(calledMethod, possibleMatch)) continue;
                matchesMap.put(AopUtils.getMostSpecificMethod((Method)possibleMatch, targetClass), possibleMatch);
            }
        }
        Collection matches = matchesMap.values();
        if (matchesMap.size() == 1) {
            Method targetMethod = (Method)matches.iterator().next();
            this.methodCache.put(key, targetMethod);
            return targetMethod;
        }
        if (matchesMap.size() > 1) {
            throw new IllegalArgumentException("Mehr als eine m\u00f6gliche Zielmethode f\u00fcr " + this.getMethodSignatureString(calledMethod) + " in " + Arrays.toString(targetClass.getInterfaces()) + ": " + matches.toString());
        }
        throw new IllegalArgumentException("Keine Zielmethode f\u00fcr " + this.getMethodSignatureString(calledMethod) + " in " + Arrays.toString(targetClass.getInterfaces()));
    }

    protected boolean isMatch(Method calledMethod, Method possibleMatch) {
        if (!calledMethod.getName().equals(possibleMatch.getName())) {
            return false;
        }
        int noOfParameters = calledMethod.getParameterTypes().length;
        for (Class<?> parType : calledMethod.getParameterTypes()) {
            if (!this.skipParameter(parType)) continue;
            --noOfParameters;
        }
        return noOfParameters == possibleMatch.getParameterTypes().length;
    }

    @Override
    public boolean skipParameter(Class<?> parameterType) {
        return AufrufKontextTo.class.isAssignableFrom(parameterType);
    }

    protected String getMethodSignatureString(Method method) {
        return method.getDeclaringClass().getName() + "." + method.getName();
    }
}

