/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.serviceapi.core.serviceimpl;

import de.bund.bva.isyfact.logging.IsyLogger;
import de.bund.bva.isyfact.logging.IsyLoggerFactory;
import de.bund.bva.isyfact.sicherheit.annotation.SicherheitAttributeSource;
import de.bund.bva.isyfact.sicherheit.common.exception.FehlerhafteServiceKonfigurationRuntimeException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.PatternMatchUtils;

public class MethodMapSicherheitAttributeSource
implements SicherheitAttributeSource,
BeanClassLoaderAware,
InitializingBean {
    private static final IsyLogger LOG = IsyLoggerFactory.getLogger(MethodMapSicherheitAttributeSource.class);
    private Map<String, String[]> methodMap;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private final Map<Method, String[]> sicherheitAttributeMap = new HashMap<Method, String[]>();
    private final Map<Method, String> methodNameMap = new HashMap<Method, String>();

    public void setMethodMap(Map<String, String[]> methodMap) {
        this.methodMap = methodMap;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public void afterPropertiesSet() {
        this.initMethodMap(this.methodMap);
    }

    protected void initMethodMap(Map<String, String[]> methodMap) {
        if (methodMap != null) {
            for (Map.Entry<String, String[]> entry : methodMap.entrySet()) {
                this.addGesichertMethod(entry.getKey(), entry.getValue());
            }
        }
    }

    public void addGesichertMethod(String name, String[] attr) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex == -1) {
            throw new IllegalArgumentException("'" + name + "' is not a valid method name: format is FQN.methodName");
        }
        String className = name.substring(0, lastDotIndex);
        String methodName = name.substring(lastDotIndex + 1);
        Class clazz = ClassUtils.resolveClassName((String)className, (ClassLoader)this.beanClassLoader);
        this.addGesichertMethod(clazz, methodName, attr);
    }

    public void addGesichertMethod(Class<?> clazz, String mappedName, String[] attr) {
        Assert.notNull(clazz, (String)"Class must not be null");
        Assert.notNull((Object)mappedName, (String)"Mapped name must not be null");
        String name = clazz.getName() + '.' + mappedName;
        Method[] methods = clazz.getDeclaredMethods();
        ArrayList<Method> matchingMethods = new ArrayList<Method>();
        for (Method method : methods) {
            if (!this.isMatch(method.getName(), mappedName)) continue;
            matchingMethods.add(method);
        }
        if (matchingMethods.isEmpty()) {
            throw new IllegalArgumentException("Couldn't find method '" + mappedName + "' on class [" + clazz.getName() + "]");
        }
        for (Method method : matchingMethods) {
            String regMethodName = this.methodNameMap.get(method);
            if (regMethodName == null || !regMethodName.equals(name) && regMethodName.length() <= name.length()) {
                if (regMethodName != null) {
                    LOG.debug("Replacing attribute for gesichert method [{}]: current name '{}' is more specific than '{}'", new Object[]{method, name, regMethodName});
                }
                this.methodNameMap.put(method, name);
                this.addGesichertMethod(method, attr);
                continue;
            }
            LOG.debug("Keeping attribute for gesichert method [{}]: current name '{}' is not more specific than '{}'", new Object[]{method, name, regMethodName});
        }
    }

    public void addGesichertMethod(Method method, String[] attr) {
        Assert.notNull((Object)method, (String)"Method must not be null");
        Assert.notNull((Object)attr, (String)"rechte must not be null");
        LOG.debug("Adding gesichert method [{}] with attribute [{}]", new Object[]{method, attr});
        this.sicherheitAttributeMap.put(method, attr);
    }

    protected boolean isMatch(String methodName, String mappedName) {
        return PatternMatchUtils.simpleMatch((String)mappedName, (String)methodName);
    }

    public String[] getBenoetigeRechte(Method method, Class<?> targetClass) {
        String[] benoetigteRechte = this.sicherheitAttributeMap.get(method);
        if (benoetigteRechte == null || benoetigteRechte.length == 0) {
            throw new FehlerhafteServiceKonfigurationRuntimeException();
        }
        return benoetigteRechte;
    }
}

