/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.serviceapi.core.httpinvoker;

import de.bund.bva.isyfact.aufrufkontext.AufrufKontextVerwalter;
import de.bund.bva.isyfact.logging.IsyLogger;
import de.bund.bva.isyfact.logging.IsyLoggerFactory;
import de.bund.bva.isyfact.logging.LogKategorie;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;
import org.springframework.remoting.httpinvoker.HttpInvokerClientConfiguration;
import org.springframework.remoting.httpinvoker.SimpleHttpInvokerRequestExecutor;
import org.springframework.remoting.support.RemoteInvocationResult;

public class TimeoutWiederholungHttpInvokerRequestExecutor
extends SimpleHttpInvokerRequestExecutor {
    private static final IsyLogger LOG = IsyLoggerFactory.getLogger(TimeoutWiederholungHttpInvokerRequestExecutor.class);
    private final AufrufKontextVerwalter<?> aufrufKontextVerwalter;
    private int timeout;
    private int anzahlWiederholungen;
    private int wiederholungenAbstand;

    public TimeoutWiederholungHttpInvokerRequestExecutor(AufrufKontextVerwalter<?> aufrufKontextVerwalter) {
        this.aufrufKontextVerwalter = aufrufKontextVerwalter;
    }

    protected RemoteInvocationResult doExecuteRequest(HttpInvokerClientConfiguration config, ByteArrayOutputStream baos) throws IOException, ClassNotFoundException {
        int versuch = 0;
        while (true) {
            try {
                return super.doExecuteRequest(config, baos);
            }
            catch (InterruptedIOException requestException) {
                LOG.info(LogKategorie.PROFILING, "EPLSAC00005", "Beim Aufrufen des Services [{}] ist ein Timeout aufgetreten.", new Object[]{config.getServiceUrl()});
                if (++versuch == this.anzahlWiederholungen) {
                    LOG.info(LogKategorie.PROFILING, "EPLSAC00006", "Aufruf nach Timeout abgebrochen.", new Object[0]);
                    throw requestException;
                }
                try {
                    if (this.wiederholungenAbstand > 0) {
                        LOG.info(LogKategorie.PROFILING, "EPLSAC00007", "Warte {}ms bis zur Wiederholung des Aufrufs.", new Object[]{this.wiederholungenAbstand});
                        Thread.sleep(this.wiederholungenAbstand);
                    }
                }
                catch (InterruptedException ex) {
                    LOG.info(LogKategorie.PROFILING, "EPLSAC00008", "Warten auf Aufrufwiederholung abgebrochen", (Throwable)ex, new Object[0]);
                    throw requestException;
                }
                LOG.info(LogKategorie.PROFILING, "EPLSAC00009", "Wiederhole Aufruf...", new Object[0]);
                continue;
            }
            break;
        }
    }

    protected void prepareConnection(HttpURLConnection con, int contentLength) throws IOException {
        super.prepareConnection(con, contentLength);
        if (this.aufrufKontextVerwalter.getBearerToken() != null) {
            con.setRequestProperty("Authorization", "Bearer " + this.aufrufKontextVerwalter.getBearerToken());
        } else {
            LOG.info(LogKategorie.JOURNAL, "EPLASC00013", "Kein Bearer-Token im AufrufKontextVerwalter. Der Authorization-Header wird nicht gesetzt.", new Object[0]);
        }
        con.setReadTimeout(this.timeout);
        con.setConnectTimeout(this.timeout);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setAnzahlWiederholungen(int anzahlWiederholungen) {
        this.anzahlWiederholungen = anzahlWiederholungen;
    }

    public void setWiederholungenAbstand(int wiederholungenAbstand) {
        this.wiederholungenAbstand = wiederholungenAbstand;
    }
}

