/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.serviceapi.core.aufrufkontext;

import de.bund.bva.isyfact.aufrufkontext.AufrufKontext;
import de.bund.bva.isyfact.aufrufkontext.AufrufKontextFactory;
import de.bund.bva.isyfact.aufrufkontext.AufrufKontextVerwalter;
import de.bund.bva.isyfact.logging.IsyLogger;
import de.bund.bva.isyfact.logging.IsyLoggerFactory;
import de.bund.bva.isyfact.serviceapi.core.aufrufkontext.AufrufKontextToResolver;
import de.bund.bva.isyfact.serviceapi.service.httpinvoker.v1_0_0.AufrufKontextTo;
import java.util.Optional;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.Ordered;

public class StelltAufrufKontextBereitInterceptor<T extends AufrufKontext>
implements MethodInterceptor,
Ordered {
    private static final IsyLogger LOG = IsyLoggerFactory.getLogger(StelltAufrufKontextBereitInterceptor.class);
    private static final int DEFAULT_ORDER = 10000;
    private final AufrufKontextFactory<T> aufrufKontextFactory;
    private final AufrufKontextVerwalter<T> aufrufKontextVerwalter;
    private final AufrufKontextToResolver aufrufKontextToResolver;
    private int order = 10000;

    public StelltAufrufKontextBereitInterceptor(AufrufKontextFactory<T> aufrufKontextFactory, AufrufKontextVerwalter<T> aufrufKontextVerwalter, AufrufKontextToResolver aufrufKontextToResolver) {
        this.aufrufKontextFactory = aufrufKontextFactory;
        this.aufrufKontextVerwalter = aufrufKontextVerwalter;
        this.aufrufKontextToResolver = aufrufKontextToResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        AufrufKontext alterAufrufKontext = this.aufrufKontextVerwalter.getAufrufKontext();
        Optional<AufrufKontextTo> aufrufKontextToOptional = this.aufrufKontextToResolver.leseAufrufKontextTo(invocation.getArguments());
        if (!aufrufKontextToOptional.isPresent()) {
            LOG.debug("Es wurde kein AufrufKontext uebermittelt.", new Object[0]);
        }
        AufrufKontext aufrufKontext = aufrufKontextToOptional.map(this::mapToGenericAufrufKontext).orElse(null);
        this.aufrufKontextVerwalter.setAufrufKontext(aufrufKontext);
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            this.aufrufKontextVerwalter.setAufrufKontext(alterAufrufKontext);
        }
    }

    private T mapToGenericAufrufKontext(AufrufKontextTo aufrufKontextTo) {
        AufrufKontext aufrufKontext = this.aufrufKontextFactory.erzeugeAufrufKontext();
        aufrufKontext.setDurchfuehrendeBehoerde(aufrufKontextTo.getDurchfuehrendeBehoerde());
        aufrufKontext.setDurchfuehrenderBenutzerKennung(aufrufKontextTo.getDurchfuehrenderBenutzerKennung());
        aufrufKontext.setDurchfuehrenderBenutzerPasswort(aufrufKontextTo.getDurchfuehrenderBenutzerPasswort());
        aufrufKontext.setDurchfuehrenderSachbearbeiterName(aufrufKontextTo.getDurchfuehrenderSachbearbeiterName());
        aufrufKontext.setKorrelationsId(aufrufKontextTo.getKorrelationsId());
        aufrufKontext.setRolle(aufrufKontextTo.getRolle());
        aufrufKontext.setRollenErmittelt(aufrufKontextTo.isRollenErmittelt());
        this.aufrufKontextFactory.nachAufrufKontextVerarbeitung(aufrufKontext);
        return (T)aufrufKontext;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

