/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.serviceapi.core.httpinvoker;

import de.bund.bva.isyfact.logging.IsyLogger;
import de.bund.bva.isyfact.logging.IsyLoggerFactory;
import de.bund.bva.isyfact.logging.util.LogHelper;
import de.bund.bva.isyfact.logging.util.MdcHelper;
import de.bund.bva.isyfact.serviceapi.common.AufrufKontextToHelper;
import de.bund.bva.isyfact.serviceapi.service.httpinvoker.v1_0_0.AufrufKontextTo;
import java.lang.reflect.Method;
import java.util.UUID;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.remoting.httpinvoker.HttpInvokerClientInterceptor;
import org.springframework.util.StringUtils;

public class IsyHttpInvokerClientInterceptor
extends HttpInvokerClientInterceptor {
    private static final IsyLogger LOGGER = IsyLoggerFactory.getLogger(IsyHttpInvokerClientInterceptor.class);
    private LogHelper logHelper = new LogHelper(false, false, true, false, false, 0L);
    private String remoteSystemName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        String korrelationsId = UUID.randomUUID().toString();
        boolean aufrufErfolgreich = false;
        Method methode = methodInvocation.getMethod();
        AufrufKontextTo aufrufKontextTo = AufrufKontextToHelper.leseAufrufKontextTo(methodInvocation.getArguments());
        LOGGER.debug("Erzeuge neue Korrelations-ID {}", new Object[]{korrelationsId});
        MdcHelper.pushKorrelationsId((String)korrelationsId);
        if (aufrufKontextTo != null && !StringUtils.isEmpty((Object)aufrufKontextTo.getKorrelationsId()) && !MdcHelper.liesKorrelationsId().equals(aufrufKontextTo.getKorrelationsId() + ";" + korrelationsId)) {
            LOGGER.warn("EPLSAC00010", "Die Korrelations-Id {} im Aufrufkontext wurde korrigiert, da diese nicht mit der Korr-Id auf dem MDC {} \u00fcbereinstimmt.", new Object[]{aufrufKontextTo.getKorrelationsId(), MdcHelper.liesKorrelationsId()});
        }
        if (aufrufKontextTo != null) {
            aufrufKontextTo.setKorrelationsId(MdcHelper.liesKorrelationsId());
        }
        this.logHelper.loggeNachbarsystemAufruf(LOGGER, methode, this.remoteSystemName, this.getServiceUrl());
        long startzeit = 0L;
        try {
            startzeit = this.logHelper.ermittleAktuellenZeitpunkt();
            Object ergebnis = super.invoke(methodInvocation);
            aufrufErfolgreich = true;
            Object object = ergebnis;
            return object;
        }
        finally {
            long endezeit = this.logHelper.ermittleAktuellenZeitpunkt();
            long dauer = endezeit - startzeit;
            this.logHelper.loggeNachbarsystemErgebnis(LOGGER, methode, this.remoteSystemName, this.getServiceUrl(), aufrufErfolgreich);
            this.logHelper.loggeNachbarsystemDauer(LOGGER, methode, dauer, this.remoteSystemName, this.getServiceUrl(), aufrufErfolgreich);
            MdcHelper.entferneKorrelationsId();
        }
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.remoteSystemName == null) {
            throw new IllegalArgumentException("Property 'remoteSystemName' is required");
        }
    }

    public void setRemoteSystemName(String remoteSystemName) {
        this.remoteSystemName = remoteSystemName;
    }

    public void setLogHelper(LogHelper logHelper) {
        this.logHelper = logHelper;
    }
}

