/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.security.test.oidcprovider;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.ContainsPattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.NegativeRegexPattern;
import com.github.tomakehurst.wiremock.matching.RegexPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import de.bund.bva.isyfact.security.test.oidcprovider.EmbeddedOidcProviderStub;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.http.HttpStatus;
import org.springframework.security.oauth2.core.AuthorizationGrantType;

public abstract class OidcProviderMockBase
extends EmbeddedOidcProviderStub {
    static final String BHKNZ_HEADER_NAME = "x-client-cert-bhknz";
    static final String OIDC_CONFIG_ENDPOINT = "/.well-known/openid-configuration";
    static final String AUTHORIZATION_ENDPOINT = "/protocol/openid-connect/auth";
    static final String JWKS_ENDPOINT = "/protocol/openid-connect/certs";
    static final String TOKEN_ENDPOINT = "/protocol/openid-connect/token";
    private static final String DEFAULT_SECOND_OU = "TESTOU";
    private String secondOu = "TESTOU";
    private final Map<String, Set<StubMapping>> userMappings = new HashMap<String, Set<StubMapping>>();
    private final Map<String, Set<StubMapping>> clientMappings = new HashMap<String, Set<StubMapping>>();

    public OidcProviderMockBase(String host, int port, String issuerPath) {
        super(host, port, issuerPath);
    }

    public OidcProviderMockBase(String host, int port, String issuerPath, int tokenLifespan) {
        super(host, port, issuerPath, tokenLifespan);
    }

    public OidcProviderMockBase(String host, int port, String issuerPath, String publicKey, String privateKey) {
        super(host, port, issuerPath, publicKey, privateKey);
    }

    public OidcProviderMockBase(String host, int port, String issuerPath, String publicKey, String privateKey, int tokenLifespan) {
        super(host, port, issuerPath, publicKey, privateKey, tokenLifespan);
    }

    public String getSecondOu() {
        return this.secondOu;
    }

    public void setSecondOu(String secondOu) {
        this.secondOu = secondOu;
    }

    protected void init(String host, int port) {
        WireMock.configureFor((String)host, (int)port);
        WireMock.reset();
        this.setupOIDCConfigEndpoint();
        this.setupDefaultTokenEndpoints();
        this.setupJwksEndpoint();
    }

    public void addUser(String clientId, String secret, String username, String password, Optional<String> bhknz, Set<String> roles) {
        String accessTokenResponse = this.getAccessTokenResponse(clientId, username, bhknz, roles);
        this.userMappings.put(username, this.generateUserMapping(clientId, secret, username, password, bhknz, accessTokenResponse));
    }

    public void addClient(String clientId, String secret, Set<String> roles) {
        String accessTokenResponse = this.getAccessTokenResponse(clientId, "service-account-" + clientId, Optional.empty(), roles);
        this.clientMappings.put(clientId, this.generateClientMapping(clientId, secret, accessTokenResponse));
    }

    public void removeUser(String username) {
        Set<StubMapping> userMapping = this.userMappings.remove(username);
        if (userMapping != null) {
            for (StubMapping mapping : userMapping) {
                WireMock.removeStub((StubMapping)mapping);
            }
        }
    }

    public void removeAllUsers() {
        for (String user : this.userMappings.keySet()) {
            this.removeUser(user);
        }
    }

    public void removeClient(String clientId) {
        Set<StubMapping> clientMapping = this.clientMappings.remove(clientId);
        if (clientMapping != null) {
            for (StubMapping mapping : clientMapping) {
                WireMock.removeStub((StubMapping)mapping);
            }
        }
    }

    public void removeAllClients() {
        for (String client : this.clientMappings.keySet()) {
            this.removeClient(client);
        }
    }

    private StubMapping setupOIDCConfigEndpoint() {
        return WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)this.appendToIssuerPath(OIDC_CONFIG_ENDPOINT))).willReturn(WireMock.aResponse().withStatus(HttpStatus.OK.value()).withHeader("Content-Type", new String[]{"application/json"}).withBody(this.getOIDCConfigResponse(JWKS_ENDPOINT, AUTHORIZATION_ENDPOINT, TOKEN_ENDPOINT))));
    }

    private StubMapping setupJwksEndpoint() {
        return WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)this.appendToIssuerPath(JWKS_ENDPOINT))).willReturn(WireMock.aResponse().withStatus(HttpStatus.OK.value()).withHeader("Content-Type", new String[]{"application/json"}).withBody(this.getJwksResponse())));
    }

    private Set<StubMapping> setupDefaultTokenEndpoints() {
        HashSet<StubMapping> stubMappings = new HashSet<StubMapping>();
        String tokenEndpoint = this.appendToIssuerPath(TOKEN_ENDPOINT);
        String clientCredentialsGrantType = String.format("%s=%s", "grant_type", AuthorizationGrantType.CLIENT_CREDENTIALS.getValue());
        stubMappings.add(WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)tokenEndpoint)).atPriority(Integer.valueOf(2)).withRequestBody((ContentPattern)new NegativeRegexPattern(String.format(".*%s=.*", "grant_type"))).willReturn(WireMock.aResponse().withStatus(HttpStatus.BAD_REQUEST.value()).withHeader("Content-Type", new String[]{"application/json"}).withBody(this.createErrorResponse("invalid_request", "Missing grant type")))));
        stubMappings.add(WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)tokenEndpoint)).atPriority(Integer.valueOf(3)).withRequestBody((ContentPattern)new EqualToPattern(clientCredentialsGrantType)).willReturn(WireMock.aResponse().withStatus(HttpStatus.BAD_REQUEST.value()).withHeader("Content-Type", new String[]{"application/json"}).withBody(this.createErrorResponse("unsupported_grant_type", "Invalid client-id or secret")))));
        stubMappings.add(WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)tokenEndpoint)).atPriority(Integer.valueOf(4)).withRequestBody((ContentPattern)new NegativeRegexPattern(".*username=.+")).willReturn(WireMock.aResponse().withStatus(HttpStatus.UNAUTHORIZED.value()).withHeader("WWW-Authenticate", new String[]{"dummy"}).withHeader("Content-Type", new String[]{"application/json"}).withBody(this.createErrorResponse("invalid_grant", "Missing username")))));
        stubMappings.add(WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)tokenEndpoint)).atPriority(Integer.valueOf(4)).withRequestBody((ContentPattern)new NegativeRegexPattern(".*password=.+")).willReturn(WireMock.aResponse().withStatus(HttpStatus.UNAUTHORIZED.value()).withHeader("WWW-Authenticate", new String[]{"dummy"}).withHeader("Content-Type", new String[]{"application/json"}).withBody(this.createErrorResponse("invalid_grant", "Missing password")))));
        return stubMappings;
    }

    private Set<StubMapping> generateUserMapping(String clientId, String secret, String username, String password, Optional<String> bhknz, String accessTokenResponse) {
        HashSet<StubMapping> stubMappings = new HashSet<StubMapping>();
        String tokenEndpoint = this.appendToIssuerPath(TOKEN_ENDPOINT);
        String validLogin = String.format("%s=%s&username=%s&password=%s", "grant_type", AuthorizationGrantType.PASSWORD.getValue(), username, password);
        if (bhknz.isPresent()) {
            String bhknzPattern = String.format("%1$s:%2$s|%2$s:%1$s", bhknz.get(), this.secondOu);
            stubMappings.add(WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)tokenEndpoint)).atPriority(Integer.valueOf(1)).withHeader(BHKNZ_HEADER_NAME, (StringValuePattern)new RegexPattern(bhknzPattern)).withRequestBody((ContentPattern)new ContainsPattern(validLogin)).withBasicAuth(clientId, secret).willReturn(WireMock.aResponse().withStatus(HttpStatus.OK.value()).withHeader("Content-Type", new String[]{"application/json"}).withBody(accessTokenResponse))));
        } else {
            stubMappings.add(WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)tokenEndpoint)).atPriority(Integer.valueOf(1)).withRequestBody((ContentPattern)new ContainsPattern(validLogin)).withBasicAuth(clientId, secret).willReturn(WireMock.aResponse().withStatus(HttpStatus.OK.value()).withHeader("Content-Type", new String[]{"application/json"}).withBody(accessTokenResponse))));
        }
        if (bhknz.isPresent()) {
            stubMappings.add(WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)tokenEndpoint)).atPriority(Integer.valueOf(5)).withRequestBody((ContentPattern)new ContainsPattern(validLogin)).willReturn(WireMock.aResponse().withStatus(HttpStatus.UNAUTHORIZED.value()).withHeader("WWW-Authenticate", new String[]{"dummy"}).withHeader("Content-Type", new String[]{"application/json"}).withBody(this.createErrorResponse("invalid_grant", "Invalid bhknz")))));
        }
        stubMappings.add(WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)tokenEndpoint)).atPriority(Integer.valueOf(5)).withRequestBody((ContentPattern)new NegativeRegexPattern(String.format(".*username=%s.*", username))).willReturn(WireMock.aResponse().withStatus(HttpStatus.UNAUTHORIZED.value()).withHeader("WWW-Authenticate", new String[]{"dummy"}).withHeader("Content-Type", new String[]{"application/json"}).withBody(this.createErrorResponse("invalid_grant", "Invalid username")))));
        stubMappings.add(WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)tokenEndpoint)).atPriority(Integer.valueOf(5)).withRequestBody((ContentPattern)new NegativeRegexPattern(String.format(".*password=%s.*", password))).willReturn(WireMock.aResponse().withStatus(HttpStatus.UNAUTHORIZED.value()).withHeader("WWW-Authenticate", new String[]{"dummy"}).withHeader("Content-Type", new String[]{"application/json"}).withBody(this.createErrorResponse("invalid_grant", "Invalid password")))));
        return stubMappings;
    }

    private Set<StubMapping> generateClientMapping(String clientId, String secret, String accessTokenResponse) {
        HashSet<StubMapping> stubMappings = new HashSet<StubMapping>();
        String clientCredentialsGrantType = String.format("%s=%s", "grant_type", AuthorizationGrantType.CLIENT_CREDENTIALS.getValue());
        stubMappings.add(WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlEqualTo((String)this.appendToIssuerPath(TOKEN_ENDPOINT))).atPriority(Integer.valueOf(1)).withRequestBody((ContentPattern)new EqualToPattern(clientCredentialsGrantType)).withBasicAuth(clientId, secret).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withStatus(HttpStatus.OK.value()).withBody(accessTokenResponse))));
        return stubMappings;
    }

    private String createErrorResponse(String errorCode, String errorDescription) {
        return "{\n  \"error\": \"" + errorCode + "\",  \"error_description\": \"" + errorDescription + "\"}";
    }

    private String appendToIssuerPath(String endpoint) {
        return this.appendPath(this.getIssuer(), endpoint).getPath();
    }
}

