/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.security.test.oidcprovider;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import de.bund.bva.isyfact.security.test.oidcprovider.OidcProviderMockBase;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class EmbeddedOidcProviderMock
extends OidcProviderMockBase
implements AfterAllCallback,
BeforeAllCallback {
    private WireMockServer oidcServerStub;

    public EmbeddedOidcProviderMock(String host, int port, String issuerPath) {
        super(host, port, issuerPath);
    }

    public EmbeddedOidcProviderMock(String host, int port, String issuerPath, int tokenLifespan) {
        super(host, port, issuerPath, tokenLifespan);
    }

    public EmbeddedOidcProviderMock(String host, int port, String issuerPath, String publicKey, String privateKey) {
        super(host, port, issuerPath, publicKey, privateKey);
    }

    public EmbeddedOidcProviderMock(String host, int port, String issuerPath, String publicKey, String privateKey, int tokenLifespan) {
        super(host, port, issuerPath, publicKey, privateKey, tokenLifespan);
    }

    public WireMockServer getOidcServer() {
        return this.oidcServerStub;
    }

    public void beforeAll(ExtensionContext extensionContext) {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this.oidcServerStub == null) {
            this.oidcServerStub = new WireMockServer(this.getPort());
            WireMock.configureFor((int)this.getPort());
        }
        if (!this.oidcServerStub.isRunning()) {
            this.oidcServerStub.start();
        }
        this.init("localhost", this.getPort());
    }

    public void afterAll(ExtensionContext extensionContext) {
        this.oidcServerStub.stop();
        this.oidcServerStub = null;
    }
}

