/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.security.test.oidcprovider;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.Tokens;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import de.bund.bva.isyfact.security.test.RsaKeyGenerator;
import java.net.URI;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.JwsHeader;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.security.oauth2.jwt.JwtEncoderParameters;
import org.springframework.security.oauth2.jwt.NimbusJwtEncoder;
import org.springframework.web.util.UriComponentsBuilder;

public class EmbeddedOidcProviderStub {
    public static final String DEFAULT_ROLES_CLAIM_NAME = "roles";
    public static final String BHKNZ_CLAIM_NAME = "bhknz";
    private final String host;
    private final int port;
    private final URI issuer;
    private final String keyId;
    private final RSAPublicKey publicKey;
    private final PrivateKey privateKey;
    private final int tokenLifespan;
    private String rolesClaimName = "roles";

    public EmbeddedOidcProviderStub(String host, int port, String issuerPath) {
        this(host, port, issuerPath, new RsaKeyGenerator().getKeyPair());
    }

    public EmbeddedOidcProviderStub(String host, int port, String issuerPath, int tokenLifespan) {
        this(host, port, issuerPath, new RsaKeyGenerator().getKeyPair(), tokenLifespan);
    }

    public EmbeddedOidcProviderStub(String host, int port, String issuerPath, String publicKey, String privateKey) {
        this(host, port, issuerPath, RsaKeyGenerator.decodeKeyPair(publicKey, privateKey));
    }

    public EmbeddedOidcProviderStub(String host, int port, String issuerPath, String publicKey, String privateKey, int tokenLifespan) {
        this(host, port, issuerPath, RsaKeyGenerator.decodeKeyPair(publicKey, privateKey), tokenLifespan);
    }

    public EmbeddedOidcProviderStub(String host, int port, String issuerPath, KeyPair keyPair) {
        this(host, port, issuerPath, keyPair, 60);
    }

    public EmbeddedOidcProviderStub(String host, int port, String issuerPath, KeyPair keyPair, int tokenLifespan) {
        this.host = host;
        this.port = port;
        this.tokenLifespan = tokenLifespan;
        this.issuer = this.appendPath(URI.create(String.format("http://%s:%s", host, port)), issuerPath);
        this.keyId = UUID.randomUUID().toString();
        this.publicKey = (RSAPublicKey)keyPair.getPublic();
        this.privateKey = keyPair.getPrivate();
    }

    public void setRolesClaimName(String rolesClaimName) {
        this.rolesClaimName = rolesClaimName;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public URI getIssuer() {
        return this.issuer;
    }

    public String getPublicKey() {
        return RsaKeyGenerator.encodePublicKey(this.publicKey);
    }

    public String getOIDCConfigResponse(String jwksEndpoint, String authorizationEndpoint, String tokenEndpoint) {
        OIDCProviderMetadata config = new OIDCProviderMetadata(new Issuer(this.issuer), Collections.singletonList(SubjectType.PUBLIC), this.appendPath(this.issuer, jwksEndpoint));
        config.setAuthorizationEndpointURI(this.appendPath(this.issuer, authorizationEndpoint));
        config.setTokenEndpointURI(this.appendPath(this.issuer, tokenEndpoint));
        return config.toJSONObject().toJSONString();
    }

    public String getJwksResponse() {
        return this.getJwkSet().toString();
    }

    public String getAccessTokenResponse(String clientId, String userName, Optional<String> bhknz, Set<String> roles) {
        return this.getAccessTokenResponse(this.getAccessToken(UUID.randomUUID(), clientId, userName, bhknz, roles, this.tokenLifespan));
    }

    public String getAccessTokenResponse(JwtClaimsSet claims) {
        long lifetime = Instant.now().plusSeconds(this.tokenLifespan).getEpochSecond();
        Scope scope = Scope.parse((String)"openid profile email");
        BearerAccessToken accessToken = new BearerAccessToken(this.getAccessTokenString(claims), lifetime, scope);
        AccessTokenResponse response = new AccessTokenResponse(new Tokens((AccessToken)accessToken, null));
        return response.toJSONObject().toJSONString();
    }

    public String getAccessTokenString(String clientId, String userName, Optional<String> bhknz, Set<String> roles) {
        return this.getAccessTokenString(UUID.randomUUID(), clientId, userName, bhknz, roles);
    }

    public String getAccessTokenString(UUID userId, String clientId, String userName, Optional<String> bhknz, Set<String> roles) {
        return this.getAccessTokenString(this.getAccessToken(userId, clientId, userName, bhknz, roles));
    }

    public JwtClaimsSet getAccessToken(UUID userId, String clientId, String userName, Optional<String> bhknz, Set<String> roles) {
        return this.getAccessToken(userId, clientId, userName, bhknz, roles, this.tokenLifespan);
    }

    public JwtClaimsSet getAccessToken(UUID userId, String clientId, String userName, Optional<String> bhknz, Set<String> roles, int newTokenLifespan) {
        JwtClaimsSet.Builder accessTokenBuilder = JwtClaimsSet.builder().issuer(this.issuer.toString()).subject(userId.toString()).audience(Collections.singletonList(clientId)).expiresAt(Instant.now().plusSeconds(newTokenLifespan)).issuedAt(Instant.now()).claim("azp", (Object)clientId).claim("preferred_username", (Object)userName).claim(this.rolesClaimName, roles);
        bhknz.ifPresent(bk -> accessTokenBuilder.claim(BHKNZ_CLAIM_NAME, bk));
        return accessTokenBuilder.build();
    }

    public String getAccessTokenString(JwtClaimsSet claims) {
        JwsHeader jwsHeader = ((JwsHeader.Builder)((JwsHeader.Builder)((JwsHeader.Builder)JwsHeader.with((JwsAlgorithm)SignatureAlgorithm.RS256).contentType("JSON")).keyId(this.keyId)).type("JWT")).build();
        ImmutableJWKSet jwkSet = new ImmutableJWKSet(this.getJwkSet());
        Jwt jwt = new NimbusJwtEncoder((JWKSource)jwkSet).encode(JwtEncoderParameters.from((JwsHeader)jwsHeader, (JwtClaimsSet)claims));
        return jwt.getTokenValue();
    }

    public JWKSet getJwkSet() {
        RSAKey jwk = new RSAKey.Builder(this.publicKey).privateKey(this.privateKey).algorithm((Algorithm)JWSAlgorithm.RS256).keyID(this.keyId).keyUse(KeyUse.SIGNATURE).build();
        return new JWKSet((JWK)jwk);
    }

    protected URI appendPath(URI baseUri, String path) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)baseUri);
        if (!baseUri.getPath().endsWith("/")) {
            builder.path("/");
        }
        builder.path(path);
        return builder.build().toUri();
    }
}

