/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.security.test;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

public class RsaKeyGenerator {
    private final KeyPair keyPair;

    public RsaKeyGenerator() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(2048);
            this.keyPair = keyGen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to generate Keypair", e);
        }
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public PublicKey getPublicKey() {
        return this.keyPair.getPublic();
    }

    public PrivateKey getPrivateKey() {
        return this.keyPair.getPrivate();
    }

    public static String encodePublicKey(PublicKey key) {
        return Base64.getEncoder().encodeToString(key.getEncoded());
    }

    public static PublicKey decodePublicKey(String encodedKey) {
        byte[] bytes = Base64.getDecoder().decode(encodedKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
        try {
            return KeyFactory.getInstance("RSA").generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to decode key", e);
        }
    }

    public static String encodePrivateKey(PrivateKey key) {
        return Base64.getEncoder().encodeToString(key.getEncoded());
    }

    public static PrivateKey decodePrivateKey(String encodedKey) {
        byte[] bytes = Base64.getDecoder().decode(encodedKey);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        try {
            return KeyFactory.getInstance("RSA").generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to decode key", e);
        }
    }

    public static KeyPair decodeKeyPair(String encodedPublicKey, String encodedPrivateKey) {
        return new KeyPair(RsaKeyGenerator.decodePublicKey(encodedPublicKey), RsaKeyGenerator.decodePrivateKey(encodedPrivateKey));
    }

    public static void main(String[] args) {
        RsaKeyGenerator gen = new RsaKeyGenerator();
        System.out.println("Public key:" + RsaKeyGenerator.encodePublicKey(gen.getPublicKey()));
        System.out.println("Private key:" + RsaKeyGenerator.encodePrivateKey(gen.getPrivateKey()));
    }
}

