/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.logging.util;

import de.bund.bva.isyfact.logging.IsyLoggerFactory;
import de.bund.bva.isyfact.logging.IsyLoggerStandard;
import org.slf4j.MDC;

public final class MdcHelper {
    public static final String MDC_KORRELATIONS_ID = "korrelationsId";
    public static final String MDC_FACHDATEN = "fachdatenmdc";
    private static final String TRENNER = ";";
    private static final IsyLoggerStandard LOG = IsyLoggerFactory.getLogger(MdcHelper.class);

    private MdcHelper() {
    }

    public static String entferneKorrelationsId() {
        String korrelationsId = MDC.get((String)MDC_KORRELATIONS_ID);
        if (korrelationsId == null) {
            return null;
        }
        if (!korrelationsId.contains(TRENNER)) {
            MDC.remove((String)MDC_KORRELATIONS_ID);
            return korrelationsId;
        }
        int letztesSemikolon = korrelationsId.lastIndexOf(TRENNER);
        String korrelationsIdEntfernt = korrelationsId.substring(letztesSemikolon + 1);
        korrelationsId = korrelationsId.substring(0, letztesSemikolon);
        MDC.put((String)MDC_KORRELATIONS_ID, (String)korrelationsId);
        return korrelationsIdEntfernt;
    }

    public static void entferneKorrelationsIds() {
        MDC.remove((String)MDC_KORRELATIONS_ID);
    }

    public static String liesKorrelationsId() {
        String korrelationsId = MDC.get((String)MDC_KORRELATIONS_ID);
        if (korrelationsId == null) {
            LOG.debug("Keine Korrelations-ID unter dem Schl\u00fcssel {} im MDC gesetzt.", MDC_KORRELATIONS_ID);
        }
        return korrelationsId;
    }

    public static String pushKorrelationsId(String korrelationsId) {
        String vorhandeneKorrelationsId = MDC.get((String)MDC_KORRELATIONS_ID);
        String neueKorrelationsId = vorhandeneKorrelationsId == null ? korrelationsId : vorhandeneKorrelationsId + TRENNER + korrelationsId;
        MDC.put((String)MDC_KORRELATIONS_ID, (String)neueKorrelationsId);
        return neueKorrelationsId;
    }

    public static boolean liesMarkerFachdaten() {
        String fachdatenMdc = MDC.get((String)MDC_FACHDATEN);
        return "true".equals(fachdatenMdc);
    }

    public static void setzeMarkerFachdaten(boolean enthaeltFachdaten) {
        if (enthaeltFachdaten) {
            MDC.put((String)MDC_FACHDATEN, (String)"true");
        } else {
            MDC.put((String)MDC_FACHDATEN, (String)"false");
        }
    }

    public static void entferneMarkerFachdaten() {
        MDC.remove((String)MDC_FACHDATEN);
    }
}

