/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.logging.util;

import de.bund.bva.isyfact.logging.IsyLoggerFactory;
import de.bund.bva.isyfact.logging.IsyLoggerStandard;
import de.bund.bva.isyfact.logging.LogKategorie;
import de.bund.bva.isyfact.logging.impl.Ereignisschluessel;
import java.util.Objects;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.ContextStartedEvent;

public class LogApplicationListener
implements ApplicationListener<ApplicationEvent>,
ApplicationContextAware {
    private static final String SYSTEM_PROPERTY_JAVA_VERSION = "java.version";
    private static final String SYSTEM_PROPERTY_ZEITZONE = "user.timezone";
    private static final String SYSTEM_PROPERTY_DATEIKODIERUNG = "file.encoding";
    private static final IsyLoggerStandard LOGGER = IsyLoggerFactory.getLogger(LogApplicationListener.class);
    private final String systemname;
    private final String systemart;
    private final String systemversion;
    private ApplicationContext applicationContext;

    public LogApplicationListener(String systemname, String systemart, String systemversion) {
        this.systemname = systemname;
        this.systemart = systemart;
        this.systemversion = systemversion;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (!(event instanceof ApplicationContextEvent) || !Objects.equals(this.applicationContext, ((ApplicationContextEvent)event).getApplicationContext())) {
            return;
        }
        if (event instanceof ContextStartedEvent || event instanceof ContextRefreshedEvent) {
            LOGGER.info(LogKategorie.JOURNAL, Ereignisschluessel.EISYLO02001.name(), Ereignisschluessel.EISYLO02001.getNachricht(), this.systemname, this.systemart, event.getClass().getSimpleName());
            LOGGER.info(LogKategorie.JOURNAL, Ereignisschluessel.EISYLO02003.name(), Ereignisschluessel.EISYLO02003.getNachricht(), this.systemversion);
            LOGGER.info(LogKategorie.JOURNAL, Ereignisschluessel.EISYLO02004.name(), Ereignisschluessel.EISYLO02004.getNachricht(), SYSTEM_PROPERTY_JAVA_VERSION, System.getProperty(SYSTEM_PROPERTY_JAVA_VERSION));
            LOGGER.info(LogKategorie.JOURNAL, Ereignisschluessel.EISYLO02004.name(), Ereignisschluessel.EISYLO02004.getNachricht(), SYSTEM_PROPERTY_ZEITZONE, System.getProperty(SYSTEM_PROPERTY_ZEITZONE));
            LOGGER.info(LogKategorie.JOURNAL, Ereignisschluessel.EISYLO02004.name(), Ereignisschluessel.EISYLO02004.getNachricht(), SYSTEM_PROPERTY_DATEIKODIERUNG, System.getProperty(SYSTEM_PROPERTY_DATEIKODIERUNG));
            LOGGER.info(LogKategorie.JOURNAL, Ereignisschluessel.EISYLO02004.name(), Ereignisschluessel.EISYLO02004.getNachricht(), "maxMemory", Runtime.getRuntime().maxMemory());
        } else {
            LOGGER.info(LogKategorie.JOURNAL, Ereignisschluessel.EISYLO02002.name(), Ereignisschluessel.EISYLO02002.getNachricht(), this.systemname, this.systemart, event.getClass().getSimpleName());
        }
    }
}

