/*
 * Decompiled with CFR 0.152.
 */
package de.bund.bva.isyfact.logging.layout;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.contrib.json.JsonFormatter;
import ch.qos.logback.contrib.json.classic.JsonLayout;
import ch.qos.logback.core.CoreConstants;
import de.bund.bva.isyfact.logging.IsyMarker;
import de.bund.bva.isyfact.logging.exceptions.FehlerhafterLogeintrag;
import de.bund.bva.isyfact.logging.exceptions.LoggingTechnicalRuntimeException;
import de.bund.bva.isyfact.logging.impl.Ereignisschluessel;
import de.bund.bva.isyfact.logging.impl.FachdatenMarker;
import de.bund.bva.isyfact.logging.util.MdcHelper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;

public class IsyJsonLayout
extends JsonLayout {
    private static final String LEERE_KORRELATIONSID = "none";
    private static final String ZEITSTEMPEL_ATTR_NAME = "zeitstempel";
    private static final String PARAMETER_ATTR_NAME = "parameter";
    private static final String NACHRICHT_ATTR_NAME = "nachricht";
    private static final String EXCEPTION_ATTR_NAME = "exception";
    private static final String KORRELATIONSID_ATTR_NAME = "korrelationsid";
    private static final String MARKER_ATTR_NAME = "marker";
    private static final String GEKUERZT_ATTR_NAME = "gekuerzt";
    private int maxLength = 32000;

    public IsyJsonLayout() {
        this.includeLevel = true;
        this.includeThreadName = true;
        this.includeMDC = false;
        this.includeLoggerName = true;
        this.includeFormattedMessage = false;
        this.includeMessage = false;
        this.includeException = true;
        this.includeContextName = true;
        this.includeTimestamp = false;
        this.appendLineSeparator = false;
    }

    public String doLayout(ILoggingEvent event) {
        Map<String, Object> map = this.toJsonMap(event);
        if (map == null || map.isEmpty()) {
            return "";
        }
        String result = this.getStringFromFormatter(map);
        if (result == null || result.isEmpty()) {
            return "";
        }
        result = this.pruefeGroesse(map, result, event);
        return this.isAppendLineSeparator() ? result + CoreConstants.LINE_SEPARATOR : result;
    }

    private String getStringFromFormatter(Map<String, Object> map) {
        JsonFormatter formatter = this.getJsonFormatter();
        if (formatter == null) {
            LoggingTechnicalRuntimeException fehler = new LoggingTechnicalRuntimeException("ISYLO00003", ((Object)((Object)this)).getClass().getName());
            this.addError(((Throwable)((Object)fehler)).getMessage(), (Throwable)((Object)fehler));
            return "";
        }
        try {
            return formatter.toJsonString(map);
        }
        catch (Exception e) {
            LinkedHashMap<String, Object> stringMap = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if ("mdc".equals(entry.getKey())) {
                    stringMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                stringMap.put(entry.getKey(), entry.getValue().toString());
            }
            try {
                return formatter.toJsonString(stringMap);
            }
            catch (Exception ex) {
                FehlerhafterLogeintrag fehler = new FehlerhafterLogeintrag("ISYLO01001", ex, new String[0]);
                this.addError(((Throwable)((Object)fehler)).getMessage(), (Throwable)((Object)fehler));
                return "";
            }
        }
    }

    protected Map<String, Object> toJsonMap(ILoggingEvent event) {
        boolean enthaeltFachlicheDaten;
        String korrelationsId;
        LinkedHashMap<String, Object> jsonMap = new LinkedHashMap<String, Object>();
        String zeitstempel = this.formatTimestamp(event.getTimeStamp());
        if (zeitstempel != null) {
            jsonMap.put(ZEITSTEMPEL_ATTR_NAME, zeitstempel);
        }
        Map defaultMap = super.toJsonMap(event);
        jsonMap.putAll(defaultMap);
        String msg = event.getFormattedMessage();
        if (msg != null) {
            jsonMap.put(NACHRICHT_ATTR_NAME, msg);
        }
        if ((korrelationsId = MdcHelper.liesKorrelationsId()) == null) {
            korrelationsId = LEERE_KORRELATIONSID;
        }
        jsonMap.put(KORRELATIONSID_ATTR_NAME, korrelationsId);
        Marker marker = event.getMarker();
        ArrayList<String> standardMarker = new ArrayList<String>();
        this.processMarker(marker, jsonMap, standardMarker);
        Object[] parameter = event.getArgumentArray();
        if (parameter != null) {
            for (int i = 0; i < parameter.length; ++i) {
                jsonMap.put(PARAMETER_ATTR_NAME + (i + 1), parameter[i]);
            }
        }
        if (!standardMarker.isEmpty()) {
            jsonMap.put(MARKER_ATTR_NAME, standardMarker);
        }
        if (enthaeltFachlicheDaten = MdcHelper.liesMarkerFachdaten()) {
            this.processMarker(new FachdatenMarker(), jsonMap, standardMarker);
        }
        return jsonMap;
    }

    private void processMarker(Marker marker, Map<String, Object> jsonMap, List<String> standardMarker) {
        if (marker == null) {
            return;
        }
        if (marker instanceof IsyMarker) {
            IsyMarker isyMarker = (IsyMarker)marker;
            if (!isyMarker.isRootMarker()) {
                jsonMap.put(isyMarker.getName(), isyMarker.getValue());
            }
        } else {
            standardMarker.add(marker.getName());
        }
        Iterator iterator = marker.iterator();
        while (iterator.hasNext()) {
            this.processMarker((Marker)iterator.next(), jsonMap, standardMarker);
        }
    }

    private String pruefeGroesse(Map<String, Object> map, String logeintrag, ILoggingEvent event) {
        byte[] zeichen;
        int tatsaechlicheLaenge;
        if (this.maxLength > 0 && event.getLevel().isGreaterOrEqual(Level.INFO) && (double)logeintrag.length() >= (double)this.maxLength / 2.0 && (tatsaechlicheLaenge = (zeichen = logeintrag.getBytes(StandardCharsets.UTF_8)).length) > this.maxLength) {
            map.replaceAll((k, v) -> {
                if (k.startsWith(PARAMETER_ATTR_NAME)) {
                    return Ereignisschluessel.DEBUG_LOG_GEKUERZT.getNachricht();
                }
                return v;
            });
            map.put(GEKUERZT_ATTR_NAME, "true");
            int ueberhang = this.berechneUeberhang(map);
            if (ueberhang > 0) {
                if (map.containsKey(EXCEPTION_ATTR_NAME)) {
                    if ((ueberhang = this.feldKuerzen(EXCEPTION_ATTR_NAME, map, ueberhang)) > 0) {
                        this.feldKuerzen(NACHRICHT_ATTR_NAME, map, ueberhang);
                    }
                } else {
                    this.feldKuerzen(NACHRICHT_ATTR_NAME, map, ueberhang);
                }
            }
            return this.getStringFromFormatter(map);
        }
        return logeintrag;
    }

    private int feldKuerzen(String schluessel, Map<String, Object> map, int ueberhang) {
        int neuerUeberhang = ueberhang;
        if (map.containsKey(schluessel)) {
            int vorherigerUeberhang;
            do {
                vorherigerUeberhang = neuerUeberhang;
                int feldlaenge = map.get(schluessel).toString().length();
                if (neuerUeberhang >= feldlaenge) {
                    map.put(schluessel, Ereignisschluessel.DEBUG_LOG_GEKUERZT.getNachricht());
                    continue;
                }
                map.put(schluessel, map.get(schluessel).toString().substring(0, feldlaenge - neuerUeberhang - 1));
            } while ((neuerUeberhang = this.berechneUeberhang(map)) > 0 && !map.get(schluessel).toString().equals(Ereignisschluessel.DEBUG_LOG_GEKUERZT.getNachricht()) && neuerUeberhang != vorherigerUeberhang);
        }
        return neuerUeberhang;
    }

    private int berechneUeberhang(Map<String, Object> map) {
        String logeintrag = this.getStringFromFormatter(map);
        int tatsaechlicheLaenge = logeintrag.getBytes(StandardCharsets.UTF_8).length;
        float byteZeichen = (float)tatsaechlicheLaenge / (float)logeintrag.length();
        return (int)((float)(tatsaechlicheLaenge - this.maxLength) / byteZeichen) + 1;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }
}

